exports.id = 4573;
exports.ids = [4573];
exports.modules = {

/***/ 6495:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = ({
    value: true
});
exports.Z = _extends;
function _extends() {
    return extends_.apply(this, arguments);
}
function extends_() {
    extends_ = Object.assign || function(target) {
        for(var i = 1; i < arguments.length; i++){
            var source = arguments[i];
            for(var key in source){
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }
        return target;
    };
    return extends_.apply(this, arguments);
}


/***/ }),

/***/ 2648:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = ({
    value: true
});
exports.Z = _interopRequireDefault;
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}


/***/ }),

/***/ 1598:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = ({
    value: true
});
exports.Z = _interopRequireWildcard;
function _interopRequireWildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {};
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
function _getRequireWildcardCache(nodeInterop1) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop1);
}


/***/ }),

/***/ 7273:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = ({
    value: true
});
exports.Z = _objectWithoutPropertiesLoose;
function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for(i = 0; i < sourceKeys.length; i++){
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        target[key] = source[key];
    }
    return target;
}


/***/ }),

/***/ 1432:
/***/ ((module, exports, __webpack_require__) => {

"client";
"use strict";

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Image;

var _extends = (__webpack_require__(6495)/* ["default"] */ .Z);

var _interop_require_default = (__webpack_require__(2648)/* ["default"] */ .Z);

var _interop_require_wildcard = (__webpack_require__(1598)/* ["default"] */ .Z);

var _object_without_properties_loose = (__webpack_require__(7273)/* ["default"] */ .Z);

var _react = _interop_require_wildcard(__webpack_require__(6689));

var _head = _interop_require_default(__webpack_require__(4957));

var _imageBlurSvg = __webpack_require__(4486);

var _imageConfig = __webpack_require__(5843);

var _imageConfigContext = __webpack_require__(744);

var _utils = __webpack_require__(9232);

function Image(_param) {
  var {
    src,
    sizes,
    unoptimized = false,
    priority = false,
    loading,
    className,
    quality,
    width,
    height,
    fill,
    style,
    onLoadingComplete,
    placeholder = 'empty',
    blurDataURL
  } = _param,
      all = _object_without_properties_loose(_param, ["src", "sizes", "unoptimized", "priority", "loading", "className", "quality", "width", "height", "fill", "style", "onLoadingComplete", "placeholder", "blurDataURL"]);

  const configContext = (0, _react).useContext(_imageConfigContext.ImageConfigContext);
  const config = (0, _react).useMemo(() => {
    const c = configEnv || configContext || _imageConfig.imageConfigDefault;
    const allSizes = [...c.deviceSizes, ...c.imageSizes].sort((a, b) => a - b);
    const deviceSizes = c.deviceSizes.sort((a, b) => a - b);
    return _extends({}, c, {
      allSizes,
      deviceSizes
    });
  }, [configContext]);
  let rest = all;
  let loader = defaultLoader;

  if ('loader' in rest) {
    if (rest.loader) {
      const customImageLoader = rest.loader;

      var _tmp;

      _tmp = obj => {
        const {
          config: _
        } = obj,
              opts = _object_without_properties_loose(obj, ["config"]); // The config object is internal only so we must
        // not pass it to the user-defined loader()


        return customImageLoader(opts);
      }, loader = _tmp, _tmp;
    } // Remove property so it's not spread on <img>


    delete rest.loader;
  }

  let staticSrc = '';
  let widthInt = getInt(width);
  let heightInt = getInt(height);
  let blurWidth;
  let blurHeight;

  if (isStaticImport(src)) {
    const staticImageData = isStaticRequire(src) ? src.default : src;

    if (!staticImageData.src) {
      throw new Error(`An object should only be passed to the image component src parameter if it comes from a static image import. It must include src. Received ${JSON.stringify(staticImageData)}`);
    }

    if (!staticImageData.height || !staticImageData.width) {
      throw new Error(`An object should only be passed to the image component src parameter if it comes from a static image import. It must include height and width. Received ${JSON.stringify(staticImageData)}`);
    }

    blurWidth = staticImageData.blurWidth;
    blurHeight = staticImageData.blurHeight;
    blurDataURL = blurDataURL || staticImageData.blurDataURL;
    staticSrc = staticImageData.src;

    if (!fill) {
      if (!widthInt && !heightInt) {
        widthInt = staticImageData.width;
        heightInt = staticImageData.height;
      } else if (widthInt && !heightInt) {
        const ratio = widthInt / staticImageData.width;
        heightInt = Math.round(staticImageData.height * ratio);
      } else if (!widthInt && heightInt) {
        const ratio = heightInt / staticImageData.height;
        widthInt = Math.round(staticImageData.width * ratio);
      }
    }
  }

  src = typeof src === 'string' ? src : staticSrc;
  let isLazy = !priority && (loading === 'lazy' || typeof loading === 'undefined');

  if (src.startsWith('data:') || src.startsWith('blob:')) {
    // https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs
    unoptimized = true;
    isLazy = false;
  }

  if (config.unoptimized) {
    unoptimized = true;
  }

  const [blurComplete, setBlurComplete] = (0, _react).useState(false);
  const [showAltText, setShowAltText] = (0, _react).useState(false);
  const qualityInt = getInt(quality);

  if (false) {}

  const imgStyle = Object.assign(fill ? {
    position: 'absolute',
    height: '100%',
    width: '100%',
    left: 0,
    top: 0,
    right: 0,
    bottom: 0
  } : {}, showAltText ? {} : {
    color: 'transparent'
  }, style);
  const blurStyle = placeholder === 'blur' && blurDataURL && !blurComplete ? {
    backgroundSize: imgStyle.objectFit || 'cover',
    backgroundPosition: imgStyle.objectPosition || '50% 50%',
    backgroundRepeat: 'no-repeat',
    backgroundImage: `url("data:image/svg+xml;charset=utf-8,${(0, _imageBlurSvg).getImageBlurSvg({
      widthInt,
      heightInt,
      blurWidth,
      blurHeight,
      blurDataURL
    })}")`
  } : {};

  if (false) {}

  const imgAttributes = generateImgAttrs({
    config,
    src,
    unoptimized,
    width: widthInt,
    quality: qualityInt,
    sizes,
    loader
  });
  let srcString = src;

  if (false) {}

  let imageSrcSetPropName = 'imagesrcset';
  let imageSizesPropName = 'imagesizes';

  if (true) {
    imageSrcSetPropName = 'imageSrcSet';
    imageSizesPropName = 'imageSizes';
  }

  const linkProps = {
    // Note: imagesrcset and imagesizes are not in the link element type with react 17.
    [imageSrcSetPropName]: imgAttributes.srcSet,
    [imageSizesPropName]: imgAttributes.sizes,
    crossOrigin: rest.crossOrigin
  };
  const onLoadingCompleteRef = (0, _react).useRef(onLoadingComplete);
  (0, _react).useEffect(() => {
    onLoadingCompleteRef.current = onLoadingComplete;
  }, [onLoadingComplete]);

  const imgElementArgs = _extends({
    isLazy,
    imgAttributes,
    heightInt,
    widthInt,
    qualityInt,
    className,
    imgStyle,
    blurStyle,
    loading,
    config,
    fill,
    unoptimized,
    placeholder,
    loader,
    srcString,
    onLoadingCompleteRef,
    setBlurComplete,
    setShowAltText
  }, rest);

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ImageElement, Object.assign({}, imgElementArgs)), priority ? // Note how we omit the `href` attribute, as it would only be relevant
  // for browsers that do not support `imagesrcset`, and in those cases
  // it would likely cause the incorrect image to be preloaded.
  //
  // https://html.spec.whatwg.org/multipage/semantics.html#attr-link-imagesrcset

  /*#__PURE__*/
  _react.default.createElement(_head.default, null, /*#__PURE__*/_react.default.createElement("link", Object.assign({
    key: '__nimg-' + imgAttributes.src + imgAttributes.srcSet + imgAttributes.sizes,
    rel: "preload",
    as: "image",
    href: imgAttributes.srcSet ? undefined : imgAttributes.src
  }, linkProps))) : null);
}

'client';
const configEnv = {"deviceSizes":[640,750,828,1080,1200,1920,2048,3840],"imageSizes":[16,32,48,64,96,128,256,384],"path":"/_next/image","loader":"default","dangerouslyAllowSVG":false,"unoptimized":true};
const allImgs = new Map();
let perfObserver;

if (true) {
  global.__NEXT_IMAGE_IMPORTED = true;
}

const VALID_LOADING_VALUES = (/* unused pure expression or super */ null && (['lazy', 'eager', undefined]));

function isStaticRequire(src) {
  return src.default !== undefined;
}

function isStaticImageData(src) {
  return src.src !== undefined;
}

function isStaticImport(src) {
  return typeof src === 'object' && (isStaticRequire(src) || isStaticImageData(src));
}

function getWidths({
  deviceSizes,
  allSizes
}, width, sizes) {
  if (sizes) {
    // Find all the "vw" percent sizes used in the sizes prop
    const viewportWidthRe = /(^|\s)(1?\d?\d)vw/g;
    const percentSizes = [];

    for (let match; match = viewportWidthRe.exec(sizes); match) {
      percentSizes.push(parseInt(match[2]));
    }

    if (percentSizes.length) {
      const smallestRatio = Math.min(...percentSizes) * 0.01;
      return {
        widths: allSizes.filter(s => s >= deviceSizes[0] * smallestRatio),
        kind: 'w'
      };
    }

    return {
      widths: allSizes,
      kind: 'w'
    };
  }

  if (typeof width !== 'number') {
    return {
      widths: deviceSizes,
      kind: 'w'
    };
  }

  const widths = [...new Set( // > This means that most OLED screens that say they are 3x resolution,
  // > are actually 3x in the green color, but only 1.5x in the red and
  // > blue colors. Showing a 3x resolution image in the app vs a 2x
  // > resolution image will be visually the same, though the 3x image
  // > takes significantly more data. Even true 3x resolution screens are
  // > wasteful as the human eye cannot see that level of detail without
  // > something like a magnifying glass.
  // https://blog.twitter.com/engineering/en_us/topics/infrastructure/2019/capping-image-fidelity-on-ultra-high-resolution-devices.html
  [width, width * 2
  /*, width * 3*/
  ].map(w => allSizes.find(p => p >= w) || allSizes[allSizes.length - 1]))];
  return {
    widths,
    kind: 'x'
  };
}

function generateImgAttrs({
  config,
  src,
  unoptimized,
  width,
  quality,
  sizes,
  loader
}) {
  if (unoptimized) {
    return {
      src,
      srcSet: undefined,
      sizes: undefined
    };
  }

  const {
    widths,
    kind
  } = getWidths(config, width, sizes);
  const last = widths.length - 1;
  return {
    sizes: !sizes && kind === 'w' ? '100vw' : sizes,
    srcSet: widths.map((w, i) => `${loader({
      config,
      src,
      quality,
      width: w
    })} ${kind === 'w' ? w : i + 1}${kind}`).join(', '),
    // It's intended to keep `src` the last attribute because React updates
    // attributes in order. If we keep `src` the first one, Safari will
    // immediately start to fetch `src`, before `sizes` and `srcSet` are even
    // updated by React. That causes multiple unnecessary requests if `srcSet`
    // and `sizes` are defined.
    // This bug cannot be reproduced in Chrome or Firefox.
    src: loader({
      config,
      src,
      quality,
      width: widths[last]
    })
  };
}

function getInt(x) {
  if (typeof x === 'number' || typeof x === 'undefined') {
    return x;
  }

  if (typeof x === 'string' && /^[0-9]+$/.test(x)) {
    return parseInt(x, 10);
  }

  return NaN;
} // See https://stackoverflow.com/q/39777833/266535 for why we use this ref
// handler instead of the img's onLoad attribute.


function handleLoading(img, src, placeholder, onLoadingCompleteRef, setBlurComplete) {
  if (!img || img['data-loaded-src'] === src) {
    return;
  }

  img['data-loaded-src'] = src;
  const p = 'decode' in img ? img.decode() : Promise.resolve();
  p.catch(() => {}).then(() => {
    if (!img.parentNode) {
      // Exit early in case of race condition:
      // - onload() is called
      // - decode() is called but incomplete
      // - unmount is called
      // - decode() completes
      return;
    }

    if (placeholder === 'blur') {
      setBlurComplete(true);
    }

    if (onLoadingCompleteRef == null ? void 0 : onLoadingCompleteRef.current) {
      onLoadingCompleteRef.current(img);
    }

    if (false) {}
  });
}

const ImageElement = _param => {
  var {
    imgAttributes,
    heightInt,
    widthInt,
    qualityInt,
    className,
    imgStyle,
    blurStyle,
    isLazy,
    fill,
    placeholder,
    loading,
    srcString,
    config,
    unoptimized,
    loader,
    onLoadingCompleteRef,
    setBlurComplete,
    setShowAltText,
    onLoad,
    onError
  } = _param,
      rest = _object_without_properties_loose(_param, ["imgAttributes", "heightInt", "widthInt", "qualityInt", "className", "imgStyle", "blurStyle", "isLazy", "fill", "placeholder", "loading", "srcString", "config", "unoptimized", "loader", "onLoadingCompleteRef", "setBlurComplete", "setShowAltText", "onLoad", "onError"]);

  loading = isLazy ? 'lazy' : loading;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("img", Object.assign({}, rest, imgAttributes, {
    width: widthInt,
    height: heightInt,
    decoding: "async",
    "data-nimg": `future${fill ? '-fill' : ''}`,
    className: className,
    // @ts-ignore - TODO: upgrade to `@types/react@17`
    loading: loading,
    style: _extends({}, imgStyle, blurStyle),
    ref: (0, _react).useCallback(img => {
      if (!img) {
        return;
      }

      if (onError) {
        // If the image has an error before react hydrates, then the error is lost.
        // The workaround is to wait until the image is mounted which is after hydration,
        // then we set the src again to trigger the error handler (if there was an error).
        // eslint-disable-next-line no-self-assign
        img.src = img.src;
      }

      if (false) {}

      if (img.complete) {
        handleLoading(img, srcString, placeholder, onLoadingCompleteRef, setBlurComplete);
      }
    }, [srcString, placeholder, onLoadingCompleteRef, setBlurComplete, onError]),
    onLoad: event => {
      const img = event.currentTarget;
      handleLoading(img, srcString, placeholder, onLoadingCompleteRef, setBlurComplete);

      if (onLoad) {
        onLoad(event);
      }
    },
    onError: event => {
      // if the real image fails to load, this will ensure "alt" is visible
      setShowAltText(true);

      if (placeholder === 'blur') {
        // If the real image fails to load, this will still remove the placeholder.
        setBlurComplete(true);
      }

      if (onError) {
        onError(event);
      }
    }
  })));
};

function defaultLoader({
  config,
  src,
  width,
  quality
}) {
  if (false) {}

  if (src.endsWith('.svg') && !config.dangerouslyAllowSVG) {
    // Special case to make svg serve as-is to avoid proxying
    // through the built-in Image Optimization API.
    return src;
  }

  return `${config.path}?url=${encodeURIComponent(src)}&w=${width}&q=${quality || 75}`;
}

if ((typeof exports.default === 'function' || typeof exports.default === 'object' && exports.default !== null) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', {
    value: true
  });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

/***/ }),

/***/ 3579:
/***/ ((module, exports, __webpack_require__) => {

"client";
"use strict";

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = dynamic;
exports.noSSR = noSSR;

var _extends = (__webpack_require__(6495)/* ["default"] */ .Z);

var _interop_require_default = (__webpack_require__(2648)/* ["default"] */ .Z);

var _react = _interop_require_default(__webpack_require__(6689));

var _loadable = _interop_require_default(__webpack_require__(5832));

function dynamic(dynamicOptions, options) {
  let loadableFn = _loadable.default;
  let loadableOptions = (options == null ? void 0 : options.suspense) ? {} : {
    // A loading component is not required, so we default it
    loading: ({
      error,
      isLoading,
      pastDelay
    }) => {
      if (!pastDelay) return null;

      if (false) {}

      return null;
    }
  }; // Support for direct import(), eg: dynamic(import('../hello-world'))
  // Note that this is only kept for the edge case where someone is passing in a promise as first argument
  // The react-loadable babel plugin will turn dynamic(import('../hello-world')) into dynamic(() => import('../hello-world'))
  // To make sure we don't execute the import without rendering first

  if (dynamicOptions instanceof Promise) {
    loadableOptions.loader = () => dynamicOptions; // Support for having import as a function, eg: dynamic(() => import('../hello-world'))

  } else if (typeof dynamicOptions === 'function') {
    loadableOptions.loader = dynamicOptions; // Support for having first argument being options, eg: dynamic({loader: import('../hello-world')})
  } else if (typeof dynamicOptions === 'object') {
    loadableOptions = _extends({}, loadableOptions, dynamicOptions);
  } // Support for passing options, eg: dynamic(import('../hello-world'), {loading: () => <p>Loading something</p>})


  loadableOptions = _extends({}, loadableOptions, options); // Error if Fizz rendering is not enabled and `suspense` option is set to true

  if (false) {}

  if (loadableOptions.suspense) {
    if (false) {}

    delete loadableOptions.ssr;
    delete loadableOptions.loading;
  } // coming from build/babel/plugins/react-loadable-plugin.js


  if (loadableOptions.loadableGenerated) {
    loadableOptions = _extends({}, loadableOptions, loadableOptions.loadableGenerated);
    delete loadableOptions.loadableGenerated;
  } // support for disabling server side rendering, eg: dynamic(import('../hello-world'), {ssr: false}).
  // skip `ssr` for suspense mode and opt-in React.lazy directly


  if (typeof loadableOptions.ssr === 'boolean' && !loadableOptions.suspense) {
    if (!loadableOptions.ssr) {
      delete loadableOptions.ssr;
      return noSSR(loadableFn, loadableOptions);
    }

    delete loadableOptions.ssr;
  }

  return loadableFn(loadableOptions);
}

'client';
const isServerSide = true;

function noSSR(LoadableInitializer, loadableOptions) {
  // Removing webpack and modules means react-loadable won't try preloading
  delete loadableOptions.webpack;
  delete loadableOptions.modules; // This check is necessary to prevent react-loadable from initializing on the server

  if (!isServerSide) {
    return LoadableInitializer(loadableOptions);
  }

  const Loading = loadableOptions.loading; // This will only be rendered on the server side

  return () => /*#__PURE__*/_react.default.createElement(Loading, {
    error: null,
    isLoading: true,
    pastDelay: false,
    timedOut: false
  });
}

if ((typeof exports.default === 'function' || typeof exports.default === 'object' && exports.default !== null) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', {
    value: true
  });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

/***/ }),

/***/ 5152:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(3579)


/***/ }),

/***/ 1608:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(1432)


/***/ })

};
;