"use strict";
exports.id = 7613;
exports.ids = [7613];
exports.modules = {

/***/ 7613:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(567);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(403);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8581);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4945);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];











function ticksToTime(ticks) {
  const milliseconds = ticks / 10000;
  const seconds = Math.floor(milliseconds / 1000 % 60);
  const minutes = Math.floor(milliseconds / (1000 * 60) % 60);
  const hours = Math.floor(milliseconds / (1000 * 60 * 60) % 24);
  return {
    hours,
    minutes,
    seconds
  };
}

function ticksToString(ticks) {
  const {
    hours,
    minutes,
    seconds
  } = ticksToTime(ticks);
  const parts = [];

  if (hours > 0) {
    parts.push(hours);
  }

  parts.push(minutes);
  parts.push(seconds);
  return parts.map(part => part.toString().padStart(2, "0")).join(":");
}

function SingleSessionEntry({
  playCommand,
  session
}) {
  const {
    NowPlayingItem: {
      Name,
      SeriesName
    },
    PlayState: {
      PositionTicks,
      IsPaused,
      IsMuted
    }
  } = session;
  const RunTimeTicks = session.NowPlayingItem?.RunTimeTicks ?? session.NowPlayingItem?.CurrentProgram?.RunTimeTicks ?? 0;
  const {
    IsVideoDirect,
    VideoDecoderIsHardware,
    VideoEncoderIsHardware
  } = session?.TranscodingInfo || {
    IsVideoDirect: true
  }; // if no transcodinginfo its videodirect

  const percent = Math.min(1, PositionTicks / RunTimeTicks) * 100;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "grow text-xs z-10 self-center ml-2 relative w-full h-4 mr-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "absolute w-full whitespace-nowrap text-ellipsis overflow-hidden",
          children: [Name, SeriesName && ` - ${SeriesName}`]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "self-center text-xs flex justify-end mr-1.5 pl-1",
        children: [IsVideoDirect && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdOutlineSmartDisplay, {
          className: "opacity-50"
        }), !IsVideoDirect && (!VideoDecoderIsHardware || !VideoEncoderIsHardware) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsCpu, {
          className: "opacity-50"
        }), !IsVideoDirect && VideoDecoderIsHardware && VideoEncoderIsHardware && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillCpuFill, {
          className: "opacity-50"
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "absolute h-5 rounded-md bg-theme-200 dark:bg-theme-900/40 z-0",
        style: {
          width: `${percent}%`
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "text-xs z-10 self-center ml-1",
        children: [IsPaused && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillPlayFill, {
          onClick: () => {
            playCommand(session, "Unpause");
          },
          className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
        }), !IsPaused && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsPauseFill, {
          onClick: () => {
            playCommand(session, "Pause");
          },
          className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "grow "
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "self-center text-xs flex justify-end mr-1 z-10",
        children: IsMuted && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsVolumeMuteFill, {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "self-center text-xs flex justify-end mr-2 z-10",
        children: [ticksToString(PositionTicks), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
          className: "mx-0.5 text-[8px]",
          children: "/"
        }), ticksToString(RunTimeTicks)]
      })]
    })]
  });
}

function SessionEntry({
  playCommand,
  session
}) {
  const {
    NowPlayingItem: {
      Name,
      SeriesName
    },
    PlayState: {
      PositionTicks,
      IsPaused,
      IsMuted
    }
  } = session;
  const RunTimeTicks = session.NowPlayingItem?.RunTimeTicks ?? session.NowPlayingItem?.CurrentProgram?.RunTimeTicks ?? 0;
  const {
    IsVideoDirect,
    VideoDecoderIsHardware,
    VideoEncoderIsHardware
  } = session?.TranscodingInfo || {
    IsVideoDirect: true
  }; // if no transcodinginfo its videodirect

  const percent = Math.min(1, PositionTicks / RunTimeTicks) * 100;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "absolute h-5 rounded-md bg-theme-200 dark:bg-theme-900/40 z-0",
      style: {
        width: `${percent}%`
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "text-xs z-10 self-center ml-1",
      children: [IsPaused && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillPlayFill, {
        onClick: () => {
          playCommand(session, "Unpause");
        },
        className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
      }), !IsPaused && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsPauseFill, {
        onClick: () => {
          playCommand(session, "Pause");
        },
        className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "grow text-xs z-10 self-center relative w-full h-4",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "absolute w-full whitespace-nowrap text-ellipsis overflow-hidden",
        children: [Name, SeriesName && ` - ${SeriesName}`]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "self-center text-xs flex justify-end mr-1 z-10",
      children: IsMuted && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsVolumeMuteFill, {})
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "self-center text-xs flex justify-end mr-1 z-10",
      children: ticksToString(PositionTicks)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "self-center items-center text-xs flex justify-end mr-1.5 pl-1 z-10",
      children: [IsVideoDirect && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdOutlineSmartDisplay, {
        className: "opacity-50"
      }), !IsVideoDirect && (!VideoDecoderIsHardware || !VideoEncoderIsHardware) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsCpu, {
        className: "opacity-50"
      }), !IsVideoDirect && VideoDecoderIsHardware && VideoEncoderIsHardware && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillCpuFill, {
        className: "opacity-50"
      })]
    })]
  });
}

function CountBlocks({
  service,
  countData
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)(); // allows filtering
  // eslint-disable-next-line no-param-reassign

  if (service.widget?.type === "jellyfin") service.widget.type = "emby";

  if (!countData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "emby.movies"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "emby.series"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "emby.episodes"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "emby.songs"
      })]
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "emby.movies",
      value: t("common.number", {
        value: countData.MovieCount
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "emby.series",
      value: t("common.number", {
        value: countData.SeriesCount
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "emby.episodes",
      value: t("common.number", {
        value: countData.EpisodeCount
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "emby.songs",
      value: t("common.number", {
        value: countData.SongCount
      })
    })]
  });
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: sessionsData,
    error: sessionsError,
    mutate: sessionMutate
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(widget, "Sessions", {
    refreshInterval: 5000
  });
  const {
    data: countData,
    error: countError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(widget, "Count", {
    refreshInterval: 60000
  });

  async function handlePlayCommand(session, command) {
    const url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_7__/* .formatProxyUrlWithSegments */ .wR)(widget, "PlayControl", {
      sessionId: session.Id,
      command
    });
    await fetch(url).then(() => {
      sessionMutate();
    });
  }

  if (sessionsError || countError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      service: service,
      error: sessionsError ?? countError
    });
  }

  const enableBlocks = service.widget?.enableBlocks;
  const enableNowPlaying = service.widget?.enableNowPlaying ?? true;

  if (!sessionsData || !countData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [enableBlocks && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(CountBlocks, {
        service: service,
        countData: null
      }), enableNowPlaying && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "flex flex-col pb-1",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "absolute left-2 text-xs mt-[2px]",
            children: "-"
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "absolute left-2 text-xs mt-[2px]",
            children: "-"
          })
        })]
      })]
    });
  }

  if (enableNowPlaying) {
    const playing = sessionsData.filter(session => session?.NowPlayingItem).sort((a, b) => {
      if (a.PlayState.PositionTicks > b.PlayState.PositionTicks) {
        return 1;
      }

      if (a.PlayState.PositionTicks < b.PlayState.PositionTicks) {
        return -1;
      }

      return 0;
    });

    if (playing.length === 0) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [enableBlocks && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(CountBlocks, {
          service: service,
          countData: countData
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex flex-col pb-1 mx-1",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
              className: "absolute left-2 text-xs mt-[2px]",
              children: t("emby.no_active")
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
              className: "absolute left-2 text-xs mt-[2px]",
              children: "-"
            })
          })]
        })]
      });
    }

    if (playing.length === 1) {
      const session = playing[0];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [enableBlocks && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(CountBlocks, {
          service: service,
          countData: countData
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "flex flex-col pb-1 mx-1",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(SingleSessionEntry, {
            playCommand: (currentSession, command) => handlePlayCommand(currentSession, command),
            session: session
          })
        })]
      });
    }

    if (playing.length > 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [enableBlocks && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(CountBlocks, {
        service: service,
        countData: countData
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "flex flex-col pb-1 mx-1",
        children: playing.map(session => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(SessionEntry, {
          playCommand: (currentSession, command) => handlePlayCommand(currentSession, command),
          session: session
        }, session.Id))
      })]
    });
  }

  if (enableBlocks) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(CountBlocks, {
      service: service,
      countData: countData
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;