"use strict";
exports.id = 864;
exports.ids = [864];
exports.modules = {

/***/ 864:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Widget)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1299);
/* harmony import */ var _widget_container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4843);
/* harmony import */ var _widget_raw__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1464);
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6536);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








function Widget({
  options
}) {
  const {
    cluster,
    nodes
  } = options;
  const {
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  const defaultData = {
    cpu: {
      load: 0,
      total: 0,
      percent: 0
    },
    memory: {
      used: 0,
      total: 0,
      free: 0,
      percent: 0
    }
  };
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/kubernetes?${new URLSearchParams({
    lang: i18n.language
  }).toString()}`, {
    refreshInterval: 1500
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      options: options
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
      options: options,
      additionalClassNames: "information-widget-kubernetes",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "flex flex-row self-center flex-wrap justify-between",
          children: [cluster.show && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_node__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
            type: "cluster",
            options: options.cluster,
            data: defaultData
          }, "cluster"), nodes.show && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_node__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
            type: "node",
            options: options.nodes,
            data: defaultData
          }, "nodes")]
        })
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
    options: options,
    additionalClassNames: "information-widget-kubernetes",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex flex-row self-center flex-wrap justify-between",
        children: [cluster.show && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_node__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          type: "cluster",
          options: options.cluster,
          data: data.cluster
        }, "cluster"), nodes.show && data.nodes && data.nodes.map(node => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_node__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          type: "node",
          options: options.nodes,
          data: node
        }, node.name))]
      })
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6536:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Node)
/* harmony export */ });
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2750);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(764);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_si__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _resources_usage_bar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4181);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);







function Node({
  type,
  options,
  data
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();

  function icon() {
    if (type === "cluster") {
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_si__WEBPACK_IMPORTED_MODULE_2__.SiKubernetes, {
        className: "text-theme-800 dark:text-theme-200 w-5 h-5"
      });
    }

    if (data.ready) {
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiServer, {
        className: "text-theme-800 dark:text-theme-200 w-5 h-5"
      });
    }

    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiAlertTriangle, {
      className: "text-theme-800 dark:text-theme-200 w-5 h-5"
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
    className: "flex flex-col max-w:full sm:basis-auto self-center grow-0 flex-wrap ml-4",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "flex flex-row self-center flex-wrap justify-between",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex-none flex flex-row items-center mr-3 py-1.5",
        children: [icon(), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "flex flex-col ml-3 text-left min-w-[85px]",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "text-theme-800 dark:text-theme-200 text-xs flex flex-row justify-between",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
              className: "pl-0.5",
              children: t("common.number", {
                value: data?.cpu?.percent ?? 0,
                style: "unit",
                unit: "percent",
                maximumFractionDigits: 0
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiCpu, {
              className: "text-theme-800 dark:text-theme-200 w-3 h-3"
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_resources_usage_bar__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
            percent: data?.cpu?.percent ?? 0
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "text-theme-800 dark:text-theme-200 text-xs flex flex-row justify-between",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
              className: "pl-0.5",
              children: t("common.bytes", {
                value: data?.memory?.free ?? 0,
                maximumFractionDigits: 0,
                binary: true
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_fa__WEBPACK_IMPORTED_MODULE_0__.FaMemory, {
              className: "text-theme-800 dark:text-theme-200 w-3 h-3"
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_resources_usage_bar__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
            percent: data?.memory?.percent
          }), options.showLabel && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
            className: "pt-1 text-center text-theme-800 dark:text-theme-200 text-xs",
            children: type === "cluster" ? options.label : data.name
          })]
        })]
      })
    })
  });
}

/***/ })

};
;