"use strict";
exports.id = 9723;
exports.ids = [9723];
exports.modules = {

/***/ 9723:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





function Component({
  service
}) {
  const {
    widget
  } = service;
  const {
    data: printerStats,
    error: printerStatsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "printer_stats");
  const {
    data: jobStats,
    error: jobStatsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "job_stats");

  if (printerStatsError && jobStats) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.printer_state",
        value: jobStats.state
      })
    });
  }

  if (printerStatsError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      error: printerStatsError
    });
  }

  if (jobStatsError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      error: jobStatsError
    });
  }

  const state = printerStats?.state?.text;
  const tempTool = printerStats?.temperature?.tool0?.actual;
  const tempBed = printerStats?.temperature?.bed?.actual;

  if (!printerStats || !state || !tempTool || !tempBed) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.printer_state"
      })
    });
  }

  const printingStateFalgs = ["Printing", "Paused", "Pausing", "Resuming"];

  if (printingStateFalgs.includes(state)) {
    const completion = jobStats?.progress?.completion;

    if (!jobStats || !completion) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        service: service,
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          label: "octoprint.printer_state"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          label: "octoprint.temp_tool"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          label: "octoprint.temp_bed"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          label: "octoprint.job_completion"
        })]
      });
    }

    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.printer_state",
        value: printerStats.state.text
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.temp_tool",
        value: `${printerStats.temperature.tool0.actual} °C`
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.temp_bed",
        value: `${printerStats.temperature.bed.actual} °C`
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "octoprint.job_completion",
        value: `${completion.toFixed(2)}%`
      })]
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "octoprint.printer_state",
      value: printerStats.state.text
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "octoprint.temp_tool",
      value: `${printerStats.temperature.tool0.actual} °C`
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "octoprint.temp_bed",
      value: `${printerStats.temperature.bed.actual} °C`
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;