"use strict";
(() => {
var exports = {};
exports.id = 5294;
exports.ids = [5294];
exports.modules = {

/***/ 276:
/***/ ((module) => {

module.exports = require("@kubernetes/client-node");

/***/ }),

/***/ 4856:
/***/ ((module) => {

module.exports = require("dockerode");

/***/ }),

/***/ 6953:
/***/ ((module) => {

module.exports = require("follow-redirects");

/***/ }),

/***/ 8840:
/***/ ((module) => {

module.exports = require("gamedig");

/***/ }),

/***/ 7837:
/***/ ((module) => {

module.exports = require("json-rpc-2.0");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 9463:
/***/ ((module) => {

module.exports = require("minecraft-ping-js");

/***/ }),

/***/ 1377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 7976:
/***/ ((module) => {

module.exports = require("tough-cookie");

/***/ }),

/***/ 1980:
/***/ ((module) => {

module.exports = require("urbackup-server-api");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 322:
/***/ ((module) => {

module.exports = require("xml-js");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 5941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ }),

/***/ 6113:
/***/ ((module) => {

module.exports = require("crypto");

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 5628:
/***/ ((module) => {

module.exports = require("node:zlib");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 3477:
/***/ ((module) => {

module.exports = require("querystring");

/***/ }),

/***/ 2205:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {


// UNUSED EXPORTS: default

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(1377);
;// CONCATENATED MODULE: external "classnames"
const external_classnames_namespaceObject = require("classnames");
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: ./src/components/services/widget/block.jsx




function Block({
  value,
  label
}) {
  const {
    t
  } = useTranslation();
  return /*#__PURE__*/_jsxs("div", {
    className: classNames("bg-theme-200/50 dark:bg-theme-900/20 rounded m-1 flex-1 flex flex-col items-center justify-center text-center p-1", value === undefined ? "animate-pulse" : "", "service-block"),
    children: [/*#__PURE__*/_jsx("div", {
      className: "font-thin text-sm",
      children: value === undefined || value === null ? "-" : value
    }), /*#__PURE__*/_jsx("div", {
      className: "font-bold text-xs uppercase",
      children: t(label)
    })]
  });
}

/***/ }),

/***/ 9684:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {


// UNUSED EXPORTS: default

;// CONCATENATED MODULE: external "react"
const external_react_namespaceObject = require("react");
;// CONCATENATED MODULE: external "react-i18next"
const external_react_i18next_namespaceObject = require("react-i18next");
;// CONCATENATED MODULE: external "react-icons/io5"
const io5_namespaceObject = require("react-icons/io5");
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: ./src/components/services/widget/error.jsx





function displayError(error) {
  return JSON.stringify(error[1] ? error[1] : error, null, 4);
}

function displayData(data) {
  return data.type === "Buffer" ? Buffer.from(data).toString() : JSON.stringify(data, 4);
}

function error_Error({
  error
}) {
  const {
    t
  } = useTranslation();

  if (error?.data?.error) {
    error = error.data.error; // eslint-disable-line no-param-reassign
  }

  return /*#__PURE__*/_jsxs("details", {
    className: "px-1 pb-1",
    children: [/*#__PURE__*/_jsx("summary", {
      className: "block text-center mt-1 mb-0 mx-auto p-3 rounded bg-rose-900/80 hover:bg-rose-900/95 text-theme-900 cursor-pointer",
      children: /*#__PURE__*/_jsxs("div", {
        className: "flex items-center justify-center text-xs font-bold",
        children: [/*#__PURE__*/_jsx(IoAlertCircle, {
          className: "mr-1 w-5 h-5"
        }), t("widget.api_error"), " ", error.message && t("widget.information")]
      })
    }), /*#__PURE__*/_jsx("div", {
      className: "bg-white dark:bg-theme-200/50 mt-2 rounded text-rose-900 text-xs font-mono whitespace-pre-wrap break-all",
      children: /*#__PURE__*/_jsxs("ul", {
        className: "p-4",
        children: [error.message && /*#__PURE__*/_jsxs("li", {
          children: [/*#__PURE__*/_jsxs("span", {
            className: "text-black",
            children: [t("widget.api_error"), ":"]
          }), " ", error.message]
        }), error.url && /*#__PURE__*/_jsxs("li", {
          className: "mt-2",
          children: [/*#__PURE__*/_jsxs("span", {
            className: "text-black",
            children: [t("widget.url"), ":"]
          }), " ", error.url]
        }), error.rawError && /*#__PURE__*/_jsxs("li", {
          className: "mt-2",
          children: [/*#__PURE__*/_jsxs("span", {
            className: "text-black",
            children: [t("widget.raw_error"), ":"]
          }), /*#__PURE__*/_jsx("div", {
            className: "ml-2",
            children: displayError(error.rawError)
          })]
        }), error.data && /*#__PURE__*/_jsxs("li", {
          className: "mt-2",
          children: [/*#__PURE__*/_jsxs("span", {
            className: "text-black",
            children: [t("widget.response_data"), ":"]
          }), /*#__PURE__*/_jsx("div", {
            className: "ml-2",
            children: displayData(error.data)
          })]
        })]
      })
    })]
  });
}
;// CONCATENATED MODULE: ./src/utils/contexts/settings.jsx


const settings_SettingsContext = /*#__PURE__*/(/* unused pure expression or super */ null && (createContext()));
function SettingsProvider({
  initialSettings,
  children
}) {
  const {
    0: settings,
    1: setSettings
  } = useState({});

  if (initialSettings) {
    setSettings(initialSettings);
  }

  const value = useMemo(() => ({
    settings,
    setSettings
  }), [settings]);
  return /*#__PURE__*/_jsx(settings_SettingsContext.Provider, {
    value: value,
    children: children
  });
}
;// CONCATENATED MODULE: ./src/components/services/widget/container.jsx




function Container({
  error = false,
  children,
  service
}) {
  const {
    settings
  } = useContext(SettingsContext);

  if (error) {
    if (settings.hideErrors || service.widget.hide_errors) {
      return null;
    }

    return /*#__PURE__*/_jsx(Error, {
      service: service,
      error: error
    });
  }

  const childrenArray = Array.isArray(children) ? children : [children];
  let visibleChildren = childrenArray;
  let fields = service?.widget?.fields;
  if (typeof fields === "string") fields = JSON.parse(service.widget.fields);
  const type = service?.widget?.type;

  if (fields && type) {
    // if the field contains a "." then it most likely contains a common loc value
    // logic now allows a fields array that can look like:
    // fields: [ "resources.cpu", "resources.mem", "field"]
    // or even
    // fields: [ "resources.cpu", "widget_type.field" ]
    visibleChildren = childrenArray?.filter(child => fields.some(field => {
      let fullField = field;

      if (!field.includes(".")) {
        fullField = `${type}.${field}`;
      }

      return fullField === child?.props?.label;
    }));
  }

  return /*#__PURE__*/_jsx("div", {
    className: "relative flex flex-row w-full service-container",
    children: visibleChildren
  });
}

/***/ }),

/***/ 4332:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(792);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2330);
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(434);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_logger__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__]);
([utils_logger__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)("servicesProxy");
async function handler(req, res) {
  try {
    const {
      type
    } = req.query;
    const widget = widgets_widgets__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z[type];

    if (!widget) {
      logger.debug("Unknown proxy service type: %s", type);
      return res.status(403).json({
        error: "Unkown proxy service type"
      });
    }

    const serviceProxyHandler = widget.proxyHandler || utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z;

    if (serviceProxyHandler instanceof Function) {
      // map opaque endpoints to their actual endpoint
      if (widget?.mappings) {
        const mapping = widget?.mappings?.[req.query.endpoint];
        const mappingParams = mapping?.params;
        const optionalParams = mapping?.optionalParams;
        const map = mapping?.map;
        const endpoint = mapping?.endpoint;
        const endpointProxy = mapping?.proxyHandler || serviceProxyHandler;

        if (!endpoint) {
          logger.debug("Unsupported service endpoint: %s", type);
          return res.status(403).json({
            error: "Unsupported service endpoint"
          });
        }

        req.method = mapping?.method || "GET";
        if (mapping?.body) req.body = mapping?.body;
        req.query.endpoint = endpoint;

        if (req.query.segments) {
          const segments = JSON.parse(req.query.segments);
          req.query.endpoint = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__/* .formatApiCall */ .s4)(endpoint, segments);
        }

        if (req.query.query && (mappingParams || optionalParams)) {
          const queryParams = JSON.parse(req.query.query);
          let filteredOptionalParams = [];
          if (optionalParams) filteredOptionalParams = optionalParams.filter(p => queryParams[p] !== undefined);
          let params = [];
          if (mappingParams) params = params.concat(mappingParams);
          if (filteredOptionalParams) params = params.concat(filteredOptionalParams);
          const query = new URLSearchParams(params.map(p => [p, queryParams[p]]));
          req.query.endpoint = `${req.query.endpoint}?${query}`;
        }

        if (mapping?.headers) {
          req.extraHeaders = mapping.headers;
        }

        if (endpointProxy instanceof Function) {
          return endpointProxy(req, res, map);
        }

        return serviceProxyHandler(req, res, map);
      }

      return serviceProxyHandler(req, res);
    }

    logger.debug("Unknown proxy service type: %s", type);
    return res.status(403).json({
      error: "Unkown proxy service type"
    });
  } catch (ex) {
    logger.error(ex);
    return res.status(500).send({
      error: "Unexpected error"
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 792:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "s4": () => (/* binding */ formatApiCall),
/* harmony export */   "sj": () => (/* binding */ jsonArrayFilter),
/* harmony export */   "vl": () => (/* binding */ asJson),
/* harmony export */   "yb": () => (/* binding */ sanitizeErrorURL)
/* harmony export */ });
/* unused harmony exports formatProxyUrlWithSegments, formatProxyUrl, jsonArrayTransform */
function formatApiCall(url, args) {
  const find = /\{.*?\}/g;

  const replace = match => {
    const key = match.replace(/\{|\}/g, "");
    return args[key] || "";
  };

  return url.replace(/\/+$/, "").replace(find, replace).replace(find, replace);
}

function getURLSearchParams(widget, endpoint) {
  const params = new URLSearchParams({
    type: widget.type,
    group: widget.service_group,
    service: widget.service_name,
    endpoint
  });
  return params;
}

function formatProxyUrlWithSegments(widget, endpoint, segments) {
  const params = getURLSearchParams(widget, endpoint);

  if (segments) {
    params.append("segments", JSON.stringify(segments));
  }

  return `/api/services/proxy?${params.toString()}`;
}
function formatProxyUrl(widget, endpoint, queryParams) {
  const params = getURLSearchParams(widget, endpoint);

  if (queryParams) {
    params.append("query", JSON.stringify(queryParams));
  }

  return `/api/services/proxy?${params.toString()}`;
}
function asJson(data) {
  if (data?.length > 0) {
    const json = JSON.parse(data.toString());
    return json;
  }

  return data;
}
function jsonArrayTransform(data, transform) {
  const json = asJson(data);

  if (json instanceof Array) {
    return transform(json);
  }

  return json;
}
function jsonArrayFilter(data, filter) {
  return jsonArrayTransform(data, items => items.filter(filter));
}
function sanitizeErrorURL(errorURL) {
  // Dont display sensitive params on frontend
  const url = new URL(errorURL);
  ["apikey", "api_key", "token", "t"].forEach(key => {
    if (url.searchParams.has(key)) url.searchParams.set(key, "***");
  });
  return url.toString();
}

/***/ }),

/***/ 5855:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ credentialedProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4511);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)("credentialedProxyHandler");
async function credentialedProxyHandler(req, res, map) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .ZP)(group, service);

    if (!widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api) {
      return res.status(403).json({
        error: "Service does not support API calls"
      });
    }

    if (widget) {
      const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].api, _objectSpread({
        endpoint
      }, widget)));
      const headers = {
        "Content-Type": "application/json"
      };

      if (widget.type === "coinmarketcap") {
        headers["X-CMC_PRO_API_KEY"] = `${widget.key}`;
      } else if (widget.type === "gotify") {
        headers["X-gotify-Key"] = `${widget.key}`;
      } else if (["authentik", "cloudflared", "ghostfolio", "mealie", "tailscale", "truenas", "pterodactyl"].includes(widget.type)) {
        headers.Authorization = `Bearer ${widget.key}`;
      } else if (widget.type === "proxmox") {
        headers.Authorization = `PVEAPIToken=${widget.username}=${widget.password}`;
      } else if (widget.type === "proxmoxbackupserver") {
        delete headers["Content-Type"];
        headers.Authorization = `PBSAPIToken=${widget.username}:${widget.password}`;
      } else if (widget.type === "autobrr") {
        headers["X-API-Token"] = `${widget.key}`;
      } else if (widget.type === "tubearchivist") {
        headers.Authorization = `Token ${widget.key}`;
      } else if (widget.type === "miniflux") {
        headers["X-Auth-Token"] = `${widget.key}`;
      } else if (widget.type === "nextcloud") {
        if (widget.key) {
          headers["NC-Token"] = `${widget.key}`;
        } else {
          headers.Authorization = `Basic ${Buffer.from(`${widget.username}:${widget.password}`).toString("base64")}`;
        }
      } else if (widget.type === "paperlessngx") {
        if (widget.key) {
          headers.Authorization = `Token ${widget.key}`;
        } else {
          headers.Authorization = `Basic ${Buffer.from(`${widget.username}:${widget.password}`).toString("base64")}`;
        }
      } else if (widget.type === "azuredevops") {
        headers.Authorization = `Basic ${Buffer.from(`$:${widget.key}`).toString("base64")}`;
      } else if (widget.type === "glances") {
        headers.Authorization = `Basic ${Buffer.from(`${widget.username}:${widget.password}`).toString("base64")}`;
      } else {
        headers["X-API-Key"] = `${widget.key}`;
      }

      const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url, {
        method: req.method,
        withCredentials: true,
        credentials: "include",
        headers
      });
      let resultData = data;

      if (resultData.error?.url) {
        resultData.error.url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .sanitizeErrorURL */ .yb)(url);
      }

      if (status === 204 || status === 304) {
        return res.status(status).end();
      }

      if (status >= 400) {
        logger.error("HTTP Error %d calling %s", status, url.toString());
      }

      if (status === 200) {
        if (!(0,utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(widget, endpoint, resultData)) {
          return res.status(500).json({
            error: {
              message: "Invalid data",
              url: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .sanitizeErrorURL */ .yb)(url),
              data: resultData
            }
          });
        }

        if (map) resultData = map(resultData);
      }

      if (contentType) res.setHeader("Content-Type", contentType);
      return res.status(status).send(resultData);
    }
  }

  logger.debug("Invalid or missing proxy service type '%s' in group '%s'", service, group);
  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 434:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ genericProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4511);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)("genericProxyHandler");
async function genericProxyHandler(req, res, map) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .ZP)(group, service);

    if (!widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api) {
      return res.status(403).json({
        error: "Service does not support API calls"
      });
    }

    if (widget) {
      // if there are more than one question marks, replace others to &
      const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].api, _objectSpread({
        endpoint
      }, widget)).replace(/(?<=\?.*)\?/g, "&"));
      const headers = req.extraHeaders ?? widget.headers ?? {};

      if (widget.username && widget.password) {
        headers.Authorization = `Basic ${Buffer.from(`${widget.username}:${widget.password}`).toString("base64")}`;
      }

      const params = {
        method: widget.method ?? req.method,
        headers
      };

      if (req.body) {
        params.body = req.body;
      }

      const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url, params);
      let resultData = data;

      if (resultData.error?.url) {
        resultData.error.url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .sanitizeErrorURL */ .yb)(url);
      }

      if (status === 200) {
        if (!(0,utils_proxy_validate_widget_data__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(widget, endpoint, resultData)) {
          return res.status(status).json({
            error: {
              message: "Invalid data",
              url: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .sanitizeErrorURL */ .yb)(url),
              data: resultData
            }
          });
        }

        if (map) resultData = map(resultData);
      }

      if (contentType) res.setHeader("Content-Type", contentType);

      if (status === 204 || status === 304) {
        return res.status(status).end();
      }

      if (status >= 400) {
        logger.debug("HTTP Error %d calling %s//%s%s%s...", status, url.protocol, url.hostname, url.port ? `:${url.port}` : "", url.pathname);
        return res.status(status).json({
          error: {
            message: "HTTP Error",
            url: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .sanitizeErrorURL */ .yb)(url),
            resultData
          }
        });
      }

      return res.status(status).send(resultData);
    }
  }

  logger.debug("Invalid or missing proxy service type '%s' in group '%s'", service, group);
  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9849:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ jsonrpcProxyHandler),
/* harmony export */   "z": () => (/* binding */ sendJsonRpcRequest)
/* harmony export */ });
/* harmony import */ var json_rpc_2_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7837);
/* harmony import */ var json_rpc_2_0__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(json_rpc_2_0__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)("jsonrpcProxyHandler");
async function sendJsonRpcRequest(url, method, params, username, password) {
  const headers = {
    "content-type": "application/json",
    accept: "application/json"
  };

  if (username && password) {
    headers.authorization = `Basic ${Buffer.from(`${username}:${password}`).toString("base64")}`;
  }

  const client = new json_rpc_2_0__WEBPACK_IMPORTED_MODULE_0__.JSONRPCClient(async rpcRequest => {
    const body = JSON.stringify(rpcRequest);
    const httpRequestParams = {
      method: "POST",
      headers,
      body
    }; // eslint-disable-next-line no-unused-vars

    const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, httpRequestParams);

    if (status === 200) {
      const json = JSON.parse(data.toString()); // in order to get access to the underlying error object in the JSON response
      // you must set `result` equal to undefined

      if (json.error && json.result === null) {
        json.result = undefined;
      }

      return client.receive(json);
    }

    return Promise.reject(data?.error ? data : new Error(data.toString()));
  });

  try {
    const response = await client.request(method, params);
    return [200, "application/json", JSON.stringify(response)];
  } catch (e) {
    if (e instanceof json_rpc_2_0__WEBPACK_IMPORTED_MODULE_0__.JSONRPCErrorException) {
      logger.debug("Error calling JSONPRC endpoint: %s.  %s", url, e.message);
      return [200, "application/json", JSON.stringify({
        result: null,
        error: {
          code: e.code,
          message: e.message
        }
      })];
    }

    logger.warn("Error calling JSONPRC endpoint: %s.  %s", url, e);
    return [500, "application/json", JSON.stringify({
      result: null,
      error: {
        code: 2,
        message: e.toString()
      }
    })];
  }
}
async function jsonrpcProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint: method
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);
    const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api;

    if (!api) {
      return res.status(403).json({
        error: "Service does not support API calls"
      });
    }

    if (widget) {
      const url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({}, widget)); // eslint-disable-next-line no-unused-vars

      const [status, contentType, data] = await sendJsonRpcRequest(url, method, null, widget.username, widget.password);
      return res.status(status).end(data);
    }
  }

  logger.debug("Invalid or missing proxy service type '%s' in group '%s'", service, group);
  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5069:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ synologyProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const INFO_ENDPOINT = "{url}/webapi/query.cgi?api=SYNO.API.Info&version=1&method=query";
const AUTH_ENDPOINT = "{url}/webapi/{path}?api=SYNO.API.Auth&version={maxVersion}&method=login&account={username}&passwd={password}&session=DownloadStation&format=cookie";
const AUTH_API_NAME = "SYNO.API.Auth";
const proxyName = "synologyProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);

async function login(loginUrl) {
  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(loginUrl);

  if (status !== 200) {
    return [status, contentType, data];
  }

  const json = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .asJson */ .vl)(data);

  if (json?.success !== true) {
    // from page 16: https://global.download.synology.com/download/Document/Software/DeveloperGuide/Os/DSM/All/enu/DSM_Login_Web_API_Guide_enu.pdf

    /*
      Code Description
      400  No such account or incorrect password
      401  Account disabled
      402  Permission denied
      403  2-step verification code required
      404  Failed to authenticate 2-step verification code
    */
    let message = "Authentication failed.";
    if (json?.error?.code >= 403) message += " 2FA enabled.";
    logger.warn("Unable to login.  Code: %d", json?.error?.code);
    return [401, "application/json", JSON.stringify({
      code: json?.error?.code,
      message
    })];
  }

  return [status, contentType, data];
}

async function getApiInfo(serviceWidget, apiName, serviceName) {
  const cacheKey = `${proxyName}__${apiName}__${serviceName}`;
  let {
    cgiPath,
    maxVersion
  } = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(cacheKey) ?? {};

  if (cgiPath && maxVersion) {
    return [cgiPath, maxVersion];
  }

  const infoUrl = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(INFO_ENDPOINT, serviceWidget); // eslint-disable-next-line no-unused-vars

  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(infoUrl);

  if (status === 200) {
    try {
      const json = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .asJson */ .vl)(data);

      if (json?.data?.[apiName]) {
        cgiPath = json.data[apiName].path;
        maxVersion = json.data[apiName].maxVersion;
        logger.debug(`Detected ${serviceWidget.type}: apiName '${apiName}', cgiPath '${cgiPath}', and maxVersion ${maxVersion}`);
        memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(cacheKey, {
          cgiPath,
          maxVersion
        });
        return [cgiPath, maxVersion];
      }
    } catch {
      logger.warn(`Error ${status} obtaining ${apiName} info`);
    }
  }

  return [null, null];
}

async function handleUnsuccessfulResponse(serviceWidget, url, serviceName) {
  logger.debug(`Attempting login to ${serviceWidget.type}`); // eslint-disable-next-line no-unused-vars

  const [apiPath, maxVersion] = await getApiInfo(serviceWidget, AUTH_API_NAME, serviceName);

  const authArgs = _objectSpread({
    path: apiPath ?? "entry.cgi",
    maxVersion: maxVersion ?? 7
  }, serviceWidget);

  const loginUrl = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(AUTH_ENDPOINT, authArgs);
  const [status, contentType, data] = await login(loginUrl);

  if (status !== 200) {
    return [status, contentType, data];
  }

  return (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url);
}

function toError(url, synologyError) {
  // commeon codes (100 => 199) from:
  // https://global.download.synology.com/download/Document/Software/DeveloperGuide/Os/DSM/All/enu/DSM_Login_Web_API_Guide_enu.pdf
  const code = synologyError.error?.code ?? synologyError.error ?? synologyError.code ?? 100;
  const error = {
    code
  };

  switch (code) {
    case 102:
      error.error = "The requested API does not exist.";
      break;

    case 103:
      error.error = "The requested method does not exist.";
      break;

    case 104:
      error.error = "The requested version does not support the functionality.";
      break;

    case 105:
      error.error = "The logged in session does not have permission.";
      break;

    case 106:
      error.error = "Session timeout.";
      break;

    case 107:
      error.error = "Session interrupted by duplicated login.";
      break;

    case 119:
      error.error = "Invalid session or SID not found.";
      break;

    default:
      error.error = synologyError.message ?? "Unknown error.";
      break;
  }

  logger.warn(`Unable to call ${url}.  code: ${code}, error: ${error.error}.`);
  return error;
}

async function synologyProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const serviceWidget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);
  const widget = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[serviceWidget.type];
  const mapping = widget?.mappings?.[endpoint];

  if (!widget.api || !mapping) {
    return res.status(403).json({
      error: "Service does not support API calls"
    });
  }

  const [cgiPath, maxVersion] = await getApiInfo(serviceWidget, mapping.apiName, service);

  if (!cgiPath || !maxVersion) {
    return res.status(400).json({
      error: `Unrecognized API name: ${mapping.apiName}`
    });
  }

  const url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widget.api, _objectSpread({
    apiName: mapping.apiName,
    apiMethod: mapping.apiMethod,
    cgiPath,
    maxVersion
  }, serviceWidget));
  let [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url);

  if (status !== 200) {
    logger.debug("Error %d calling url %s", status, url);
    return res.status(status, data);
  }

  let json = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .asJson */ .vl)(data);

  if (json?.success !== true) {
    logger.debug(`Attempting login to ${serviceWidget.type}`);
    [status, contentType, data] = await handleUnsuccessfulResponse(serviceWidget, url, service);
    json = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .asJson */ .vl)(data);
  }

  if (json.success !== true) {
    data = toError(url, json);
    status = 500;
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5374:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export default */
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


function useWidgetAPI(widget, ...options) {
  const config = {};

  if (options && options[1]?.refreshInterval) {
    config.refreshInterval = options[1].refreshInterval;
  }

  let url = formatProxyUrl(widget, ...options);

  if (options[0] === "") {
    url = null;
  }

  const {
    data,
    error,
    mutate
  } = useSWR(url, config); // make the data error the top-level error

  return {
    data,
    error: data?.error ?? error,
    mutate
  };
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4511:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ validateWidgetData)
/* harmony export */ });
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([widgets_widgets__WEBPACK_IMPORTED_MODULE_0__]);
widgets_widgets__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/* eslint-disable no-console */

function validateWidgetData(widget, endpoint, data) {
  let valid = true;
  let dataParsed = data;
  let error;
  let mapping;

  if (Buffer.isBuffer(data)) {
    try {
      dataParsed = JSON.parse(data);
    } catch (e) {
      error = e;
      valid = false;
    }
  }

  if (dataParsed && Object.entries(dataParsed).length) {
    const mappings = widgets_widgets__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z[widget.type]?.mappings;

    if (mappings) {
      mapping = Object.values(mappings).find(m => m.endpoint === endpoint);
      mapping?.validate?.forEach(key => {
        if (dataParsed[key] === undefined) {
          valid = false;
        }
      });
    }
  }

  if (!valid) {
    console.warn(`Invalid data for widget '${widget.type}' endpoint '${endpoint}':\nExpected:${mapping?.validate}\nParse error: ${error ?? "none"}\nData: ${JSON.stringify(data)}`);
  }

  return valid;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7996:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/control/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    stats: {
      endpoint: "stats"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1505:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/server/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    info: {
      endpoint: "info"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1303:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ audiobookshelfProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const proxyName = "audiobookshelfProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(proxyName);

async function retrieveFromAPI(url, key) {
  const headers = {
    "content-type": "application/json",
    Authorization: `Bearer ${key}`
  };
  const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, {
    headers
  });

  if (status !== 200) {
    throw new Error(`Error getting data from Audiobookshelf: ${status}. Data: ${data.toString()}`);
  }

  return JSON.parse(Buffer.from(data).toString());
}

async function audiobookshelfProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  if (!widget.key) {
    logger.debug("Invalid or missing key for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Missing widget key"
    });
  }

  const apiURL = widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z[widget.type].api;

  try {
    const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(apiURL, _objectSpread({
      endpoint
    }, widget)));
    const libraryData = await retrieveFromAPI(url, widget.key);
    const libraryStats = await Promise.all(libraryData.libraries.map(async l => {
      const stats = await retrieveFromAPI(new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(apiURL, _objectSpread({
        endpoint: `libraries/${l.id}/stats`
      }, widget))), widget.key);
      return _objectSpread(_objectSpread({}, l), {}, {
        stats
      });
    }));
    return res.status(200).send(libraryStats);
  } catch (e) {
    logger.error(e.message);
    return res.status(500).send({
      error: {
        message: e.message
      }
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9107:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1303);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    libraries: {
      endpoint: "libraries"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9015:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v3/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    users: {
      endpoint: "core/users/?page_size=1"
    },
    login: {
      endpoint: "events/events/per_month/?action=login"
    },
    login_failed: {
      endpoint: "events/events/per_month/?action=login_failed"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5329:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    stats: {
      endpoint: "release/stats",
      validate: ["push_approved_count", "push_rejected_count"]
    },
    filters: {
      endpoint: "filters"
    },
    indexers: {
      endpoint: "release/indexers"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6846:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://dev.azure.com/{organization}/{project}/_apis/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    pr: {
      endpoint: "git/repositories/{repositoryId}/pullrequests"
    },
    pipeline: {
      endpoint: "build/Builds?branchName={branchName}&definitions={definitionId}"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2094:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/api/{endpoint}/wanted?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    movies: {
      endpoint: "movies",
      map: data => ({
        total: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).total
      })
    },
    episodes: {
      endpoint: "episodes",
      map: data => ({
        total: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).total
      })
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1934:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/reverse_proxy/upstreams",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8447:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ calendarProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("calendarProxyHandler");
async function calendarProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .ZP)(group, service);
    const integration = widget.integrations?.find(i => i.name === endpoint);

    if (integration) {
      if (!integration.url) {
        return res.status(403).json({
          error: "No integration URL specified"
        });
      }

      const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(integration.url);
      if (contentType) res.setHeader("Content-Type", contentType);

      if (status !== 200) {
        logger.debug(`HTTTP ${status} retrieving data from integration URL ${integration.url} : ${data}`);
        return res.status(status).send(data);
      }

      return res.status(status).json({
        data: data.toString()
      });
    }
  }

  return res.status(400).json({
    error: "Invalid integration"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3094:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8447);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8887:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
_utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: _utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    stats: {
      endpoint: "opds/stats"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2018:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    info: {
      method: "GET",
      endpoint: "watch"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8153:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status: {
      endpoint: "dvr"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6985:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://api.cloudflare.com/client/v4/accounts/{accountid}/{endpoint}/{tunnelid}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    cfd_tunnel: {
      endpoint: "cfd_tunnel",
      validate: ["success", "result"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5964:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://pro-api.coinmarketcap.com/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "v1/cryptocurrency/quotes/latest": {
      endpoint: "v1/cryptocurrency/quotes/latest",
      params: ["convert"],
      optionalParams: ["symbol", "slug"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9297:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7513:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ delugeProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9849);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__]);
([utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("delugeProxyHandler");
const dataMethod = "web.update_ui";
const dataParams = [["queue", "name", "total_wanted", "state", "progress", "download_payload_rate", "upload_payload_rate", "total_remaining"], {}];
const loginMethod = "auth.login";

async function sendRpc(url, method, params) {
  const [status, contentType, data] = await (0,utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__/* .sendJsonRpcRequest */ .z)(url, method, params);
  const json = JSON.parse(data.toString());

  if (json?.error) {
    if (json.error.code === 1) {
      return [403, contentType, data];
    }

    return [500, contentType, data];
  }

  return [status, contentType, data];
}

function login(url, password) {
  return sendRpc(url, loginMethod, [password]);
}

async function delugeProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z?.[widget.type]?.api;
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(api, _objectSpread({}, widget)));
  let [status, contentType, data] = await sendRpc(url, dataMethod, dataParams);

  if (status === 403) {
    [status, contentType, data] = await login(url, widget.password);

    if (status !== 200) {
      return res.status(status).end(data);
    } // eslint-disable-next-line no-unused-vars


    [status, contentType, data] = await sendRpc(url, dataMethod, dataParams);
  }

  return res.status(status).end(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5616:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7513);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/json",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7122:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5069);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__]);
_utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  // cgiPath and maxVersion are discovered at runtime, don't supply
  api: "{url}/webapi/{cgiPath}?api={apiName}&version={maxVersion}&method={apiMethod}",
  proxyHandler: _utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    system_storage: {
      apiName: "SYNO.Core.System",
      apiMethod: 'info&type="storage"',
      endpoint: "system_storage"
    },
    system_info: {
      apiName: "SYNO.Core.System",
      apiMethod: "info",
      endpoint: "system_info"
    },
    utilization: {
      apiName: "SYNO.Core.System.Utilization",
      apiMethod: "get",
      endpoint: "utilization"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7217:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5069);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__]);
_utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  // cgiPath and maxVersion are discovered at runtime, don't supply
  api: "{url}/webapi/{cgiPath}?api={apiName}&version={maxVersion}&method={apiMethod}",
  proxyHandler: _utils_proxy_handlers_synology__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    list: {
      apiName: "SYNO.DownloadStation.Task",
      apiMethod: "list&additional=transfer",
      endpoint: "list"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6919:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/emby/{endpoint}?api_key={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    Sessions: {
      endpoint: "Sessions"
    },
    Count: {
      endpoint: "Items/Counts",
      segments: ["MovieCount", "SeriesCount", "EpisodeCount", "SongCount"]
    },
    PlayControl: {
      method: "POST",
      endpoint: "Sessions/{sessionId}/Playing/{command}",
      segments: ["sessionId", "command"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    state: {
      endpoint: "state"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3814:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status: {
      endpoint: "status"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9539:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ floodProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("floodProxyHandler");

async function login(widget) {
  logger.debug("flood is rejecting the request, logging in.");
  const loginUrl = new URL(`${widget.url}/api/auth/authenticate`).toString();
  const loginParams = {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: null
  };

  if (widget.username && widget.password) {
    loginParams.body = JSON.stringify({
      username: widget.username,
      password: widget.password
    });
  } // eslint-disable-next-line no-unused-vars


  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(loginUrl, loginParams);
  return [status, data];
}

async function floodProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__/* .formatApiCall */ .s4)("{url}/api/{endpoint}", _objectSpread({
    endpoint
  }, widget)));
  const params = {
    method: "GET",
    headers: {}
  };
  let [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);

  if (status === 401) {
    [status, data] = await login(widget);

    if (status !== 200) {
      logger.error("HTTP %d logging in to flood.  Data: %s", status, data);
      return res.status(status).end(data);
    }

    [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);
  }

  if (status !== 200) {
    logger.error("HTTP %d getting data from flood.  Data: %s", status, data);
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6842:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9539);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1524:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ freshrssProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "freshrssProxyHandler";
const sessionTokenCacheKey = `${proxyName}__sessionToken`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);

async function login(widget, service) {
  const endpoint = "accounts/ClientLogin";
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api;
  const loginUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const headers = {
    "Content-Type": "application/x-www-form-urlencoded"
  };
  const [,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: new URLSearchParams({
      Email: widget.username,
      Passwd: widget.password
    }).toString(),
    headers
  });

  try {
    const [, token] = data.toString().split("\n").find(line => line.startsWith("Auth=")).split("=");
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionTokenCacheKey}.${service}`, token);
    return {
      token
    };
  } catch (e) {
    logger.error("Unable to login to FreshRSS API: %s", e);
  }

  return {
    token: false
  };
}

async function apiCall(widget, endpoint, service) {
  const key = `${sessionTokenCacheKey}.${service}`;
  const headers = {
    Authorization: `GoogleLogin auth=${memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(key)}`
  };
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].api, _objectSpread({
    endpoint
  }, widget)));
  const method = "GET";
  let [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
    method,
    headers
  });

  if (status === 401) {
    logger.debug("FreshRSS API rejected the request, attempting to obtain new session token");
    const {
      token
    } = await login(widget, service);
    headers.Authorization = `GoogleLogin auth=${token}`; // retry the request, now with the new session token

    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
      method,
      headers
    });
  }

  if (status !== 200) {
    logger.error("Error getting data from FreshRSS: %s status %d. Data: %s", url, status, data);
    return {
      status,
      contentType,
      data: null,
      responseHeaders
    };
  }

  return {
    status,
    contentType,
    data: JSON.parse(data.toString()),
    responseHeaders
  };
}

async function freshrssProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  if (!memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionTokenCacheKey}.${service}`)) {
    await login(widget, service);
  }

  const {
    data: subscriptionData
  } = await apiCall(widget, "reader/api/0/subscription/list", service);
  const {
    data: unreadCountData
  } = await apiCall(widget, "reader/api/0/unread-count", service);
  return res.status(200).send({
    subscriptions: subscriptionData?.subscriptions.length,
    unread: unreadCountData?.max
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5661:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1524);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/greader.php/{endpoint}?output=json",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    info: {
      endpoint: "/"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9899:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "n": () => (/* binding */ fritzboxDefaultFields)
/* harmony export */ });
/* unused harmony export default */
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9684);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2205);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5374);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const fritzboxDefaultFields = ["connectionStatus", "uptime", "maxDown", "maxUp"];
function Component({
  service
}) {
  const {
    t
  } = useTranslation();
  const {
    widget
  } = service;
  const {
    data: fritzboxData,
    error: fritzboxError
  } = useWidgetAPI(widget, "status");

  if (fritzboxError) {
    return /*#__PURE__*/_jsx(Container, {
      service: service,
      error: fritzboxError
    });
  } // Default fields


  if (!widget.fields?.length > 0) {
    widget.fields = fritzboxDefaultFields;
  }

  const MAX_ALLOWED_FIELDS = 4; // Limits max number of displayed fields

  if (widget.fields?.length > MAX_ALLOWED_FIELDS) {
    widget.fields = widget.fields.slice(0, MAX_ALLOWED_FIELDS);
  }

  if (!fritzboxData) {
    return /*#__PURE__*/_jsxs(Container, {
      service: service,
      children: [/*#__PURE__*/_jsx(Block, {
        label: "fritzbox.connectionStatus"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.uptime"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.maxDown"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.maxUp"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.down"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.up"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.received"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.sent"
      }), /*#__PURE__*/_jsx(Block, {
        label: "fritzbox.externalIPAddress"
      })]
    });
  }

  return /*#__PURE__*/_jsxs(Container, {
    service: service,
    children: [/*#__PURE__*/_jsx(Block, {
      label: "fritzbox.connectionStatus",
      value: t(`fritzbox.connectionStatus${fritzboxData.connectionStatus}`)
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.uptime",
      value: t("common.uptime", {
        value: fritzboxData.uptime
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.maxDown",
      value: t("common.byterate", {
        value: fritzboxData.maxDown / 8,
        decimals: 1
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.maxUp",
      value: t("common.byterate", {
        value: fritzboxData.maxUp / 8,
        decimals: 1
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.down",
      value: t("common.byterate", {
        value: fritzboxData.down,
        decimals: 1
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.up",
      value: t("common.byterate", {
        value: fritzboxData.up,
        decimals: 1
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.received",
      value: t("common.bytes", {
        value: fritzboxData.received
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.sent",
      value: t("common.bytes", {
        value: fritzboxData.sent
      })
    }), /*#__PURE__*/_jsx(Block, {
      label: "fritzbox.externalIPAddress",
      value: fritzboxData.externalIPAddress
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8291:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ fritzboxProxyHandler)
/* harmony export */ });
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(322);
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(xml_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9899);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_component__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__]);
([_component__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)("fritzboxProxyHandler");

async function requestEndpoint(apiBaseUrl, service, action) {
  const servicePath = service === "WANIPConnection" ? "WANIPConn1" : "WANCommonIFC1";
  const params = {
    method: "POST",
    headers: {
      "Content-Type": "text/xml; charset='utf-8'",
      SoapAction: `urn:schemas-upnp-org:service:${service}:1#${action}`
    },
    body: "<?xml version='1.0' encoding='utf-8'?>" + "<s:Envelope s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'>" + "<s:Body>" + `<u:${action} xmlns:u='urn:schemas-upnp-org:service:${service}:1' />` + "</s:Body>" + "</s:Envelope>"
  };
  const apiUrl = `${apiBaseUrl}/igdupnp/control/${servicePath}`;
  const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(apiUrl, params);

  if (status !== 200) {
    logger.debug(`HTTP ${status} performing SoapRequest for ${service}->${action}`, data);
    throw new Error(`Failed fetching '${action}'`);
  }

  const response = {};

  try {
    const jsonData = JSON.parse((0,xml_js__WEBPACK_IMPORTED_MODULE_0__.xml2json)(data));
    const responseElements = jsonData?.elements?.[0]?.elements?.[0]?.elements?.[0]?.elements || [];
    responseElements.forEach(element => {
      response[element.name] = element.elements?.[0].text || "";
    });
  } catch (e) {
    logger.debug(`Failed parsing ${service}->${action} response:`, data);
    throw new Error(`Failed parsing '${action}' response`);
  }

  return response;
}

async function fritzboxProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceWidget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);

  if (!serviceWidget) {
    res.status(500).json({
      error: {
        message: "Service widget not found"
      }
    });
    return;
  }

  if (!serviceWidget.url) {
    res.status(500).json({
      error: {
        message: "Service widget url not configured"
      }
    });
    return;
  }

  const serviceWidgetUrl = new URL(serviceWidget.url);
  const port = serviceWidgetUrl.protocol === "https:" ? 49443 : 49000;
  const apiBaseUrl = `${serviceWidgetUrl.protocol}//${serviceWidgetUrl.hostname}:${port}`;

  if (!serviceWidget.fields?.length > 0) {
    serviceWidget.fields = _component__WEBPACK_IMPORTED_MODULE_1__/* .fritzboxDefaultFields */ .n;
  }

  const requestStatusInfo = ["connectionStatus", "uptime"].some(field => serviceWidget.fields.includes(field));
  const requestLinkProperties = ["maxDown", "maxUp"].some(field => serviceWidget.fields.includes(field));
  const requestAddonInfos = ["down", "up", "received", "sent"].some(field => serviceWidget.fields.includes(field));
  const requestExternalIPAddress = ["externalIPAddress"].some(field => serviceWidget.fields.includes(field));
  await Promise.all([requestStatusInfo ? requestEndpoint(apiBaseUrl, "WANIPConnection", "GetStatusInfo") : null, requestLinkProperties ? requestEndpoint(apiBaseUrl, "WANCommonInterfaceConfig", "GetCommonLinkProperties") : null, requestAddonInfos ? requestEndpoint(apiBaseUrl, "WANCommonInterfaceConfig", "GetAddonInfos") : null, requestExternalIPAddress ? requestEndpoint(apiBaseUrl, "WANIPConnection", "GetExternalIPAddress") : null]).then(([statusInfo, linkProperties, addonInfos, externalIPAddress]) => {
    res.status(200).json({
      connectionStatus: statusInfo?.NewConnectionStatus || "Unconfigured",
      uptime: statusInfo?.NewUptime || 0,
      maxDown: linkProperties?.NewLayer1DownstreamMaxBitRate || 0,
      maxUp: linkProperties?.NewLayer1UpstreamMaxBitRate || 0,
      down: addonInfos?.NewByteReceiveRate || 0,
      up: addonInfos?.NewByteSendRate || 0,
      received: addonInfos?.NewX_AVM_DE_TotalBytesReceived64 || 0,
      sent: addonInfos?.NewX_AVM_DE_TotalBytesSent64 || 0,
      externalIPAddress: externalIPAddress?.NewExternalIPAddress || null
    });
  }).catch(error => {
    res.status(500).json({
      error: {
        message: error.message
      }
    });
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7760:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8291);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3934:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ gamedigProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2330);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_logger__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__]);
([utils_logger__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


const proxyName = "gamedigProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(proxyName);

const gamedig = __webpack_require__(8840);

async function gamedigProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceWidget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);
  const url = new URL(serviceWidget.url);

  try {
    const serverData = await gamedig.query({
      type: serviceWidget.serverType,
      host: url.hostname,
      port: url.port,
      givenPortOnly: true
    });
    res.status(200).send({
      online: true,
      name: serverData.name,
      map: serverData.map,
      players: serverData.players.length,
      maxplayers: serverData.maxplayers,
      bots: serverData.bots.length,
      ping: serverData.ping
    });
  } catch (e) {
    logger.error(e);
    res.status(200).send({
      online: false
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8269:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3934);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6709:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v2/portfolio/performance?range={endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    today: {
      endpoint: "1d"
    },
    year: {
      endpoint: "1y"
    },
    max: {
      endpoint: "max"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1681:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/3/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8838:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    ip: {
      endpoint: "publicip/ip",
      validate: ["public_ip", "region", "country"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2625:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    application: {
      endpoint: "application"
    },
    client: {
      endpoint: "client"
    },
    message: {
      endpoint: "message"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6863:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    alerts: {
      endpoint: "alerts"
    },
    alertmanager: {
      endpoint: "alertmanager/grafana/api/v2/alerts"
    },
    stats: {
      endpoint: "admin/stats",
      validate: ["dashboards"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9671:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    lineup: {
      endpoint: "lineup.json"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 186:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v2/{endpoint}/{uuid}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    checks: {
      endpoint: "checks",
      validate: ["status", "last_ping"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7068:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ homeassistantProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("homeassistantProxyHandler");
const defaultQueries = [{
  template: "{{ states.person|selectattr('state','equalto','home')|list|length }} / {{ states.person|list|length }}",
  label: "homeassistant.people_home"
}, {
  template: "{{ states.light|selectattr('state','equalto','on')|list|length }} / {{ states.light|list|length }}",
  label: "homeassistant.lights_on"
}, {
  template: "{{ states.switch|selectattr('state','equalto','on')|list|length }} / {{ states.switch|list|length }}",
  label: "homeassistant.switches_on"
}];

function formatOutput(output, data) {
  return output.replace(/\{.*?\}/g, match => match.replace(/\{|\}/g, "").split(".").reduce((o, p) => o ? o[p] : "", data) ?? "");
}

async function getQuery(query, {
  url,
  key
}) {
  const headers = {
    Authorization: `Bearer ${key}`
  };
  const {
    state,
    template,
    label,
    value
  } = query;

  if (state) {
    return {
      result: await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(new URL(`${url}/api/states/${state}`), {
        headers,
        method: "GET"
      }),
      output: data => {
        const jsonData = JSON.parse(data);
        return {
          label: formatOutput(label ?? "{attributes.friendly_name}", jsonData),
          value: formatOutput(value ?? "{state} {attributes.unit_of_measurement}", jsonData)
        };
      }
    };
  }

  if (template) {
    return {
      result: await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(new URL(`${url}/api/template`), {
        headers,
        method: "POST",
        body: JSON.stringify({
          template
        })
      }),
      output: data => ({
        label,
        value: data.toString()
      })
    };
  }

  return {
    result: [500, null, {
      error: {
        message: `invalid query ${JSON.stringify(query)}`
      }
    }]
  };
}

async function homeassistantProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  let queries = defaultQueries;

  if (!widget.fields && widget.custom) {
    if (typeof widget.custom === "string") {
      try {
        widget.custom = JSON.parse(widget.custom);
      } catch (error) {
        logger.debug("Error parsing HASS widget custom label: %s", JSON.stringify(error));
        return res.status(400).json({
          error: "Error parsing widget custom label"
        });
      }
    }

    queries = widget.custom.slice(0, 4);
  }

  const results = await Promise.all(queries.map(q => getQuery(q, widget)));
  const err = results.find(r => r.result[2]?.error);

  if (err) {
    const [status,, data] = err.result;
    return res.status(status).send(data);
  }

  return res.status(200).send(results.map(r => {
    const [status,, data] = r.result;
    return status === 200 ? r.output(data) : {
      label: status,
      value: data.toString()
    };
  }));
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5669:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7068);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8380:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ homebridgeProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "homebridgeProxyHandler";
const sessionTokenCacheKey = `${proxyName}__sessionToken`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);

async function login(widget, service) {
  const endpoint = "auth/login";
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api;
  const loginUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const loginBody = {
    username: widget.username,
    password: widget.password
  };
  const headers = {
    "Content-Type": "application/json"
  }; // eslint-disable-next-line no-unused-vars

  const [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: JSON.stringify(loginBody),
    headers
  });

  try {
    const {
      access_token: accessToken,
      expires_in: expiresIn
    } = JSON.parse(data.toString());
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionTokenCacheKey}.${service}`, accessToken, expiresIn * 1000 - 5 * 60 * 1000); // expiresIn (s) - 5m

    return {
      accessToken
    };
  } catch (e) {
    logger.error("Unable to login to Homebridge API: %s", e);
  }

  return {
    accessToken: false
  };
}

async function apiCall(widget, endpoint, service) {
  const key = `${sessionTokenCacheKey}.${service}`;
  const headers = {
    "content-type": "application/json",
    Authorization: `Bearer ${memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(key)}`
  };
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].api, _objectSpread({
    endpoint
  }, widget)));
  const method = "GET";
  let [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
    method,
    headers
  });

  if (status === 401 || status === 403) {
    logger.debug("Homebridge API rejected the request, attempting to obtain new session token");
    const {
      accessToken
    } = await login(widget, service);
    headers.Authorization = `Bearer ${accessToken}`; // retry the request, now with the new session token

    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
      method,
      headers
    });
  }

  if (status !== 200) {
    logger.error("Error getting data from Homebridge: %s status %d. Data: %s", url, status, JSON.stringify(data));
    return {
      status,
      contentType,
      data: null,
      responseHeaders
    };
  }

  return {
    status,
    contentType,
    data: JSON.parse(data.toString()),
    responseHeaders
  };
}

async function homebridgeProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  if (!memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionTokenCacheKey}.${service}`)) {
    await login(widget, service);
  }

  const {
    data: statusData
  } = await apiCall(widget, "status/homebridge", service);
  const {
    data: versionData
  } = await apiCall(widget, "status/homebridge-version", service);
  const {
    data: childBridgeData
  } = await apiCall(widget, "status/homebridge/child-bridges", service);
  const {
    data: pluginsData
  } = await apiCall(widget, "plugins", service);
  return res.status(200).send({
    status: statusData?.status,
    updateAvailable: versionData?.updateAvailable,
    plugins: {
      updatesAvailable: pluginsData?.filter(p => p.updateAvailable).length
    },
    childBridges: {
      running: childBridgeData?.filter(cb => cb.status === "ok").length,
      total: childBridgeData?.length
    }
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4790:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8380);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    info: {
      endpoint: "/"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1761:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/server-info/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    version: {
      endpoint: "version"
    },
    statistics: {
      endpoint: "statistics"
    },
    stats: {
      endpoint: "stats"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7736:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v2.0/{endpoint}?apikey={key}&configured=true",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    indexers: {
      endpoint: "indexers"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9868:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ jdownloaderProxyHandler)
/* harmony export */ });
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6113);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var querystring__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3477);
/* harmony import */ var querystring__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(querystring__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9683);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__, utils_logger__WEBPACK_IMPORTED_MODULE_5__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__, utils_logger__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-underscore-dangle */






const proxyName = "jdownloaderProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(proxyName);

async function getWidget(req) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return null;
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return null;
  }

  return widget;
}

async function login(loginSecret, deviceSecret, params) {
  const rid = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .uniqueRid */ .Qh)();
  const path = `/my/connect?${querystring__WEBPACK_IMPORTED_MODULE_1___default().stringify(_objectSpread(_objectSpread({}, params), {}, {
    rid
  }))}`;
  const signature = crypto__WEBPACK_IMPORTED_MODULE_0___default().createHmac("sha256", loginSecret).update(path).digest("hex");
  const url = `${new URL(`https://api.jdownloader.org${path}&signature=${signature}`)}`;
  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__/* .httpProxy */ .hC)(url, {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    }
  });

  if (status !== 200) {
    logger.error("HTTP %d communicating with jdownloader. Data: %s", status, data.toString());
    return [status, data];
  }

  try {
    const decryptedData = JSON.parse((0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .decrypt */ .pe)(data.toString(), loginSecret));
    const sessionToken = decryptedData.sessiontoken;
    (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .validateRid */ .Bj)(decryptedData, rid);
    const serverEncryptionToken = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .createEncryptionToken */ .ku)(loginSecret, sessionToken);
    const deviceEncryptionToken = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .createEncryptionToken */ .ku)(deviceSecret, sessionToken);
    return [status, decryptedData, contentType, serverEncryptionToken, deviceEncryptionToken, sessionToken];
  } catch (e) {
    logger.error("Error decoding jdownloader API data. Data: %s", data.toString());
    return [status, null];
  }
}

async function getDevice(serverEncryptionToken, deviceName, params) {
  const rid = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .uniqueRid */ .Qh)();
  const path = `/my/listdevices?${querystring__WEBPACK_IMPORTED_MODULE_1___default().stringify(_objectSpread(_objectSpread({}, params), {}, {
    rid
  }))}`;
  const signature = crypto__WEBPACK_IMPORTED_MODULE_0___default().createHmac("sha256", serverEncryptionToken).update(path).digest("hex");
  const url = `${new URL(`https://api.jdownloader.org${path}&signature=${signature}`)}`;
  const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__/* .httpProxy */ .hC)(url, {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    }
  });

  if (status !== 200) {
    logger.error("HTTP %d communicating with jdownloader. Data: %s", status, data.toString());
    return [status, data];
  }

  try {
    const decryptedData = JSON.parse((0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .decrypt */ .pe)(data.toString(), serverEncryptionToken));
    const filteredDevice = decryptedData.list.filter(device => device.name === deviceName);
    return [status, filteredDevice[0].id];
  } catch (e) {
    logger.error("Error decoding jdownloader API data. Data: %s", data.toString());
    return [status, null];
  }
}

function createBody(rid, query, params) {
  const baseBody = {
    apiVer: 1,
    rid,
    url: query
  };
  return params ? _objectSpread(_objectSpread({}, baseBody), {}, {
    params: [JSON.stringify(params)]
  }) : baseBody;
}

async function queryPackages(deviceEncryptionToken, deviceId, sessionToken, params) {
  const rid = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .uniqueRid */ .Qh)();
  const body = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .encrypt */ .HI)(JSON.stringify(createBody(rid, "/downloadsV2/queryPackages", params)), deviceEncryptionToken);
  const url = `${new URL(`https://api.jdownloader.org/t_${encodeURI(sessionToken)}_${encodeURI(deviceId)}/downloadsV2/queryPackages`)}`;
  const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__/* .httpProxy */ .hC)(url, {
    method: "POST",
    body
  });

  if (status !== 200) {
    logger.error("HTTP %d communicating with jdownloader. Data: %s", status, data.toString());
    return [status, data];
  }

  try {
    const decryptedData = JSON.parse((0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .decrypt */ .pe)(data.toString(), deviceEncryptionToken));
    return decryptedData.data;
  } catch (e) {
    logger.error("Error decoding JDRss jdownloader data. Data: %s", data.toString());
    return [status, null];
  }
}

async function jdownloaderProxyHandler(req, res) {
  const widget = await getWidget(req);

  if (!widget) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  logger.debug("Getting data from JDRss API");
  const {
    username
  } = widget;
  const {
    password
  } = widget;
  const appKey = "homepage";
  const loginSecret = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .sha256 */ .JQ)(`${username}${password}server`);
  const deviceSecret = (0,_tools__WEBPACK_IMPORTED_MODULE_2__/* .sha256 */ .JQ)(`${username}${password}device`);
  const email = username;
  const loginData = await login(loginSecret, deviceSecret, {
    appKey,
    email
  });
  const deviceData = await getDevice(loginData[3], widget.client, {
    sessiontoken: loginData[5]
  });
  const packageStatus = await queryPackages(loginData[4], deviceData[1], loginData[5], {
    bytesLoaded: true,
    bytesTotal: true,
    comment: false,
    enabled: true,
    eta: false,
    priority: false,
    finished: true,
    running: true,
    speed: true,
    status: true,
    childCount: false,
    hosts: false,
    saveTo: false,
    maxResults: -1,
    startAt: 0
  });
  let totalLoaded = 0;
  let totalBytes = 0;
  let totalSpeed = 0;
  packageStatus.forEach(file => {
    totalBytes += file.bytesTotal;
    totalLoaded += file.bytesLoaded;

    if (file.finished !== true && file.speed) {
      totalSpeed += file.speed;
    }
  });
  const data = {
    downloadCount: packageStatus.length,
    bytesRemaining: totalBytes - totalLoaded,
    totalBytes,
    totalSpeed
  };
  return res.send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9683:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Bj": () => (/* binding */ validateRid),
/* harmony export */   "HI": () => (/* binding */ encrypt),
/* harmony export */   "JQ": () => (/* binding */ sha256),
/* harmony export */   "Qh": () => (/* binding */ uniqueRid),
/* harmony export */   "ku": () => (/* binding */ createEncryptionToken),
/* harmony export */   "pe": () => (/* binding */ decrypt)
/* harmony export */ });
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6113);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_0__);

function sha256(data) {
  return crypto__WEBPACK_IMPORTED_MODULE_0___default().createHash("sha256").update(data).digest();
}
function uniqueRid() {
  return Math.floor(Math.random() * 10e12);
}
function validateRid(decryptedData, rid) {
  if (decryptedData.rid !== rid) {
    throw new Error("RequestID mismatch");
  }

  return decryptedData;
}
function decrypt(data, ivKey) {
  const iv = ivKey.slice(0, ivKey.length / 2);
  const key = ivKey.slice(ivKey.length / 2, ivKey.length);
  const cipher = crypto__WEBPACK_IMPORTED_MODULE_0___default().createDecipheriv("aes-128-cbc", key, iv);
  return Buffer.concat([cipher.update(data, "base64"), cipher.final()]).toString();
}
function createEncryptionToken(oldTokenBuff, updateToken) {
  const updateTokenBuff = Buffer.from(updateToken, "hex");
  const mergedBuffer = Buffer.concat([oldTokenBuff, updateTokenBuff], oldTokenBuff.length + updateTokenBuff.length);
  return sha256(mergedBuffer);
}
function encrypt(data, ivKey) {
  if (typeof data !== "string") {
    throw new Error("data no es un string");
  }

  if (!(ivKey instanceof Buffer)) {
    throw new Error("ivKey no es un buffer");
  }

  if (ivKey.length !== 32) {
    throw new Error("ivKey tiene que tener tamaño 32");
  }

  const stringIVKey = ivKey.toString("hex");
  const stringIV = stringIVKey.substring(0, stringIVKey.length / 2);
  const stringKey = stringIVKey.substring(stringIVKey.length / 2, stringIVKey.length);
  const iv = Buffer.from(stringIV, "hex");
  const key = Buffer.from(stringKey, "hex");
  const cipher = crypto__WEBPACK_IMPORTED_MODULE_0___default().createCipheriv("aes-128-cbc", key, iv);
  return cipher.update(data, "utf8", "base64") + cipher.final("base64");
}

/***/ }),

/***/ 7655:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9868);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://api.jdownloader.org/{endpoint}/&signature={signature}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    unified: {
      endpoint: "/",
      signature: ""
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6433:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "request/count": {
      endpoint: "request/count",
      validate: ["pending", "approved", "available"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5676:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ KavitaProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "kavitaProxyHandler";
const sessionTokenCacheKey = `${proxyName}__sessionToken`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);

async function login(widget, service) {
  const endpoint = "Account/login";
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api;
  const loginUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const loginBody = {
    username: widget.username,
    password: widget.password
  };
  const headers = {
    "Content-Type": "application/json",
    accept: "text/plain"
  };
  const [,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: JSON.stringify(loginBody),
    headers
  });

  try {
    const {
      token: accessToken
    } = JSON.parse(data.toString());
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionTokenCacheKey}.${service}`, accessToken);
    return {
      accessToken
    };
  } catch (e) {
    logger.error("Unable to login to Kavita API: %s", e);
  }

  return {
    token: false
  };
}

async function apiCall(widget, endpoint, service) {
  const key = `${sessionTokenCacheKey}.${service}`;
  const headers = {
    "content-type": "application/json",
    Authorization: `Bearer ${memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(key)}`
  };
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].api, _objectSpread({
    endpoint
  }, widget)));
  const method = "GET";
  let [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
    method,
    headers
  });

  if (status === 401 || status === 403) {
    logger.debug("Kavita API rejected the request, attempting to obtain new session token");
    const {
      accessToken
    } = await login(widget, service);
    headers.Authorization = `Bearer ${accessToken}`; // retry the request, now with the new session token

    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
      method,
      headers
    });
  }

  if (status !== 200) {
    logger.error("Error getting data from Kavita: %s status %d. Data: %s", url, status, data);
    return {
      status,
      contentType,
      data: null,
      responseHeaders
    };
  }

  return {
    status,
    contentType,
    data: JSON.parse(data.toString()),
    responseHeaders
  };
}

async function KavitaProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  if (!memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionTokenCacheKey}.${service}`)) {
    await login(widget, service);
  }

  const {
    data: statsData
  } = await apiCall(widget, "Stats/server/stats", service);
  return res.status(200).send({
    seriesCount: statsData?.seriesCount,
    totalFiles: statsData?.totalFiles
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5260:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5676);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    info: {
      endpoint: "/"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3848:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    libraries: {
      endpoint: "libraries",
      map: data => ({
        total: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .jsonArrayFilter */ .sj)(data, item => !item.unavailable).length
      })
    },
    series: {
      endpoint: "series",
      validate: ["totalElements"]
    },
    books: {
      endpoint: "books",
      validate: ["totalElements"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6355:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status: {
      endpoint: "api/v1/sources"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9427:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    artist: {
      endpoint: "artist"
    },
    "wanted/missing": {
      endpoint: "wanted/missing"
    },
    "queue/status": {
      endpoint: "queue/status"
    },
    calendar: {
      endpoint: "calendar",
      params: ["start", "end", "unmonitored", "includeArtist"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1327:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    instance: {
      endpoint: "instance"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7750:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/groups/statistics",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9094:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{key}/{endpoint}/",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    stats: {
      endpoint: "?cmd=shows.stats",
      validate: ["data"]
    },
    future: {
      endpoint: "?cmd=future",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/rest/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    system: {
      endpoint: "system/resource",
      validate: ["cpu-load", "free-memory", "total-memory", "uptime"]
    },
    leases: {
      endpoint: "ip/dhcp-server/lease"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5653:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ minecraftProxyHandler)
/* harmony export */ });
/* harmony import */ var minecraft_ping_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9463);
/* harmony import */ var minecraft_ping_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(minecraft_ping_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2330);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_logger__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__]);
([utils_logger__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const proxyName = "minecraftProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(proxyName);
async function minecraftProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceWidget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);
  const url = new URL(serviceWidget.url);

  try {
    const pingResponse = await (0,minecraft_ping_js__WEBPACK_IMPORTED_MODULE_0__.pingWithPromise)(url.hostname, url.port || 25565);
    res.status(200).send({
      version: pingResponse.version.name,
      online: true,
      players: pingResponse.players
    });
  } catch (e) {
    logger.error(e);
    res.status(200).send({
      version: undefined,
      online: false,
      players: undefined
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8510:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5653);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7849:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    counters: {
      endpoint: "feeds/counters",
      map: data => ({
        read: Object.values((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).reads).reduce((acc, i) => acc + i, 0),
        unread: Object.values((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).unreads).reduce((acc, i) => acc + i, 0)
      })
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4244:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8314:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/printer/objects/query?{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    print_stats: {
      endpoint: "print_stats"
    },
    display_status: {
      endpoint: "display_status"
    },
    webhooks: {
      endpoint: "webhooks"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9532:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api?cmd={endpoint}&apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    issues: {
      endpoint: "getIndex"
    },
    series: {
      endpoint: "seriesjsonListing"
    },
    wanted: {
      endpoint: "getWanted"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9014:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/rest/{endpoint}?u={user}&t={token}&s={salt}&v=1.16.1&c=homepage&f=json",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    getNowPlaying: {
      endpoint: "getNowPlaying"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3886:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    serverinfo: {
      endpoint: "ocs/v2.php/apps/serverinfo/api/v1/info?format=json"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2702:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://api.nextdns.io/profiles/{profile}/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "analytics/status": {
      endpoint: "analytics/status",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6773:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ npmProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8110);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "npmProxyHandler";
const tokenCacheKey = `${proxyName}__token`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(proxyName);

async function login(loginUrl, username, password, service) {
  const authResponse = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: JSON.stringify({
      identity: username,
      secret: password
    }),
    headers: {
      "Content-Type": "application/json"
    }
  });
  const status = authResponse[0];
  let data = authResponse[2];

  try {
    data = JSON.parse(Buffer.from(authResponse[2]).toString());

    if (status === 200) {
      const expiration = new Date(data.expires) - Date.now();
      memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${tokenCacheKey}.${service}`, data.token, expiration - 5 * 60 * 1000); // expiration -5 minutes
    }
  } catch (e) {
    logger.error(`Error ${status} logging into npm`, authResponse[2]);
  }

  return [status, data.token ?? data];
}

async function npmProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

    if (!widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z?.[widget.type]?.api) {
      return res.status(403).json({
        error: "Service does not support API calls"
      });
    }

    if (widget) {
      const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z[widget.type].api, _objectSpread({
        endpoint
      }, widget)));
      const loginUrl = `${widget.url}/api/tokens`;
      let status;
      let contentType;
      let data;
      let token = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${tokenCacheKey}.${service}`);

      if (!token) {
        [status, token] = await login(loginUrl, widget.username, widget.password, service);

        if (status !== 200) {
          logger.debug(`HTTTP ${status} logging into npm api: ${token}`);
          return res.status(status).send(token);
        }
      }

      [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url, {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer ${token}`
        }
      });

      if (status === 403) {
        logger.debug(`HTTTP ${status} retrieving data from npm api, logging in and trying again.`);
        memory_cache__WEBPACK_IMPORTED_MODULE_0___default().del(`${tokenCacheKey}.${service}`);
        [status, token] = await login(loginUrl, widget.username, widget.password, service);

        if (status !== 200) {
          logger.debug(`HTTTP ${status} logging into npm api: ${data}`);
          return res.status(status).send(data);
        } // eslint-disable-next-line no-unused-vars


        [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url, {
          method: "GET",
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bearer ${token}`
          }
        });
      }

      if (status !== 200) {
        return res.status(status).send(data);
      }

      return res.send(data);
    }
  }

  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8230:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6773);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8137:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9849);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/jsonrpc",
  proxyHandler: utils_proxy_handlers_jsonrpc__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1166:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    printer_stats: {
      endpoint: "printer"
    },
    job_stats: {
      endpoint: "job"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9112:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ omadaProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const proxyName = "omadaProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(proxyName);

async function login(loginUrl, username, password, controllerVersionMajor) {
  const params = {
    username,
    password
  };

  if (controllerVersionMajor === 3) {
    params.method = "login";
    params.params = {
      name: username,
      password
    };
  } // eslint-disable-next-line no-unused-vars


  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: JSON.stringify(params),
    headers: {
      "Content-Type": "application/json"
    }
  });
  return [status, JSON.parse(data.toString())];
}

async function omadaProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

    if (widget) {
      const {
        url
      } = widget;
      const controllerInfoURL = `${url}/api/info`;
      let [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(controllerInfoURL, {
        headers: {
          "Content-Type": "application/json"
        }
      });

      if (status !== 200) {
        logger.error("Unable to retrieve Omada controller info");
        return res.status(status).json({
          error: {
            message: `HTTP Error ${status}`,
            url: controllerInfoURL,
            data
          }
        });
      }

      let cId;
      let controllerVersion;

      try {
        cId = JSON.parse(data).result.omadacId;
        controllerVersion = JSON.parse(data).result.controllerVer;
      } catch (e) {
        controllerVersion = "3.2.x";
      }

      const controllerVersionMajor = parseInt(controllerVersion.split(".")[0], 10);

      if (![3, 4, 5].includes(controllerVersionMajor)) {
        return res.status(500).json({
          error: {
            message: "Error determining controller version",
            data
          }
        });
      }

      let loginUrl;

      switch (controllerVersionMajor) {
        case 3:
          loginUrl = `${url}/api/user/login?ajax`;
          break;

        case 4:
          loginUrl = `${url}/api/v2/login`;
          break;

        case 5:
          loginUrl = `${url}/${cId}/api/v2/login`;
          break;

        default:
          break;
      }

      const [loginStatus, loginResponseData] = await login(loginUrl, widget.username, widget.password, controllerVersionMajor);

      if (loginStatus !== 200 || loginResponseData.errorCode > 0) {
        return res.status(status).json({
          error: {
            message: "Error logging in to Oamda controller",
            url: loginUrl,
            data: loginResponseData
          }
        });
      }

      const {
        token
      } = loginResponseData.result;
      let sitesUrl;
      let body = {};
      let params = {
        token
      };
      let headers = {
        "Csrf-Token": token
      };
      let method = "GET";

      switch (controllerVersionMajor) {
        case 3:
          sitesUrl = `${url}/web/v1/controller?ajax=&token=${token}`;
          body = {
            method: "getUserSites",
            params: {
              userName: widget.username
            }
          };
          method = "POST";
          break;

        case 4:
          sitesUrl = `${url}/api/v2/sites?token=${token}&currentPage=1&currentPageSize=1000`;
          break;

        case 5:
          sitesUrl = `${url}/${cId}/api/v2/sites?token=${token}&currentPage=1&currentPageSize=1000`;
          break;

        default:
          break;
      }

      [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(sitesUrl, {
        method,
        params,
        body: JSON.stringify(body),
        headers
      });
      const sitesResponseData = JSON.parse(data);

      if (status !== 200 || sitesResponseData.errorCode > 0) {
        logger.debug(`HTTTP ${status} getting sites list: ${sitesResponseData.msg}`);
        return res.status(status).json({
          error: {
            message: "Error getting sites list",
            url,
            data: sitesResponseData
          }
        });
      }

      const site = controllerVersionMajor === 3 ? sitesResponseData.result.siteList.find(s => s.name === widget.site) : sitesResponseData.result.data.find(s => s.name === widget.site);

      if (!site) {
        return res.status(status).json({
          error: {
            message: `Site ${widget.site} is not found`,
            url: sitesUrl,
            data
          }
        });
      }

      let siteResponseData;
      let connectedAp;
      let activeUser;
      let connectedSwitches;
      let connectedGateways;
      let alerts;

      if (controllerVersionMajor === 3) {
        // Omada v3 controller requires switching site
        const switchUrl = `${url}/web/v1/controller?ajax=&token=${token}`;
        method = "POST";
        body = {
          method: "switchSite",
          params: {
            siteName: site.siteName,
            userName: widget.username
          }
        };
        headers = {
          "Content-Type": "application/json"
        };
        params = {
          token
        };
        [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(switchUrl, {
          method,
          params,
          body: JSON.stringify(body),
          headers
        });
        const switchResponseData = JSON.parse(data);

        if (status !== 200 || switchResponseData.errorCode > 0) {
          logger.error(`HTTP ${status} getting sites list: ${data}`);
          return res.status(status).json({
            error: {
              message: "Error switching site",
              url: switchUrl,
              data
            }
          });
        }

        const statsUrl = `${url}/web/v1/controller?getGlobalStat=&token=${token}`;
        [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(statsUrl, {
          method,
          params,
          body: JSON.stringify({
            method: "getGlobalStat"
          }),
          headers
        });
        siteResponseData = JSON.parse(data);

        if (status !== 200 || siteResponseData.errorCode > 0) {
          return res.status(status).json({
            error: {
              message: "Error getting stats",
              url: statsUrl,
              data
            }
          });
        }

        connectedAp = siteResponseData.result.connectedAp;
        activeUser = siteResponseData.result.activeUser;
        alerts = siteResponseData.result.alerts;
      } else if (controllerVersionMajor === 4 || controllerVersionMajor === 5) {
        const siteName = controllerVersionMajor === 5 ? site.id : site.key;
        const siteStatsUrl = controllerVersionMajor === 4 ? `${url}/api/v2/sites/${siteName}/dashboard/overviewDiagram?token=${token}&currentPage=1&currentPageSize=1000` : `${url}/${cId}/api/v2/sites/${siteName}/dashboard/overviewDiagram?token=${token}&currentPage=1&currentPageSize=1000`;
        [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(siteStatsUrl, {
          headers: {
            "Csrf-Token": token
          }
        });
        siteResponseData = JSON.parse(data);

        if (status !== 200 || siteResponseData.errorCode > 0) {
          logger.debug(`HTTP ${status} getting stats for site ${widget.site} with message ${siteResponseData.msg}`);
          return res.status(500).send(data);
        }

        const alertUrl = controllerVersionMajor === 4 ? `${url}/api/v2/sites/${siteName}/alerts/num?token=${token}&currentPage=1&currentPageSize=1000` : `${url}/${cId}/api/v2/sites/${siteName}/alerts/num?token=${token}&currentPage=1&currentPageSize=1000`; // eslint-disable-next-line no-unused-vars

        [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(alertUrl, {
          headers: {
            "Csrf-Token": token
          }
        });
        const alertResponseData = JSON.parse(data);
        activeUser = siteResponseData.result.totalClientNum;
        connectedAp = siteResponseData.result.connectedApNum;
        connectedGateways = siteResponseData.result.connectedGatewayNum;
        connectedSwitches = siteResponseData.result.connectedSwitchNum;
        alerts = alertResponseData.result.alertNum;
      }

      return res.send(JSON.stringify({
        connectedAp,
        activeUser,
        alerts,
        connectedGateways,
        connectedSwitches
      }));
    }
  }

  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9568:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9112);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2035:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "Request/count": {
      endpoint: "Request/count"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6534:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/livedata/status",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7388:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ proxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9967);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const PROXY_NAME = "OMVProxyHandler";
const BG_MAX_RETRIES = 50;
const BG_POLL_PERIOD = 500;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(PROXY_NAME);

async function getWidget(req) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return null;
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return null;
  }

  return widget;
}

async function rpc(url, request) {
  const params = {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify(request)
  };
  (0,utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .setCookieHeader */ .w)(url, params);
  const [status, contentType, data, headers] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);
  return {
    status,
    contentType,
    data,
    headers
  };
}

async function poll(attemptsLeft, makeReqByPos, pos = 0) {
  if (attemptsLeft <= 0) {
    return null;
  }

  const resp = await makeReqByPos(pos);
  const data = JSON.parse(resp.data.toString()).response;

  if (data.running === true || data.outputPending) {
    await new Promise(resolve => {
      setTimeout(resolve, BG_POLL_PERIOD);
    });
    return poll(attemptsLeft - 1, makeReqByPos, data.pos);
  }

  return resp;
}

async function tryLogin(widget) {
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api, _objectSpread({}, widget)));
  const {
    username,
    password
  } = widget;
  const resp = await rpc(url, {
    method: "login",
    service: "session",
    params: {
      username: username.toString(),
      password: password.toString()
    }
  });

  if (resp.status !== 200) {
    logger.error("HTTP %d logging in to OpenMediaVault. Data: %s", resp.status, resp.data);
    return [false, resp];
  }

  const json = JSON.parse(resp.data.toString());

  if (json.response.authenticated !== true) {
    logger.error("Login error in OpenMediaVault. Data: %s", resp.data);
    resp.status = 401;
    return [false, resp];
  }

  return [true, resp];
}

async function processBg(url, filename) {
  const resp = await poll(BG_MAX_RETRIES, pos => rpc(url, {
    service: "exec",
    method: "getOutput",
    params: {
      pos,
      filename
    }
  }));

  if (resp == null) {
    const errText = "The maximum number of attempts to receive a response from Bg data has been exceeded.";
    logger.error(errText);
    return errText;
  }

  if (resp.status !== 200) {
    logger.error("HTTP %d getting Bg data from OpenMediaVault RPC. Data: %s", resp.status, resp.data);
  }

  return resp;
}

async function proxyHandler(req, res) {
  const widget = await getWidget(req);

  if (!widget) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z?.[widget.type]?.api;

  if (!api) {
    return res.status(403).json({
      error: "Service does not support RPC calls"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({}, widget)));
  const [service, method] = widget.method.split(".");
  const rpcReq = {
    params: {
      limit: -1,
      start: 0
    },
    service,
    method
  };
  let resp = await rpc(url, rpcReq);

  if (resp.status === 401) {
    logger.debug("Session not authenticated.");
    const [success, lResp] = await tryLogin(widget);

    if (success) {
      (0,utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .addCookieToJar */ .a)(url, lResp.headers);
    } else {
      res.status(lResp.status).json({
        error: {
          message: `HTTP Error ${lResp.status}`,
          url,
          data: lResp.data
        }
      });
    }

    logger.debug("Retrying OpenMediaVault request after login.");
    resp = await rpc(url, rpcReq);
  }

  if (resp.status !== 200) {
    logger.error("HTTP %d getting data from OpenMediaVault RPC. Data: %s", resp.status, resp.data);
    return res.status(resp.status).json({
      error: {
        message: `HTTP Error ${resp.status}`,
        url,
        data: resp.data
      }
    });
  }

  if (method.endsWith("Bg")) {
    const json = JSON.parse(resp.data.toString());
    const bgResp = await processBg(url, json.response);

    if (typeof bgResp === "string") {
      return res.status(400).json({
        error: bgResp
      });
    }

    return res.status(bgResp.status).send(bgResp.data);
  }

  return res.status(resp.status).send(resp.data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2122:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7388);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/rpc.php",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4031:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    activity: {
      endpoint: "diagnostics/activity/getActivity",
      validate: ["headers"]
    },
    interface: {
      endpoint: "diagnostics/traffic/interface",
      validate: ["interfaces"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5245:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "request/count": {
      endpoint: "request/count",
      validate: ["pending", "processing", "approved", "available"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 815:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    statistics: {
      endpoint: "statistics/?format=json",
      validate: ["documents_total"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3726:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}/{key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    devices: {
      endpoint: "devices"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3800:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    system: {
      endpoint: "status/system",
      validate: ["data"]
    },
    interface: {
      endpoint: "status/interface",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 848:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ photoprismProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("photoprismProxyHandler");
async function photoprismProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__/* .formatApiCall */ .s4)("{url}/api/v1/session", _objectSpread({}, widget)));
  const params = {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: null
  };

  if (widget.username && widget.password) {
    params.body = JSON.stringify({
      username: widget.username,
      password: widget.password
    });
  }

  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);

  if (status !== 200) {
    logger.error("HTTP %d getting data from PhotoPrism. Data: %s", status, data);
    return res.status(status).json({
      error: {
        message: `HTTP Error ${status}`,
        url,
        data
      }
    });
  }

  const json = JSON.parse(data.toString());
  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(200).send(json?.config?.count);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4212:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(848);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7926:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/php/server/devices.php?action=getDevicesTotals",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    data: {
      endpoint: "data"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4827:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/admin/api.php?{endpoint}&auth={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    summaryRaw: {
      endpoint: "summaryRaw",
      validate: ["dns_queries_today", "ads_blocked_today", "ads_percentage_today", "domains_being_blocked"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4373:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ plexProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(322);
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(xml_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__, widgets_widgets__WEBPACK_IMPORTED_MODULE_5__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__, widgets_widgets__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-underscore-dangle */







const proxyName = "plexProxyHandler";
const librariesCacheKey = `${proxyName}__libraries`;
const albumsCacheKey = `${proxyName}__albums`;
const moviesCacheKey = `${proxyName}__movies`;
const tvCacheKey = `${proxyName}__tv`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(proxyName);

async function getWidget(req) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return null;
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return null;
  }

  return widget;
}

async function fetchFromPlexAPI(endpoint, widget) {
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z?.[widget.type]?.api;

  if (!api) {
    return [403, null];
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_6__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(url);

  if (status !== 200) {
    logger.error("HTTP %d communicating with Plex. Data: %s", status, data.toString());
    return [status, data];
  }

  try {
    const dataDecoded = (0,xml_js__WEBPACK_IMPORTED_MODULE_1__.xml2json)(data.toString(), {
      compact: true
    });
    return [status, JSON.parse(dataDecoded), contentType];
  } catch (e) {
    logger.error("Error decoding Plex API data. Data: %s", data.toString());
    return [status, null];
  }
}

async function plexProxyHandler(req, res) {
  const widget = await getWidget(req);
  const {
    service
  } = req.query;

  if (!widget) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  logger.debug("Getting streams from Plex API");
  let streams;
  let [status, apiData] = await fetchFromPlexAPI("/status/sessions", widget);

  if (status !== 200) {
    return res.status(status).json({
      error: {
        message: "HTTP error communicating with Plex API",
        data: Buffer.from(apiData).toString()
      }
    });
  }

  if (apiData && apiData.MediaContainer) {
    streams = apiData.MediaContainer._attributes.size;
  }

  let libraries = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${librariesCacheKey}.${service}`);

  if (libraries === null) {
    logger.debug("Getting libraries from Plex API");
    [status, apiData] = await fetchFromPlexAPI("/library/sections", widget);

    if (apiData && apiData.MediaContainer) {
      libraries = [].concat(apiData.MediaContainer.Directory);
      memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${librariesCacheKey}.${service}`, libraries, 1000 * 60 * 60 * 6);
    }
  }

  let albums = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${albumsCacheKey}.${service}`);
  let movies = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${moviesCacheKey}.${service}`);
  let tv = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${tvCacheKey}.${service}`);

  if (albums === null || movies === null || tv === null) {
    albums = 0;
    movies = 0;
    tv = 0;
    logger.debug("Getting counts from Plex API");
    const movieTVLibraries = libraries.filter(l => ["movie", "show", "artist"].includes(l._attributes.type));
    await Promise.all(movieTVLibraries.map(async library => {
      const libraryURL = ["movie", "show"].includes(library._attributes.type) ? `/library/sections/${library._attributes.key}/all` // tv + movies
      : `/library/sections/${library._attributes.key}/albums`; // music

      [status, apiData] = await fetchFromPlexAPI(libraryURL, widget);

      if (apiData && apiData.MediaContainer) {
        const size = parseInt(apiData.MediaContainer._attributes.size, 10);

        if (library._attributes.type === "movie") {
          movies += size;
        } else if (library._attributes.type === "show") {
          tv += size;
        } else if (library._attributes.type === "artist") {
          albums += size;
        }
      }
    }));
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${albumsCacheKey}.${service}`, albums, 1000 * 60 * 10);
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${tvCacheKey}.${service}`, tv, 1000 * 60 * 10);
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${moviesCacheKey}.${service}`, movies, 1000 * 60 * 10);
  }

  const data = {
    streams,
    albums,
    movies,
    tv
  };
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7201:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4373);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}{endpoint}?X-Plex-Token={key}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    unified: {
      endpoint: "/"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9242:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/endpoints/{env}/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "docker/containers/json": {
      endpoint: "docker/containers/json",
      params: ["all"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7686:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    targets: {
      endpoint: "targets",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5005:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v1/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    indexer: {
      endpoint: "indexer"
    },
    indexerstats: {
      endpoint: "indexerstats"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 635:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api2/json/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "cluster/resources": {
      endpoint: "cluster/resources"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 947:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const since = Date.now() - 24 * 60 * 60 * 1000;
const widget = {
  api: "{url}/api2/json/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "status/datastore-usage": {
      endpoint: "status/datastore-usage"
    },
    "nodes/localhost/tasks": {
      endpoint: `nodes/localhost/tasks?errors=true&limit=100&since=${since}`
    },
    "nodes/localhost/status": {
      endpoint: "nodes/localhost/status"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8943:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/application/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    nodes: {
      endpoint: "nodes?include=servers",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 472:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ pyloadProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8110);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8562);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "pyloadProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);
const sessionCacheKey = `${proxyName}__sessionId`;
const isNgCacheKey = `${proxyName}__isNg`;

async function fetchFromPyloadAPI(url, sessionId, params, service) {
  const options = {
    body: params ? Object.keys(params).map(prop => `${prop}=${params[prop]}`).join("&") : `session=${sessionId}`,
    method: "POST",
    headers: {
      "Content-Type": "application/x-www-form-urlencoded"
    }
  }; // see https://github.com/gethomepage/homepage/issues/517

  const isNg = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${isNgCacheKey}.${service}`);

  if (isNg && !params) {
    delete options.body;
    options.headers.Cookie = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionCacheKey}.${service}`);
  } // eslint-disable-next-line no-unused-vars


  const [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_4__/* .httpProxy */ .hC)(url, options);
  let returnData;

  try {
    returnData = JSON.parse(Buffer.from(data).toString());
  } catch (e) {
    logger.error(`Error logging into pyload API: ${JSON.stringify(data)}`);
    returnData = data;
  }

  return [status, returnData, responseHeaders];
}

async function login(loginUrl, service, username, password = "") {
  const [status, sessionId, responseHeaders] = await fetchFromPyloadAPI(loginUrl, null, {
    username,
    password
  }, service); // this API actually returns status 200 even on login failure

  if (status !== 200 || sessionId === false) {
    logger.error(`HTTP ${status} logging into Pyload API, returned: ${JSON.stringify(sessionId)}`);
  } else if (responseHeaders["set-cookie"]?.join().includes("pyload_session")) {
    // Support pyload-ng, see https://github.com/gethomepage/homepage/issues/517
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${isNgCacheKey}.${service}`, true);
    const sessionCookie = responseHeaders["set-cookie"][0];
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionCacheKey}.${service}`, sessionCookie, 60 * 60 * 23 * 1000); // cache for 23h
  } else {
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionCacheKey}.${service}`, sessionId);
  }

  return sessionId;
}

async function pyloadProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  try {
    if (group && service) {
      const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

      if (widget) {
        const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z[widget.type].api, _objectSpread({
          endpoint
        }, widget)));
        const loginUrl = `${widget.url}/api/login`;
        let sessionId = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionCacheKey}.${service}`) ?? (await login(loginUrl, service, widget.username, widget.password));
        let [status, data] = await fetchFromPyloadAPI(url, sessionId, null, service);

        if (status === 403 || status === 401) {
          logger.info("Failed to retrieve data from Pyload API, trying to login again...");
          memory_cache__WEBPACK_IMPORTED_MODULE_0___default().del(`${sessionCacheKey}.${service}`);
          sessionId = await login(loginUrl, service, widget.username, widget.password);
          [status, data] = await fetchFromPyloadAPI(url, sessionId, null, service);
        }

        if (data?.error || status !== 200) {
          try {
            return res.status(status).send({
              error: {
                message: "HTTP error communicating with Pyload API",
                data: Buffer.from(data).toString()
              }
            });
          } catch (e) {
            return res.status(status).send({
              error: {
                message: "HTTP error communicating with Pyload API",
                data
              }
            });
          }
        }

        return res.json(data);
      }
    }
  } catch (e) {
    logger.error(e);
    return res.status(500).send({
      error: {
        message: `Error communicating with Pyload API: ${e.toString()}`
      }
    });
  }

  return res.status(400).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6145:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(472);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status: {
      endpoint: "statusServer"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 549:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ qbittorrentProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("qbittorrentProxyHandler");

async function login(widget) {
  logger.debug("qBittorrent is rejecting the request, logging in.");
  const loginUrl = new URL(`${widget.url}/api/v2/auth/login`).toString();
  const loginBody = `username=${encodeURIComponent(widget.username)}&password=${encodeURIComponent(widget.password)}`;
  const loginParams = {
    method: "POST",
    headers: {
      "Content-Type": "application/x-www-form-urlencoded"
    },
    body: loginBody
  }; // eslint-disable-next-line no-unused-vars

  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(loginUrl, loginParams);
  return [status, data];
}

async function qbittorrentProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__/* .formatApiCall */ .s4)("{url}/api/v2/{endpoint}", _objectSpread({
    endpoint
  }, widget)));
  const params = {
    method: "GET",
    headers: {}
  };
  let [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);

  if (status === 403) {
    [status, data] = await login(widget);

    if (status !== 200) {
      logger.error("HTTP %d logging in to qBittorrent.  Data: %s", status, data);
      return res.status(status).end(data);
    }

    if (data.toString() !== "Ok.") {
      logger.error("Error logging in to qBittorrent: Data: %s", data);
      return res.status(401).end(data);
    }

    [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, params);
  }

  if (status !== 200) {
    logger.error("HTTP %d getting data from qBittorrent.  Data: %s", status, data);
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9527:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(549);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8281:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ qnapProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(322);
/* harmony import */ var xml_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(xml_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_logger__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
/* eslint no-underscore-dangle: ["error", { "allow": ["_text", "_cdata"] }] */






const proxyName = "qnapProxyHandler";
const sessionTokenCacheKey = `${proxyName}__sessionToken`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(proxyName);

async function login(widget, service) {
  const endpoint = "{url}/cgi-bin/authLogin.cgi";
  const loginUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(endpoint, widget));
  const headers = {
    "Content-Type": "application/x-www-form-urlencoded"
  };
  const [,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: new URLSearchParams({
      user: widget.username,
      pwd: Buffer.from(`${widget.password}`).toString("base64")
    }).toString(),
    headers
  });

  try {
    const dataDecoded = (0,xml_js__WEBPACK_IMPORTED_MODULE_1__.xml2json)(data.toString(), {
      compact: true
    });
    const jsonData = JSON.parse(dataDecoded);
    const token = jsonData.QDocRoot.authSid._cdata;
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${sessionTokenCacheKey}.${service}`, token);
    return {
      token
    };
  } catch (e) {
    logger.error("Unable to login to QNAP API: %s", e);
  }

  return {
    token: false
  };
}

async function apiCall(widget, endpoint, service) {
  let key = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionTokenCacheKey}.${service}`);
  let apiUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(`${endpoint}&sid=${key}`, widget));
  let [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(apiUrl);

  if (status === 404) {
    logger.error("QNAP API rejected the request, attempting to obtain new session token");
    key = await login(widget, service);
    apiUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(`${endpoint}&sid=${key}`, widget));
    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(apiUrl);
  }

  if (status !== 200) {
    logger.error("Error getting data from QNAP: %s status %d. Data: %s", apiUrl, status, data);
    return {
      status,
      contentType,
      data: null,
      responseHeaders
    };
  }

  let dataDecoded = JSON.parse((0,xml_js__WEBPACK_IMPORTED_MODULE_1__.xml2json)(data.toString(), {
    compact: true
  }).toString());

  if (dataDecoded.QDocRoot.authPassed._cdata === "0") {
    logger.error("QNAP API rejected the request, attempting to obtain new session token");
    key = await login(widget, service);
    apiUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(`${endpoint}&sid=${key}`, widget));
    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_2__/* .httpProxy */ .hC)(apiUrl);

    if (status !== 200) {
      logger.error("Error getting data from QNAP: %s status %d. Data: %s", apiUrl, status, data);
      return {
        status,
        contentType,
        data: null,
        responseHeaders
      };
    }

    dataDecoded = JSON.parse((0,xml_js__WEBPACK_IMPORTED_MODULE_1__.xml2json)(data.toString(), {
      compact: true
    }).toString());
  }

  return {
    status,
    contentType,
    data: dataDecoded,
    responseHeaders
  };
}

async function qnapProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  if (!memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${sessionTokenCacheKey}.${service}`)) {
    await login(widget, service);
  }

  const {
    data: systemStatsData
  } = await apiCall(widget, "{url}/cgi-bin/management/manaRequest.cgi?subfunc=sysinfo&hd=no&multicpu=1", service);
  const {
    data: volumeStatsData
  } = await apiCall(widget, "{url}/cgi-bin/management/chartReq.cgi?chart_func=disk_usage&disk_select=all&include=all", service);
  return res.status(200).send({
    system: systemStatsData.QDocRoot.func.ownContent.root,
    volume: volumeStatsData.QDocRoot
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7269:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8281);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4526:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/api/v3/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    movie: {
      endpoint: "movie",
      map: data => ({
        wanted: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .jsonArrayFilter */ .sj)(data, item => item.monitored && !item.hasFile && item.isAvailable).length,
        have: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .jsonArrayFilter */ .sj)(data, item => item.hasFile).length,
        missing: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .jsonArrayFilter */ .sj)(data, item => item.monitored && !item.hasFile).length,
        all: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data)
      })
    },
    "queue/status": {
      endpoint: "queue/status",
      validate: ["totalCount"]
    },
    "queue/details": {
      endpoint: "queue/details",
      map: data => (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).map(entry => ({
        trackedDownloadState: entry.trackedDownloadState,
        trackedDownloadStatus: entry.trackedDownloadStatus,
        timeLeft: entry.timeleft,
        size: entry.size,
        sizeLeft: entry.sizeleft,
        movieId: entry.movieId ?? entry.id,
        status: entry.status
      })).sort((a, b) => {
        const downloadingA = a.trackedDownloadState === "downloading";
        const downloadingB = b.trackedDownloadState === "downloading";

        if (downloadingA && !downloadingB) {
          return -1;
        }

        if (downloadingB && !downloadingA) {
          return 1;
        }

        const percentA = a.sizeLeft / a.size;
        const percentB = b.sizeLeft / b.size;

        if (percentA < percentB) {
          return -1;
        }

        if (percentA > percentB) {
          return 1;
        }

        return 0;
      })
    },
    calendar: {
      endpoint: "calendar",
      params: ["start", "end", "unmonitored"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5288:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/api/v1/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    book: {
      endpoint: "book",
      map: data => ({
        have: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .jsonArrayFilter */ .sj)(data, item => item?.statistics?.bookFileCount > 0).length
      })
    },
    "queue/status": {
      endpoint: "queue/status"
    },
    "wanted/missing": {
      endpoint: "wanted/missing"
    },
    calendar: {
      endpoint: "calendar",
      params: ["start", "end", "unmonitored", "includeAuthor"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 827:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ rutorrentProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7765);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8110);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)("rutorrentProxyHandler"); // from https://github.com/ctessier/node-rutorrent-promise/blob/next/utils.js

const getTorrentInfo = data => ({
  "d.is_open": data[0],
  "d.is_hash_checking": data[1],
  "d.is_hash_checked": data[2],
  "d.get_state": data[3],
  "d.get_name": data[4],
  "d.get_size_bytes": data[5],
  "d.get_completed_chunks": data[6],
  "d.get_size_chunks": data[7],
  "d.get_bytes_done": data[8],
  "d.get_up_total": data[9],
  "d.get_ratio": data[10],
  "d.get_up_rate": data[11],
  "d.get_down_rate": data[12],
  "d.get_chunk_size": data[13],
  "d.get_custom1": data[14],
  "d.get_peers_accounted": data[15],
  "d.get_peers_not_connected": data[16],
  "d.get_peers_connected": data[17],
  "d.get_peers_complete": data[18],
  "d.get_left_bytes": data[19],
  "d.get_priority": data[20],
  "d.get_state_changed": data[21],
  "d.get_skip_total": data[22],
  "d.get_hashing": data[23],
  "d.get_chunks_hashed": data[24],
  "d.get_base_path": data[25],
  "d.get_creation_date": data[26],
  "d.get_tracker_focus": data[27],
  "d.is_active": data[28],
  "d.get_message": data[29],
  "d.get_custom2": data[30],
  "d.get_free_diskspace": data[31],
  "d.is_private": data[32],
  "d.is_multi_file": data[33]
});

async function rutorrentProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;

  if (group && service) {
    const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .ZP)(group, service);

    if (widget) {
      const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z?.[widget.type]?.api;
      const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(api, _objectSpread({}, widget)));
      const headers = {};

      if (widget.username) {
        headers.Authorization = `Basic ${Buffer.from(`${widget.username}:${widget.password}`).toString("base64")}`;
      }

      const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
        method: "POST",
        headers,
        body: "mode=list"
      });

      if (status !== 200) {
        logger.error("HTTP Error %d calling %s", status, url.toString());
        return res.status(status).json({
          error: {
            message: "HTTP Error",
            url,
            data
          }
        });
      }

      try {
        const rawData = JSON.parse(data);
        const parsedData = Object.keys(rawData.t).map(hashString => getTorrentInfo(rawData.t[hashString]));
        return res.status(200).send(parsedData);
      } catch (e) {
        return res.status(500).json({
          error: {
            message: e?.toString() ?? "Error parsing rutorrent data",
            url,
            data
          }
        });
      }
    }
  }

  return res.status(500).json({
    error: "Invalid proxy service type"
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5420:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(827);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/plugins/httprpc/action.php",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9439:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/?apikey={key}&output=json&mode={endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    queue: {
      endpoint: "queue",
      validate: ["queue"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3989:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    summary: {
      endpoint: "summary",
      validate: ["data"]
    },
    settings: {
      endpoint: "settings",
      validate: ["settings"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 398:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/api/v3/{endpoint}?apikey={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    series: {
      endpoint: "series",
      map: data => (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).map(entry => ({
        title: entry.title,
        id: entry.id
      }))
    },
    queue: {
      endpoint: "queue",
      validate: ["totalRecords"]
    },
    "wanted/missing": {
      endpoint: "wanted/missing",
      validate: ["totalRecords"]
    },
    "queue/details": {
      endpoint: "queue/details",
      map: data => (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).map(entry => ({
        trackedDownloadState: entry.trackedDownloadState,
        trackedDownloadStatus: entry.trackedDownloadStatus,
        timeLeft: entry.timeleft,
        size: entry.size,
        sizeLeft: entry.sizeleft,
        seriesId: entry.seriesId,
        episodeTitle: entry.episode?.title ?? entry.title,
        episodeId: entry.episodeId ?? entry.id,
        status: entry.status
      })).sort((a, b) => {
        const downloadingA = a.trackedDownloadState === "downloading";
        const downloadingB = b.trackedDownloadState === "downloading";

        if (downloadingA && !downloadingB) {
          return -1;
        }

        if (downloadingB && !downloadingA) {
          return 1;
        }

        const percentA = a.sizeLeft / a.size;
        const percentB = b.sizeLeft / b.size;

        if (percentA < percentB) {
          return -1;
        }

        if (percentA > percentB) {
          return 1;
        }

        return 0;
      })
    },
    calendar: {
      endpoint: "calendar",
      params: ["start", "end", "unmonitored", "includeSeries", "includeEpisodeFile", "includeEpisodeImages"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2699:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "speedtest/latest": {
      endpoint: "speedtest/latest",
      validate: ["data"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 393:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status: {
      endpoint: "status",
      validate: ["numActiveSessions", "numConnections", "bytesProxied"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7529:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "https://api.tailscale.com/api/v2/{endpoint}/{deviceid}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    device: {
      endpoint: "device"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5911:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v2?apikey={key}&cmd={endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    get_activity: {
      endpoint: "get_activity"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7470:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ tdarrProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const proxyName = "tdarrProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(proxyName);
async function tdarrProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z[widget.type].api, _objectSpread({
    endpoint
  }, widget)));
  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, {
    method: "POST",
    body: JSON.stringify({
      data: {
        collection: "StatisticsJSONDB",
        mode: "getById",
        docID: "statistics"
      }
    }),
    headers: {
      "content-type": "application/json"
    }
  });

  if (status !== 200) {
    logger.error("Error getting data from Tdarr: %d.  Data: %s", status, data);
    return res.status(500).send({
      error: {
        message: "Error getting data from Tdarr",
        url,
        data
      }
    });
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5915:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7470);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/v2/cruddb",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 216:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    overview: {
      endpoint: "overview",
      validate: ["http"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6073:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ transmissionProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_3__, widgets_widgets__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







const proxyName = "transmissionProxyHandler";
const headerCacheKey = `${proxyName}__headers`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(proxyName);
async function transmissionProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  let headers = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${headerCacheKey}.${service}`);

  if (!headers) {
    headers = {
      "content-type": "application/json"
    };
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${headerCacheKey}.${service}`, headers);
  }

  const api = `${widget.url}${widget.rpcUrl || widgets_widgets__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z[widget.type].rpcUrl}rpc`;
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_5__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const csrfHeaderName = "x-transmission-session-id";
  const method = "POST";
  const auth = `${widget.username}:${widget.password}`;
  const body = JSON.stringify({
    method: "torrent-get",
    arguments: {
      fields: ["percentDone", "status", "rateDownload", "rateUpload"]
    }
  });
  let [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
    method,
    auth,
    body,
    headers
  });

  if (status === 409) {
    logger.debug("Transmission is rejecting the request, but returning a CSRF token");
    headers[csrfHeaderName] = responseHeaders[csrfHeaderName];
    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${headerCacheKey}.${service}`, headers); // retry the request, now with the CSRF token

    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, {
      method,
      auth,
      body,
      headers
    });
  }

  if (status !== 200) {
    logger.error("Error getting data from Transmission: %d.  Data: %s", status, data);
    return res.status(500).send({
      error: {
        message: "Error getting data from Transmission",
        url,
        data
      }
    });
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8287:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6073);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  rpcUrl: "/transmission/",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3452:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(434);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7765);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__, utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const widget = {
  api: "{url}/api/v2.0/{endpoint}",
  proxyHandler: async (req, res, map) => {
    // choose proxy handler based on widget settings
    const {
      group,
      service
    } = req.query;

    if (group && service) {
      const widgetOpts = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(group, service);
      let handler;

      if (widgetOpts.username && widgetOpts.password) {
        handler = utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z;
      } else if (widgetOpts.key) {
        handler = utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z;
      }

      if (handler) {
        return handler(req, res, map);
      }

      return res.status(500).json({
        error: "Username / password or API key required"
      });
    }

    return res.status(500).json({
      error: "Error parsing widget request"
    });
  },
  mappings: {
    alerts: {
      endpoint: "alert/list",
      map: data => ({
        pending: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_3__/* .jsonArrayFilter */ .sj)(data, item => item?.dismissed === false).length
      })
    },
    status: {
      endpoint: "system/info",
      validate: ["loadavg", "uptime_seconds"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8693:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5855);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/api/{endpoint}",
  proxyHandler: utils_proxy_handlers_credentialed__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    downloads: {
      endpoint: "download",
      validate: ["paginate"]
    },
    videos: {
      endpoint: "video",
      validate: ["paginate"]
    },
    channels: {
      endpoint: "channel",
      validate: ["paginate"]
    },
    playlists: {
      endpoint: "playlist",
      validate: ["paginate"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2509:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ unifiProxyHandler)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9967);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
/* harmony import */ var utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7704);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, widgets_widgets__WEBPACK_IMPORTED_MODULE_6__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, widgets_widgets__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }









const udmpPrefix = "/proxy/network";
const proxyName = "unifiProxyHandler";
const prefixCacheKey = `${proxyName}__prefix`;
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(proxyName);

async function getWidget(req) {
  const {
    group,
    service,
    type
  } = req.query;
  let widget = null;

  if (type === "unifi_console") {
    // info widget
    const index = req.query?.query ? JSON.parse(req.query.query).index : undefined;
    widget = await (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_4__/* .getPrivateWidgetOptions */ .Bh)(type, index);

    if (!widget) {
      logger.debug("Error retrieving settings for this Unifi widget");
      return null;
    }

    widget.type = "unifi";
  } else {
    if (!group || !service) {
      logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
      return null;
    }

    widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);

    if (!widget) {
      logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
      return null;
    }
  }

  return widget;
}

async function login(widget, csrfToken) {
  const endpoint = widget.prefix === udmpPrefix ? "auth/login" : "login";
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z?.[widget.type]?.api?.replace("{prefix}", ""); // no prefix for login url

  const loginUrl = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_7__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const loginBody = {
    username: widget.username,
    password: widget.password,
    remember: true
  };
  const headers = {
    "Content-Type": "application/json"
  };

  if (csrfToken) {
    headers["X-CSRF-TOKEN"] = csrfToken;
  }

  const [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(loginUrl, {
    method: "POST",
    body: JSON.stringify(loginBody),
    headers
  });
  return [status, contentType, data, responseHeaders];
}

async function unifiProxyHandler(req, res) {
  const widget = await getWidget(req);
  const {
    service
  } = req.query;

  if (!widget) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z?.[widget.type]?.api;

  if (!api) {
    return res.status(403).json({
      error: "Service does not support API calls"
    });
  }

  let [status, contentType, data, responseHeaders] = [];
  let prefix = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(`${prefixCacheKey}.${service}`);
  let csrfToken;

  if (prefix === null) {
    // auto detect if we're talking to a UDM Pro, and cache the result so that we
    // don't make two requests each time data from Unifi is required
    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(widget.url);
    prefix = "";

    if (responseHeaders?.["x-csrf-token"]) {
      // Unifi OS < 3.2.5 passes & requires csrf-token
      prefix = udmpPrefix;
      csrfToken = responseHeaders["x-csrf-token"];
    } else if (responseHeaders?.["access-control-expose-headers"]) {
      // Unifi OS ≥ 3.2.5 doesnt pass csrf token but still uses different endpoint
      prefix = udmpPrefix;
    }

    memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(`${prefixCacheKey}.${service}`, prefix);
  }

  widget.prefix = prefix;
  const {
    endpoint
  } = req.query;
  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_7__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget)));
  const params = {
    method: "GET",
    headers: {}
  };
  (0,utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .setCookieHeader */ .w)(url, params);
  [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, params);

  if (status === 401) {
    logger.debug("Unifi isn't logged in or rejected the reqeust, attempting login.");

    if (responseHeaders?.["x-csrf-token"]) {
      csrfToken = responseHeaders["x-csrf-token"];
    }

    [status, contentType, data, responseHeaders] = await login(widget, csrfToken);

    if (status !== 200) {
      logger.error("HTTP %d logging in to Unifi. Data: %s", status, data);
      return res.status(status).json({
        error: {
          message: `HTTP Error ${status}`,
          url,
          data
        }
      });
    }

    const json = JSON.parse(data.toString());

    if (!(json?.meta?.rc === "ok" || json?.login_time || json?.update_time)) {
      logger.error("Error logging in to Unifi: Data: %s", data);
      return res.status(401).end(data);
    }

    (0,utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .addCookieToJar */ .a)(url, responseHeaders);
    (0,utils_proxy_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .setCookieHeader */ .w)(url, params);
    logger.debug("Retrying Unifi request after login.");
    [status, contentType, data, responseHeaders] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_1__/* .httpProxy */ .hC)(url, params);
  }

  if (status !== 200) {
    logger.error("HTTP %d getting data from Unifi endpoint %s. Data: %s", status, url.href, data);
    return res.status(status).json({
      error: {
        message: `HTTP Error ${status}`,
        url,
        data
      }
    });
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7871:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2509);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}{prefix}/api/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    "stat/sites": {
      endpoint: "stat/sites"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1677:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const widget = {
  api: "{url}/unmanic/api/v2/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    workers: {
      endpoint: "workers/status",
      map: data => ({
        total_workers: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).workers_status.length,
        active_workers: (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .asJson */ .vl)(data).workers_status.filter(worker => !worker.idle).length
      })
    },
    pending: {
      method: "POST",
      body: "{}",
      endpoint: "pending/tasks",
      validate: ["recordsTotal"]
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8418:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
// import credentialedProxyHandler from "utils/proxy/handlers/credentialed";

const widget = {
  api: "{url}/api/{endpoint}/{slug}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    status_page: {
      endpoint: "status-page"
    },
    heartbeat: {
      endpoint: "status-page/heartbeat"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4295:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/v2/{endpoint}?api_key={key}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    getmonitors: {
      method: "POST",
      endpoint: "getMonitors",
      body: "format=json&logs=1",
      headers: {
        "content-type": "application/x-www-form-urlencoded",
        "cache-control": "no-cache"
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5312:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ urbackupProxyHandler)
/* harmony export */ });
/* harmony import */ var urbackup_server_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1980);
/* harmony import */ var urbackup_server_api__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(urbackup_server_api__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__]);
utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


async function urbackupProxyHandler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceWidget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);
  const server = new urbackup_server_api__WEBPACK_IMPORTED_MODULE_0__.UrbackupServer({
    url: serviceWidget.url,
    username: serviceWidget.username,
    password: serviceWidget.password
  });
  await (async () => {
    try {
      const allClients = await server.getStatus({
        includeRemoved: false
      });
      let diskUsage = false;

      if (serviceWidget.fields?.includes("totalUsed")) {
        diskUsage = await server.getUsage();
      }

      res.status(200).send({
        clientStatuses: allClients,
        diskUsage,
        maxDays: serviceWidget.maxDays
      });
    } catch (error) {
      res.status(500).json({
        error: "Error communicating with UrBackup server"
      });
    }
  })();
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7505:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5312);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2985:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ watchtowerProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, widgets_widgets__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const proxyName = "watchtowerProxyHandler";
const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(proxyName);
async function watchtowerProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    logger.debug("Invalid or missing service '%s' or group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(group, service);

  if (!widget) {
    logger.debug("Invalid or missing widget for service '%s' in group '%s'", service, group);
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const url = new URL((0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(widgets_widgets__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z[widget.type].api, _objectSpread({
    endpoint
  }, widget)));
  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, {
    method: "GET",
    headers: {
      Authorization: `Bearer ${widget.key}`
    }
  });

  if (status !== 200 || !data) {
    logger.error("Error getting data from WatchTower: %d.  Data: %s", status, data);
    return res.status(status).json({
      error: {
        message: `HTTP Error ${status}`,
        url,
        data
      }
    });
  }

  const cleanData = data.toString().split("\n").filter(s => s.startsWith("watchtower"));
  const jsonRes = {};
  cleanData.map(e => e.split(" ")).forEach(strArray => {
    const [key, value] = strArray;
    jsonRes[key] = value;
  });
  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(jsonRes);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5087:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2985);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    watchtower: {
      endpoint: "v1/metrics"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9512:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(434);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__]);
utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: utils_proxy_handlers_generic__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    containers: {
      endpoint: "api/containers"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8110:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _adguard_widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7996);
/* harmony import */ var _atsumeru_widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1505);
/* harmony import */ var _audiobookshelf_widget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9107);
/* harmony import */ var _authentik_widget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9015);
/* harmony import */ var _autobrr_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5329);
/* harmony import */ var _azuredevops_widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6846);
/* harmony import */ var _bazarr_widget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2094);
/* harmony import */ var _caddy_widget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1934);
/* harmony import */ var _calendar_widget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(3094);
/* harmony import */ var _calibreweb_widget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8887);
/* harmony import */ var _changedetectionio_widget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2018);
/* harmony import */ var _channelsdvrserver_widget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(8153);
/* harmony import */ var _cloudflared_widget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6985);
/* harmony import */ var _coinmarketcap_widget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(5964);
/* harmony import */ var _customapi_widget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(9297);
/* harmony import */ var _deluge_widget__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(5616);
/* harmony import */ var _diskstation_widget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(7122);
/* harmony import */ var _downloadstation_widget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(7217);
/* harmony import */ var _emby_widget__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(6919);
/* harmony import */ var _evcc_widget__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(61);
/* harmony import */ var _fileflows_widget__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(3814);
/* harmony import */ var _flood_widget__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(6842);
/* harmony import */ var _freshrss_widget__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(5661);
/* harmony import */ var _fritzbox_widget__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(7760);
/* harmony import */ var _gamedig_widget__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(8269);
/* harmony import */ var _ghostfolio_widget__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(6709);
/* harmony import */ var _glances_widget__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(1681);
/* harmony import */ var _gluetun_widget__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(8838);
/* harmony import */ var _gotify_widget__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(2625);
/* harmony import */ var _grafana_widget__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(6863);
/* harmony import */ var _hdhomerun_widget__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(9671);
/* harmony import */ var _homeassistant_widget__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(5669);
/* harmony import */ var _homebridge_widget__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(4790);
/* harmony import */ var _healthchecks_widget__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(186);
/* harmony import */ var _immich_widget__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(1761);
/* harmony import */ var _jackett_widget__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(7736);
/* harmony import */ var _jellyseerr_widget__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(6433);
/* harmony import */ var _jdownloader_widget__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(7655);
/* harmony import */ var _kavita_widget__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(5260);
/* harmony import */ var _komga_widget__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(3848);
/* harmony import */ var _kopia_widget__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(6355);
/* harmony import */ var _lidarr_widget__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(9427);
/* harmony import */ var _mastodon_widget__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(1327);
/* harmony import */ var _mealie_widget__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(7750);
/* harmony import */ var _medusa_widget__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(9094);
/* harmony import */ var _minecraft_widget__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(8510);
/* harmony import */ var _miniflux_widget__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(7849);
/* harmony import */ var _mikrotik_widget__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(98);
/* harmony import */ var _mjpeg_widget__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(4244);
/* harmony import */ var _moonraker_widget__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(8314);
/* harmony import */ var _mylar_widget__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(9532);
/* harmony import */ var _navidrome_widget__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(9014);
/* harmony import */ var _nextcloud_widget__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(3886);
/* harmony import */ var _nextdns_widget__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(2702);
/* harmony import */ var _npm_widget__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(8230);
/* harmony import */ var _nzbget_widget__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(8137);
/* harmony import */ var _octoprint_widget__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(1166);
/* harmony import */ var _omada_widget__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(9568);
/* harmony import */ var _ombi_widget__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(2035);
/* harmony import */ var _opendtu_widget__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(6534);
/* harmony import */ var _opnsense_widget__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(4031);
/* harmony import */ var _overseerr_widget__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(5245);
/* harmony import */ var _openmediavault_widget__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(2122);
/* harmony import */ var _paperlessngx_widget__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(815);
/* harmony import */ var _peanut_widget__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(3726);
/* harmony import */ var _pfsense_widget__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(3800);
/* harmony import */ var _photoprism_widget__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(4212);
/* harmony import */ var _proxmoxbackupserver_widget__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(947);
/* harmony import */ var _pialert_widget__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(7926);
/* harmony import */ var _pihole_widget__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(4827);
/* harmony import */ var _plex_widget__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(7201);
/* harmony import */ var _portainer_widget__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(9242);
/* harmony import */ var _prometheus_widget__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(7686);
/* harmony import */ var _prowlarr_widget__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(5005);
/* harmony import */ var _proxmox_widget__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(635);
/* harmony import */ var _pterodactyl_widget__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(8943);
/* harmony import */ var _pyload_widget__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(6145);
/* harmony import */ var _qbittorrent_widget__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(9527);
/* harmony import */ var _qnap_widget__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(7269);
/* harmony import */ var _radarr_widget__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(4526);
/* harmony import */ var _readarr_widget__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(5288);
/* harmony import */ var _rutorrent_widget__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(5420);
/* harmony import */ var _sabnzbd_widget__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(9439);
/* harmony import */ var _scrutiny_widget__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(3989);
/* harmony import */ var _sonarr_widget__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(398);
/* harmony import */ var _speedtest_widget__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(2699);
/* harmony import */ var _strelaysrv_widget__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(393);
/* harmony import */ var _tailscale_widget__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(7529);
/* harmony import */ var _tautulli_widget__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(5911);
/* harmony import */ var _tdarr_widget__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(5915);
/* harmony import */ var _traefik_widget__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(216);
/* harmony import */ var _transmission_widget__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(8287);
/* harmony import */ var _tubearchivist_widget__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(8693);
/* harmony import */ var _truenas_widget__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(3452);
/* harmony import */ var _unifi_widget__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(7871);
/* harmony import */ var _unmanic_widget__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(1677);
/* harmony import */ var _uptimekuma_widget__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(8418);
/* harmony import */ var _uptimerobot_widget__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(4295);
/* harmony import */ var _watchtower_widget__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(5087);
/* harmony import */ var _whatsupdocker_widget__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__(9512);
/* harmony import */ var _xteve_widget__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__(3313);
/* harmony import */ var _urbackup_widget__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__(7505);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_adguard_widget__WEBPACK_IMPORTED_MODULE_0__, _atsumeru_widget__WEBPACK_IMPORTED_MODULE_1__, _audiobookshelf_widget__WEBPACK_IMPORTED_MODULE_2__, _authentik_widget__WEBPACK_IMPORTED_MODULE_3__, _autobrr_widget__WEBPACK_IMPORTED_MODULE_4__, _azuredevops_widget__WEBPACK_IMPORTED_MODULE_5__, _bazarr_widget__WEBPACK_IMPORTED_MODULE_6__, _caddy_widget__WEBPACK_IMPORTED_MODULE_7__, _calendar_widget__WEBPACK_IMPORTED_MODULE_8__, _calibreweb_widget__WEBPACK_IMPORTED_MODULE_9__, _changedetectionio_widget__WEBPACK_IMPORTED_MODULE_10__, _channelsdvrserver_widget__WEBPACK_IMPORTED_MODULE_11__, _cloudflared_widget__WEBPACK_IMPORTED_MODULE_12__, _coinmarketcap_widget__WEBPACK_IMPORTED_MODULE_13__, _customapi_widget__WEBPACK_IMPORTED_MODULE_14__, _deluge_widget__WEBPACK_IMPORTED_MODULE_15__, _diskstation_widget__WEBPACK_IMPORTED_MODULE_16__, _downloadstation_widget__WEBPACK_IMPORTED_MODULE_17__, _emby_widget__WEBPACK_IMPORTED_MODULE_18__, _evcc_widget__WEBPACK_IMPORTED_MODULE_19__, _fileflows_widget__WEBPACK_IMPORTED_MODULE_20__, _flood_widget__WEBPACK_IMPORTED_MODULE_21__, _freshrss_widget__WEBPACK_IMPORTED_MODULE_22__, _fritzbox_widget__WEBPACK_IMPORTED_MODULE_23__, _gamedig_widget__WEBPACK_IMPORTED_MODULE_24__, _ghostfolio_widget__WEBPACK_IMPORTED_MODULE_25__, _glances_widget__WEBPACK_IMPORTED_MODULE_26__, _gluetun_widget__WEBPACK_IMPORTED_MODULE_27__, _gotify_widget__WEBPACK_IMPORTED_MODULE_28__, _grafana_widget__WEBPACK_IMPORTED_MODULE_29__, _hdhomerun_widget__WEBPACK_IMPORTED_MODULE_30__, _homeassistant_widget__WEBPACK_IMPORTED_MODULE_31__, _homebridge_widget__WEBPACK_IMPORTED_MODULE_32__, _healthchecks_widget__WEBPACK_IMPORTED_MODULE_33__, _immich_widget__WEBPACK_IMPORTED_MODULE_34__, _jackett_widget__WEBPACK_IMPORTED_MODULE_35__, _jellyseerr_widget__WEBPACK_IMPORTED_MODULE_36__, _jdownloader_widget__WEBPACK_IMPORTED_MODULE_37__, _kavita_widget__WEBPACK_IMPORTED_MODULE_38__, _komga_widget__WEBPACK_IMPORTED_MODULE_39__, _kopia_widget__WEBPACK_IMPORTED_MODULE_40__, _lidarr_widget__WEBPACK_IMPORTED_MODULE_41__, _mastodon_widget__WEBPACK_IMPORTED_MODULE_42__, _mealie_widget__WEBPACK_IMPORTED_MODULE_43__, _medusa_widget__WEBPACK_IMPORTED_MODULE_44__, _minecraft_widget__WEBPACK_IMPORTED_MODULE_45__, _miniflux_widget__WEBPACK_IMPORTED_MODULE_46__, _mikrotik_widget__WEBPACK_IMPORTED_MODULE_47__, _mjpeg_widget__WEBPACK_IMPORTED_MODULE_48__, _moonraker_widget__WEBPACK_IMPORTED_MODULE_49__, _mylar_widget__WEBPACK_IMPORTED_MODULE_50__, _navidrome_widget__WEBPACK_IMPORTED_MODULE_51__, _nextcloud_widget__WEBPACK_IMPORTED_MODULE_52__, _nextdns_widget__WEBPACK_IMPORTED_MODULE_53__, _npm_widget__WEBPACK_IMPORTED_MODULE_54__, _nzbget_widget__WEBPACK_IMPORTED_MODULE_55__, _octoprint_widget__WEBPACK_IMPORTED_MODULE_56__, _omada_widget__WEBPACK_IMPORTED_MODULE_57__, _ombi_widget__WEBPACK_IMPORTED_MODULE_58__, _opendtu_widget__WEBPACK_IMPORTED_MODULE_59__, _opnsense_widget__WEBPACK_IMPORTED_MODULE_60__, _overseerr_widget__WEBPACK_IMPORTED_MODULE_61__, _openmediavault_widget__WEBPACK_IMPORTED_MODULE_62__, _paperlessngx_widget__WEBPACK_IMPORTED_MODULE_63__, _peanut_widget__WEBPACK_IMPORTED_MODULE_64__, _pfsense_widget__WEBPACK_IMPORTED_MODULE_65__, _photoprism_widget__WEBPACK_IMPORTED_MODULE_66__, _proxmoxbackupserver_widget__WEBPACK_IMPORTED_MODULE_67__, _pialert_widget__WEBPACK_IMPORTED_MODULE_68__, _pihole_widget__WEBPACK_IMPORTED_MODULE_69__, _plex_widget__WEBPACK_IMPORTED_MODULE_70__, _portainer_widget__WEBPACK_IMPORTED_MODULE_71__, _prometheus_widget__WEBPACK_IMPORTED_MODULE_72__, _prowlarr_widget__WEBPACK_IMPORTED_MODULE_73__, _proxmox_widget__WEBPACK_IMPORTED_MODULE_74__, _pterodactyl_widget__WEBPACK_IMPORTED_MODULE_75__, _pyload_widget__WEBPACK_IMPORTED_MODULE_76__, _qbittorrent_widget__WEBPACK_IMPORTED_MODULE_77__, _qnap_widget__WEBPACK_IMPORTED_MODULE_78__, _radarr_widget__WEBPACK_IMPORTED_MODULE_79__, _readarr_widget__WEBPACK_IMPORTED_MODULE_80__, _rutorrent_widget__WEBPACK_IMPORTED_MODULE_81__, _sabnzbd_widget__WEBPACK_IMPORTED_MODULE_82__, _scrutiny_widget__WEBPACK_IMPORTED_MODULE_83__, _sonarr_widget__WEBPACK_IMPORTED_MODULE_84__, _speedtest_widget__WEBPACK_IMPORTED_MODULE_85__, _strelaysrv_widget__WEBPACK_IMPORTED_MODULE_86__, _tailscale_widget__WEBPACK_IMPORTED_MODULE_87__, _tautulli_widget__WEBPACK_IMPORTED_MODULE_88__, _tdarr_widget__WEBPACK_IMPORTED_MODULE_89__, _traefik_widget__WEBPACK_IMPORTED_MODULE_90__, _transmission_widget__WEBPACK_IMPORTED_MODULE_91__, _tubearchivist_widget__WEBPACK_IMPORTED_MODULE_92__, _truenas_widget__WEBPACK_IMPORTED_MODULE_93__, _unifi_widget__WEBPACK_IMPORTED_MODULE_94__, _unmanic_widget__WEBPACK_IMPORTED_MODULE_95__, _uptimekuma_widget__WEBPACK_IMPORTED_MODULE_96__, _uptimerobot_widget__WEBPACK_IMPORTED_MODULE_97__, _watchtower_widget__WEBPACK_IMPORTED_MODULE_98__, _whatsupdocker_widget__WEBPACK_IMPORTED_MODULE_99__, _xteve_widget__WEBPACK_IMPORTED_MODULE_100__, _urbackup_widget__WEBPACK_IMPORTED_MODULE_101__]);
([_adguard_widget__WEBPACK_IMPORTED_MODULE_0__, _atsumeru_widget__WEBPACK_IMPORTED_MODULE_1__, _audiobookshelf_widget__WEBPACK_IMPORTED_MODULE_2__, _authentik_widget__WEBPACK_IMPORTED_MODULE_3__, _autobrr_widget__WEBPACK_IMPORTED_MODULE_4__, _azuredevops_widget__WEBPACK_IMPORTED_MODULE_5__, _bazarr_widget__WEBPACK_IMPORTED_MODULE_6__, _caddy_widget__WEBPACK_IMPORTED_MODULE_7__, _calendar_widget__WEBPACK_IMPORTED_MODULE_8__, _calibreweb_widget__WEBPACK_IMPORTED_MODULE_9__, _changedetectionio_widget__WEBPACK_IMPORTED_MODULE_10__, _channelsdvrserver_widget__WEBPACK_IMPORTED_MODULE_11__, _cloudflared_widget__WEBPACK_IMPORTED_MODULE_12__, _coinmarketcap_widget__WEBPACK_IMPORTED_MODULE_13__, _customapi_widget__WEBPACK_IMPORTED_MODULE_14__, _deluge_widget__WEBPACK_IMPORTED_MODULE_15__, _diskstation_widget__WEBPACK_IMPORTED_MODULE_16__, _downloadstation_widget__WEBPACK_IMPORTED_MODULE_17__, _emby_widget__WEBPACK_IMPORTED_MODULE_18__, _evcc_widget__WEBPACK_IMPORTED_MODULE_19__, _fileflows_widget__WEBPACK_IMPORTED_MODULE_20__, _flood_widget__WEBPACK_IMPORTED_MODULE_21__, _freshrss_widget__WEBPACK_IMPORTED_MODULE_22__, _fritzbox_widget__WEBPACK_IMPORTED_MODULE_23__, _gamedig_widget__WEBPACK_IMPORTED_MODULE_24__, _ghostfolio_widget__WEBPACK_IMPORTED_MODULE_25__, _glances_widget__WEBPACK_IMPORTED_MODULE_26__, _gluetun_widget__WEBPACK_IMPORTED_MODULE_27__, _gotify_widget__WEBPACK_IMPORTED_MODULE_28__, _grafana_widget__WEBPACK_IMPORTED_MODULE_29__, _hdhomerun_widget__WEBPACK_IMPORTED_MODULE_30__, _homeassistant_widget__WEBPACK_IMPORTED_MODULE_31__, _homebridge_widget__WEBPACK_IMPORTED_MODULE_32__, _healthchecks_widget__WEBPACK_IMPORTED_MODULE_33__, _immich_widget__WEBPACK_IMPORTED_MODULE_34__, _jackett_widget__WEBPACK_IMPORTED_MODULE_35__, _jellyseerr_widget__WEBPACK_IMPORTED_MODULE_36__, _jdownloader_widget__WEBPACK_IMPORTED_MODULE_37__, _kavita_widget__WEBPACK_IMPORTED_MODULE_38__, _komga_widget__WEBPACK_IMPORTED_MODULE_39__, _kopia_widget__WEBPACK_IMPORTED_MODULE_40__, _lidarr_widget__WEBPACK_IMPORTED_MODULE_41__, _mastodon_widget__WEBPACK_IMPORTED_MODULE_42__, _mealie_widget__WEBPACK_IMPORTED_MODULE_43__, _medusa_widget__WEBPACK_IMPORTED_MODULE_44__, _minecraft_widget__WEBPACK_IMPORTED_MODULE_45__, _miniflux_widget__WEBPACK_IMPORTED_MODULE_46__, _mikrotik_widget__WEBPACK_IMPORTED_MODULE_47__, _mjpeg_widget__WEBPACK_IMPORTED_MODULE_48__, _moonraker_widget__WEBPACK_IMPORTED_MODULE_49__, _mylar_widget__WEBPACK_IMPORTED_MODULE_50__, _navidrome_widget__WEBPACK_IMPORTED_MODULE_51__, _nextcloud_widget__WEBPACK_IMPORTED_MODULE_52__, _nextdns_widget__WEBPACK_IMPORTED_MODULE_53__, _npm_widget__WEBPACK_IMPORTED_MODULE_54__, _nzbget_widget__WEBPACK_IMPORTED_MODULE_55__, _octoprint_widget__WEBPACK_IMPORTED_MODULE_56__, _omada_widget__WEBPACK_IMPORTED_MODULE_57__, _ombi_widget__WEBPACK_IMPORTED_MODULE_58__, _opendtu_widget__WEBPACK_IMPORTED_MODULE_59__, _opnsense_widget__WEBPACK_IMPORTED_MODULE_60__, _overseerr_widget__WEBPACK_IMPORTED_MODULE_61__, _openmediavault_widget__WEBPACK_IMPORTED_MODULE_62__, _paperlessngx_widget__WEBPACK_IMPORTED_MODULE_63__, _peanut_widget__WEBPACK_IMPORTED_MODULE_64__, _pfsense_widget__WEBPACK_IMPORTED_MODULE_65__, _photoprism_widget__WEBPACK_IMPORTED_MODULE_66__, _proxmoxbackupserver_widget__WEBPACK_IMPORTED_MODULE_67__, _pialert_widget__WEBPACK_IMPORTED_MODULE_68__, _pihole_widget__WEBPACK_IMPORTED_MODULE_69__, _plex_widget__WEBPACK_IMPORTED_MODULE_70__, _portainer_widget__WEBPACK_IMPORTED_MODULE_71__, _prometheus_widget__WEBPACK_IMPORTED_MODULE_72__, _prowlarr_widget__WEBPACK_IMPORTED_MODULE_73__, _proxmox_widget__WEBPACK_IMPORTED_MODULE_74__, _pterodactyl_widget__WEBPACK_IMPORTED_MODULE_75__, _pyload_widget__WEBPACK_IMPORTED_MODULE_76__, _qbittorrent_widget__WEBPACK_IMPORTED_MODULE_77__, _qnap_widget__WEBPACK_IMPORTED_MODULE_78__, _radarr_widget__WEBPACK_IMPORTED_MODULE_79__, _readarr_widget__WEBPACK_IMPORTED_MODULE_80__, _rutorrent_widget__WEBPACK_IMPORTED_MODULE_81__, _sabnzbd_widget__WEBPACK_IMPORTED_MODULE_82__, _scrutiny_widget__WEBPACK_IMPORTED_MODULE_83__, _sonarr_widget__WEBPACK_IMPORTED_MODULE_84__, _speedtest_widget__WEBPACK_IMPORTED_MODULE_85__, _strelaysrv_widget__WEBPACK_IMPORTED_MODULE_86__, _tailscale_widget__WEBPACK_IMPORTED_MODULE_87__, _tautulli_widget__WEBPACK_IMPORTED_MODULE_88__, _tdarr_widget__WEBPACK_IMPORTED_MODULE_89__, _traefik_widget__WEBPACK_IMPORTED_MODULE_90__, _transmission_widget__WEBPACK_IMPORTED_MODULE_91__, _tubearchivist_widget__WEBPACK_IMPORTED_MODULE_92__, _truenas_widget__WEBPACK_IMPORTED_MODULE_93__, _unifi_widget__WEBPACK_IMPORTED_MODULE_94__, _unmanic_widget__WEBPACK_IMPORTED_MODULE_95__, _uptimekuma_widget__WEBPACK_IMPORTED_MODULE_96__, _uptimerobot_widget__WEBPACK_IMPORTED_MODULE_97__, _watchtower_widget__WEBPACK_IMPORTED_MODULE_98__, _whatsupdocker_widget__WEBPACK_IMPORTED_MODULE_99__, _xteve_widget__WEBPACK_IMPORTED_MODULE_100__, _urbackup_widget__WEBPACK_IMPORTED_MODULE_101__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






































































































const widgets = {
  adguard: _adguard_widget__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  atsumeru: _atsumeru_widget__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z,
  audiobookshelf: _audiobookshelf_widget__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z,
  authentik: _authentik_widget__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
  autobrr: _autobrr_widget__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
  azuredevops: _azuredevops_widget__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z,
  bazarr: _bazarr_widget__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z,
  caddy: _caddy_widget__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z,
  calibreweb: _calibreweb_widget__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z,
  changedetectionio: _changedetectionio_widget__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z,
  channelsdvrserver: _channelsdvrserver_widget__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z,
  cloudflared: _cloudflared_widget__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z,
  coinmarketcap: _coinmarketcap_widget__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z,
  customapi: _customapi_widget__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z,
  deluge: _deluge_widget__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z,
  diskstation: _diskstation_widget__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z,
  downloadstation: _downloadstation_widget__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z,
  emby: _emby_widget__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z,
  evcc: _evcc_widget__WEBPACK_IMPORTED_MODULE_19__/* ["default"] */ .Z,
  fileflows: _fileflows_widget__WEBPACK_IMPORTED_MODULE_20__/* ["default"] */ .Z,
  flood: _flood_widget__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z,
  freshrss: _freshrss_widget__WEBPACK_IMPORTED_MODULE_22__/* ["default"] */ .Z,
  fritzbox: _fritzbox_widget__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z,
  gamedig: _gamedig_widget__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z,
  ghostfolio: _ghostfolio_widget__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z,
  glances: _glances_widget__WEBPACK_IMPORTED_MODULE_26__/* ["default"] */ .Z,
  gluetun: _gluetun_widget__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z,
  gotify: _gotify_widget__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z,
  grafana: _grafana_widget__WEBPACK_IMPORTED_MODULE_29__/* ["default"] */ .Z,
  hdhomerun: _hdhomerun_widget__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z,
  homeassistant: _homeassistant_widget__WEBPACK_IMPORTED_MODULE_31__/* ["default"] */ .Z,
  homebridge: _homebridge_widget__WEBPACK_IMPORTED_MODULE_32__/* ["default"] */ .Z,
  healthchecks: _healthchecks_widget__WEBPACK_IMPORTED_MODULE_33__/* ["default"] */ .Z,
  ical: _calendar_widget__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z,
  immich: _immich_widget__WEBPACK_IMPORTED_MODULE_34__/* ["default"] */ .Z,
  jackett: _jackett_widget__WEBPACK_IMPORTED_MODULE_35__/* ["default"] */ .Z,
  jdownloader: _jdownloader_widget__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .Z,
  jellyfin: _emby_widget__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z,
  jellyseerr: _jellyseerr_widget__WEBPACK_IMPORTED_MODULE_36__/* ["default"] */ .Z,
  kavita: _kavita_widget__WEBPACK_IMPORTED_MODULE_38__/* ["default"] */ .Z,
  komga: _komga_widget__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .Z,
  kopia: _kopia_widget__WEBPACK_IMPORTED_MODULE_40__/* ["default"] */ .Z,
  lidarr: _lidarr_widget__WEBPACK_IMPORTED_MODULE_41__/* ["default"] */ .Z,
  mastodon: _mastodon_widget__WEBPACK_IMPORTED_MODULE_42__/* ["default"] */ .Z,
  mealie: _mealie_widget__WEBPACK_IMPORTED_MODULE_43__/* ["default"] */ .Z,
  medusa: _medusa_widget__WEBPACK_IMPORTED_MODULE_44__/* ["default"] */ .Z,
  minecraft: _minecraft_widget__WEBPACK_IMPORTED_MODULE_45__/* ["default"] */ .Z,
  miniflux: _miniflux_widget__WEBPACK_IMPORTED_MODULE_46__/* ["default"] */ .Z,
  mikrotik: _mikrotik_widget__WEBPACK_IMPORTED_MODULE_47__/* ["default"] */ .Z,
  mjpeg: _mjpeg_widget__WEBPACK_IMPORTED_MODULE_48__/* ["default"] */ .Z,
  moonraker: _moonraker_widget__WEBPACK_IMPORTED_MODULE_49__/* ["default"] */ .Z,
  mylar: _mylar_widget__WEBPACK_IMPORTED_MODULE_50__/* ["default"] */ .Z,
  navidrome: _navidrome_widget__WEBPACK_IMPORTED_MODULE_51__/* ["default"] */ .Z,
  nextcloud: _nextcloud_widget__WEBPACK_IMPORTED_MODULE_52__/* ["default"] */ .Z,
  nextdns: _nextdns_widget__WEBPACK_IMPORTED_MODULE_53__/* ["default"] */ .Z,
  npm: _npm_widget__WEBPACK_IMPORTED_MODULE_54__/* ["default"] */ .Z,
  nzbget: _nzbget_widget__WEBPACK_IMPORTED_MODULE_55__/* ["default"] */ .Z,
  octoprint: _octoprint_widget__WEBPACK_IMPORTED_MODULE_56__/* ["default"] */ .Z,
  omada: _omada_widget__WEBPACK_IMPORTED_MODULE_57__/* ["default"] */ .Z,
  ombi: _ombi_widget__WEBPACK_IMPORTED_MODULE_58__/* ["default"] */ .Z,
  opendtu: _opendtu_widget__WEBPACK_IMPORTED_MODULE_59__/* ["default"] */ .Z,
  opnsense: _opnsense_widget__WEBPACK_IMPORTED_MODULE_60__/* ["default"] */ .Z,
  overseerr: _overseerr_widget__WEBPACK_IMPORTED_MODULE_61__/* ["default"] */ .Z,
  openmediavault: _openmediavault_widget__WEBPACK_IMPORTED_MODULE_62__/* ["default"] */ .Z,
  paperlessngx: _paperlessngx_widget__WEBPACK_IMPORTED_MODULE_63__/* ["default"] */ .Z,
  peanut: _peanut_widget__WEBPACK_IMPORTED_MODULE_64__/* ["default"] */ .Z,
  pfsense: _pfsense_widget__WEBPACK_IMPORTED_MODULE_65__/* ["default"] */ .Z,
  photoprism: _photoprism_widget__WEBPACK_IMPORTED_MODULE_66__/* ["default"] */ .Z,
  proxmoxbackupserver: _proxmoxbackupserver_widget__WEBPACK_IMPORTED_MODULE_67__/* ["default"] */ .Z,
  pialert: _pialert_widget__WEBPACK_IMPORTED_MODULE_68__/* ["default"] */ .Z,
  pihole: _pihole_widget__WEBPACK_IMPORTED_MODULE_69__/* ["default"] */ .Z,
  plex: _plex_widget__WEBPACK_IMPORTED_MODULE_70__/* ["default"] */ .Z,
  portainer: _portainer_widget__WEBPACK_IMPORTED_MODULE_71__/* ["default"] */ .Z,
  prometheus: _prometheus_widget__WEBPACK_IMPORTED_MODULE_72__/* ["default"] */ .Z,
  prowlarr: _prowlarr_widget__WEBPACK_IMPORTED_MODULE_73__/* ["default"] */ .Z,
  proxmox: _proxmox_widget__WEBPACK_IMPORTED_MODULE_74__/* ["default"] */ .Z,
  pterodactyl: _pterodactyl_widget__WEBPACK_IMPORTED_MODULE_75__/* ["default"] */ .Z,
  pyload: _pyload_widget__WEBPACK_IMPORTED_MODULE_76__/* ["default"] */ .Z,
  qbittorrent: _qbittorrent_widget__WEBPACK_IMPORTED_MODULE_77__/* ["default"] */ .Z,
  qnap: _qnap_widget__WEBPACK_IMPORTED_MODULE_78__/* ["default"] */ .Z,
  radarr: _radarr_widget__WEBPACK_IMPORTED_MODULE_79__/* ["default"] */ .Z,
  readarr: _readarr_widget__WEBPACK_IMPORTED_MODULE_80__/* ["default"] */ .Z,
  rutorrent: _rutorrent_widget__WEBPACK_IMPORTED_MODULE_81__/* ["default"] */ .Z,
  sabnzbd: _sabnzbd_widget__WEBPACK_IMPORTED_MODULE_82__/* ["default"] */ .Z,
  scrutiny: _scrutiny_widget__WEBPACK_IMPORTED_MODULE_83__/* ["default"] */ .Z,
  sonarr: _sonarr_widget__WEBPACK_IMPORTED_MODULE_84__/* ["default"] */ .Z,
  speedtest: _speedtest_widget__WEBPACK_IMPORTED_MODULE_85__/* ["default"] */ .Z,
  strelaysrv: _strelaysrv_widget__WEBPACK_IMPORTED_MODULE_86__/* ["default"] */ .Z,
  tailscale: _tailscale_widget__WEBPACK_IMPORTED_MODULE_87__/* ["default"] */ .Z,
  tautulli: _tautulli_widget__WEBPACK_IMPORTED_MODULE_88__/* ["default"] */ .Z,
  tdarr: _tdarr_widget__WEBPACK_IMPORTED_MODULE_89__/* ["default"] */ .Z,
  traefik: _traefik_widget__WEBPACK_IMPORTED_MODULE_90__/* ["default"] */ .Z,
  transmission: _transmission_widget__WEBPACK_IMPORTED_MODULE_91__/* ["default"] */ .Z,
  tubearchivist: _tubearchivist_widget__WEBPACK_IMPORTED_MODULE_92__/* ["default"] */ .Z,
  truenas: _truenas_widget__WEBPACK_IMPORTED_MODULE_93__/* ["default"] */ .Z,
  unifi: _unifi_widget__WEBPACK_IMPORTED_MODULE_94__/* ["default"] */ .Z,
  unifi_console: _unifi_widget__WEBPACK_IMPORTED_MODULE_94__/* ["default"] */ .Z,
  unmanic: _unmanic_widget__WEBPACK_IMPORTED_MODULE_95__/* ["default"] */ .Z,
  uptimekuma: _uptimekuma_widget__WEBPACK_IMPORTED_MODULE_96__/* ["default"] */ .Z,
  uptimerobot: _uptimerobot_widget__WEBPACK_IMPORTED_MODULE_97__/* ["default"] */ .Z,
  urbackup: _urbackup_widget__WEBPACK_IMPORTED_MODULE_101__/* ["default"] */ .Z,
  watchtower: _watchtower_widget__WEBPACK_IMPORTED_MODULE_98__/* ["default"] */ .Z,
  whatsupdocker: _whatsupdocker_widget__WEBPACK_IMPORTED_MODULE_99__/* ["default"] */ .Z,
  xteve: _xteve_widget__WEBPACK_IMPORTED_MODULE_100__/* ["default"] */ .Z
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widgets);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7893:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ xteveProxyHandler)
/* harmony export */ });
/* harmony import */ var utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(792);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2330);
/* harmony import */ var widgets_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8110);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7765);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_logger__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_logger__WEBPACK_IMPORTED_MODULE_1__, widgets_widgets__WEBPACK_IMPORTED_MODULE_2__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)("xteveProxyHandler");
async function xteveProxyHandler(req, res) {
  const {
    group,
    service,
    endpoint
  } = req.query;

  if (!group || !service) {
    return res.status(400).json({
      error: "Invalid proxy service type"
    });
  }

  const widget = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(group, service);
  const api = widgets_widgets__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z?.[widget.type]?.api;

  if (!api) {
    return res.status(403).json({
      error: "Service does not support API calls"
    });
  }

  const url = (0,utils_proxy_api_helpers__WEBPACK_IMPORTED_MODULE_4__/* .formatApiCall */ .s4)(api, _objectSpread({
    endpoint
  }, widget));
  const method = "POST";
  const payload = {
    cmd: "status"
  };

  if (widget.username && widget.password) {
    // eslint-disable-next-line no-unused-vars
    const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, {
      method,
      body: JSON.stringify({
        cmd: "login",
        username: widget.username,
        password: widget.password
      })
    });

    if (status !== 200) {
      logger.debug("Error logging into xteve", status, url);
      return res.status(status).json({
        error: {
          message: `HTTP Error ${status} logging into xteve`,
          url,
          data
        }
      });
    }

    const json = JSON.parse(data.toString());

    if (json?.status !== true) {
      return res.status(401).json({
        error: {
          message: "Authentication failed",
          url,
          data
        }
      });
    }

    payload.token = json.token;
  }

  const [status, contentType, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(url, {
    method,
    body: JSON.stringify(payload)
  });

  if (status !== 200) {
    logger.debug("Error %d calling xteve endpoint %s", status, url);
    return res.status(status).json({
      error: {
        message: `HTTP Error ${status}`,
        url,
        data
      }
    });
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  return res.status(status).send(data);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3313:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _proxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7893);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_proxy__WEBPACK_IMPORTED_MODULE_0__]);
_proxy__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const widget = {
  api: "{url}/{endpoint}",
  proxyHandler: _proxy__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z,
  mappings: {
    api: {
      endpoint: "api/"
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widget);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,2156,7765,7704,8562], () => (__webpack_exec__(4332)));
module.exports = __webpack_exports__;

})();