"use strict";
(() => {
var exports = {};
exports.id = 2453;
exports.ids = [2453];
exports.modules = {

/***/ 276:
/***/ ((module) => {

module.exports = require("@kubernetes/client-node");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 7835:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(201);
/* harmony import */ var _utils_kubernetes_kubernetes_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9366);
/* harmony import */ var _utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_1__, _utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([_utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_1__, _utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const logger = (0,_utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("kubernetes-widget");
async function handler(req, res) {
  try {
    const kc = (0,_utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)();

    if (!kc) {
      return res.status(500).send({
        error: "No kubernetes configuration"
      });
    }

    const coreApi = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_0__.CoreV1Api);
    const metricsApi = new _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_0__.Metrics(kc);
    const nodes = await coreApi.listNode().then(response => response.body).catch(error => {
      logger.error("Error getting ingresses: %d %s %s", error.statusCode, error.body, error.response);
      return null;
    });

    if (!nodes) {
      return res.status(500).send({
        error: "unknown error"
      });
    }

    let cpuTotal = 0;
    let cpuUsage = 0;
    let memTotal = 0;
    let memUsage = 0;
    const nodeMap = {};
    nodes.items.forEach(node => {
      const cpu = Number.parseInt(node.status.capacity.cpu, 10);
      const mem = (0,_utils_kubernetes_kubernetes_utils__WEBPACK_IMPORTED_MODULE_3__/* .parseMemory */ .S)(node.status.capacity.memory);
      const ready = node.status.conditions.filter(condition => condition.type === "Ready" && condition.status === "True").length > 0;
      nodeMap[node.metadata.name] = {
        name: node.metadata.name,
        ready,
        cpu: {
          total: cpu
        },
        memory: {
          total: mem
        }
      };
      cpuTotal += cpu;
      memTotal += mem;
    });

    try {
      const nodeMetrics = await metricsApi.getNodeMetrics();
      nodeMetrics.items.forEach(nodeMetric => {
        const cpu = (0,_utils_kubernetes_kubernetes_utils__WEBPACK_IMPORTED_MODULE_3__/* .parseCpu */ .t)(nodeMetric.usage.cpu);
        const mem = (0,_utils_kubernetes_kubernetes_utils__WEBPACK_IMPORTED_MODULE_3__/* .parseMemory */ .S)(nodeMetric.usage.memory);
        cpuUsage += cpu;
        memUsage += mem;
        nodeMap[nodeMetric.metadata.name].cpu.load = cpu;
        nodeMap[nodeMetric.metadata.name].cpu.percent = cpu / nodeMap[nodeMetric.metadata.name].cpu.total * 100;
        nodeMap[nodeMetric.metadata.name].memory.used = mem;
        nodeMap[nodeMetric.metadata.name].memory.free = nodeMap[nodeMetric.metadata.name].memory.total - mem;
        nodeMap[nodeMetric.metadata.name].memory.percent = mem / nodeMap[nodeMetric.metadata.name].memory.total * 100;
      });
    } catch (error) {
      logger.error("Error getting metrics, ensure you have metrics-server installed: s", JSON.stringify(error));
      return res.status(500).send({
        error: "Error getting metrics, check logs for more details"
      });
    }

    const cluster = {
      cpu: {
        load: cpuUsage,
        total: cpuTotal,
        percent: cpuUsage / cpuTotal * 100
      },
      memory: {
        used: memUsage,
        total: memTotal,
        free: memTotal - memUsage,
        percent: memUsage / memTotal * 100
      }
    };
    return res.status(200).json({
      cluster,
      nodes: Object.entries(nodeMap).map(([name, node]) => _objectSpread({
        name
      }, node))
    });
  } catch (e) {
    logger.error("exception %s", e);
    return res.status(500).send({
      error: "unknown error"
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,5834], () => (__webpack_exec__(7835)));
module.exports = __webpack_exports__;

})();