"use strict";
(() => {
var exports = {};
exports.id = 8191;
exports.ids = [8191];
exports.modules = {

/***/ 6953:
/***/ ((module) => {

module.exports = require("follow-redirects");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 7976:
/***/ ((module) => {

module.exports = require("tough-cookie");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 5628:
/***/ ((module) => {

module.exports = require("node:zlib");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 3080:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var _utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var _utils_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2330);
/* harmony import */ var _utils_config_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, _utils_logger__WEBPACK_IMPORTED_MODULE_1__, _utils_config_config__WEBPACK_IMPORTED_MODULE_2__]);
([_utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, _utils_logger__WEBPACK_IMPORTED_MODULE_1__, _utils_config_config__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const logger = (0,_utils_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)("longhorn");

function parseLonghornData(data) {
  const json = JSON.parse(data);

  if (!json) {
    return null;
  }

  const nodes = json.data.map(node => {
    let available = 0;
    let maximum = 0;
    let reserved = 0;
    let scheduled = 0;

    if (node.disks) {
      Object.keys(node.disks).forEach(diskKey => {
        const disk = node.disks[diskKey];
        available += disk.storageAvailable;
        maximum += disk.storageMaximum;
        reserved += disk.storageReserved;
        scheduled += disk.storageScheduled;
      });
    }

    return {
      id: node.id,
      available,
      maximum,
      reserved,
      scheduled
    };
  });
  const total = nodes.reduce((summary, node) => ({
    available: summary.available + node.available,
    maximum: summary.maximum + node.maximum,
    reserved: summary.reserved + node.reserved,
    scheduled: summary.scheduled + node.scheduled
  }));
  total.id = "total";
  nodes.push(total);
  return nodes;
}

async function handler(req, res) {
  const settings = (0,_utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* .getSettings */ .Gw)();
  const longhornSettings = settings?.providers?.longhorn || {};
  const {
    url,
    username,
    password
  } = longhornSettings;

  if (!url) {
    const errorMessage = "Missing Longhorn URL";
    logger.error(errorMessage);
    return res.status(400).json({
      error: errorMessage
    });
  }

  const apiUrl = `${url}/v1/nodes`;
  const headers = {
    "Accept-Encoding": "application/json"
  };

  if (username && password) {
    headers.Authorization = `Basic ${Buffer.from(`${username}:${password}`).toString("base64")}`;
  }

  const params = {
    method: "GET",
    headers
  };
  const [status, contentType, data] = await (0,_utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(apiUrl, params);

  if (status === 401) {
    logger.error("Authorization failure getting data from Longhorn API. Data: %s", data);
  }

  if (status !== 200) {
    logger.error("HTTP %d getting data from Longhorn API. Data: %s", status, data);
  }

  if (contentType) res.setHeader("Content-Type", contentType);
  const nodes = parseLonghornData(data);
  return res.status(200).json({
    nodes
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,8562], () => (__webpack_exec__(3080)));
module.exports = __webpack_exports__;

})();