"use strict";
(() => {
var exports = {};
exports.id = 9127;
exports.ids = [9127];
exports.modules = {

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 8741:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var utils_proxy_cached_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6378);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_config__WEBPACK_IMPORTED_MODULE_1__]);
utils_config_config__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


async function handler(req, res) {
  const {
    latitude,
    longitude,
    provider,
    cache,
    lang
  } = req.query;
  let {
    apiKey
  } = req.query;

  if (!apiKey && !provider) {
    return res.status(400).json({
      error: "Missing API key or provider"
    });
  }

  if (!apiKey && provider !== "weatherapi") {
    return res.status(400).json({
      error: "Invalid provider for endpoint"
    });
  }

  if (!apiKey && provider) {
    const settings = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_1__/* .getSettings */ .Gw)();
    apiKey = settings?.providers?.weatherapi;
  }

  if (!apiKey) {
    return res.status(400).json({
      error: "Missing API key"
    });
  }

  const apiUrl = `http://api.weatherapi.com/v1/current.json?q=${latitude},${longitude}&key=${apiKey}&lang=${lang}`;
  return res.send(await (0,utils_proxy_cached_fetch__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(apiUrl, cache));
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6378:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ cachedFetch)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);

const defaultDuration = 5;
async function cachedFetch(url, duration) {
  const cached = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(url); // eslint-disable-next-line no-param-reassign

  duration = duration || defaultDuration;

  if (cached) {
    return cached;
  }

  const data = await fetch(url).then(res => res.json());
  memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(url, data, duration * 1000 * 60);
  return data;
}

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732], () => (__webpack_exec__(8741)));
module.exports = __webpack_exports__;

})();