"use strict";
exports.id = 163;
exports.ids = [163];
exports.modules = {

/***/ 163:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IY": () => (/* binding */ bookmarksResponse),
/* harmony export */   "a5": () => (/* binding */ widgetsResponse),
/* harmony export */   "bh": () => (/* binding */ servicesResponse)
/* harmony export */ });
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5732);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7765);
/* harmony import */ var utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7704);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-console */






/**
 * Compares services by weight then by name.
 */

function compareServices(service1, service2) {
  const comp = service1.weight - service2.weight;

  if (comp !== 0) {
    return comp;
  }

  return service1.name.localeCompare(service2.name);
}

async function bookmarksResponse() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("bookmarks.yaml");
  const bookmarksYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "bookmarks.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(bookmarksYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const bookmarks = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);
  if (!bookmarks) return [];
  let initialSettings;

  try {
    initialSettings = await (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .getSettings */ .Gw)();
  } catch (e) {
    console.error("Failed to load settings.yaml, please check for errors");
    if (e) console.error(e.toString());
    initialSettings = {};
  } // map easy to write YAML objects into easy to consume JS arrays


  const bookmarksArray = bookmarks.map(group => ({
    name: Object.keys(group)[0],
    bookmarks: group[Object.keys(group)[0]].map(entries => _objectSpread({
      name: Object.keys(entries)[0]
    }, entries[Object.keys(entries)[0]][0]))
  }));
  const sortedGroups = [];
  const unsortedGroups = [];
  const definedLayouts = initialSettings.layout ? Object.keys(initialSettings.layout) : null;
  bookmarksArray.forEach(group => {
    if (definedLayouts) {
      const layoutIndex = definedLayouts.findIndex(layout => layout === group.name);
      if (layoutIndex > -1) sortedGroups[layoutIndex] = group;else unsortedGroups.push(group);
    } else {
      unsortedGroups.push(group);
    }
  });
  return [...sortedGroups.filter(g => g), ...unsortedGroups];
}
async function widgetsResponse() {
  let configuredWidgets;

  try {
    configuredWidgets = (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__/* .cleanWidgetGroups */ .qz)(await (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__/* .widgetsFromConfig */ .uN)());
  } catch (e) {
    console.error("Failed to load widgets, please check widgets.yaml for errors or remove example entries.");
    if (e) console.error(e);
    configuredWidgets = [];
  }

  return configuredWidgets;
}
async function servicesResponse() {
  let discoveredDockerServices;
  let discoveredKubernetesServices;
  let configuredServices;
  let initialSettings;

  try {
    discoveredDockerServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromDocker */ .kr)());

    if (discoveredDockerServices?.length === 0) {
      console.debug("No containers were found with homepage labels.");
    }
  } catch (e) {
    console.error("Failed to discover services, please check docker.yaml for errors or remove example entries.");
    if (e) console.error(e.toString());
    discoveredDockerServices = [];
  }

  try {
    discoveredKubernetesServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromKubernetes */ .iP)());
  } catch (e) {
    console.error("Failed to discover services, please check kubernetes.yaml for errors or remove example entries.");
    if (e) console.error(e.toString());
    discoveredKubernetesServices = [];
  }

  try {
    configuredServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromConfig */ .ah)());
  } catch (e) {
    console.error("Failed to load services.yaml, please check for errors");
    if (e) console.error(e.toString());
    configuredServices = [];
  }

  try {
    initialSettings = await (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .getSettings */ .Gw)();
  } catch (e) {
    console.error("Failed to load settings.yaml, please check for errors");
    if (e) console.error(e.toString());
    initialSettings = {};
  }

  const mergedGroupsNames = [...new Set([discoveredDockerServices.map(group => group.name), discoveredKubernetesServices.map(group => group.name), configuredServices.map(group => group.name)].flat())];
  const sortedGroups = [];
  const unsortedGroups = [];
  const definedLayouts = initialSettings.layout ? Object.keys(initialSettings.layout) : null;
  mergedGroupsNames.forEach(groupName => {
    const discoveredDockerGroup = discoveredDockerServices.find(group => group.name === groupName) || {
      services: []
    };
    const discoveredKubernetesGroup = discoveredKubernetesServices.find(group => group.name === groupName) || {
      services: []
    };
    const configuredGroup = configuredServices.find(group => group.name === groupName) || {
      services: []
    };
    const mergedGroup = {
      name: groupName,
      services: [...discoveredDockerGroup.services, ...discoveredKubernetesGroup.services, ...configuredGroup.services].filter(service => service).sort(compareServices)
    };

    if (definedLayouts) {
      const layoutIndex = definedLayouts.findIndex(layout => layout === mergedGroup.name);
      if (layoutIndex > -1) sortedGroups[layoutIndex] = mergedGroup;else unsortedGroups.push(mergedGroup);
    } else {
      unsortedGroups.push(mergedGroup);
    }
  });
  return [...sortedGroups.filter(g => g), ...unsortedGroups];
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;