"use strict";
exports.id = 2330;
exports.ids = [2330];
exports.modules = {

/***/ 2330:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ createLogger)
/* harmony export */ });
/* harmony import */ var node_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7261);
/* harmony import */ var node_util__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_util__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var winston__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7773);
/* harmony import */ var winston__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(winston__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_config__WEBPACK_IMPORTED_MODULE_2__]);
utils_config_config__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/* eslint-disable no-console */



let winstonLogger;

function init() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)("settings.yaml");
  const settings = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* .getSettings */ .Gw)();
  const logpath = settings.logpath || utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* .CONF_DIR */ .Fn;

  function combineMessageAndSplat() {
    return {
      // eslint-disable-next-line no-unused-vars
      transform: (info, opts) => {
        // combine message and args if any
        // eslint-disable-next-line no-param-reassign
        info.message = (0,node_util__WEBPACK_IMPORTED_MODULE_0__.format)(info.message, ...(info[Symbol.for("splat")] || []));
        return info;
      }
    };
  }

  function messageFormatter(logInfo) {
    if (logInfo.label) {
      if (logInfo.stack) {
        return `[${logInfo.timestamp}] ${logInfo.level}: <${logInfo.label}> ${logInfo.stack}`;
      }

      return `[${logInfo.timestamp}] ${logInfo.level}: <${logInfo.label}> ${logInfo.message}`;
    }

    if (logInfo.stack) {
      return `[${logInfo.timestamp}] ${logInfo.level}: ${logInfo.stack}`;
    }

    return `[${logInfo.timestamp}] ${logInfo.level}: ${logInfo.message}`;
  }

  winstonLogger = winston__WEBPACK_IMPORTED_MODULE_1___default().createLogger({
    level: process.env.LOG_LEVEL || "info",
    transports: [new (winston__WEBPACK_IMPORTED_MODULE_1___default().transports.Console)({
      format: winston__WEBPACK_IMPORTED_MODULE_1___default().format.combine(winston__WEBPACK_IMPORTED_MODULE_1___default().format.errors({
        stack: true
      }), combineMessageAndSplat(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.timestamp(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.colorize(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.printf(messageFormatter)),
      handleExceptions: true,
      handleRejections: true
    }), new (winston__WEBPACK_IMPORTED_MODULE_1___default().transports.File)({
      format: winston__WEBPACK_IMPORTED_MODULE_1___default().format.combine(winston__WEBPACK_IMPORTED_MODULE_1___default().format.errors({
        stack: true
      }), combineMessageAndSplat(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.timestamp(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.printf(messageFormatter)),
      filename: `${logpath}/logs/homepage.log`,
      handleExceptions: true,
      handleRejections: true
    })]
  }); // patch the console log mechanism to use our logger

  const consoleMethods = ["log", "debug", "info", "warn", "error"];
  consoleMethods.forEach(method => {
    // workaround for https://github.com/winstonjs/winston/issues/1591
    switch (method) {
      case "log":
        console[method] = winstonLogger.info.bind(winstonLogger);
        break;

      default:
        console[method] = winstonLogger[method].bind(winstonLogger);
        break;
    }
  });
}

const loggers = {};
function createLogger(label) {
  if (!winstonLogger) {
    init();
  }

  if (!loggers[label]) {
    loggers[label] = winstonLogger.child({
      label
    });
  }

  return loggers[label];
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;