"use strict";
exports.id = 3341;
exports.ids = [3341];
exports.modules = {

/***/ 3341:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var _metrics_memory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5061);
/* harmony import */ var _metrics_cpu__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3683);
/* harmony import */ var _metrics_sensor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7312);
/* harmony import */ var _metrics_net__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4239);
/* harmony import */ var _metrics_process__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9277);
/* harmony import */ var _metrics_disk__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9010);
/* harmony import */ var _metrics_gpu__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8349);
/* harmony import */ var _metrics_info__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5399);
/* harmony import */ var _metrics_fs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7053);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_metrics_memory__WEBPACK_IMPORTED_MODULE_0__, _metrics_cpu__WEBPACK_IMPORTED_MODULE_1__, _metrics_sensor__WEBPACK_IMPORTED_MODULE_2__, _metrics_net__WEBPACK_IMPORTED_MODULE_3__, _metrics_process__WEBPACK_IMPORTED_MODULE_4__, _metrics_disk__WEBPACK_IMPORTED_MODULE_5__, _metrics_gpu__WEBPACK_IMPORTED_MODULE_6__, _metrics_info__WEBPACK_IMPORTED_MODULE_7__, _metrics_fs__WEBPACK_IMPORTED_MODULE_8__]);
([_metrics_memory__WEBPACK_IMPORTED_MODULE_0__, _metrics_cpu__WEBPACK_IMPORTED_MODULE_1__, _metrics_sensor__WEBPACK_IMPORTED_MODULE_2__, _metrics_net__WEBPACK_IMPORTED_MODULE_3__, _metrics_process__WEBPACK_IMPORTED_MODULE_4__, _metrics_disk__WEBPACK_IMPORTED_MODULE_5__, _metrics_gpu__WEBPACK_IMPORTED_MODULE_6__, _metrics_info__WEBPACK_IMPORTED_MODULE_7__, _metrics_fs__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










function Component({
  service
}) {
  const {
    widget
  } = service;

  if (widget.metric === "info") {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_info__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric === "memory") {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_memory__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric === "process") {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_process__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric === "cpu") {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_cpu__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric.match(/^network:/)) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_net__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric.match(/^sensor:/)) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_sensor__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric.match(/^disk:/)) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_disk__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric.match(/^gpu:/)) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_gpu__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
      service: service
    });
  }

  if (widget.metric.match(/^fs:/)) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_metrics_fs__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      service: service
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1230:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Block)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function Block({
  position,
  children
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: `absolute ${position} z-20 text-sm pointer-events-none`,
    children: children
  });
}

/***/ }),

/***/ 3743:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Container)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);


function Container({
  children,
  chart = true,
  className = ""
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    children: [children, /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
      className: `absolute top-0 right-0 bottom-0 left-0 overflow-clip pointer-events-none ${className}`
    }), chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
      className: "h-[68px] overflow-clip"
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
      className: "h-[16px] overflow-clip"
    })]
  });
}

/***/ }),

/***/ 2080:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Error)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Error() {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
    className: "absolute bottom-2 left-2 z-20 text-red-400 text-xs opacity-75",
    children: t("widget.api_error")
  });
}

/***/ }),

/***/ 3683:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const Chart = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 6238).then(__webpack_require__.bind(__webpack_require__, 6238)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/cpu.jsx -> " + "../components/chart"]
  }
});
const defaultPointsLimit = 15;
const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval,
    pointsLimit = defaultPointsLimit
  } = widget;
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    value: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(service.widget, "cpu", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });
  const {
    data: systemData,
    error: systemError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(service.widget, "system");
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      setDataPoints(prevDataPoints => {
        const newDataPoints = [...prevDataPoints, {
          value: data.total
        }];

        if (newDataPoints.length > pointsLimit) {
          newDataPoints.shift();
        }

        return newDataPoints;
      });
    }
  }, [data, pointsLimit]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(Chart, {
      dataPoints: dataPoints,
      label: [t("resources.used")],
      formatter: value => t("common.number", {
        value,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      })
    }), !chart && systemData && !systemError && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [systemData.linux_distro && `${systemData.linux_distro} - `, systemData.os_version && systemData.os_version]
      })
    }), systemData && !systemError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [systemData.linux_distro && chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: systemData.linux_distro
      }), systemData.os_version && chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: systemData.os_version
      }), systemData.hostname && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: systemData.hostname
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs font-bold opacity-75",
        children: [t("common.number", {
          value: data.total,
          style: "unit",
          unit: "percent",
          maximumFractionDigits: 0
        }), " ", t("resources.used")]
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9010:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const ChartDual = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 303).then(__webpack_require__.bind(__webpack_require__, 303)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/disk.jsx -> " + "../components/chart_dual"]
  }
});
const defaultPointsLimit = 15;
const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval,
    pointsLimit = defaultPointsLimit
  } = widget;
  const [, diskName] = widget.metric.split(":");
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    read_bytes: 0,
    write_bytes: 0,
    time_since_update: 0
  }, 0, pointsLimit));
  const {
    0: ratePoints,
    1: setRatePoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    a: 0,
    b: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(service.widget, "diskio", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });

  const calculateRates = d => d.map(item => ({
    a: item.read_bytes / item.time_since_update,
    b: item.write_bytes / item.time_since_update
  }));

  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      const diskData = data.find(item => item.disk_name === diskName);
      setDataPoints(prevDataPoints => {
        const newDataPoints = [...prevDataPoints, diskData];

        if (newDataPoints.length > pointsLimit) {
          newDataPoints.shift();
        }

        return newDataPoints;
      });
    }
  }, [data, diskName, pointsLimit]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    setRatePoints(calculateRates(dataPoints));
  }, [dataPoints]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  const diskData = data.find(item => item.disk_name === diskName);

  if (!diskData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  const diskRates = calculateRates(dataPoints);
  const currentRate = diskRates[diskRates.length - 1];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(ChartDual, {
      dataPoints: ratePoints,
      label: [t("glances.read"), t("glances.write")],
      max: diskData.critical,
      formatter: value => t("common.bitrate", {
        value
      })
    }), currentRate && !error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: chart ? "bottom-3 left-3" : "bottom-3 right-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50 text-right",
        children: [t("common.bitrate", {
          value: currentRate.a
        }), " ", t("glances.read")]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50 text-right",
        children: [t("common.bitrate", {
          value: currentRate.b
        }), " ", t("glances.write")]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: chart ? "bottom-3 right-3" : "bottom-3 left-3",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-75",
        children: t("common.bitrate", {
          value: currentRate.a + currentRate.b
        })
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7053:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval
  } = widget;
  const [, fsName] = widget.metric.split("fs:");
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(widget, "fs", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  const fsData = data.find(item => item[item.key] === fsName);

  if (!fsData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "absolute top-0 left-0 right-0 bottom-0",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        style: {
          height: `${Math.max(20, fsData.size / fsData.free)}%`
        },
        className: "absolute bottom-0 border-t border-t-theme-500 bg-gradient-to-b from-theme-500/40 to-theme-500/10 w-full"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [fsData.used && chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.bbytes", {
          value: fsData.used,
          maximumFractionDigits: 0
        }), " ", t("resources.used")]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [t("common.bbytes", {
          value: fsData.free,
          maximumFractionDigits: 1
        }), " ", t("resources.free")]
      })]
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: fsData.used && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.bbytes", {
          value: fsData.used,
          maximumFractionDigits: 0
        }), " ", t("resources.used")]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [t("common.bbytes", {
          value: fsData.size,
          maximumFractionDigits: 1
        }), " ", t("resources.total")]
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8349:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const ChartDual = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 303).then(__webpack_require__.bind(__webpack_require__, 303)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/gpu.jsx -> " + "../components/chart_dual"]
  }
});
const defaultPointsLimit = 15;
const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval,
    pointsLimit = defaultPointsLimit
  } = widget;
  const [, gpuName] = widget.metric.split(":");
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    a: 0,
    b: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(widget, "gpu", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      // eslint-disable-next-line eqeqeq
      const gpuData = data.find(item => item[item.key] == gpuName);

      if (gpuData) {
        setDataPoints(prevDataPoints => {
          const newDataPoints = [...prevDataPoints, {
            a: gpuData.mem,
            b: gpuData.proc
          }];

          if (newDataPoints.length > pointsLimit) {
            newDataPoints.shift();
          }

          return newDataPoints;
        });
      }
    }
  }, [data, gpuName, pointsLimit]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  } // eslint-disable-next-line eqeqeq


  const gpuData = data.find(item => item[item.key] == gpuName);

  if (!gpuData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(ChartDual, {
      dataPoints: dataPoints,
      label: [t("glances.mem"), t("glances.gpu")],
      stack: ["mem", "proc"],
      formatter: value => t("common.percent", {
        value,
        maximumFractionDigits: 1
      })
    }), chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [gpuData && gpuData.name && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: gpuData.name
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.number", {
          value: gpuData.mem,
          maximumFractionDigits: 1
        }), "% ", t("resources.mem")]
      })]
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.number", {
          value: gpuData.temperature,
          maximumFractionDigits: 1
        }), "\xB0 C"]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [!chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "inline-block mr-1",
          children: [t("common.number", {
            value: gpuData.proc,
            maximumFractionDigits: 1
          }), "% ", t("glances.gpu")]
        }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
          children: "\u2022"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "inline-block ml-1",
          children: [t("common.number", {
            value: gpuData.proc,
            maximumFractionDigits: 1
          }), "% ", t("glances.gpu")]
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: [chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.number", {
          value: gpuData.temperature,
          maximumFractionDigits: 1
        }), "\xB0 C"]
      }), gpuData && gpuData.name && !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: gpuData.name
      })]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5399:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








function Swap({
  quicklookData,
  className = ""
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return quicklookData && quicklookData.swap !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "text-xs flex place-content-between",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("glances.swap")
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("common.number", {
        value: quicklookData.swap,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      })
    })]
  });
}

function CPU({
  quicklookData,
  className = ""
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return quicklookData && quicklookData.cpu && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "text-xs flex place-content-between",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("glances.cpu")
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("common.number", {
        value: quicklookData.cpu,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      })
    })]
  });
}

function Mem({
  quicklookData,
  className = ""
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return quicklookData && quicklookData.mem && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "text-xs flex place-content-between",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("glances.mem")
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: className,
      children: t("common.number", {
        value: quicklookData.mem,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      })
    })]
  });
}

const defaultInterval = 1000;
const defaultSystemInterval = 30000; // This data (OS, hostname, distribution) is usually super stable.

function Component({
  service
}) {
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval
  } = widget;
  const {
    data: quicklookData,
    errorL: quicklookError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(service.widget, "quicklook", {
    refreshInterval
  });
  const {
    data: systemData,
    errorL: systemError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(service.widget, "system", {
    refreshInterval: defaultSystemInterval
  });

  if (quicklookError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        error: quicklookError
      })
    });
  }

  if (systemError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        error: systemError
      })
    });
  }

  const dataCharts = [];

  if (quicklookData) {
    quicklookData.percpu.forEach((cpu, index) => {
      dataCharts.push({
        name: `CPU ${index}`,
        cpu: cpu.total,
        mem: quicklookData.mem,
        swap: quicklookData.swap,
        proc: quicklookData.cpu
      });
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    chart: chart,
    className: "bg-gradient-to-br from-theme-500/30 via-theme-600/20 to-theme-700/10",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: [quicklookData && quicklookData.cpu_name && chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-[0.6rem] opacity-50",
        children: quicklookData.cpu_name
      }), !chart && quicklookData?.swap === 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-[0.6rem] opacity-50",
        children: quicklookData.cpu_name
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "w-[4rem]",
        children: !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(Swap, {
          quicklookData: quicklookData,
          className: "opacity-25"
        })
      })]
    }), chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [systemData && systemData.linux_distro && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-xs opacity-50",
        children: systemData.linux_distro
      }), systemData && systemData.os_version && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-xs opacity-50",
        children: systemData.os_version
      }), systemData && systemData.hostname && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-xs opacity-75",
        children: systemData.hostname
      })]
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-3 left-3 w-[3rem]",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(CPU, {
        quicklookData: quicklookData,
        className: "opacity-75"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-3 right-3 w-[4rem]",
      children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(CPU, {
        quicklookData: quicklookData,
        className: "opacity-50"
      }), chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(Mem, {
        quicklookData: quicklookData,
        className: "opacity-50"
      }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(Mem, {
        quicklookData: quicklookData,
        className: "opacity-75"
      }), chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(Swap, {
        quicklookData: quicklookData,
        className: "opacity-50"
      })]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5061:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const ChartDual = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 303).then(__webpack_require__.bind(__webpack_require__, 303)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/memory.jsx -> " + "../components/chart_dual"]
  }
});
const defaultPointsLimit = 15;

const defaultInterval = isChart => isChart ? 1000 : 5000;

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart
  } = widget;
  const {
    refreshInterval = defaultInterval(chart),
    pointsLimit = defaultPointsLimit
  } = widget;
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    value: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(service.widget, "mem", {
    refreshInterval: Math.max(defaultInterval(chart), refreshInterval)
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      setDataPoints(prevDataPoints => {
        const newDataPoints = [...prevDataPoints, {
          a: data.used,
          b: data.free
        }];

        if (newDataPoints.length > pointsLimit) {
          newDataPoints.shift();
        }

        return newDataPoints;
      });
    }
  }, [data, pointsLimit]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(ChartDual, {
      dataPoints: dataPoints,
      max: data.total,
      label: [t("resources.used"), t("resources.free")],
      formatter: value => t("common.bytes", {
        value,
        maximumFractionDigits: 0,
        binary: true
      })
    }), data && !error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [data.free && chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.bytes", {
          value: data.free,
          maximumFractionDigits: 1,
          binary: true
        }), " ", t("resources.free")]
      }), data.total && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.bytes", {
          value: data.total,
          maximumFractionDigits: 1,
          binary: true
        }), " ", t("resources.total")]
      })]
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: data.free && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("common.bytes", {
          value: data.free,
          maximumFractionDigits: 1,
          binary: true
        }), " ", t("resources.free")]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs font-bold opacity-75",
        children: [t("common.bytes", {
          value: data.used,
          maximumFractionDigits: 1,
          binary: true
        }), " ", t("resources.used")]
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4239:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const ChartDual = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 303).then(__webpack_require__.bind(__webpack_require__, 303)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/net.jsx -> " + "../components/chart_dual"]
  }
});
const defaultPointsLimit = 15;

const defaultInterval = isChart => isChart ? 1000 : 5000;

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    metric
  } = widget;
  const {
    refreshInterval = defaultInterval(chart),
    pointsLimit = defaultPointsLimit
  } = widget;
  const [, interfaceName] = metric.split(":");
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    value: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(widget, "network", {
    refreshInterval: Math.max(defaultInterval(chart), refreshInterval)
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      const interfaceData = data.find(item => item[item.key] === interfaceName);

      if (interfaceData) {
        setDataPoints(prevDataPoints => {
          const newDataPoints = [...prevDataPoints, {
            a: interfaceData.rx * 8 / interfaceData.time_since_update,
            b: interfaceData.tx * 8 / interfaceData.time_since_update
          }];

          if (newDataPoints.length > pointsLimit) {
            newDataPoints.shift();
          }

          return newDataPoints;
        });
      }
    }
  }, [data, interfaceName, pointsLimit]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  const interfaceData = data.find(item => item[item.key] === interfaceName);

  if (!interfaceData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(ChartDual, {
      dataPoints: dataPoints,
      label: [t("docker.rx"), t("docker.tx")],
      formatter: value => t("common.bitrate", {
        value,
        maximumFractionDigits: 0
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [interfaceData && interfaceData.interface_name && chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: interfaceData.interface_name
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [t("common.bitrate", {
          value: interfaceData.rx * 8 / interfaceData.time_since_update,
          maximumFractionDigits: 0
        }), " ", t("docker.rx")]
      })]
    }), !chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "top-3 right-3",
      children: interfaceData && interfaceData.interface_name && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: interfaceData.interface_name
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [t("common.bitrate", {
          value: interfaceData.tx * 8 / interfaceData.time_since_update,
          maximumFractionDigits: 0
        }), " ", t("docker.tx")]
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9277:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4582);
/* harmony import */ var components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8904);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const statusMap = {
  R: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-circle",
    width: 32,
    height: 32
  }),
  // running
  S: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-circle-outline",
    width: 32,
    height: 32
  }),
  // sleeping
  D: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-circle-double",
    width: 32,
    height: 32
  }),
  // disk sleep
  Z: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-circle-opacity",
    width: 32,
    height: 32
  }),
  // zombie
  T: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-decagram-outline",
    width: 32,
    height: 32
  }),
  // traced
  t: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-hexagon-outline",
    width: 32,
    height: 32
  }),
  // traced
  X: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    icon: "mdi-rhombus-outline",
    width: 32,
    height: 32
  }) // dead

};
const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval
  } = widget;
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(service.widget, "processlist", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  data.splice(chart ? 5 : 1);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    chart: chart,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "top-4 right-3 left-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "flex items-center text-xs",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "grow"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "w-14 text-right italic",
          children: t("resources.cpu")
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "w-14 text-right",
          children: t("resources.mem")
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      position: "bottom-4 right-3 left-3",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "pointer-events-none text-theme-900 dark:text-theme-200",
        children: data.map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "text-[0.75rem] h-[0.8rem]",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "flex items-center",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "w-3 h-3 mr-1.5 opacity-50",
              children: statusMap[item.status]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "opacity-75 grow",
              children: item.name
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "opacity-25 w-14 text-right",
              children: [item.cpu_percent.toFixed(1), "%"]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "opacity-25 w-14 text-right",
              children: t("common.bytes", {
                value: item.memory_info[0],
                maximumFractionDigits: 0
              })
            })]
          })
        }, item.pid))
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7312:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2080);
/* harmony import */ var _components_container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3743);
/* harmony import */ var _components_block__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1230);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const Chart = next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 6238).then(__webpack_require__.bind(__webpack_require__, 6238)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../widgets/glances/metrics/sensor.jsx -> " + "../components/chart"]
  }
});
const defaultPointsLimit = 15;
const defaultInterval = 1000;
function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    widget
  } = service;
  const {
    chart,
    refreshInterval = defaultInterval,
    pointsLimit = defaultPointsLimit
  } = widget;
  const [, sensorName] = widget.metric.split(":");
  const {
    0: dataPoints,
    1: setDataPoints
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(new Array(pointsLimit).fill({
    value: 0
  }, 0, pointsLimit));
  const {
    data,
    error
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(service.widget, "sensors", {
    refreshInterval: Math.max(defaultInterval, refreshInterval)
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (data) {
      const sensorData = data.find(item => item.label === sensorName);
      setDataPoints(prevDataPoints => {
        const newDataPoints = [...prevDataPoints, {
          value: sensorData.value
        }];

        if (newDataPoints.length > pointsLimit) {
          newDataPoints.shift();
        }

        return newDataPoints;
      });
    }
  }, [data, sensorName, pointsLimit]);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        error: error
      })
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  const sensorData = data.find(item => item.label === sensorName);

  if (!sensorData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      chart: chart,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        position: "bottom-3 left-3",
        children: "-"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_container__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    chart: chart,
    children: [chart && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(Chart, {
      dataPoints: dataPoints,
      label: [sensorData.unit],
      max: sensorData.critical,
      formatter: value => t("common.number", {
        value
      })
    }), sensorData && !error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 left-3",
      children: [sensorData.warning && chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("glances.warn"), " ", sensorData.warning, " ", sensorData.unit]
      }), sensorData.critical && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-50",
        children: [t("glances.crit"), " ", sensorData.critical, " ", sensorData.unit]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_components_block__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      position: "bottom-3 right-3",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "text-xs opacity-50",
        children: sensorData.warning && !chart && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
          children: [t("glances.warn"), " ", sensorData.warning, " ", sensorData.unit]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "text-xs opacity-75",
        children: [t("glances.temp"), " ", t("common.number", {
          value: sensorData.value
        }), " ", sensorData.unit]
      })]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;