"use strict";
exports.id = 3813;
exports.ids = [3813];
exports.modules = {

/***/ 3813:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const Status = Object.freeze({
  ok: Symbol("Ok"),
  errored: Symbol("Errored"),
  noRecent: Symbol("No Recent Backups")
});

function hasRecentBackups(client, maxDays) {
  const days = maxDays || 3;
  const diffTime = days * 24 * 60 * 60; // 7 days

  const recentFile = client.lastbackup > Date.now() / 1000 - diffTime;
  const recentImage = client.image_not_supported || client.image_disabled || client.lastbackup_image > Date.now() / 1000 - diffTime;
  return recentFile && recentImage;
}

function determineStatuses(urbackupData) {
  let ok = 0;
  let errored = 0;
  let noRecent = 0;
  let status;
  urbackupData.clientStatuses.forEach(client => {
    status = Status.noRecent;

    if (hasRecentBackups(client, urbackupData.maxDays)) {
      status = client.file_ok && (client.image_ok || client.image_not_supported || client.image_disabled) ? Status.ok : Status.errored;
    }

    switch (status) {
      case Status.ok:
        ok += 1;
        break;

      case Status.errored:
        errored += 1;
        break;

      case Status.noRecent:
        noRecent += 1;
        break;

      default:
        break;
    }
  });
  let totalUsage = false; // calculate total disk space if provided

  if (urbackupData.diskUsage) {
    totalUsage = 0.0;
    urbackupData.diskUsage.forEach(client => {
      totalUsage += client.used;
    });
  }

  return {
    ok,
    errored,
    noRecent,
    totalUsage
  };
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const showDiskUsage = widget.fields?.includes("totalUsed");
  const {
    data: urbackupData,
    error: urbackupError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "status");

  if (urbackupError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: urbackupError
    });
  }

  if (!urbackupData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "urbackup.ok"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "urbackup.errored"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "urbackup.noRecent"
      }), showDiskUsage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "urbackup.totalUsed"
      })]
    });
  }

  const statusData = determineStatuses(urbackupData, widget);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "urbackup.ok",
      value: t("common.number", {
        value: parseInt(statusData.ok, 10)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "urbackup.errored",
      value: t("common.number", {
        value: parseInt(statusData.errored, 10)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "urbackup.noRecent",
      value: t("common.number", {
        value: parseInt(statusData.noRecent, 10)
      })
    }), showDiskUsage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "urbackup.totalUsed",
      value: t("common.bbytes", {
        value: parseFloat(statusData.totalUsage, 10)
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;