"use strict";
exports.id = 4582;
exports.ids = [4582];
exports.modules = {

/***/ 4945:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "iX": () => (/* binding */ formatProxyUrl),
/* harmony export */   "wR": () => (/* binding */ formatProxyUrlWithSegments)
/* harmony export */ });
/* unused harmony exports formatApiCall, asJson, jsonArrayTransform, jsonArrayFilter, sanitizeErrorURL */
function formatApiCall(url, args) {
  const find = /\{.*?\}/g;

  const replace = match => {
    const key = match.replace(/\{|\}/g, "");
    return args[key] || "";
  };

  return url.replace(/\/+$/, "").replace(find, replace).replace(find, replace);
}

function getURLSearchParams(widget, endpoint) {
  const params = new URLSearchParams({
    type: widget.type,
    group: widget.service_group,
    service: widget.service_name,
    endpoint
  });
  return params;
}

function formatProxyUrlWithSegments(widget, endpoint, segments) {
  const params = getURLSearchParams(widget, endpoint);

  if (segments) {
    params.append("segments", JSON.stringify(segments));
  }

  return `/api/services/proxy?${params.toString()}`;
}
function formatProxyUrl(widget, endpoint, queryParams) {
  const params = getURLSearchParams(widget, endpoint);

  if (queryParams) {
    params.append("query", JSON.stringify(queryParams));
  }

  return `/api/services/proxy?${params.toString()}`;
}
function asJson(data) {
  if (data?.length > 0) {
    const json = JSON.parse(data.toString());
    return json;
  }

  return data;
}
function jsonArrayTransform(data, transform) {
  const json = asJson(data);

  if (json instanceof Array) {
    return transform(json);
  }

  return json;
}
function jsonArrayFilter(data, filter) {
  return jsonArrayTransform(data, items => items.filter(filter));
}
function sanitizeErrorURL(errorURL) {
  // Dont display sensitive params on frontend
  const url = new URL(errorURL);
  ["apikey", "api_key", "token", "t"].forEach(key => {
    if (url.searchParams.has(key)) url.searchParams.set(key, "***");
  });
  return url.toString();
}

/***/ }),

/***/ 4582:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useWidgetAPI)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var _api_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4945);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


function useWidgetAPI(widget, ...options) {
  const config = {};

  if (options && options[1]?.refreshInterval) {
    config.refreshInterval = options[1].refreshInterval;
  }

  let url = (0,_api_helpers__WEBPACK_IMPORTED_MODULE_1__/* .formatProxyUrl */ .iX)(widget, ...options);

  if (options[0] === "") {
    url = null;
  }

  const {
    data,
    error,
    mutate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(url, config); // make the data error the top-level error

  return {
    data,
    error: data?.error ?? error,
    mutate
  };
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;