"use strict";
exports.id = 527;
exports.ids = [527];
exports.modules = {

/***/ 527:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: infoData,
    error: infoError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "system_info");
  const {
    data: storageData,
    error: storageError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "system_storage");
  const {
    data: utilizationData,
    error: utilizationError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "utilization");

  if (storageError || infoError || utilizationError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: storageError ?? infoError ?? utilizationError
    });
  }

  if (!storageData || !infoData || !utilizationData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "diskstation.uptime"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "diskstation.volumeAvailable"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "resources.cpu"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "resources.mem"
      })]
    });
  } // uptime info
  // eslint-disable-next-line no-unused-vars


  const [hour, minutes, seconds] = infoData.data.up_time.split(":");
  const days = Math.floor(hour / 24);
  const uptime = `${t("common.number", {
    value: days
  })} ${t("diskstation.days")}`; // storage info

  const volume = widget.volume ? storageData.data.vol_info?.find(vol => vol.name === widget.volume) : storageData.data.vol_info?.[0];
  const usedBytes = parseFloat(volume?.used_size);
  const totalBytes = parseFloat(volume?.total_size);
  const freeBytes = totalBytes - usedBytes; // utilization info

  const {
    cpu,
    memory
  } = utilizationData.data;
  const cpuLoad = parseFloat(cpu.user_load) + parseFloat(cpu.system_load);
  const memoryUsage = 100 - 100 * (parseFloat(memory.avail_real) + parseFloat(memory.cached)) / parseFloat(memory.total_real);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "diskstation.uptime",
      value: uptime
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "diskstation.volumeAvailable",
      value: t("common.bbytes", {
        value: freeBytes,
        maximumFractionDigits: 1
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "resources.cpu",
      value: t("common.percent", {
        value: cpuLoad
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "resources.mem",
      value: t("common.percent", {
        value: memoryUsage
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;