"use strict";
exports.id = 568;
exports.ids = [568];
exports.modules = {

/***/ 568:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: datastoreData,
    error: datastoreError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "status/datastore-usage");
  const {
    data: tasksData,
    error: tasksError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "nodes/localhost/tasks");
  const {
    data: hostData,
    error: hostError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "nodes/localhost/status");

  if (datastoreError || tasksError || hostError) {
    const finalError = tasksError ?? datastoreError ?? hostError;
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: finalError
    });
  }

  if (!datastoreData || !tasksData || !hostData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "proxmoxbackupserver.datastore_usage"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "proxmoxbackupserver.failed_tasks_24h"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "proxmoxbackupserver.cpu_usage"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "proxmoxbackupserver.memory_usage"
      })]
    });
  }

  const datastoreUsage = datastoreData.data[0].used / datastoreData.data[0].total * 100;
  const cpuUsage = hostData.data.cpu * 100;
  const memoryUsage = hostData.data.memory.used / hostData.data.memory.total * 100;
  const failedTasks = tasksData.total >= 100 ? "99+" : tasksData.total;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "proxmoxbackupserver.datastore_usage",
      value: t("common.percent", {
        value: datastoreUsage
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "proxmoxbackupserver.failed_tasks_24h",
      value: failedTasks
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "proxmoxbackupserver.cpu_usage",
      value: t("common.percent", {
        value: cpuUsage
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "proxmoxbackupserver.memory_usage",
      value: t("common.percent", {
        value: memoryUsage
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;