"use strict";
exports.id = 5834;
exports.ids = [5834];
exports.modules = {

/***/ 201:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getKubeConfig)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function getKubeConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .ZP)("kubernetes.yaml");
  const configFile = path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .CONF_DIR */ .Fn, "kubernetes.yaml");
  const rawConfigData = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configFile, "utf8");
  const configData = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .substituteEnvironmentVars */ .AI)(rawConfigData);
  const config = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(configData);
  const kc = new _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__.KubeConfig();

  switch (config?.mode) {
    case "cluster":
      kc.loadFromCluster();
      break;

    case "default":
      kc.loadFromDefault();
      break;

    case "disabled":
    default:
      return null;
  }

  return kc;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9366:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "S": () => (/* binding */ parseMemory),
/* harmony export */   "t": () => (/* binding */ parseCpu)
/* harmony export */ });
function parseCpu(cpuStr) {
  const unitLength = 1;
  const base = Number.parseInt(cpuStr, 10);
  const units = cpuStr.substring(cpuStr.length - unitLength);

  if (Number.isNaN(Number(units))) {
    switch (units) {
      case "n":
        return base / 1000000000;

      case "u":
        return base / 1000000;

      case "m":
        return base / 1000;

      default:
        return base;
    }
  } else {
    return Number.parseInt(cpuStr, 10);
  }
}
function parseMemory(memStr) {
  const unitLength = memStr.substring(memStr.length - 1) === "i" ? 2 : 1;
  const base = Number.parseInt(memStr, 10);
  const units = memStr.substring(memStr.length - unitLength);

  if (Number.isNaN(Number(units))) {
    switch (units) {
      case "Ki":
        return base * 1000;

      case "K":
        return base * 1024;

      case "Mi":
        return base * 1000000;

      case "M":
        return base * 1024 * 1024;

      case "Gi":
        return base * 1000000000;

      case "G":
        return base * 1024 * 1024 * 1024;

      default:
        return base;
    }
  } else {
    return Number.parseInt(memStr, 10);
  }
}

/***/ })

};
;