"use strict";
exports.id = 7;
exports.ids = [7];
exports.modules = {

/***/ 7:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WeatherApi)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_wi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5744);
/* harmony import */ var react_icons_wi__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_wi__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1299);
/* harmony import */ var _widget_container__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4843);
/* harmony import */ var _widget_primary_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8312);
/* harmony import */ var _widget_secondary_text__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7508);
/* harmony import */ var _widget_widget_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6254);
/* harmony import */ var _widget_container_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2107);
/* harmony import */ var _utils_weather_condition_map__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(9556);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















function Widget({
  options
}) {
  const {
    t,
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/weather?${new URLSearchParams(_objectSpread({
    lang: i18n.language
  }, options)).toString()}`);

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      options: options
    });
  }

  if (!data) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_widget_container__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP, {
      options: options,
      additionalClassNames: "information-widget-weather",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_primary_text__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        children: t("weather.updating")
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_secondary_text__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
        children: t("weather.wait")
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_widget_icon__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
        icon: react_icons_wi__WEBPACK_IMPORTED_MODULE_2__.WiCloudDown,
        size: "l"
      })]
    });
  }

  const unit = options.units === "metric" ? "celsius" : "fahrenheit";
  const condition = data.current.condition.code;
  const timeOfDay = data.current.is_day ? "day" : "night";
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_widget_container__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP, {
    options: options,
    additionalClassNames: "information-widget-weather",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_widget_primary_text__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      children: [options.label && `${options.label}, `, t("common.number", {
        value: options.units === "metric" ? data.current.temp_c : data.current.temp_f,
        style: "unit",
        unit
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_secondary_text__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      children: data.current.condition.text
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_widget_icon__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
      icon: (0,_utils_weather_condition_map__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)(condition, timeOfDay),
      size: "xl"
    })]
  });
}

function WeatherApi({
  options
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
  const {
    0: location,
    1: setLocation
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const {
    0: requesting,
    1: setRequesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);

  if (!location && options.latitude && options.longitude) {
    setLocation({
      latitude: options.latitude,
      longitude: options.longitude
    });
  }

  const requestLocation = () => {
    setRequesting(true);

    if (false) {}
  };

  if (!location) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_widget_container_button__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
      options: options,
      callback: requestLocation,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_primary_text__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        children: t("weather.current")
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_secondary_text__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
        children: t("weather.allow")
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_widget_widget_icon__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
        icon: requesting ? react_icons_md__WEBPACK_IMPORTED_MODULE_3__.MdLocationSearching : react_icons_md__WEBPACK_IMPORTED_MODULE_3__.MdLocationDisabled,
        size: "m",
        pulse: true
      })]
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(Widget, {
    options: _objectSpread(_objectSpread({}, location), options)
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9556:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ mapIcon)
/* harmony export */ });
/* harmony import */ var react_icons_wi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5744);
/* harmony import */ var react_icons_wi__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_icons_wi__WEBPACK_IMPORTED_MODULE_0__);
// Code primarely based on Flame's ConditionMap class
// https://github.com/pawelmalak/flame/blob/master/client/src/components/UI/Icons/WeatherIcon/IconMapping.ts

const conditions = [{
  code: 1000,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySunny,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightClear
  }
}, {
  code: 1003,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayCloudy,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightPartlyCloudy
  }
}, {
  code: 1006,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayCloudy,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightCloudy
  }
}, {
  code: 1009,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayCloudy,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightCloudy
  }
}, {
  code: 1030,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayFog,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightFog
  }
}, {
  code: 1063,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1066,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1069,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRainMix,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRainMix
  }
}, {
  code: 1072,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySleet,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSleet
  }
}, {
  code: 1087,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayThunderstorm,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightThunderstorm
  }
}, {
  code: 1114,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1117,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1135,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayFog,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightFog
  }
}, {
  code: 1147,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayFog,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightFog
  }
}, {
  code: 1150,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1153,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1168,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySleet,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSleet
  }
}, {
  code: 1171,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySleet,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSleet
  }
}, {
  code: 1180,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1183,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1186,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1189,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1192,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1195,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1198,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySleet,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSleet
  }
}, {
  code: 1201,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySleet,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSleet
  }
}, {
  code: 1204,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRainMix,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRainMix
  }
}, {
  code: 1207,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRainMix,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRainMix
  }
}, {
  code: 1210,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1213,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1216,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1219,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1222,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1225,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1237,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayHail,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightHail
  }
}, {
  code: 1240,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1243,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1246,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRain,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRain
  }
}, {
  code: 1249,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRainMix,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRainMix
  }
}, {
  code: 1252,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayRainMix,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightRainMix
  }
}, {
  code: 1255,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1258,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySnow,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightSnow
  }
}, {
  code: 1261,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayHail,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightHail
  }
}, {
  code: 1264,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayHail,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightHail
  }
}, {
  code: 1273,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayThunderstorm,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightThunderstorm
  }
}, {
  code: 1276,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayThunderstorm,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightThunderstorm
  }
}, {
  code: 1279,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayThunderstorm,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightThunderstorm
  }
}, {
  code: 1282,
  icon: {
    day: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDayThunderstorm,
    night: react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiNightThunderstorm
  }
}];
function mapIcon(weatherStatusCode, timeOfDay) {
  const mapping = conditions.find(condition => condition.code === weatherStatusCode);

  if (mapping) {
    if (timeOfDay === "day") {
      return mapping.icon.day;
    }

    if (timeOfDay === "night") {
      return mapping.icon.night;
    }
  }

  return react_icons_wi__WEBPACK_IMPORTED_MODULE_0__.WiDaySunny;
}

/***/ })

};
;