"use strict";
exports.id = 8562;
exports.ids = [8562];
exports.modules = {

/***/ 9967:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "a": () => (/* binding */ addCookieToJar),
/* harmony export */   "w": () => (/* binding */ setCookieHeader)
/* harmony export */ });
/* harmony import */ var tough_cookie__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7976);
/* harmony import */ var tough_cookie__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(tough_cookie__WEBPACK_IMPORTED_MODULE_0__);
/* eslint-disable no-param-reassign */

const cookieJar = new tough_cookie__WEBPACK_IMPORTED_MODULE_0__.CookieJar();
function setCookieHeader(url, params) {
  // add cookie header, if we have one in the jar
  const existingCookie = cookieJar.getCookieStringSync(url.toString());

  if (existingCookie) {
    params.headers = params.headers ?? {};
    params.headers.Cookie = existingCookie;
  }
}
function addCookieToJar(url, headers) {
  let cookieHeader = headers["set-cookie"];

  if (headers instanceof Headers) {
    cookieHeader = headers.get("set-cookie");
  }

  if (!cookieHeader || cookieHeader.length === 0) return;
  let cookies = null;

  if (cookieHeader instanceof Array) {
    cookies = cookieHeader.map(c => {
      const cookie = tough_cookie__WEBPACK_IMPORTED_MODULE_0__.Cookie.parse(c);
      cookie.setMaxAge(60 * 60);
      return cookie;
    });
  } else {
    const cookie = tough_cookie__WEBPACK_IMPORTED_MODULE_0__.Cookie.parse(cookieHeader);
    cookie.setMaxAge(60 * 60);
    cookies = [cookie];
  }

  for (let i = 0; i < cookies.length; i += 1) {
    cookieJar.setCookieSync(cookies[i], url.toString(), {
      ignoreError: true
    });
  }
}

/***/ }),

/***/ 8562:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hC": () => (/* binding */ httpProxy)
/* harmony export */ });
/* unused harmony exports httpsRequest, httpRequest */
/* harmony import */ var node_zlib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5628);
/* harmony import */ var node_zlib__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_zlib__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var follow_redirects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6953);
/* harmony import */ var follow_redirects__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(follow_redirects__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _cookie_jar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9967);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_logger__WEBPACK_IMPORTED_MODULE_3__]);
utils_logger__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable prefer-promise-reject-errors */

/* eslint-disable no-param-reassign */




const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)("httpProxy");

function addCookieHandler(url, params) {
  (0,_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .setCookieHeader */ .w)(url, params); // handle cookies during redirects

  params.beforeRedirect = (options, responseInfo) => {
    (0,_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .addCookieToJar */ .a)(options.href, responseInfo.headers);
    (0,_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .setCookieHeader */ .w)(options.href, options);
  };
}

function handleRequest(requestor, url, params) {
  return new Promise((resolve, reject) => {
    addCookieHandler(url, params);

    if (params?.body) {
      params.headers = params.headers ?? {};
      params.headers["content-length"] = Buffer.byteLength(params.body);
    }

    const request = requestor.request(url, params, response => {
      const data = [];
      const contentEncoding = response.headers["content-encoding"]?.trim().toLowerCase();
      let responseContent = response;

      if (contentEncoding === "gzip" || contentEncoding === "deflate") {
        // https://github.com/request/request/blob/3c0cddc7c8eb60b470e9519da85896ed7ee0081e/request.js#L1018-L1025
        // Be more lenient with decoding compressed responses, in case of invalid gzip responses that are still accepted
        // by common browsers.
        responseContent = (0,node_zlib__WEBPACK_IMPORTED_MODULE_0__.createUnzip)({
          flush: node_zlib__WEBPACK_IMPORTED_MODULE_0__.constants.Z_SYNC_FLUSH,
          finishFlush: node_zlib__WEBPACK_IMPORTED_MODULE_0__.constants.Z_SYNC_FLUSH
        }); // zlib errors

        responseContent.on("error", e => {
          logger.error(e);
          responseContent = response; // fallback
        });
        response.pipe(responseContent);
      }

      responseContent.on("data", chunk => {
        data.push(chunk);
      });
      responseContent.on("end", () => {
        (0,_cookie_jar__WEBPACK_IMPORTED_MODULE_2__/* .addCookieToJar */ .a)(url, response.headers);
        resolve([response.statusCode, response.headers["content-type"], Buffer.concat(data), response.headers]);
      });
    });
    request.on("error", error => {
      reject([500, error]);
    });

    if (params?.body) {
      request.write(params.body);
    }

    request.end();
  });
}

function httpsRequest(url, params) {
  return handleRequest(follow_redirects__WEBPACK_IMPORTED_MODULE_1__.https, url, params);
}
function httpRequest(url, params) {
  return handleRequest(follow_redirects__WEBPACK_IMPORTED_MODULE_1__.http, url, params);
}
async function httpProxy(url, params = {}) {
  const constructedUrl = new URL(url);
  let request = null;

  if (constructedUrl.protocol === "https:") {
    request = httpsRequest(constructedUrl, _objectSpread({
      agent: new follow_redirects__WEBPACK_IMPORTED_MODULE_1__.https.Agent({
        rejectUnauthorized: false,
        autoSelectFamily: true
      })
    }, params));
  } else {
    request = httpRequest(constructedUrl, _objectSpread({
      agent: new follow_redirects__WEBPACK_IMPORTED_MODULE_1__.http.Agent({
        autoSelectFamily: true
      })
    }, params));
  }

  try {
    const [status, contentType, data, responseHeaders] = await request;
    return [status, contentType, data, responseHeaders];
  } catch (err) {
    logger.error("Error calling %s//%s%s%s...", constructedUrl.protocol, constructedUrl.hostname, constructedUrl.port ? `:${constructedUrl.port}` : "", constructedUrl.pathname);
    logger.error(err);
    return [500, "application/json", {
      error: {
        message: err?.message ?? "Unknown error",
        url,
        rawError: err
      }
    }, null];
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;