"use strict";
(() => {
var exports = {};
exports.id = 3762;
exports.ids = [3762];
exports.modules = {

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 6113:
/***/ ((module) => {

module.exports = require("crypto");

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 6648:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6113);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_config__WEBPACK_IMPORTED_MODULE_3__]);
utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const configs = ["docker.yaml", "settings.yaml", "services.yaml", "bookmarks.yaml", "widgets.yaml", "custom.css", "custom.js"];

function hash(buffer) {
  const hashSum = (0,crypto__WEBPACK_IMPORTED_MODULE_1__.createHash)("sha256");
  hashSum.update(buffer);
  return hashSum.digest("hex");
}

async function handler(req, res) {
  const hashes = configs.map(config => {
    (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)(config);
    const configYaml = (0,path__WEBPACK_IMPORTED_MODULE_0__.join)(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, config);
    return hash((0,fs__WEBPACK_IMPORTED_MODULE_2__.readFileSync)(configYaml, "utf8"));
  }); // set to date by docker entrypoint, will force revalidation between restarts/recreates

  const buildTime = process.env.HOMEPAGE_BUILDTIME?.length ? process.env.HOMEPAGE_BUILDTIME : "";
  const combinedHash = hash(hashes.join("") + buildTime);
  res.send({
    hash: combinedHash
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732], () => (__webpack_exec__(6648)));
module.exports = __webpack_exports__;

})();