"use strict";
(() => {
var exports = {};
exports.id = 456;
exports.ids = [456];
exports.modules = {

/***/ 276:
/***/ ((module) => {

module.exports = require("@kubernetes/client-node");

/***/ }),

/***/ 4856:
/***/ ((module) => {

module.exports = require("dockerode");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 9755:
/***/ ((module) => {

module.exports = require("ping");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 3987:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var ping__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9755);
/* harmony import */ var ping__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(ping__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("ping");
async function handler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceItem = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* .getServiceItem */ .FM)(group, service);

  if (!serviceItem) {
    logger.debug(`No service item found for group ${group} named ${service}`);
    return res.status(400).send({
      error: "Unable to find service, see log for details."
    });
  }

  const {
    ping: pingHostOrURL
  } = serviceItem;

  if (!pingHostOrURL) {
    logger.debug("No ping host specified");
    return res.status(400).send({
      error: "No ping host given"
    });
  }

  let hostname = pingHostOrURL;

  try {
    // maintain backwards compatibility with old ping where may be http://...
    hostname = new URL(pingHostOrURL).hostname;
  } catch (e) {// eslint-disable-line no-empty
  }

  try {
    const response = await ping__WEBPACK_IMPORTED_MODULE_0__.promise.probe(hostname);
    return res.status(200).json(response);
  } catch (e) {
    logger.debug("Error attempting ping: %s", e);
    return res.status(400).send({
      error: "Error attempting ping, see logs."
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,2156,7765], () => (__webpack_exec__(3987)));
module.exports = __webpack_exports__;

})();