import * as Icons from "react-icons/wi";

const conditions = [
  {
    code: 200,
    icon: {
      day: Icons.WiDayStormShowers,
      night: Icons.WiNightAltStormShowers,
    },
  },
  {
    code: 201,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },
  {
    code: 202,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },
  {
    code: 210,
    icon: {
      day: Icons.WiDayStormShowers,
      night: Icons.WiNightAltStormShowers,
    },
  },
  {
    code: 211,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },
  {
    code: 212,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },
  {
    code: 221,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },
  {
    code: 230,
    icon: {
      day: Icons.WiDayStormShowers,
      night: Icons.WiNightAltStormShowers,
    },
  },
  {
    code: 231,
    icon: {
      day: Icons.WiDayStormShowers,
      night: Icons.WiNightAltStormShowers,
    },
  },
  {
    code: 232,
    icon: {
      day: Icons.WiDayThunderstorm,
      night: Icons.WiNightAltThunderstorm,
    },
  },

  {
    code: 300,
    icon: {
      day: Icons.WiDaySprinkle,
      night: Icons.WiNightAltSprinkle,
    },
  },
  {
    code: 301,
    icon: {
      day: Icons.WiDaySprinkle,
      night: Icons.WiNightAltSprinkle,
    },
  },
  {
    code: 302,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 310,
    icon: {
      day: Icons.WiDaySprinkle,
      night: Icons.WiNightAltSprinkle,
    },
  },
  {
    code: 311,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 312,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 313,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },
  {
    code: 314,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },
  {
    code: 321,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },

  {
    code: 500,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 501,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 502,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 503,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 504,
    icon: {
      day: Icons.WiDayRain,
      night: Icons.WiNightAltRain,
    },
  },
  {
    code: 511,
    icon: {
      day: Icons.WiDaySleet,
      night: Icons.WiNightAltSleet,
    },
  },
  {
    code: 520,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },
  {
    code: 521,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },
  {
    code: 522,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },
  {
    code: 531,
    icon: {
      day: Icons.WiDayShowers,
      night: Icons.WiNightAltShowers,
    },
  },

  {
    code: 600,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },
  {
    code: 601,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },
  {
    code: 602,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },
  {
    code: 611,
    icon: {
      day: Icons.WiDaySleet,
      night: Icons.WiNightAltSleet,
    },
  },
  {
    code: 612,
    icon: {
      day: Icons.WiDaySleet,
      night: Icons.WiNightAltSleet,
    },
  },
  {
    code: 613,
    icon: {
      day: Icons.WiDaySleet,
      night: Icons.WiNightAltSleet,
    },
  },
  {
    code: 615,
    icon: {
      day: Icons.WiDayRainMix,
      night: Icons.WiNightAltRainMix,
    },
  },
  {
    code: 616,
    icon: {
      day: Icons.WiDayRainMix,
      night: Icons.WiNightAltRainMix,
    },
  },
  {
    code: 620,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },
  {
    code: 621,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },
  {
    code: 622,
    icon: {
      day: Icons.WiDaySnow,
      night: Icons.WiNightAltSnow,
    },
  },

  {
    code: 701,
    icon: {
      day: Icons.WiDayFog,
      night: Icons.WiNightFog,
    },
  },
  {
    code: 711,
    icon: {
      day: Icons.WiSmoke,
      night: Icons.WiSmoke,
    },
  },
  {
    code: 721,
    icon: {
      day: Icons.WiDayHaze,
      night: Icons.WiWindy,
    },
  },
  {
    code: 731,
    icon: {
      day: Icons.WiDust,
      night: Icons.WiDust,
    },
  },
  {
    code: 741,
    icon: {
      day: Icons.WiDayFog,
      night: Icons.WiNightFog,
    },
  },
  {
    code: 751,
    icon: {
      day: Icons.WiDust,
      night: Icons.WiDust,
    },
  },
  {
    code: 761,
    icon: {
      day: Icons.WiSandstorm,
      night: Icons.WiSandstorm,
    },
  },
  {
    code: 762,
    icon: {
      day: Icons.WiDust,
      night: Icons.WiDust,
    },
  },
  {
    code: 771,
    icon: {
      day: Icons.WiStrongWind,
      night: Icons.WiStrongWind,
    },
  },

  {
    code: 781,
    icon: {
      day: Icons.WiTornado,
      night: Icons.WiTornado,
    },
  },

  {
    code: 800,
    icon: {
      day: Icons.WiDaySunny,
      night: Icons.WiNightClear,
    },
  },

  {
    code: 801,
    icon: {
      day: Icons.WiDayCloudy,
      night: Icons.WiNightAltCloudy,
    },
  },
  {
    code: 802,
    icon: {
      day: Icons.WiDayCloudy,
      night: Icons.WiNightAltCloudy,
    },
  },
  {
    code: 803,
    icon: {
      day: Icons.WiDayCloudy,
      night: Icons.WiNightAltCloudy,
    },
  },
  {
    code: 804,
    icon: {
      day: Icons.WiCloudy,
      night: Icons.WiCloudy,
    },
  },
];

export default function mapIcon(weatherStatusCode, timeOfDay) {
  const mapping = conditions.find((condition) => condition.code === weatherStatusCode);

  if (mapping) {
    if (timeOfDay === "day") {
      return mapping.icon.day;
    }

    if (timeOfDay === "night") {
      return mapping.icon.night;
    }
  }

  return Icons.WiDaySunny;
}
