/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ChoiceDialog;
import common.BASEPACKET;
import common.GET_INFO;
import common.INFO;
import common.MESSAGE;
import connection.Connection;
import connection.ConnectionHandler;
import connection.ObjectPacket;
import connection.Packet;
import connection.SocketAddress;
import connection.TCPConnection;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;

class Main
implements Runnable,
ConnectionHandler,
ActionListener {
    private SocketAddress addr;
    private long endTime;
    private Frame frame;
    private Button bLogout;
    private Thread thread;
    private boolean toRun = false;
    private TCPConnection tcpc;

    public static void main(String[] args) throws Exception {
        new Main(args);
    }

    private final void print(String msg) {
        System.out.println("[MAIN] " + msg);
    }

    private final String diffToTime(long diff) {
        boolean minus = diff < 0L;
        diff = Math.abs(diff + 500L) / 1000L;
        int hours = (int)(diff / 3600L);
        int mins = (int)(diff % 3600L / 60L);
        int secs = (int)(diff % 60L);
        return (minus ? "-" : "") + hours + ":" + (mins < 10 ? "0" : "") + mins + ":" + (secs < 10 ? "0" : "") + secs;
    }

    private final void updateFrame() {
        String sTime = this.endTime == 0L ? "--:--:--" : this.diffToTime(Math.max(0L, this.endTime - System.currentTimeMillis()));
        this.frame.setTitle(sTime);
        this.frame.invalidate();
        this.frame.validate();
        this.frame.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.print(e.toString());
        if (e.getSource() == this.bLogout && new ChoiceDialog(this.frame, "Figyelmeztet\u00e9s", "Biztos, hogy kil\u00e9p?", "Igen", "M\u00e9gsem").getChoice() == 1) {
            this.logout();
        }
    }

    public void onConnectionData(Connection conn, Packet packet) {
        if (packet instanceof ObjectPacket) {
            BASEPACKET p = (BASEPACKET)((ObjectPacket)packet).getObject();
            this.print("-> " + p);
            if (p instanceof INFO) {
                INFO info = (INFO)p;
                if (!info.isEnabled) {
                    this.logout();
                }
                this.endTime = System.currentTimeMillis() + info.timeLeft;
            } else if (p instanceof MESSAGE) {
                MESSAGE message = (MESSAGE)p;
                new ChoiceDialog(this.frame, "\u00dczenet az oper\u00e1tort\u00f3l", message.message, "OK", null).getChoice();
            }
        }
    }

    public void onConnectionBroken(Connection conn, IOException ioe) {
        this.print("A kapcsolat megszakadt: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        this.tcpc = null;
        if (this.endTime == 0L) {
            this.logout();
        }
    }

    public void onConnectionClosed(Connection conn) {
        this.print("A kapcsolat lez\u00e1rva");
        this.tcpc = null;
    }

    private final void logout() {
        try {
            this.print("Logout...");
            Process p = Runtime.getRuntime().exec("kilep");
            this.print("Parancs futtat\u00e1sa...");
            p.waitFor();
            this.print("Eredm\u00e9ny: " + p.exitValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private final boolean send(BASEPACKET packet) {
        if (this.tcpc != null) {
            this.print("<- " + packet);
            return this.tcpc.send(new ObjectPacket(packet));
        }
        return false;
    }

    public void run() {
        this.print("A sz\u00e1l elindult");
        try {
            while (this.toRun) {
                block6: {
                    Thread.sleep(1000L);
                    if (this.tcpc == null) {
                        try {
                            this.tcpc = new TCPConnection(this.addr, (Packet)new ObjectPacket(), (ConnectionHandler)this);
                            this.tcpc.start();
                            this.send(new GET_INFO());
                        }
                        catch (IOException ioe) {
                            this.tcpc = null;
                            if (this.endTime != 0L) break block6;
                            this.logout();
                        }
                    }
                }
                this.updateFrame();
            }
        }
        catch (Exception e) {
            this.print(e.getMessage());
            e.printStackTrace();
        }
        this.print("A sz\u00e1l le\u00e1llt");
    }

    Main(String[] args) throws Exception {
        InetAddress serverAddr = InetAddress.getByName(args[0]);
        int serverPort = Integer.parseInt(args[1]);
        this.addr = new SocketAddress(serverAddr, serverPort);
        this.frame = new Frame();
        this.frame.setLayout(new BorderLayout());
        this.bLogout = new Button("    Kil\u00e9p\u00e9s    ");
        this.bLogout.addActionListener(this);
        Panel pUpper = new Panel();
        pUpper.setLayout(new FlowLayout(1, 5, 5));
        pUpper.add(this.bLogout);
        this.frame.add((Component)pUpper, "North");
        this.updateFrame();
        this.frame.pack();
        this.frame.show();
        this.toRun = true;
        this.thread = new Thread((Runnable)this, "Main");
        this.thread.start();
    }
}

