/*
 * Decompiled with CFR 0.152.
 */
package connection;

import connection.ConnectionHandler;
import connection.Packet;
import connection.SocketAddress;
import connection.Traffic;
import connection.TrafficCounter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import util.Queue;

public abstract class Connection
implements TrafficCounter {
    static Packet PING = new PingPacket();
    SocketAddress localAddr;
    SocketAddress remoteAddr;
    Packet packetType;
    ConnectionHandler connHandler;
    boolean isClosed;
    Sender senderThread;
    Receiver receiverThread;
    private long pingFreq;
    private long pingTimeout;
    Traffic traffic;
    Object closingMonitor = new Object();

    public void setPing(long pingFreq, long pingTimeout) {
        this.pingFreq = pingFreq;
        this.pingTimeout = pingTimeout;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddr;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public void start() {
        this.traffic = new Traffic();
        this.senderThread = new Sender();
        this.receiverThread = new Receiver();
        this.isClosed = false;
        this.receiverThread.start();
        this.senderThread.start();
    }

    void stop() {
        this.senderThread.stop();
        this.receiverThread.stop();
    }

    public void setPriority(int priority) {
        this.receiverThread.setPriority(priority);
        this.senderThread.setPriority(priority);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean send(Packet packet) {
        if (!this.isClosed) {
            this.senderThread.put(packet);
            return true;
        }
        return false;
    }

    public void flush() {
        if (!this.isClosed) {
            this.senderThread.flush();
        }
    }

    abstract void closeConnection() throws IOException;

    void close(boolean isBroken, IOException ioe) {
        Object object = this.closingMonitor;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosed = true;
                try {
                    this.closeConnection();
                }
                catch (IOException tm) {
                    // empty catch block
                }
                this.stop();
                if (isBroken) {
                    this.connHandler.onConnectionBroken(this, ioe);
                } else {
                    this.connHandler.onConnectionClosed(this);
                }
            }
        }
    }

    public void close() {
        Object object = this.closingMonitor;
        synchronized (object) {
            this.close(false, null);
        }
    }

    public Traffic getTraffic() {
        return new Traffic(this.traffic);
    }

    abstract boolean sendPacket(Packet var1) throws IOException;

    abstract Packet receivePacket() throws IOException;

    static /* synthetic */ long access$1(Connection connection) {
        return connection.pingTimeout;
    }

    Connection(Packet packetType, ConnectionHandler connHandler) {
        this.packetType = packetType;
        this.connHandler = connHandler;
        this.setPing(0L, 0L);
    }

    private class Sender
    implements Runnable {
        Queue queue = new Queue(100, 100);
        Thread thread;
        boolean toRun;

        void start() {
            this.thread = new Thread((Runnable)this, Connection.this.toString() + " Sender");
            this.toRun = true;
            this.thread.start();
        }

        void stop() {
            this.toRun = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        void setPriority(int priority) {
            this.thread.setPriority(priority);
        }

        synchronized void put(Packet packet) {
            this.queue.push(packet);
        }

        synchronized void flush() {
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.queue.isEmpty() && !Connection.this.isClosed());
        }

        public void run() {
            try {
                while (this.toRun) {
                    Packet packet = (Packet)this.queue.pop(Connection.this.pingFreq);
                    if (this.toRun) {
                        if (packet == null) {
                            packet = PING;
                        }
                        if (Connection.this.sendPacket(packet)) {
                            Thread.yield();
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                Connection.this.close(true, ioe);
            }
            this.queue.empty();
        }

        Sender() {
        }
    }

    private class Receiver
    implements Runnable {
        Queue queue = new Queue(100, 100);
        Thread thread1;
        Thread thread2;
        boolean toRun;

        void start() {
            this.thread1 = new Thread(this, Connection.this.toString() + " Receiver - Queue handler"){
                private final /* synthetic */ Receiver this$0;
                private final /* synthetic */ Connection this$1;

                public final void run() {
                    try {
                        while (this.this$0.toRun) {
                            Packet packet = (Packet)this.this$0.queue.pop(Connection.access$1(this.this$1));
                            if (this.this$0.toRun) {
                                if (packet == null) {
                                    throw new IOException("ping timeout (" + Connection.access$1(this.this$1) + ")");
                                }
                                if (packet != PING && this.this$1.connHandler != null) {
                                    this.this$1.connHandler.onConnectionData(this.this$1, packet);
                                }
                                Thread.yield();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        this.this$1.close(true, ioe);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.this$1 = Receiver.access$0(this.this$0);
                    this.constructor$0(this$0, $1);
                }

                private final void constructor$0(Receiver receiver, String $1) {
                }
            };
            this.thread2 = new Thread((Runnable)this, Connection.this.toString() + " Receiver - IO handler");
            this.toRun = true;
            this.thread1.start();
            this.thread2.start();
        }

        void stop() {
            this.toRun = false;
            if (this.thread1 != null) {
                this.thread1.interrupt();
            }
            if (this.thread2 != null) {
                this.thread2.interrupt();
            }
        }

        void setPriority(int priority) {
            this.thread1.setPriority(priority);
            this.thread2.setPriority(priority);
        }

        public void run() {
            try {
                while (this.toRun) {
                    Packet packet = Connection.this.receivePacket();
                    this.queue.push(packet);
                    Thread.yield();
                }
            }
            catch (IOException ioe) {
                do {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.queue.isEmpty() && !Connection.this.isClosed());
                Connection.this.close(true, ioe);
            }
        }

        static /* synthetic */ Connection access$0(Receiver receiver) {
            return receiver.Connection.this;
        }

        Receiver() {
        }
    }

    static class PingPacket
    extends Packet {
        public void write(OutputStream out) throws IOException {
            throw new RuntimeException("illegal method call, method not implemented");
        }

        public Packet read(InputStream in) throws IOException {
            throw new RuntimeException("illegal method call, method not implemented");
        }

        PingPacket() {
        }
    }
}

