/*
 * Decompiled with CFR 0.152.
 */
package connection;

import connection.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectPacket
extends Packet {
    byte[] value;

    public Serializable getObject() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (Serializable)ois.readObject();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
            return null;
        }
    }

    public void write(OutputStream out) throws IOException {
        out.write(111);
        int len = this.value.length;
        out.write(len >>> 24 & 0xFF);
        out.write(len >>> 16 & 0xFF);
        out.write(len >>> 8 & 0xFF);
        out.write(len & 0xFF);
        out.write(this.value);
    }

    public Packet read(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ptype = in.read();
        if (ptype == -1) {
            throw new EOFException();
        }
        if (ptype != 111) {
            throw new IOException("illegal packet type");
        }
        ObjectPacket packet = new ObjectPacket();
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        int len = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        packet.value = new byte[len];
        int read = 0;
        while (read < len) {
            int inbytes = in.read(packet.value, read, len - read);
            if (inbytes == -1) {
                throw new EOFException();
            }
            read += inbytes;
        }
        return packet;
    }

    public String toString() {
        return "ObjectPacket[" + this.getObject() + "]";
    }

    public ObjectPacket(Serializable object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter can't be null!");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            this.value = baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    public ObjectPacket() {
    }
}

