/*
 * Decompiled with CFR 0.152.
 */
package connection;

import connection.Connection;
import connection.ConnectionHandler;
import connection.Packet;
import connection.SocketAddress;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class TCPConnection
extends Connection {
    static final boolean DEBUG = false;
    static final boolean TRAFFICLOG = false;
    static final int ACK_COUNT = 500;
    static final long ACK_TIMEOUT = 10000L;
    static final int TL_NONE = 0;
    static final int TL_INPUT = 1;
    static final int TL_OUTPUT = 2;
    Socket socket;
    InputStream in;
    OutputStream out;
    int packetCount;
    Object ACKMonitor = new Object();
    boolean ACKCome;
    boolean rawMode;
    PrintStream trafficLog;
    int trafficLogMode;
    Object sendMonitor = new Object();
    private int rCounter = 0;
    private int sCounter = 0;

    void tlog(String msg) {
    }

    void tlog(Exception e) {
    }

    void tlog(int b, int mode) {
    }

    boolean sendPacket(Packet packet) throws IOException {
        Object object;
        if (packet == Connection.PING) {
            this.out.write(35);
            this.out.flush();
            return true;
        }
        if (this.rawMode) {
            packet.write(this.out);
            this.out.flush();
            return true;
        }
        if (--this.packetCount <= 0) {
            object = this.ACKMonitor;
            synchronized (object) {
                this.packetCount = 500;
                this.out.write(65);
                this.out.flush();
                this.ACKCome = false;
                try {
                    this.ACKMonitor.wait(10000L);
                }
                catch (InterruptedException ie) {
                    return false;
                }
                if (!this.ACKCome) {
                    throw new IOException("Couldn't get ACK from other side in 10 seconds!");
                }
            }
        }
        object = this.sendMonitor;
        synchronized (object) {
            this.out.write(80);
            packet.write(this.out);
            this.out.flush();
            return true;
        }
    }

    Packet receivePacket() throws IOException {
        if (!this.rawMode) {
            int b;
            do {
                Object object;
                if ((b = this.in.read()) == 35) {
                    return Connection.PING;
                }
                if (b == 65) {
                    object = this.sendMonitor;
                    synchronized (object) {
                        this.out.write(79);
                        this.out.flush();
                    }
                } else if (b == 79) {
                    object = this.ACKMonitor;
                    synchronized (object) {
                        this.ACKCome = true;
                        this.ACKMonitor.notify();
                    }
                } else {
                    if (b != -1) continue;
                    throw new EOFException();
                }
            } while (b != 80);
        }
        Packet packet = this.packetType.read(this.in);
        packet.setAddress(this.getRemoteAddress());
        return packet;
    }

    void closeConnection() throws IOException {
        this.socket.close();
    }

    public void setRawMode(boolean rawMode) {
        this.rawMode = rawMode;
    }

    public String toString() {
        return "TCPConnection[" + this.getLocalAddress() + " <-> " + this.getRemoteAddress() + "]";
    }

    public TCPConnection(SocketAddress sockAddr, Packet packetType, ConnectionHandler connHandler) throws IOException {
        this(sockAddr, null, packetType, connHandler);
    }

    public TCPConnection(SocketAddress sockAddr, InetAddress bindAddr, Packet packetType, ConnectionHandler connHandler) throws IOException {
        this(new Socket(sockAddr.getInetAddress(), sockAddr.getPort(), bindAddr, 0), packetType, connHandler);
    }

    public TCPConnection(Socket socket, Packet packetType, ConnectionHandler connHandler) {
        super(packetType, connHandler);
        this.setPing(5000L, 8000L);
        this.socket = socket;
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (SocketException se) {
            // empty catch block
        }
        try {
            this.in = new InputTrafficCounter(socket.getInputStream());
            this.out = new OutputTrafficCounter(socket.getOutputStream());
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.packetCount = 500;
        this.localAddr = new SocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
        this.remoteAddr = new SocketAddress(this.socket.getInetAddress(), this.socket.getPort());
        this.rawMode = false;
    }

    private class InputTrafficCounter
    extends InputStream {
        private InputStream in;

        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                ++TCPConnection.this.traffic.input;
            }
            return b;
        }

        public int read(byte[] b) throws IOException {
            int count = this.in.read(b);
            if (count != -1) {
                TCPConnection.this.traffic.input += (long)count;
            }
            return count;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.in.read(b, off, len);
            if (count != -1) {
                TCPConnection.this.traffic.input += (long)count;
            }
            return count;
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        public void reset() throws IOException {
            this.in.reset();
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        InputTrafficCounter(InputStream in) {
            this.in = in;
        }
    }

    private class OutputTrafficCounter
    extends OutputStream {
        private OutputStream out;

        public void write(int b) throws IOException {
            this.out.write(b);
            ++TCPConnection.this.traffic.output;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
            TCPConnection.this.traffic.output += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            TCPConnection.this.traffic.output += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }

        OutputTrafficCounter(OutputStream out) {
            this.out = out;
        }
    }
}

