/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DCheckbox;
import dog.gui.DCheckboxGroup;
import dog.gui.DColor;
import dog.gui.DComponent;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.StringTokenizer;

public class DButton
extends DCheckbox {
    public static final int LEFT = 4;
    public static final int RIGHT = 2;
    protected boolean sticky = false;
    protected boolean focus = false;
    protected Image icon;
    transient Dimension minimumSize;
    transient Dimension preferredSize;
    private Color myForeground = null;

    public void setForeground(Color c) {
        this.myForeground = c;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        if (this.sticky != sticky) {
            boolean old = this.sticky;
            if (this.value && !sticky) {
                this.setValue(false);
            }
            this.sticky = sticky;
            this.changes.firePropertyChange("sticky", new Boolean(old), new Boolean(sticky));
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        if (icon != null) {
            Image old = this.icon;
            if ((icon = DComponent.getImage(icon, (ImageObserver)this)) != null) {
                this.invalidate();
                Container parent = this.getParent();
                if (parent != null) {
                    parent.validate();
                    parent.repaint();
                }
                this.changes.firePropertyChange("icon", old, icon);
            }
        }
    }

    public void setIcon(String file) {
        if (file != null) {
            Image old = this.icon;
            this.icon = DComponent.getImage(file, (ImageObserver)this);
            if (this.icon != null) {
                this.invalidate();
                Container parent = this.getParent();
                if (parent != null) {
                    parent.validate();
                    parent.repaint();
                }
                this.changes.firePropertyChange("icon", old, this.icon);
            }
        }
    }

    public void setIcon(URL url) {
        if (url != null) {
            Image old = this.icon;
            this.icon = DComponent.getImage(url, (ImageObserver)this);
            if (this.icon != null) {
                this.invalidate();
                Container parent = this.getParent();
                if (parent != null) {
                    parent.validate();
                    parent.repaint();
                }
                this.changes.firePropertyChange("icon", old, this.icon);
            }
        }
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        if (align != 4 && align != 0 && align != 2) {
            throw new IllegalArgumentException("illegal alignment value" + align);
        }
        if (this.align != align) {
            int old = this.align;
            this.align = align;
            this.repaint();
            this.changes.firePropertyChange("align", new Integer(old), new Integer(align));
        }
    }

    public boolean isDefault() {
        DRootPane root = this.getRootPane();
        if (root != null) {
            return this.equals(root.getDefaultButton());
        }
        return false;
    }

    public void setDefault(boolean flag) {
        DRootPane root = this.getRootPane();
        if (root != null) {
            if (flag) {
                root.setDefaultButton(this);
            } else {
                root.setDefaultButton(null);
            }
        }
    }

    public boolean isCancel() {
        DRootPane root = this.getRootPane();
        if (root != null) {
            return this.equals(root.getCancelButton());
        }
        return false;
    }

    public void setCancel(boolean flag) {
        DRootPane root = this.getRootPane();
        if (root != null) {
            if (flag) {
                root.setCancelButton(this);
            } else {
                root.setCancelButton(null);
            }
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.repaint();
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
        if ((flags & 0x20) != 0) {
            this.icon = image;
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                parent.validate();
                parent.repaint();
            }
            return false;
        }
        return (flags & 0x40) == 0;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.isValid() && this.preferredSize != null) {
            return this.preferredSize;
        }
        DTheme theme = this.myTheme;
        Font font = theme.getFont("BUTTON");
        FontMetrics fm = this.getFontMetrics(font);
        int rh = fm.getHeight();
        int min = Math.min(16, rh);
        Dimension ps = new Dimension(0, min);
        if (this.label != null) {
            int rows = 0;
            StringTokenizer st = new StringTokenizer(this.label, "\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                ps.width = Math.max(ps.width, fm.stringWidth(token));
                ++rows;
            }
            ps.height = rh * rows;
        } else {
            ps.width = ps.height;
        }
        if (this.icon != null) {
            Dimension is = new Dimension(this.icon.getWidth(this), this.icon.getHeight(this));
            ps.width = Math.max(ps.width, this.label != null ? ps.width + (is.width + 3) : is.width);
            ps.height = Math.max(ps.height, is.height);
        }
        ps.width += 8;
        ps.height += 6;
        ps.width += 4;
        ps.height += 4;
        this.preferredSize = ps;
        return this.preferredSize;
    }

    protected Dimension getPreferredIconSize(Rectangle bounds) {
        Dimension pis = new Dimension(0, 0);
        if (this.icon != null) {
            double scale;
            pis = new Dimension(this.icon.getWidth(this), this.icon.getHeight(this));
            if (pis.width > bounds.width) {
                scale = (double)bounds.width / (double)pis.width;
                pis.width = (int)((double)pis.width * scale);
                pis.height = (int)((double)pis.height * scale);
            }
            if (pis.height > bounds.height) {
                scale = (double)bounds.height / (double)pis.height;
                pis.width = (int)((double)pis.width * scale);
                pis.height = (int)((double)pis.height * scale);
            }
        }
        return pis;
    }

    protected Dimension getPreferredLabelSize(FontMetrics fm) {
        Dimension pls = new Dimension(0, 0);
        if (this.label != null) {
            int tw;
            int offset = 0;
            int rows = 1;
            int index = this.label.indexOf(10);
            while (index > -1) {
                String token = this.label.substring(offset, index);
                tw = fm.stringWidth(token);
                pls.width = tw > pls.width ? tw : pls.width;
                ++rows;
                offset = index + 1;
                index = this.label.indexOf(10, offset);
            }
            tw = fm.stringWidth(this.label.substring(offset, this.label.length()));
            pls.width = tw > pls.width ? tw : pls.width;
            pls.height = rows * fm.getHeight();
        }
        return pls;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        DTheme theme = this.myTheme;
        boolean ficon = this.icon != null;
        boolean flabel = this.label != null;
        boolean enabled = this.isEnabled();
        boolean pressed = this.down || this.sticky && this.value;
        Font font = theme.getFont("BUTTON");
        FontMetrics fm = this.getFontMetrics(font);
        Color text = theme.getColor(this.isDefault() ? "BUTTON_DEFAULT_TEXT" : "BUTTON_TEXT");
        Color background = theme.getColor("BUTTON_BACKGROUND");
        Color border = theme.getColor("BUTTON_BORDER");
        if (!enabled) {
            text = DColor.toGray(text);
            background = DColor.darker(DColor.toGray(background));
            border = DColor.darker(DColor.toGray(border));
        } else if (this.focus) {
            border = theme.getColor("BUTTON_FOCUS_BORDER");
        }
        Rectangle clip = g.getClipBounds();
        Rectangle r = new Rectangle(0, 0, size.width, size.height);
        this.drawButton(g, r, background, border, pressed);
        g.setClip(r.intersection(clip));
        Dimension is = this.getPreferredIconSize(r);
        Dimension ls = this.getPreferredLabelSize(fm);
        int maxlwidth = r.width - (ficon ? is.width + 3 : 0);
        Rectangle lr = new Rectangle(r.x, r.y, maxlwidth < ls.width ? maxlwidth : ls.width, ls.height);
        switch (this.align) {
            case 4: {
                lr.x = r.x + (ficon ? is.width + 3 : 0);
                break;
            }
            case 2: {
                lr.x = r.x + r.width - (ficon ? is.width + 3 : 0) - lr.width;
                break;
            }
            default: {
                lr.x = r.x + (r.width - (is.width + lr.width)) / 2 + (ficon ? is.width + 3 : 0);
                break;
            }
        }
        lr.y = r.y + (r.height - lr.height) / 2;
        if (ficon && is.width > -1 && is.height > -1) {
            Rectangle ir = new Rectangle(r.x, r.y, is.width, is.height);
            switch (this.align) {
                case 4: {
                    break;
                }
                case 2: {
                    ir.x = r.x + r.width - ir.width;
                    break;
                }
                default: {
                    ir.x = r.x + (r.width - (ir.width + (flabel ? lr.width + 3 : 0))) / 2;
                    break;
                }
            }
            ir.y = r.y + (r.height - ir.height) / 2;
            g.drawImage(this.icon, ir.x, ir.y, ir.width, ir.height, this);
        }
        if (flabel) {
            g.setFont(font);
            DComponent.drawLabel(g, lr, fm, this.label, this.align, text);
        }
        if (this.focus) {
            DComponent.drawFocusBorder(g, r, text);
        }
    }

    protected void drawButton(Graphics g, Rectangle r, Color background, Color border, boolean pressed) {
        Color bottomRight3;
        Color bottomRight2;
        Color bottomRight1;
        Color topLeft3;
        Color topLeft2;
        Color topLeft1;
        g.setColor(pressed ? DColor.darker(background) : background);
        g.fillRect(r.x, r.y, r.width, r.height);
        if (!pressed) {
            topLeft1 = border;
            topLeft2 = DColor.brighter(topLeft1);
            topLeft3 = DColor.brighter(topLeft2);
            bottomRight1 = border;
            bottomRight2 = DColor.darker(bottomRight1);
            Color color = DColor.darker(bottomRight2);
        } else {
            topLeft3 = border;
            topLeft2 = DColor.darker(topLeft3);
            topLeft1 = DColor.darker(topLeft2);
            bottomRight1 = border;
            bottomRight2 = DColor.brighter(bottomRight1);
            bottomRight3 = DColor.brighter(bottomRight2);
        }
        g.setColor(topLeft1);
        g.drawLine(2, 2, r.width - 3, 2);
        g.drawLine(2, 2, 2, r.height - 3);
        g.setColor(topLeft2);
        g.drawLine(1, 1, r.width - 2, 1);
        g.drawLine(1, 1, 1, r.height - 2);
        g.setColor(topLeft3);
        g.drawLine(0, 0, r.width - 1, 0);
        g.drawLine(0, 0, 0, r.height - 1);
        g.setColor(bottomRight1);
        g.drawLine(2, r.height - 3, r.width - 3, r.height - 3);
        g.drawLine(r.width - 3, 2, r.width - 3, r.height - 3);
        g.setColor(bottomRight2);
        g.drawLine(1, r.height - 2, r.width - 2, r.height - 2);
        g.drawLine(r.width - 2, 1, r.width - 2, r.height - 2);
        g.setColor(bottomRight3);
        g.drawLine(0, r.height - 1, r.width - 1, r.height - 1);
        g.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
        r.x += 3;
        r.y += 3;
        r.width -= 6;
        r.height -= 6;
        if (pressed) {
            --r.x;
            --r.y;
        }
    }

    protected void processKeyEvent(KeyEvent event) {
        if (!event.isConsumed()) {
            block0 : switch (event.getID()) {
                case 401: {
                    if (!this.isEnabled()) break;
                    switch (event.getKeyCode()) {
                        case 32: {
                            if (!this.sticky) {
                                event.consume();
                                this.down = true;
                                this.repaint();
                                break block0;
                            }
                            super.processKeyEvent(event);
                            break block0;
                        }
                    }
                    super.processKeyEvent(event);
                    break;
                }
                case 402: {
                    if (!this.isEnabled() || event.getKeyCode() != 32) break;
                    if (!this.sticky) {
                        event.consume();
                        this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
                        this.down = false;
                        this.repaint();
                        break;
                    }
                    super.processKeyEvent(event);
                    break;
                }
            }
        }
        super.processKeyEvent(event);
    }

    protected void processMouseEvent(MouseEvent event) {
        if (!event.isConsumed()) {
            switch (event.getID()) {
                case 504: {
                    if (!this.isEnabled()) break;
                    this.focus = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    if (!this.isEnabled()) break;
                    this.focus = false;
                    this.repaint();
                    break;
                }
                case 501: {
                    if (!this.isEnabled()) break;
                    this.requestFocus();
                    if (!this.sticky) {
                        this.down = true;
                        event.consume();
                        this.repaint();
                        break;
                    }
                    super.processMouseEvent(event);
                    break;
                }
                case 502: {
                    if (!this.isEnabled()) break;
                    if (!this.sticky) {
                        if (!this.down) break;
                        Rectangle bounds = this.getBounds();
                        bounds.y = 0;
                        bounds.x = 0;
                        if (this.isEnabled() && bounds.contains(event.getPoint())) {
                            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
                        }
                        this.down = false;
                        event.consume();
                        this.repaint();
                        break;
                    }
                    super.processMouseEvent(event);
                    break;
                }
                default: {
                    super.processMouseEvent(event);
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        if (!event.isConsumed()) {
            switch (event.getID()) {
                case 506: {
                    if (!this.isEnabled() || this.sticky) break;
                    Rectangle bounds = this.getBounds();
                    bounds.y = 0;
                    bounds.x = 0;
                    if (!this.isEnabled()) break;
                    this.down = bounds.contains(event.getPoint());
                    event.consume();
                    this.repaint();
                    break;
                }
                default: {
                    super.processMouseMotionEvent(event);
                    break;
                }
            }
        }
    }

    protected synchronized String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        if (this.sticky) {
            buffer.append(",sticky");
        }
        return buffer.toString();
    }

    public DButton() {
        this((String)null, (Image)null, 0, false, (DCheckboxGroup)null);
    }

    public DButton(String label) {
        this(label, (Image)null, 0, false, (DCheckboxGroup)null);
    }

    public DButton(String label, int align) {
        this(label, (Image)null, align, false, (DCheckboxGroup)null);
    }

    public DButton(Image icon) {
        this(null, icon, 0, false, null);
    }

    public DButton(Image icon, int align) {
        this(null, icon, align, false, null);
    }

    public DButton(URL icon) {
        this(null, icon, 0, false, null);
    }

    public DButton(URL icon, int align) {
        this(null, icon, align, false, null);
    }

    public DButton(String label, Image icon) {
        this(label, icon, 0, false, null);
    }

    public DButton(String label, URL icon) {
        this(label, icon, 0, false, null);
    }

    public DButton(String label, Image icon, int align) {
        this(label, icon, align, false, null);
    }

    public DButton(String label, URL icon, int align) {
        this(label, icon, align, false, null);
    }

    public DButton(String label, DCheckboxGroup group) {
        this(label, (Image)null, 0, false, group);
    }

    public DButton(String label, boolean value, DCheckboxGroup group) {
        this(label, (Image)null, 0, value, group);
    }

    public DButton(String label, int align, boolean value, DCheckboxGroup group) {
        this(label, (Image)null, align, value, group);
    }

    public DButton(Image icon, boolean value, DCheckboxGroup group) {
        this(null, icon, 0, value, group);
    }

    public DButton(URL icon, boolean value, DCheckboxGroup group) {
        this(null, icon, 0, value, group);
    }

    public DButton(Image icon, int align, boolean value, DCheckboxGroup group) {
        this(null, icon, align, value, group);
    }

    public DButton(URL icon, int align, boolean value, DCheckboxGroup group) {
        this(null, icon, align, value, group);
    }

    public DButton(String label, Image icon, int align, boolean value, DCheckboxGroup group) {
        this.label = label;
        this.align = align;
        if (icon != null) {
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
        }
        if (group != null) {
            this.sticky = true;
            this.setGroup(group);
            this.value = value;
        }
    }

    public DButton(String label, URL icon, int align, boolean value, DCheckboxGroup group) {
        this(label, (Image)null, align, value, group);
        if (icon != null) {
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
        }
    }
}

