/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DCheckboxGroup;
import dog.gui.DColor;
import dog.gui.DComponent;
import dog.gui.DTheme;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class DCheckbox
extends DComponent {
    public static final int LEFT = 4;
    public static final int RIGHT = 2;
    protected boolean value = false;
    protected boolean down = false;
    protected String label;
    protected int align;
    protected DCheckboxGroup group;
    protected String command;
    protected transient boolean focus = false;
    Vector listeners = new Vector();

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        if (this.value != value) {
            boolean old = this.value;
            this.value = value;
            this.repaint();
            this.changes.firePropertyChange("value", new Boolean(old), new Boolean(value));
        }
    }

    public String getText() {
        return this.getLabel();
    }

    public void setText(String text) {
        this.setLabel(text);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (this.label == null && label != null || this.label != null && !this.label.equals(label)) {
            String old = this.label;
            this.label = label;
            this.changes.firePropertyChange("label", old, label);
            this.invalidate();
            this.repaint();
        }
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        if (align != 4 && align != 2) {
            throw new IllegalArgumentException("illegal alignment value: " + align);
        }
        if (this.align != align) {
            int old = this.align;
            this.align = align;
            this.changes.firePropertyChange("align", new Integer(old), new Integer(align));
            this.repaint();
        }
    }

    public DCheckboxGroup getGroup() {
        return this.group;
    }

    public void setGroup(DCheckboxGroup group) {
        if (this.group == null && group != null || this.group != null && !this.group.equals(group)) {
            DCheckboxGroup old = this.group;
            if (this.group != null) {
                this.group.removeCheckbox(this);
            }
            if (group != null) {
                group.addCheckbox(this);
            }
            this.changes.firePropertyChange("group", old, group);
        }
    }

    public String getActionCommand() {
        return this.command != null ? this.command : this.label;
    }

    public void setActionCommand(String command) {
        if (command == null && this.command != null || command != null && !command.equals(this.command)) {
            String old = this.command;
            this.command = command;
            this.changes.firePropertyChange("command", old, command);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("CHECKBOX"));
        int rh = fm.getHeight() + fm.getDescent();
        int max = Math.min(16, rh);
        Dimension ps = new Dimension(0, max);
        if (this.label != null) {
            String[] r = DComponent.getRows(fm, this.label, this.getParent().getSize().width);
            int rows = 0;
            while (rows < r.length) {
                String token = r[rows];
                ps.width = Math.max(ps.width, fm.stringWidth(token));
                ++rows;
            }
            ps.height = rh * r.length;
            ps.width += max + 4;
        } else {
            ps.width = ps.height;
        }
        ps.width += 4;
        ps.height += 4;
        return ps;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        boolean left;
        DTheme theme = this.myTheme;
        Font font = theme.getFont("CHECKBOX");
        FontMetrics fm = this.getFontMetrics(font);
        Dimension size = this.getSize();
        boolean enabled = this.isEnabled();
        Color text = theme.getColor("CHECKBOX_TEXT");
        Color tick = theme.getColor("CHECKBOX_TICK");
        Color background = theme.getColor("CHECKBOX_BACKGROUND");
        Color border = theme.getColor("CHECKBOX_BORDER");
        if (!enabled) {
            text = DColor.toGray(text);
            tick = DColor.toGray(tick);
            background = DColor.darker(DColor.toGray(background));
            border = DColor.darker(DColor.toGray(border));
        }
        if (this.down) {
            background = DColor.darker(background);
        }
        int th = fm.getHeight();
        int max = 14;
        boolean flabel = this.label != null;
        boolean bl = left = this.align == 4;
        Rectangle box = new Rectangle(left ? (flabel ? 3 : 1) : size.width - max + 1, (size.height - max) / 2, max - 2, max - 2);
        if (this.group == null) {
            Color topLeft2 = border;
            Color topLeft1 = DColor.darker(topLeft2);
            Color bottomRight1 = border;
            Color bottomRight2 = DColor.brighter(bottomRight1);
            g.setColor(background);
            g.fillRect(box.x, box.y, box.width, box.height);
            g.setColor(topLeft1);
            g.drawLine(box.x + 1, box.y + 1, box.x + box.width - 2, box.y + 1);
            g.drawLine(box.x + 1, box.y + 1, box.x + 1, box.y + box.height - 2);
            g.setColor(topLeft2);
            g.drawLine(box.x, box.y, box.x + box.width - 1, box.y);
            g.drawLine(box.x, box.y, box.x, box.y + box.height - 1);
            g.setColor(bottomRight1);
            g.drawLine(box.x + 1, box.y + box.height - 2, box.x + box.width - 2, box.y + box.height - 2);
            g.drawLine(box.x + box.width - 2, box.y + 1, box.x + box.width - 2, box.y + box.height - 2);
            g.setColor(bottomRight2);
            g.drawLine(box.x, box.y + box.height - 1, box.x + box.width - 1, box.y + box.height - 1);
            g.drawLine(box.x + box.width - 1, box.y, box.x + box.width - 1, box.y + box.height - 1);
            if (this.value) {
                DComponent.drawTick(g, box, tick);
            }
        } else {
            g.setColor(background);
            g.fillOval(box.x + 1, box.y + 1, box.width - 2, box.height - 2);
            g.setColor(border);
            g.drawOval(box.x + 1, box.y + 1, box.width - 2, box.height - 2);
            if (this.value) {
                g.setColor(tick);
                g.fillOval(box.x + 3, box.y + 3, box.width - 6, box.height - 6);
            }
        }
        if (flabel) {
            g.setFont(font);
            Rectangle lr = new Rectangle(left ? max + 3 : 0, 0, size.width - max - 3, size.height);
            if (this.focus) {
                DComponent.drawFocusBorder(g, lr, text);
            }
            lr.x += 2;
            lr.y += 2;
            lr.width -= 4;
            lr.height -= 4;
            DComponent.drawLabel(g, lr, fm, this.label, this.align, text);
        } else if (this.focus) {
            DComponent.drawFocusBorder(g, new Rectangle(0, 0, size.width, size.height), text);
        }
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processActionEvent(ActionEvent event) {
        Object[] l = null;
        DCheckbox dCheckbox = this;
        synchronized (dCheckbox) {
            l = new ActionListener[this.listeners.size()];
            this.listeners.copyInto(l);
        }
        int i = 0;
        while (i < l.length) {
            l[i].actionPerformed(event);
            ++i;
        }
    }

    protected void processFocusEvent(FocusEvent event) {
        switch (event.getID()) {
            case 1004: {
                this.focus = true;
                this.repaint();
                break;
            }
            case 1005: {
                this.focus = false;
                this.repaint();
                break;
            }
        }
        super.processFocusEvent(event);
    }

    protected void processKeyEvent(KeyEvent event) {
        if (!event.isConsumed()) {
            block0 : switch (event.getID()) {
                case 401: {
                    switch (event.getKeyCode()) {
                        case 10: {
                            this.processDefaultAction(new ActionEvent(this, 1001, this.getActionCommand()));
                            event.consume();
                            break block0;
                        }
                        case 3: 
                        case 27: {
                            this.processCancelAction(new ActionEvent(this, 1001, this.getActionCommand()));
                            event.consume();
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                        case 32: {
                            this.down = true;
                            this.repaint();
                            event.consume();
                            break block0;
                        }
                    }
                    break;
                }
                case 402: {
                    if (event.getKeyCode() != 32) break;
                    this.down = false;
                    this.setValue(!this.value);
                    this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
                    event.consume();
                    break;
                }
            }
        }
        super.processKeyEvent(event);
    }

    protected void processMouseEvent(MouseEvent event) {
        if (!event.isConsumed()) {
            switch (event.getID()) {
                case 501: {
                    if (!this.isEnabled()) break;
                    this.requestFocus();
                    this.down = true;
                    this.repaint();
                    break;
                }
                case 502: {
                    if (!this.isEnabled()) break;
                    Rectangle bounds = this.getBounds();
                    bounds.y = 0;
                    bounds.x = 0;
                    this.down = false;
                    if (bounds.contains(event.getPoint())) {
                        this.setValue(!this.value);
                        this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
                        break;
                    }
                    this.repaint();
                    break;
                }
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        if (!event.isConsumed()) {
            switch (event.getID()) {
                case 506: {
                    if (!this.isEnabled()) break;
                    Rectangle bounds = this.getBounds();
                    bounds.y = 0;
                    bounds.x = 0;
                    this.down = bounds.contains(event.getPoint());
                    this.repaint();
                    break;
                }
            }
        }
        super.processMouseEvent(event);
    }

    protected String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        if (this.label != null) {
            buffer.append(",label=");
            buffer.append(this.label);
        }
        buffer.append(",value=");
        buffer.append(this.value);
        if (this.command != null) {
            buffer.append(",command=");
            buffer.append(this.command);
        }
        return buffer.toString();
    }

    public DCheckbox() {
        this(null, 4, false, null);
    }

    public DCheckbox(String label) {
        this(label, 4, false, null);
    }

    public DCheckbox(String label, int align) {
        this(label, align, false, null);
    }

    public DCheckbox(boolean value) {
        this(null, 4, value, null);
    }

    public DCheckbox(String label, boolean value) {
        this(label, 4, value, null);
    }

    public DCheckbox(String label, int align, boolean value) {
        this(label, align, value, null);
    }

    public DCheckbox(String label, int align, DCheckboxGroup group) {
        this(label, align, false, group);
    }

    public DCheckbox(String label, DCheckboxGroup group) {
        this(label, 4, false, group);
    }

    public DCheckbox(String label, boolean value, DCheckboxGroup group) {
        this(label, 4, value, group);
    }

    public DCheckbox(String label, int align, boolean value, DCheckboxGroup group) {
        this.label = label;
        this.align = align;
        this.value = value;
        this.setGroup(group);
        this.enableEvents(60L);
    }
}

