/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DContainer;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import dog.gui.TooltipManager;
import dog.util.Referential;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class DComponent
extends Component
implements Referential {
    public static final int CENTER = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int NORTHEAST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTHWEST = 7;
    public static final int NORTHWEST = 8;
    public static final int TILE = 11;
    public static final int INTEGER_TILE = 12;
    public static final int CENTER_TILE = 13;
    public static final int MAXIMIZE = 14;
    public static final int MAXIMIZE_ASPECT = 15;
    public static final int MAXIMIZE_VERTICAL = 16;
    public static final int MAXIMIZE_HORIZONTAL = 17;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static boolean preloadImages;
    private static Hashtable imageCache;
    private static final int CLICK_MOUSE_TRAVEL = 5;
    private static final int CLICK_MOUSE_DURATION = 400;
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected Object reference;
    protected String tooltip;
    protected DTheme myTheme;
    private Clicker clicker;

    public void setTheme(DTheme myTheme) {
        if (myTheme == null) {
            myTheme = DTheme.getTheme();
        }
        this.myTheme = myTheme;
    }

    public DTheme getTheme() {
        return this.myTheme;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    protected void processDefaultAction(ActionEvent event) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DContainer) {
                ((DContainer)parent).processDefaultAction(event);
                return;
            }
            if (parent instanceof DRootPane) {
                ((DRootPane)((Object)parent)).processDefaultAction(event);
                return;
            }
            parent = parent.getParent();
        }
    }

    protected void processCancelAction(ActionEvent event) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DContainer) {
                ((DContainer)parent).processCancelAction(event);
                return;
            }
            if (parent instanceof DRootPane) {
                ((DRootPane)((Object)parent)).processCancelAction(event);
                return;
            }
            parent = parent.getParent();
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.repaint();
    }

    public static Toolkit getDefaultToolkit() {
        return toolkit;
    }

    public static Image getImage(Image image, ImageObserver observer) {
        if (image != null) {
            toolkit.prepareImage(image, -1, -1, observer);
            return image;
        }
        return null;
    }

    public static Image getImage(String file, ImageObserver observer) {
        if (file != null) {
            Image image = (Image)imageCache.get(file);
            if (image != null) {
                return image;
            }
            return DComponent.getImage2(toolkit.getImage(file), observer);
        }
        return null;
    }

    public static Image getImage(URL url, ImageObserver observer) {
        if (url != null) {
            Image image = (Image)imageCache.get(url);
            if (image != null) {
                return image;
            }
            return DComponent.getImage2(toolkit.getImage(url), observer);
        }
        return null;
    }

    static Image getImage2(Image image, ImageObserver observer) {
        if (preloadImages && observer instanceof Component) {
            try {
                MediaTracker tracker = new MediaTracker((Component)observer);
                tracker.addImage(image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        toolkit.prepareImage(image, -1, -1, observer);
        return image;
    }

    public static boolean isPreloadImages() {
        return preloadImages;
    }

    public static void setPreloadImages(boolean flag) {
        preloadImages = flag;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        Object old = this.reference;
        this.reference = reference;
        this.changes.firePropertyChange("reference", old, reference);
    }

    public DRootPane getRootPane() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DRootPane) {
                return (DRootPane)((Object)parent);
            }
            parent = parent.getParent();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append('[');
        Rectangle bounds = this.getBounds();
        buffer.append(bounds.x);
        buffer.append(',');
        buffer.append(bounds.y);
        buffer.append(',');
        buffer.append(bounds.width);
        buffer.append('x');
        buffer.append(bounds.height);
        if (!this.isValid()) {
            buffer.append(",invalid");
        }
        if (!this.isVisible()) {
            buffer.append(",hidden");
        }
        if (!this.isEnabled()) {
            buffer.append(",disabled");
        }
        buffer.append(this.paramString());
        buffer.append(']');
        return buffer.toString();
    }

    protected String paramString() {
        return new String();
    }

    protected String alignParamString(int align) {
        switch (align) {
            case 0: {
                return "center";
            }
            case 1: {
                return "north";
            }
            case 2: {
                return "east";
            }
            case 3: {
                return "south";
            }
            case 4: {
                return "west";
            }
            case 5: {
                return "northeast";
            }
            case 6: {
                return "southeast";
            }
            case 7: {
                return "southwest";
            }
            case 8: {
                return "northwest";
            }
        }
        return "<unknown>";
    }

    public static Color parseColor(String rgb) {
        if (rgb == null) {
            return null;
        }
        if (rgb.indexOf(44) > -1) {
            int r = -1;
            int g = -1;
            int b = -1;
            try {
                StringTokenizer st = new StringTokenizer(rgb, ", ");
                if (st.hasMoreTokens()) {
                    r = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        g = Integer.parseInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            b = Integer.parseInt(st.nextToken());
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (r > -1 && r < 256 && g > -1 && g < 256 && b > -1 && b < 256) {
                return new Color(r, g, b);
            }
            return null;
        }
        byte[] bytes = rgb.toLowerCase().getBytes();
        String hex = "0123456789ABCDEFabcdef";
        int field = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        byte last = -1;
        int i = 0;
        while (i < bytes.length) {
            if (hex.indexOf(bytes[i]) > -1) {
                if (last == -1) {
                    last = bytes[i];
                } else {
                    byte[] fbytes = new byte[]{last, bytes[i]};
                    last = -1;
                    switch (field) {
                        case 0: {
                            red = Integer.parseInt(new String(fbytes), 16);
                            ++field;
                            break;
                        }
                        case 1: {
                            green = Integer.parseInt(new String(fbytes), 16);
                            ++field;
                            break;
                        }
                        case 2: {
                            blue = Integer.parseInt(new String(fbytes), 16);
                            ++field;
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        return new Color(red, green, blue);
    }

    public static Font parseFont(String font) {
        int size;
        int style;
        String name;
        block9: {
            name = "SansSerif";
            style = 0;
            size = 12;
            if (font != null) {
                StringTokenizer st = new StringTokenizer(font, ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    String token = st.nextToken().trim().toLowerCase();
                    try {
                        size = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {
                        if (token.indexOf("italic") > -1) {
                            style += 2;
                        }
                        if (token.indexOf("bold") > -1) {
                            ++style;
                        }
                        if (!st.hasMoreTokens()) break block9;
                        try {
                            size = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return new Font(name, style, size);
    }

    protected static void drawBorder(Graphics g, Rectangle r, Color ds, Color h, Color c) {
        g.translate(r.x, r.y);
        g.setColor(ds);
        g.drawRect(0, 0, r.width - 2, r.height - 2);
        g.setColor(h);
        g.drawRect(1, 1, r.width - 2, r.height - 2);
        g.setColor(c);
        g.drawLine(0, r.height - 1, 1, r.height - 2);
        g.drawLine(r.width - 1, 0, r.width - 2, 1);
        g.translate(-r.x, -r.y);
        g.setColor(Color.white);
        g.drawRect(0, 0, r.width - 1, r.height - 1);
    }

    protected static void drawFocusBorder(Graphics g, Rectangle r, Color f) {
    }

    protected static void drawPressedBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs) {
        g.translate(r.x, r.y);
        DComponent.drawBorder(g, r, ds, h, c);
        g.setColor(cs);
        g.drawLine(1, 1, 1, r.height - 2);
        g.drawLine(1, 1, r.width - 2, 1);
        g.translate(-r.x, -r.y);
    }

    protected static void drawDisabledBorder(Graphics g, Rectangle r, Color d) {
        g.translate(r.x, r.y);
        g.setColor(d);
        g.drawRect(0, 0, r.width - 2, r.height - 2);
        g.translate(-r.x, -r.y);
    }

    protected static void drawDarkBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs) {
    }

    protected static void drawButtonBorder(Graphics g, Rectangle r, boolean active, Color ds, Color h, Color c, Color pc, Color pcds) {
        if (active) {
            DComponent.drawActiveButtonBorder(g, r, ds, h, c, pc, pcds);
        } else {
            DComponent.drawBorder(g, r, ds, h, c);
        }
    }

    protected static void drawActiveButtonBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color pc, Color pcds) {
        DComponent.drawBorder(g, r, ds, h, c);
        g.translate(r.x, r.y);
        g.setColor(pc);
        g.drawLine(1, 1, 1, r.height - 3);
        g.drawLine(1, 1, r.width - 3, 1);
        g.setColor(pcds);
        g.drawLine(2, r.height - 2, r.width - 2, r.height - 2);
        g.drawLine(r.width - 2, 2, r.width - 2, r.height - 2);
        g.translate(-r.x, -r.y);
    }

    protected static void drawDefaultButtonBorder(Graphics g, Rectangle r, boolean active, Color ds, Color h, Color c, Color pc, Color pcds) {
        DComponent.drawButtonBorder(g, new Rectangle(r.x + 1, r.y + 1, r.width - 1, r.height - 1), active, ds, h, c, pc, pcds);
        g.setColor(active ? pcds : ds);
        g.drawRect(r.x, r.y, r.width - 3, r.height - 3);
        g.drawLine(r.width - 2, 0, r.width - 2, 0);
        g.drawLine(0, r.height - 2, 0, r.height - 2);
    }

    protected static void drawArrow(Graphics g, Rectangle r, boolean active, int orientation, Color ds, Color h, Color pc) {
        Point apex = null;
        Point base1 = null;
        Point base2 = null;
        int bw = r.width - 1;
        int bh = r.height - 1;
        switch (orientation) {
            case 1: {
                apex = new Point(r.x + bw / 2, r.y + bh / 5);
                base1 = new Point(r.x + bw * 4 / 5, r.y + bh * 2 / 3);
                base2 = new Point(r.x + bw / 5, r.y + bh * 2 / 3);
                break;
            }
            case 2: {
                apex = new Point(r.x + bw * 4 / 5, r.y + bh / 2);
                base1 = new Point(r.x + bw / 3, r.y + bh * 4 / 5);
                base2 = new Point(r.x + bw / 3, r.y + bh / 5);
                break;
            }
            case 3: {
                apex = new Point(r.x + bw / 2, r.y + bh * 4 / 5);
                base1 = new Point(r.x + bw / 5, r.y + bh / 3);
                base2 = new Point(r.x + bw * 4 / 5, r.y + bh / 3);
                break;
            }
            case 4: {
                apex = new Point(r.x + bw / 5, r.y + bh / 2);
                base1 = new Point(r.x + bw * 2 / 3, r.y + bh / 5);
                base2 = new Point(r.x + bw * 2 / 3, r.y + bh * 4 / 5);
                break;
            }
        }
        if (active) {
            g.setColor(pc);
            Polygon polygon = new Polygon();
            polygon.addPoint(apex.x, apex.y);
            polygon.addPoint(base1.x, base1.y);
            polygon.addPoint(base2.x, base2.y);
            polygon.addPoint(apex.x, apex.y);
            g.fillPolygon(polygon);
        }
        switch (orientation) {
            case 1: {
                g.setColor(h);
                g.drawLine(apex.x, apex.y, base1.x, base1.y);
                g.drawLine(base1.x, base1.y, base2.x, base2.y);
                g.setColor(ds);
                g.drawLine(base2.x, base2.y, apex.x, apex.y);
                break;
            }
            case 2: {
                g.setColor(h);
                g.drawLine(apex.x, apex.y, base1.x, base1.y);
                g.setColor(ds);
                g.drawLine(base1.x, base1.y, base2.x, base2.y);
                g.drawLine(base2.x, base2.y, apex.x, apex.y);
                break;
            }
            case 3: {
                g.setColor(h);
                g.drawLine(base2.x, base2.y, apex.x, apex.y);
                g.setColor(ds);
                g.drawLine(apex.x, apex.y, base1.x, base1.y);
                g.drawLine(base1.x, base1.y, base2.x, base2.y);
                break;
            }
            case 4: {
                g.setColor(h);
                g.drawLine(base1.x, base1.y, base2.x, base2.y);
                g.drawLine(base2.x, base2.y, apex.x, apex.y);
                g.setColor(ds);
                g.drawLine(apex.x, apex.y, base1.x, base1.y);
                break;
            }
        }
    }

    protected static void drawCheckbox(Graphics g, Rectangle r, boolean active, boolean value, Color ds, Color h, Color c, Color cs, Color pc, Color pcds, Color f) {
        if (active) {
            g.setColor(cs);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        DComponent.drawButtonBorder(g, r, active, ds, h, c, pc, pcds);
        if (value) {
            DComponent.drawTick(g, r, f);
        }
    }

    protected static void drawDisabledCheckbox(Graphics g, Rectangle r, boolean value, Color d) {
        DComponent.drawDisabledBorder(g, r, d);
        if (value) {
            DComponent.drawTick(g, r, d);
        }
    }

    protected static void drawTick(Graphics g, Rectangle r, Color c) {
        int extent = 13;
        g.setColor(c);
        g.translate(r.x, r.y);
        g.fillRect(3, 5, 2, extent - 8);
        g.drawLine(extent - 4, 3, 5, extent - 6);
        g.drawLine(extent - 4, 4, 5, extent - 5);
        g.translate(-r.x, -r.y);
    }

    protected static void drawOption(Graphics g, Rectangle r, boolean active, boolean value, Color ds, Color h, Color c, Color cs, Color pc, Color pcds, Color f) {
        if (active) {
            DComponent.drawActiveOptionBorder(g, r, ds, h, c, cs, pc, pcds);
        } else {
            DComponent.drawOptionBorder(g, r, ds, h, c);
        }
        if (value) {
            g.setColor(f);
            g.fillOval(r.x + 3, r.y + 3, r.width - 6, r.height - 6);
        }
    }

    protected static void drawDisabledOption(Graphics g, Rectangle r, boolean value, Color d) {
        g.setColor(d);
        g.drawOval(r.x, r.y, r.width, r.height);
        if (value) {
            g.fillOval(r.x + 3, r.y + 3, r.width - 6, r.height - 6);
        }
    }

    protected static void drawOptionBorder(Graphics g, Rectangle r, Color ds, Color h, Color c) {
        g.setColor(h);
        g.drawOval(r.x + 1, r.y + 1, r.width, r.height);
        g.setColor(ds);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected static void drawActiveOptionBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs, Color pc, Color pcds) {
        DComponent.drawOptionBorder(g, r, ds, h, c);
        g.setColor(cs);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(ds);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected static void drawExpander(Graphics g, Rectangle r, boolean active, boolean collapsed, Color pc, Color pch, Color pcs, Color pcds, Color f) {
        int extent = 7;
        Rectangle cr = new Rectangle(r.x + (r.width - extent) / 2, r.y + (r.height - extent) / 2, extent, extent);
        g.setColor(collapsed ? pc : pcds);
        g.fillOval(cr.x, cr.y, cr.width, cr.height);
        g.setColor(collapsed ? pch : pc);
        g.drawLine(cr.x + 2, cr.y + 1, cr.x + cr.width - 2, cr.y + 1);
        g.drawLine(cr.x + 1, cr.y + 2, cr.x + 1, cr.y + cr.height - 2);
        g.setColor(f);
        g.drawOval(cr.x, cr.y, cr.width, cr.height);
    }

    protected static void drawLabel(Graphics g, Rectangle r, FontMetrics fm, String label, int align, Color f) {
        String[] rows = DComponent.getRows(fm, label, r.width);
        int rh = fm.getHeight();
        int ascent = fm.getAscent();
        g.setColor(f);
        int i = 0;
        while (i < rows.length) {
            Rectangle rr = new Rectangle(0, 0, fm.stringWidth(rows[i]), rh);
            if (align == 0 || align == 1 || align == 3) {
                rr.x = (r.width - rr.width) / 2;
            } else if (align == 2 || align == 5 || align == 6) {
                rr.x = r.width - rr.width;
            } else if (align == 4 || align == 7 || align == 8) {
                rr.x = 0;
            }
            if (align == 0 || align == 2 || align == 4) {
                rr.y = rh * i + (r.height - rows.length * rh) / 2;
            } else if (align == 1 || align == 5 || align == 8) {
                rr.y = rh * i;
            } else if (align == 3 || align == 6 || align == 7) {
                rr.y = rh * i + (r.height - rows.length * rh);
            }
            g.drawString(rows[i], r.x + rr.x, r.y + ascent + rr.y);
            ++i;
        }
    }

    protected static String[] getRows(FontMetrics fm, String label, int width) {
        String row = new String();
        Vector<String> rows = new Vector<String>();
        StringTokenizer st = new StringTokenizer(label, " \n", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (" ".equals(token)) continue;
            if ("\n".equals(token)) {
                rows.addElement(row);
                row = new String();
                continue;
            }
            String test = row + token;
            int rw = fm.stringWidth(test);
            if (rw > width - 2 && row.length() > 0) {
                rows.addElement(row);
                row = new String();
            }
            row = row + (row.length() > 0 ? " " : "") + token;
        }
        if (row.length() > 0) {
            rows.addElement(row);
        }
        Object[] r = new String[rows.size()];
        rows.copyInto(r);
        return r;
    }

    protected static void drawImage(Graphics g, Rectangle r, Image image, ImageObserver observer, int align) {
        double scale;
        Rectangle ir = new Rectangle(0, 0, image.getWidth(observer), image.getHeight(observer));
        if (ir.width > r.width) {
            scale = (double)r.width / (double)ir.width;
            ir.width = (int)((double)ir.width * scale);
            ir.height = (int)((double)ir.height * scale);
        }
        if (ir.height > r.height) {
            scale = (double)r.height / (double)ir.height;
            ir.width = (int)((double)ir.width * scale);
            ir.height = (int)((double)ir.height * scale);
        }
        if (align == 0 || align == 1 || align == 3) {
            ir.x = r.x + (r.width - ir.width) / 2;
        } else if (align == 2 || align == 5 || align == 6) {
            ir.x = r.x + r.width - ir.width;
        } else if (align == 4 || align == 7 || align == 8) {
            ir.x = r.x;
        }
        if (align == 0 || align == 2 || align == 4) {
            ir.y = r.y + (r.height - ir.height) / 2;
        } else if (align == 1 || align == 5 || align == 8) {
            ir.y = r.y;
        } else if (align == 3 || align == 6 || align == 7) {
            ir.y = r.y + r.height - ir.height;
        }
        g.drawImage(image, ir.x, ir.y, ir.width, ir.height, observer);
    }

    protected static void drawBackgroundImage(Graphics g, Image image, Rectangle bounds, Dimension bs, Rectangle br, int mode, ImageObserver observer) {
        int iw = image.getWidth(observer);
        int ih = image.getHeight(observer);
        if (iw < 0 || ih < 0) {
            g.clearRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        switch (mode) {
            case 0: {
                br.width = bs.width;
                br.height = bs.height;
                br.x = (bounds.width - bs.width) / 2;
                br.y = (bounds.height - bs.height) / 2;
                g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                break;
            }
            case 11: {
                br.width = bs.width;
                br.height = bs.height;
                br.y = 0;
                while (br.y < bounds.height) {
                    br.x = 0;
                    while (br.x < bounds.width) {
                        g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                        br.x += br.width;
                    }
                    br.y += br.height;
                }
                break;
            }
            case 12: {
                int cols = bounds.width / bs.width;
                int rows = bounds.height / bs.height;
                br.width = bounds.width / cols;
                br.height = bounds.height / rows;
                br.y = 0;
                while (br.y < bounds.height) {
                    br.x = 0;
                    while (br.x < bounds.width) {
                        g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                        br.x += br.width;
                    }
                    br.y += br.height;
                }
                break;
            }
            case 13: {
                br.width = bs.width;
                br.height = bs.height;
                Point origin = new Point(bounds.width / 2, bounds.height / 2);
                origin.x -= bs.width / 2;
                origin.y -= bs.width / 2;
                while (origin.x > 0) {
                    origin.x -= bs.width;
                }
                while (origin.y >= 0) {
                    origin.y -= bs.height;
                }
                br.y = origin.x;
                while (br.y < bounds.height) {
                    br.x = origin.x;
                    while (br.x < bounds.width) {
                        g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                        br.x += bs.width;
                    }
                    br.y += bs.height;
                }
                break;
            }
            case 14: {
                g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                break;
            }
            case 15: {
                double ahscale = (double)bounds.width / (double)bs.width;
                double avscale = (double)bounds.height / (double)bs.height;
                int diffx = bounds.width - (int)((double)br.width * avscale);
                int diffy = bounds.height - (int)((double)br.height * ahscale);
                if (diffx > diffy) {
                    br.width = (int)((double)bs.width * avscale);
                    br.height = bounds.height;
                    br.x = (bounds.width - bs.width) / 2;
                    br.y = 0;
                } else {
                    br.width = bounds.width;
                    br.height = (int)((double)bs.height * ahscale);
                    br.x = 0;
                    br.y = (bounds.height - br.height) / 2;
                }
                g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                break;
            }
            case 16: {
                double vscale = (double)bounds.height / (double)bs.height;
                br.width = (int)((double)bs.width * vscale);
                br.height = bounds.height;
                br.x = (bounds.width - br.width) / 2;
                br.y = 0;
                g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                break;
            }
            case 17: {
                double hscale = (double)bounds.width / (double)bs.width;
                br.width = bounds.width;
                br.height = (int)((double)bs.height * hscale);
                br.x = 0;
                br.y = (bounds.height - br.height) / 2;
                g.drawImage(image, br.x, br.y, br.width, br.height, observer);
                break;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    protected void processEvent(AWTEvent event) {
        if (event.getID() != 500) {
            super.processEvent(event);
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 504: {
                TooltipManager.setComponent(this, event.getPoint());
                break;
            }
            case 505: {
                TooltipManager.setComponent(null, null);
                break;
            }
            case 501: {
                if (this.clicker == null) {
                    this.clicker = new Clicker(this);
                }
                this.clicker.down(event);
                break;
            }
            case 502: {
                if (this.clicker == null) break;
                this.clicker.up(event);
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 503: {
                TooltipManager.setComponent(null, null);
                TooltipManager.setComponent(this, event.getPoint());
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    static /* synthetic */ int access$0() {
        return CLICK_MOUSE_DURATION;
    }

    static /* synthetic */ int access$1() {
        return CLICK_MOUSE_TRAVEL;
    }

    public DComponent() {
        this.enableEvents(48L);
        this.myTheme = DTheme.getTheme();
    }

    static {
        imageCache = new Hashtable();
    }

    final class Clicker
    implements Runnable {
        private DComponent component;
        private MouseEvent downEvent;
        private MouseEvent upEvent;
        private int count = 0;

        public final void down(MouseEvent event) {
            if (this.downEvent == null) {
                this.downEvent = event;
                this.upEvent = null;
                this.count = 1;
                Thread t = new Thread(this);
                t.setPriority(1);
                t.start();
            }
            ++this.count;
        }

        public final void up(MouseEvent event) {
            this.upEvent = event;
        }

        public final void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.upEvent != null) {
                this.click();
            }
            this.downEvent = null;
        }

        final void click() {
            boolean withinTravelArea;
            Dimension size = this.component.getSize();
            Rectangle inside = new Rectangle(0, 0, size.width, size.height);
            Point upPoint = this.upEvent.getPoint();
            Point downPoint = this.downEvent.getPoint();
            int dx = upPoint.x - downPoint.x;
            dx = dx < 0 ? -dx : dx;
            int dy = upPoint.y - downPoint.y;
            dy = dy < 0 ? -dy : dy;
            boolean bl = withinTravelArea = dx <= 5 && dy <= 5;
            if (inside.contains(upPoint) && withinTravelArea) {
                this.component.processMouseEvent(new MouseEvent(this.component, 500, this.upEvent.getWhen(), this.upEvent.getModifiers(), downPoint.x, downPoint.y, this.count, this.upEvent.isPopupTrigger()));
            }
        }

        Clicker(DComponent component) {
            this.component = component;
        }
    }
}

