/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DButton;
import dog.gui.DComponent;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import dog.gui.TooltipManager;
import dog.util.Referential;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;

public class DContainer
extends Container
implements Referential {
    public static final int CENTER = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int NORTHEAST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTHWEST = 7;
    public static final int NORTHWEST = 8;
    private static final int CLICK_MOUSE_TRAVEL = 5;
    private static final long CLICK_MOUSE_DURATION = 400L;
    PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected DButton defaultButton;
    protected DButton cancelButton;
    protected Object reference;
    protected String tooltip;
    private Point clickFix;
    protected DTheme myTheme;
    private Insets insets = super.getInsets();
    private boolean enableFlag = true;
    private Clicker clicker;

    public void setTheme(DTheme myTheme) {
        if (myTheme == null) {
            myTheme = DTheme.getTheme();
        }
        this.myTheme = myTheme;
    }

    public DTheme getTheme() {
        return this.myTheme;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(int size) {
        this.insets = new Insets(size, size, size, size);
    }

    public void setInsets(int topdown, int leftright) {
        this.insets = new Insets(topdown, leftright, topdown, leftright);
    }

    public void setInsets(Insets i) {
        this.insets = i;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public DButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(DButton button) {
        this.defaultButton = button;
    }

    public void processDefaultAction(ActionEvent event) {
        if (this.defaultButton != null) {
            this.defaultButton.down = true;
            this.defaultButton.repaint();
            this.defaultButton.processActionEvent(new ActionEvent(this.defaultButton, event.getID(), event.getActionCommand(), event.getModifiers()));
            this.defaultButton.down = false;
            this.defaultButton.repaint();
        } else {
            DRootPane root = this.getRootPane();
            if (root != null) {
                root.processDefaultAction(event);
            }
        }
    }

    public DButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(DButton button) {
        this.cancelButton = button;
    }

    public void processCancelAction(ActionEvent event) {
        if (this.cancelButton != null) {
            this.cancelButton.down = true;
            this.cancelButton.repaint();
            this.cancelButton.processActionEvent(new ActionEvent(this.cancelButton, event.getID(), event.getActionCommand(), event.getModifiers()));
            this.cancelButton.down = false;
            this.cancelButton.repaint();
        } else {
            DRootPane root = this.getRootPane();
            if (root != null) {
                root.processCancelAction(event);
            }
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (this.enableFlag != flag) {
            this.enableFlag = flag;
            this.repaint();
        }
    }

    public static Toolkit getDefaultToolkit() {
        return DComponent.getDefaultToolkit();
    }

    public static Image getImage(Image image, ImageObserver observer) {
        return DComponent.getImage(image, observer);
    }

    public static Image getImage(String file, ImageObserver observer) {
        return DComponent.getImage(file, observer);
    }

    public static Image getImage(URL url, ImageObserver observer) {
        return DComponent.getImage(url, observer);
    }

    public static boolean isPreloadImages() {
        return DComponent.isPreloadImages();
    }

    public static void setPreloadImages(boolean flag) {
        DComponent.setPreloadImages(flag);
    }

    protected void addImpl(Component component, Object constraints, int index) {
        super.addImpl(component, constraints, index);
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        Object old = this.reference;
        this.reference = reference;
        this.changes.firePropertyChange("reference", old, reference);
    }

    public Component getComponent(Object reference) {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] != null && components[i] instanceof Referential) {
                Object creference = ((Referential)((Object)components[i])).getReference();
                if (reference == null && creference == null || reference != null && reference.equals(creference)) {
                    return components[i];
                }
            }
            ++i;
        }
        return null;
    }

    public DRootPane getRootPane() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DRootPane) {
                return (DRootPane)((Object)parent);
            }
            parent = parent.getParent();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append('[');
        Rectangle bounds = this.getBounds();
        buffer.append(bounds.x);
        buffer.append(',');
        buffer.append(bounds.y);
        buffer.append(',');
        buffer.append(bounds.width);
        buffer.append('x');
        buffer.append(bounds.height);
        if (!this.isValid()) {
            buffer.append(",invalid");
        }
        if (!this.isVisible()) {
            buffer.append(",hidden");
        }
        if (!this.isEnabled()) {
            buffer.append(",disabled");
        }
        buffer.append(this.paramString());
        buffer.append(']');
        return buffer.toString();
    }

    protected String paramString() {
        return new String();
    }

    protected String alignParamString(int align) {
        switch (align) {
            case 0: {
                return "center";
            }
            case 1: {
                return "north";
            }
            case 2: {
                return "east";
            }
            case 3: {
                return "south";
            }
            case 4: {
                return "west";
            }
            case 5: {
                return "northeast";
            }
            case 6: {
                return "southeast";
            }
            case 7: {
                return "southwest";
            }
            case 8: {
                return "northwest";
            }
        }
        return "<unknown>";
    }

    protected static void drawBorder(Graphics g, Rectangle r, Color ds, Color h, Color c) {
        DComponent.drawBorder(g, r, ds, h, c);
    }

    protected static void drawFocusBorder(Graphics g, Rectangle r, Color f) {
        DComponent.drawFocusBorder(g, r, f);
    }

    protected static void drawPressedBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs) {
        DComponent.drawPressedBorder(g, r, ds, h, c, cs);
    }

    protected static void drawDisabledBorder(Graphics g, Rectangle r, Color d) {
        DComponent.drawDisabledBorder(g, r, d);
    }

    protected static void drawDarkBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs) {
        DComponent.drawDarkBorder(g, r, ds, h, c, cs);
    }

    protected static void drawButtonBorder(Graphics g, Rectangle r, boolean active, Color ds, Color h, Color c, Color pc, Color pcds) {
        DComponent.drawButtonBorder(g, r, active, ds, h, c, pc, pcds);
    }

    protected static void drawActiveButtonBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color pc, Color pcds) {
        DComponent.drawActiveButtonBorder(g, r, ds, h, c, pc, pcds);
    }

    protected static void drawDefaultButtonBorder(Graphics g, Rectangle r, boolean active, Color ds, Color h, Color c, Color pc, Color pcds) {
        DComponent.drawDefaultButtonBorder(g, r, active, ds, h, c, pc, pcds);
    }

    protected static void drawArrow(Graphics g, Rectangle r, boolean active, int orientation, Color ds, Color h, Color pc) {
        DComponent.drawArrow(g, r, active, orientation, ds, h, pc);
    }

    protected static void drawCheckbox(Graphics g, Rectangle r, boolean active, boolean value, Color ds, Color h, Color c, Color cs, Color pc, Color pcds, Color f) {
        DComponent.drawCheckbox(g, r, active, value, ds, h, c, cs, pc, pcds, f);
    }

    protected static void drawDisabledCheckbox(Graphics g, Rectangle r, boolean value, Color d) {
        DComponent.drawDisabledCheckbox(g, r, value, d);
    }

    protected static void drawOption(Graphics g, Rectangle r, boolean active, boolean value, Color ds, Color h, Color c, Color cs, Color pc, Color pcds, Color f) {
        DComponent.drawOption(g, r, active, value, ds, h, c, cs, pc, pcds, f);
    }

    protected static void drawDisabledOption(Graphics g, Rectangle r, boolean value, Color d) {
        DComponent.drawDisabledOption(g, r, value, d);
    }

    protected static void drawOptionBorder(Graphics g, Rectangle r, Color ds, Color h, Color c) {
        DComponent.drawOptionBorder(g, r, ds, h, c);
    }

    protected static void drawActiveOptionBorder(Graphics g, Rectangle r, Color ds, Color h, Color c, Color cs, Color pc, Color pcds) {
        DComponent.drawActiveOptionBorder(g, r, ds, h, c, cs, pc, pcds);
    }

    protected static void drawExpander(Graphics g, Rectangle r, boolean active, boolean collapsed, Color pc, Color pch, Color pcs, Color pcds, Color f) {
        DComponent.drawExpander(g, r, active, collapsed, pc, pch, pcs, pcds, f);
    }

    protected static void drawLabel(Graphics g, Rectangle r, FontMetrics fm, String label, int align, Color f) {
        DComponent.drawLabel(g, r, fm, label, align, f);
    }

    protected static void drawImage(Graphics g, Rectangle r, Image image, ImageObserver observer, int align) {
        DComponent.drawImage(g, r, image, observer, align);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    protected void processEvent(AWTEvent event) {
        if (event.getID() != 500) {
            super.processEvent(event);
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 504: {
                TooltipManager.setComponent(this, event.getPoint());
                break;
            }
            case 505: {
                TooltipManager.setComponent(null, null);
                break;
            }
            case 501: {
                if (this.clicker == null) {
                    this.clicker = new Clicker(this);
                }
                this.clicker.down(event);
                break;
            }
            case 502: {
                if (this.clicker == null) break;
                this.clicker.up(event);
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 503: {
                TooltipManager.setComponent(null, null);
                TooltipManager.setComponent(this, event.getPoint());
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    static /* synthetic */ long access$0() {
        return CLICK_MOUSE_DURATION;
    }

    static /* synthetic */ int access$1() {
        return CLICK_MOUSE_TRAVEL;
    }

    public DContainer() {
        this(null);
        this.myTheme = DTheme.getTheme();
    }

    public DContainer(LayoutManager layout) {
        this.setLayout(layout);
    }

    final class Clicker
    implements Runnable {
        private DContainer component;
        private MouseEvent downEvent;
        private MouseEvent upEvent;
        private int count = 0;

        public final void down(MouseEvent event) {
            if (this.downEvent == null) {
                this.downEvent = event;
                this.upEvent = null;
                this.count = 1;
                Thread t = new Thread(this);
                t.setPriority(1);
                t.start();
            }
            ++this.count;
        }

        public final void up(MouseEvent event) {
            this.upEvent = event;
        }

        public final void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.upEvent != null) {
                this.click();
            }
            this.downEvent = null;
        }

        final void click() {
            boolean withinTravelArea;
            Dimension size = this.component.getSize();
            Rectangle inside = new Rectangle(0, 0, size.width, size.height);
            Point upPoint = this.upEvent.getPoint();
            Point downPoint = this.downEvent.getPoint();
            int dx = upPoint.x - downPoint.x;
            dx = dx < 0 ? -dx : dx;
            int dy = upPoint.y - downPoint.y;
            dy = dy < 0 ? -dy : dy;
            boolean bl = withinTravelArea = dx <= 5 && dy <= 5;
            if (inside.contains(upPoint) && withinTravelArea) {
                this.component.processMouseEvent(new MouseEvent(this.component, 500, this.upEvent.getWhen(), this.upEvent.getModifiers(), downPoint.x, downPoint.y, this.count, this.upEvent.isPopupTrigger()));
            }
        }

        Clicker(DContainer component) {
            this.component = component;
        }
    }
}

