/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DButton;
import dog.gui.DComponent;
import dog.gui.DContainer;
import dog.gui.DPopup;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;

public class DDialog
extends Dialog
implements DRootPane {
    protected DTheme myTheme;
    protected int mode = 11;
    protected Image backgroundImage;
    protected DButton defaultButton;
    protected DButton cancelButton;
    private Image offscreen;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Frame frame;
    private DContainer contentPane;
    private DContainer glassPane;

    public void setTheme(DTheme myTheme) {
        if (myTheme == null) {
            myTheme = DTheme.getTheme();
        }
        this.myTheme = myTheme;
    }

    private final void initialiseUI() {
        this.myTheme = DTheme.getTheme();
        this.glassPane = new DContainer();
        this.add(this.glassPane);
        this.contentPane = new DContainer(this.getLayout());
        this.add(this.contentPane);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 11 && mode != 12 && mode != 13 && mode != 14 && mode != 15 && mode != 16 && mode != 17) {
            throw new IllegalArgumentException("illegal mode:" + mode);
        }
        if (this.mode != mode) {
            int old = this.mode;
            this.mode = mode;
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("mode", new Integer(old), new Integer(mode));
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if ((image = DComponent.getImage(image, (ImageObserver)this)) != null) {
            Image old = this.backgroundImage;
            this.backgroundImage = image;
            this.repaint();
            this.changes.firePropertyChange("backgroundImage", old, image);
        }
    }

    public void setBackgroundImage(String file) {
        Image image;
        if (file != null && (image = DComponent.getImage(file, (ImageObserver)this)) != null) {
            Image old = this.backgroundImage;
            this.backgroundImage = image;
            this.repaint();
            this.changes.firePropertyChange("backgroundImage", old, image);
        }
    }

    public void setBackgroundImage(URL url) {
        Image image;
        if (url != null && (image = DComponent.getImage(url, (ImageObserver)this)) != null) {
            Image old = this.backgroundImage;
            this.backgroundImage = image;
            this.repaint();
            this.changes.firePropertyChange("backgroundImage", old, image);
        }
    }

    public DButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(DButton button) {
        this.defaultButton = button;
        if (this.defaultButton != null || this.cancelButton != null) {
            this.enableEvents(8L);
        }
    }

    public void processDefaultAction(ActionEvent event) {
        if (this.defaultButton != null) {
            this.defaultButton.down = true;
            this.defaultButton.repaint();
            this.defaultButton.processActionEvent(new ActionEvent(this.defaultButton, event.getID(), event.getActionCommand(), event.getModifiers()));
            this.defaultButton.down = false;
            this.defaultButton.repaint();
        }
    }

    public DButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(DButton button) {
        this.cancelButton = button;
        if (this.defaultButton != null || this.cancelButton != null) {
            this.enableEvents(8L);
        }
    }

    public void processCancelAction(ActionEvent event) {
        if (this.cancelButton != null) {
            this.cancelButton.down = true;
            this.cancelButton.repaint();
            this.cancelButton.processActionEvent(new ActionEvent(this.cancelButton, event.getID(), event.getActionCommand(), event.getModifiers()));
            this.cancelButton.down = false;
            this.cancelButton.repaint();
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setLayout(LayoutManager layout) {
        super.setLayout(layout);
        if (this.contentPane != null) {
            this.contentPane.setLayout(layout);
        }
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    protected void addImpl(Component component, Object constraints, int index) {
        if (component == this.contentPane || component == this.glassPane) {
            super.addImpl(component, constraints, index);
        } else if (component instanceof DPopup) {
            this.glassPane.addImpl(component, constraints, index);
        } else {
            this.contentPane.add(component, constraints, index);
        }
    }

    public void remove(Component component) {
        if (component == this.contentPane || component == this.glassPane) {
            super.remove(component);
        } else if (component instanceof DPopup) {
            this.glassPane.remove(component);
        } else {
            this.contentPane.remove(component);
        }
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void centre() {
        Dimension size = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
    }

    public Dimension getMinimumSize() {
        return this.maxExtent(super.getMinimumSize(), this.getToolkit().getScreenSize());
    }

    public Dimension getPreferredSize() {
        return this.maxExtent(super.getPreferredSize(), this.getToolkit().getScreenSize());
    }

    public Dimension getMaximumSize() {
        return this.maxExtent(super.getMaximumSize(), this.getToolkit().getScreenSize());
    }

    Dimension maxExtent(Dimension d1, Dimension d2) {
        return new Dimension(Math.min(d1.width, d2.width), Math.min(d1.height, d2.height));
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
        if ((flags & 0x20) != 0) {
            this.backgroundImage = image;
            this.repaint();
            return false;
        }
        return (flags & 0x40) == 0;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void doLayout() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.contentPane.setBounds(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        this.glassPane.setBounds(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics gPrime) {
        if (this.myTheme == null) {
            System.out.println("mytheme is null in DDialog");
        }
        Color bgcolor = this.myTheme.getColor("DIALOG_BACKGROUND");
        Image image = this.myTheme.getControlBackgroundImage();
        if (image != null) {
            this.setBackgroundImage(image);
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        if (this.offscreen != null && (this.offscreen.getWidth(null) != bounds.width || this.offscreen.getHeight(null) != bounds.height)) {
            this.offscreen = null;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(bounds.width, bounds.height);
        }
        Rectangle clip = gPrime.getClipBounds();
        Graphics g = this.offscreen.getGraphics();
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        g.setColor(bgcolor);
        g.fillRect(0, 0, bounds.width, bounds.height);
        if (this.backgroundImage != null) {
            Dimension bs = new Dimension(this.backgroundImage.getWidth(this), this.backgroundImage.getHeight(this));
            if (bs.width > -1 && bs.height > -1) {
                Rectangle br = new Rectangle(0, 0, bounds.width, bounds.height);
                DComponent.drawBackgroundImage(g, this.backgroundImage, bounds, bs, br, this.mode, this);
            }
        }
        this.paintImpl(g);
        if (this.offscreen != null) {
            gPrime.drawImage(this.offscreen, 0, 0, this);
        }
        g.dispose();
    }

    protected void paintImpl(Graphics g) {
        super.paint(g);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    protected void processKeyEvent(KeyEvent event) {
        if (!event.isConsumed()) {
            block0 : switch (event.getID()) {
                case 401: {
                    switch (event.getKeyCode()) {
                        case 10: {
                            if (this.defaultButton == null) break block0;
                            this.processDefaultAction(new ActionEvent(this.defaultButton, 1001, this.defaultButton.getActionCommand()));
                            event.consume();
                            break;
                        }
                        case 3: 
                        case 27: {
                            if (this.cancelButton == null) break block0;
                            this.processCancelAction(new ActionEvent(this.cancelButton, 1001, this.cancelButton.getActionCommand()));
                            event.consume();
                            break;
                        }
                    }
                    break;
                }
            }
        }
        super.processKeyEvent(event);
    }

    public DDialog(Frame parent) {
        super(parent);
        this.frame = parent;
        this.initialiseUI();
    }

    public DDialog(Frame parent, String title) {
        super(parent, title);
        this.frame = parent;
        this.initialiseUI();
    }

    public DDialog(Frame parent, String title, Image backgroundImage) {
        super(parent, title);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }

    public DDialog(Frame parent, String title, String backgroundImage) {
        super(parent, title);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }

    public DDialog(Frame parent, String title, URL backgroundImage) {
        super(parent, title);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }

    public DDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.frame = parent;
        this.initialiseUI();
    }

    public DDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.frame = parent;
        this.initialiseUI();
    }

    public DDialog(Frame parent, String title, Image backgroundImage, boolean modal) {
        super(parent, title, modal);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }

    public DDialog(Frame parent, String title, String backgroundImage, boolean modal) {
        super(parent, title, modal);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }

    public DDialog(Frame parent, String title, URL backgroundImage, boolean modal) {
        super(parent, title, modal);
        this.frame = parent;
        this.initialiseUI();
        this.setBackgroundImage(backgroundImage);
    }
}

