/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DComponent;
import dog.util.Referential;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DItem
implements Referential,
ImageObserver {
    private static final Object NULL = new Object();
    protected String label;
    protected Image icon;
    protected Color color;
    protected Object reference;
    protected Hashtable fields;
    protected Vector listeners;

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public String getText() {
        return this.getLabel();
    }

    public void setText(String text) {
        this.setLabel(text);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null && this.label != null || label != null && !label.equals(this.label)) {
            String old = this.label;
            this.label = label;
            this.processPropertyChangeEvent("label", old, label);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        if (icon != null) {
            Image old = this.icon;
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
            if (this.icon != null) {
                this.processPropertyChangeEvent("icon", old, this.icon);
            }
        }
    }

    public void setIcon(String file) {
        if (file != null) {
            Image old = this.icon;
            this.icon = DComponent.getImage(file, (ImageObserver)this);
            if (this.icon != null) {
                this.processPropertyChangeEvent("icon", old, this.icon);
            }
        }
    }

    public void setIcon(URL url) {
        if (url != null) {
            Image old = this.icon;
            this.icon = DComponent.getImage(url, (ImageObserver)this);
            if (this.icon != null) {
                this.processPropertyChangeEvent("icon", old, this.icon);
            }
        }
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
        if ((flags & 0x20) != 0) {
            Image old = this.icon;
            this.icon = image;
            this.processPropertyChangeEvent("icon", old, this.icon);
            return false;
        }
        return (flags & 0x40) == 0;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        if (reference == null && this.reference != null || reference != null && !reference.equals(this.reference)) {
            Object old = this.reference;
            this.reference = reference;
            this.processPropertyChangeEvent("reference", old, reference);
        }
    }

    public synchronized String[] getFieldNames() {
        if (this.fields == null) {
            return new String[0];
        }
        String[] fieldnames = new String[this.fields.size()];
        int count = 0;
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            fieldnames[count++] = (String)enumeration.nextElement();
        }
        return fieldnames;
    }

    public Object getField(String name) {
        if (this.fields == null) {
            return null;
        }
        Object value = this.fields.get(name);
        if (NULL.equals(value)) {
            value = null;
        }
        return value;
    }

    public void addField(String name, Object value) {
        if (this.fields == null) {
            this.fields = new Hashtable();
        }
        if (value == null) {
            value = NULL;
        }
        this.fields.put(name, value);
        this.processPropertyChangeEvent("field", null, name);
    }

    public void removeField(String name) {
        if (this.fields == null) {
            return;
        }
        if (this.fields.containsKey(name)) {
            this.fields.remove(name);
            this.processPropertyChangeEvent("field", name, null);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    protected void processPropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object[] targets = null;
        DItem dItem = this;
        synchronized (dItem) {
            if (this.listeners == null) {
                return;
            }
            targets = new PropertyChangeListener[this.listeners.size()];
            this.listeners.copyInto(targets);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
        int i = 0;
        while (i < targets.length) {
            targets[i].propertyChange(event);
            ++i;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append('[');
        buffer.append(this.paramString());
        buffer.append(']');
        return buffer.toString();
    }

    protected String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("label=");
        buffer.append(this.label);
        if (this.reference != null) {
            buffer.append(",reference=");
            buffer.append(this.reference);
        }
        return buffer.toString();
    }

    public DItem() {
        this("New item", (Image)null, (Object)null);
    }

    public DItem(String label) {
        this(label, (Image)null, (Object)null);
    }

    public DItem(String label, Image icon) {
        this(label, icon, null);
    }

    public DItem(String label, Image icon, Object reference) {
        this.label = label;
        if (icon != null) {
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
        }
        this.reference = reference;
    }

    public DItem(String label, String icon) {
        this(label, icon, null);
    }

    public DItem(String label, String icon, Object reference) {
        this.label = label;
        if (icon != null) {
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
        }
        this.reference = reference;
    }

    public DItem(String label, URL icon) {
        this(label, icon, null);
    }

    public DItem(String label, URL icon, Object reference) {
        this.label = label;
        if (icon != null) {
            this.icon = DComponent.getImage(icon, (ImageObserver)this);
        }
        this.reference = reference;
    }
}

