/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DComponent;
import dog.gui.DTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class DLabel
extends DComponent {
    protected String label;
    protected int align;
    private int max_width = 0;

    public String getText() {
        return this.getLabel();
    }

    public void setText(String label) {
        this.setLabel(label);
    }

    public void setText(String label, int max_width) {
        this.max_width = max_width;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(label) >= max_width) {
            StringTokenizer st = new StringTokenizer(label);
            String s1 = "";
            String test = "";
            String ret = "";
            while (st.hasMoreTokens()) {
                test = st.nextToken(" ");
                if (fm.stringWidth(s1 + test) < max_width) {
                    ret = ret + test + " ";
                    s1 = s1 + test + " ";
                    continue;
                }
                ret = ret + "\n" + test + " ";
                s1 = test + " ";
            }
            this.setLabel(ret + "\n");
        } else {
            this.setLabel(label);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (this.label != null && label == null || label != null && !label.equals(this.label)) {
            String old = this.label;
            this.label = label;
            this.changes.firePropertyChange("label", old, label);
            this.invalidate();
            this.repaint();
        }
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3 && align != 4 && align != 5 && align != 6 && align != 7 && align != 8) {
            throw new IllegalArgumentException("illegal alignment value: " + align);
        }
        this.align = align;
        this.invalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Font getFont() {
        return this.myTheme.getFont("LABEL");
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension ps = new Dimension(0, fm.getHeight() + fm.getDescent());
        int rows = 1;
        if (this.label != null) {
            StringTokenizer st = new StringTokenizer(this.label, "\n", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("\n".equals(token)) {
                    ++rows;
                    continue;
                }
                ps.width = Math.max(ps.width, fm.stringWidth(token));
            }
        }
        if (this.max_width != 0) {
            ps.width = this.max_width;
        }
        ps.height *= rows;
        return ps;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.label != null) {
            Color f;
            DTheme theme = this.myTheme;
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            Rectangle bounds = this.getBounds();
            Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
            if (this.isEnabled()) {
                Color color = theme.getColor("LABEL_TEXT");
            } else {
                f = theme.getColor("LABEL_TEXT_DISABLED");
            }
            g.setFont(font);
            DComponent.drawLabel(g, inside, fm, this.label, this.align, f);
        }
    }

    public String paramString() {
        StringBuffer buffer = new StringBuffer();
        if (this.label != null) {
            buffer.append(",label=");
            buffer.append(this.label);
        }
        buffer.append(",align=");
        buffer.append(this.alignParamString(this.align));
        return buffer.toString();
    }

    public DLabel() {
        this("New label", 4);
    }

    public DLabel(String label) {
        this(label, 4);
    }

    public DLabel(String label, int align) {
        this.label = label;
        this.align = align;
    }
}

