/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DColor;
import dog.gui.DComponent;
import dog.gui.DContainer;
import dog.gui.DItem;
import dog.gui.DScrollbar;
import dog.gui.DTheme;
import dog.gui.ItemCollator;
import dog.gui.TreeValidator;
import dog.util.Tree;
import dog.util.TreeEvent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class DList
extends DContainer
implements ItemSelectable,
AdjustmentListener,
PropertyChangeListener {
    public static final int LIST_VERTICAL = 0;
    public static final int LIST_HORIZONTAL = 1;
    protected static final Dimension MINSMALLICONSIZE = new Dimension(16, 16);
    protected static final Dimension MINLARGEICONSIZE = new Dimension(32, 32);
    public static final int COLUMNS = 2;
    public static final int ICON = 3;
    public static final int COLUMNS_WEIGHTED = 4;
    public static final int LEFT = 4;
    public static final int CENTER = 0;
    public static final int RIGHT = 2;
    public static final String DEFAULT_COLUMN = "";
    protected int mode = 0;
    protected int indent = -1;
    protected boolean multipleMode = false;
    protected boolean singeClickAction = false;
    protected boolean filled = true;
    protected boolean showColumnLines = true;
    protected boolean showTreeLines = false;
    protected boolean selectable = true;
    protected boolean lastItemDeselectable = false;
    protected boolean suppressHorizontalScrollbar = false;
    protected boolean suppressVerticalScrollbar = false;
    View view;
    Hashtable itemStates = new Hashtable();
    DItem selected;
    Vector actionListeners = new Vector();
    Vector itemListeners = new Vector();
    VetoableChangeSupport vetoes = new VetoableChangeSupport(this);
    DScrollbar horizontal;
    protected DScrollbar vertical;
    protected Tree items;
    protected TreeValidator treeValidator;
    protected DateFormat dateFormat;
    protected Vector columns;
    protected Hashtable columnMap;
    protected int columnsWidth;
    protected boolean sorted = false;
    protected Vector indices;
    protected Hashtable descendingMap;
    protected ItemCollator collator;
    private transient Hashtable dateStringCache = new Hashtable();
    private transient Hashtable numberStringCache = new Hashtable();
    private transient String columnToResize;
    private transient String columnToMove;
    private transient int moveTarget = -1;
    private transient int dragStartX = -1;
    private transient int dragStartWidth = 0;
    private int nofDisplayedItems = 10;
    private int headerRows = 1;
    private boolean propertyChangeRepaintingEnabled = true;

    public void setTheme(DTheme myTheme) {
        super.setTheme(myTheme);
        this.vertical.setTheme(myTheme);
        this.horizontal.setTheme(myTheme);
        this.view.setTheme(myTheme);
    }

    public void setHeaderRows(int rows) {
        this.headerRows = rows;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.mode == mode) break;
                this.mode = mode;
                this.invalidate();
                this.validate();
                if (!this.isShowing()) break;
                this.repaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid mode: " + mode);
            }
        }
    }

    public int getIndent() {
        if (this.indent > -1) {
            return this.indent;
        }
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public void setIndent(int indent) {
        this.indent = indent;
        if (this.mode == 2 || this.mode == 4) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public void looseFocus() {
        this.view.focused = null;
        this.repaint();
    }

    public synchronized void setSingleClickAction(boolean flag) {
        this.singeClickAction = flag;
    }

    public synchronized void setMultipleMode(boolean flag) {
        if (this.multipleMode != flag) {
            this.multipleMode = flag;
            if (!flag && this.selectedCount() > 0) {
                this.selected = null;
                Object[] objects = this.items.getTree();
                int i = 0;
                while (i < objects.length) {
                    ItemState state = (ItemState)this.itemStates.get(objects[i]);
                    if (state != null && state.selected) {
                        if (this.selected == null) {
                            this.selected = (DItem)objects[i];
                        }
                        state.selected = false;
                    }
                    ++i;
                }
                this.repaint();
            }
        }
    }

    public boolean isLastItemDeselectable() {
        return this.lastItemDeselectable;
    }

    public void setLastItemDeselectable(boolean flag) {
        if (this.lastItemDeselectable != flag) {
            this.lastItemDeselectable = flag;
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean flag) {
        if (this.selectable != flag) {
            this.selectable = flag;
        }
    }

    public boolean isSuppressHorizontalScrollbar() {
        return this.suppressHorizontalScrollbar;
    }

    public void setSuppressHorizontalScrollbar(boolean flag) {
        if (this.suppressHorizontalScrollbar != flag) {
            this.suppressHorizontalScrollbar = flag;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public boolean isSuppressVerticalScrollbar() {
        return this.suppressVerticalScrollbar;
    }

    public void setSuppressVerticalScrollbar(boolean flag) {
        if (this.suppressVerticalScrollbar != flag) {
            this.suppressVerticalScrollbar = flag;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        if (this.filled != filled) {
            this.filled = filled;
            this.repaint();
        }
    }

    public boolean isShowColumnLines() {
        return this.showColumnLines;
    }

    public void setShowColumnLines(boolean flag) {
        if (this.showColumnLines != flag) {
            this.showColumnLines = flag;
            this.repaint();
        }
    }

    public boolean isShowTreeLines() {
        return this.showTreeLines;
    }

    public void setShowTreeLines(boolean flag) {
        if (this.showTreeLines != flag) {
            this.showTreeLines = flag;
            this.repaint();
        }
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getInstance();
            return this.dateFormat;
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null && this.dateFormat != null || dateFormat != null && this.dateFormat == null || dateFormat != null && !dateFormat.equals(this.dateFormat)) {
            DateFormat old = this.dateFormat;
            this.dateFormat = dateFormat;
            this.flushDateStringCache();
            this.repaint();
            this.changes.firePropertyChange("dateFormat", old, dateFormat);
        }
    }

    protected void addImpl(Component component, Object constraints, int index) {
        if (component != this.horizontal && component != this.vertical && component != this.view) {
            throw new IllegalArgumentException("you can only add items to a list");
        }
        super.addImpl(component, constraints, index);
    }

    public DItem[] getItems() {
        Object[] objects = this.items.getTree();
        DItem[] array = new DItem[objects.length];
        System.arraycopy(objects, 0, array, 0, objects.length);
        return array;
    }

    public int getItemCount() {
        return this.items.getTreeCount();
    }

    public DItem getItem(Object reference) {
        if (reference == null) {
            return null;
        }
        Object[] objects = this.items.getTree();
        DItem[] array = new DItem[objects.length];
        System.arraycopy(objects, 0, array, 0, objects.length);
        int i = 0;
        while (i < array.length) {
            if (reference.equals(array[i].getReference())) {
                return array[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean hasChildren() {
        if (this.lazyCount() > 0) {
            return true;
        }
        return this.items.hasChildren();
    }

    public DItem[] getChildren(DItem parent) {
        Object[] objects = this.items.getChildren(parent);
        DItem[] array = new DItem[objects.length];
        System.arraycopy(objects, 0, array, 0, objects.length);
        return array;
    }

    public boolean hasChildren(DItem parent) {
        if (this.isLazy(parent)) {
            return true;
        }
        return this.items.getChildCount(parent) > 0;
    }

    public int getChildCount(DItem parent) {
        return this.items.getChildCount(parent);
    }

    public DItem getParent(DItem child) {
        return (DItem)this.items.getParent(child);
    }

    public int getDepth(DItem item) {
        return this.items.getDepth(item);
    }

    public DItem[] getRoots() {
        Object[] objects = this.items.getRoots();
        DItem[] roots = new DItem[objects.length];
        System.arraycopy(objects, 0, roots, 0, objects.length);
        return roots;
    }

    public int getRootCount() {
        return this.items.getRootCount();
    }

    public boolean contains(DItem item) {
        return this.items.contains(item);
    }

    public DItem add(DItem item) {
        this.items.add(item);
        item.addPropertyChangeListener(this);
        if (this.sorted) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.items.sort(this.collator);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return item;
    }

    public DItem add(DItem parent, DItem child) {
        this.items.add((Object)parent, child);
        child.addPropertyChangeListener(this);
        if (this.sorted) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.items.sort(this.collator);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return child;
    }

    public DItem[] add(DItem[] items) {
        this.items.add(items);
        int i = 0;
        while (i < items.length) {
            items[i].addPropertyChangeListener(this);
            ++i;
        }
        if (this.sorted) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.items.sort(this.collator);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return items;
    }

    public DItem[] add(DItem parent, DItem[] children) {
        this.items.add((Object)parent, children);
        int i = 0;
        while (i < children.length) {
            children[i].addPropertyChangeListener(this);
            ++i;
        }
        if (this.sorted) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.items.sort(this.collator);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return children;
    }

    public DItem[] replace(DItem[] items) {
        DItem[] old = this.getItems();
        int i = 0;
        while (i < old.length) {
            old[i].removePropertyChangeListener(this);
            ++i;
        }
        this.items.clear();
        this.itemStates.clear();
        this.items.add(items);
        i = 0;
        while (i < items.length) {
            items[i].addPropertyChangeListener(this);
            ++i;
        }
        if (this.sorted) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.items.sort(this.collator);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return items;
    }

    public DItem remove(DItem item) {
        this.items.remove(item);
        item.removePropertyChangeListener(this);
        this.itemStates.remove(item);
        if (item.equals(this.selected)) {
            this.selected = null;
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return item;
    }

    public DItem[] remove(DItem[] items) {
        this.items.remove(items);
        int i = 0;
        while (i < items.length) {
            items[i].removePropertyChangeListener(this);
            this.itemStates.remove(items[i]);
            if (items[i].equals(this.selected)) {
                this.selected = null;
            }
            ++i;
        }
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
        return items;
    }

    public void clear() {
        DItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].removePropertyChangeListener(this);
            ++i;
        }
        this.items.clear();
        this.itemStates.clear();
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void removeChildren(DItem parent) {
        DItem[] children = this.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            children[i].removePropertyChangeListener(this);
            ++i;
        }
        this.items.removeChildren(parent);
        this.view.flush();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public boolean isSelected(DItem item) {
        if (item != null) {
            if (!this.multipleMode) {
                return item.equals(this.selected);
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state != null) {
                return state.selected;
            }
        }
        return false;
    }

    public synchronized DItem setSelected(DItem item, boolean flag) {
        if (this.select(item, flag)) {
            this.repaint();
            return item;
        }
        return null;
    }

    public synchronized DItem[] setSelected(DItem[] items, boolean flag) {
        if (!this.multipleMode) {
            throw new IllegalStateException("list is in single-select mode");
        }
        Vector<DItem> changed = new Vector<DItem>();
        int i = 0;
        while (i < items.length) {
            if (this.select(items[i], flag)) {
                changed.addElement(items[i]);
            }
            ++i;
        }
        if (changed.size() > 0) {
            this.repaint();
        }
        Object[] array = new DItem[changed.size()];
        changed.copyInto(array);
        return array;
    }

    private final boolean select(DItem item, boolean flag) {
        if (item != null) {
            if (!this.contains(item) || !this.selectable) {
                return false;
            }
            if (!this.multipleMode) {
                if (!flag && !this.lastItemDeselectable) {
                    return false;
                }
                ItemState state = (ItemState)this.itemStates.get(item);
                if (state != null && !state.enabled) {
                    return false;
                }
                if (flag) {
                    if (!item.equals(this.selected)) {
                        this.selected = item;
                        return true;
                    }
                    return false;
                }
                if (item.equals(this.selected)) {
                    this.selected = null;
                    return true;
                }
                return false;
            }
            if (!flag && !this.lastItemDeselectable && this.selectedCount() == 1) {
                return false;
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                state = new ItemState();
                this.itemStates.put(item, state);
            }
            if (!state.enabled) {
                return false;
            }
            if (state.selected != flag) {
                state.selected = flag;
                return true;
            }
            state.selected = flag;
            return false;
        }
        return false;
    }

    public synchronized DItem[] getSelected() {
        if (!this.multipleMode) {
            DItem[] selected = new DItem[]{this.selected};
            return this.selected == null ? new DItem[]{} : selected;
        }
        return this.selected();
    }

    private final DItem[] selected() {
        Vector<Object> v = new Vector<Object>(this.items.getTreeCount());
        Object[] objects = this.items.getTree();
        int i = 0;
        while (i < objects.length) {
            ItemState state = (ItemState)this.itemStates.get(objects[i]);
            if (state != null && state.selected) {
                v.addElement(objects[i]);
            }
            ++i;
        }
        Object[] selected = new DItem[v.size()];
        v.copyInto(selected);
        return selected;
    }

    public synchronized int getSelectedCount() {
        if (!this.multipleMode) {
            return this.selected != null ? 1 : 0;
        }
        return this.selectedCount();
    }

    private final int selectedCount() {
        int count = 0;
        Object[] objects = this.items.getTree();
        int i = 0;
        while (i < objects.length) {
            ItemState state = (ItemState)this.itemStates.get(objects[i]);
            if (state != null && state.selected) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public synchronized DItem getCurrent() {
        if (!this.multipleMode) {
            return this.selected;
        }
        if (this.selected == null) {
            DItem[] items = this.selected();
            if (items.length > 0) {
                return items[0];
            }
        } else {
            return this.selected;
        }
        return null;
    }

    public synchronized Object getCurrentReference() {
        if (!this.multipleMode) {
            return this.selected != null ? this.selected.getReference() : null;
        }
        if (this.selected == null) {
            DItem[] items = this.selected();
            if (items.length > 0) {
                return items[0].getReference();
            }
        } else {
            return this.selected != null ? this.selected.getReference() : null;
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        return this.getSelected();
    }

    public boolean isCollapsed(DItem item) {
        ItemState state;
        if (item != null && (state = (ItemState)this.itemStates.get(item)) != null) {
            return state.lazy || state.collapsed;
        }
        return false;
    }

    public synchronized DItem setCollapsed(DItem item, boolean flag) {
        if (this.collapse(item, flag)) {
            this.view.flush();
            this.invalidate();
            this.validate();
            this.repaint();
            return item;
        }
        return null;
    }

    public synchronized DItem[] setCollapsed(DItem[] items, boolean flag) {
        Vector<DItem> changed = new Vector<DItem>();
        int i = 0;
        while (i < items.length) {
            if (this.collapse(items[i], flag)) {
                changed.addElement(items[i]);
            }
            ++i;
        }
        if (changed.size() > 0) {
            this.view.flush();
            this.invalidate();
            this.validate();
            this.repaint();
        }
        Object[] array = new DItem[changed.size()];
        changed.copyInto(array);
        return array;
    }

    private final boolean collapse(DItem item, boolean flag) {
        if (item != null) {
            if (!this.contains(item)) {
                return false;
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                state = new ItemState();
                this.itemStates.put(item, state);
            }
            if (!state.enabled) {
                return false;
            }
            if (state.collapsed != flag) {
                state.collapsed = flag;
                return true;
            }
            state.collapsed = flag;
            return false;
        }
        return false;
    }

    public synchronized void collapseAll() {
        this.collapse(true);
    }

    public synchronized void expandAll() {
        this.collapse(false);
    }

    private final void collapse(boolean flag) {
        DItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            this.collapse(items[i], flag);
            ++i;
        }
        if (items.length > 0) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public synchronized DItem[] getCollapsed() {
        Vector<Object> v = new Vector<Object>(this.items.getTreeCount());
        Object[] objects = this.items.getTree();
        int i = 0;
        while (i < objects.length) {
            ItemState state = (ItemState)this.itemStates.get(objects[i]);
            if (state != null && state.collapsed) {
                v.addElement(objects[i]);
            }
            ++i;
        }
        Object[] collapsed = new DItem[v.size()];
        v.copyInto(collapsed);
        return collapsed;
    }

    public boolean isLazy(DItem item) {
        ItemState state;
        if (item != null && (state = (ItemState)this.itemStates.get(item)) != null) {
            return state.lazy;
        }
        return false;
    }

    public synchronized DItem setLazy(DItem item, boolean flag) {
        if (this.lazify(item, flag)) {
            this.invalidate();
            this.validate();
            this.repaint();
            return item;
        }
        return null;
    }

    public synchronized DItem[] setLazy(DItem[] items, boolean flag) {
        Vector<DItem> changed = new Vector<DItem>();
        int i = 0;
        while (i < items.length) {
            if (this.lazify(items[i], flag)) {
                changed.addElement(items[i]);
            }
            ++i;
        }
        if (changed.size() > 0) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
        Object[] array = new DItem[changed.size()];
        changed.copyInto(array);
        return array;
    }

    private final boolean lazify(DItem item, boolean flag) {
        if (item != null) {
            if (!this.contains(item)) {
                return false;
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                state = new ItemState();
                this.itemStates.put(item, state);
            }
            if (flag && !state.collapsed) {
                state.collapsed = flag;
            }
            if (state.lazy != flag) {
                state.lazy = flag;
                return true;
            }
            state.lazy = flag;
            return false;
        }
        return false;
    }

    private final int lazyCount() {
        int count = 0;
        Object[] objects = this.items.getTree();
        if (objects.length > 0) {
            int i = 0;
            while (i < objects.length) {
                ItemState state = (ItemState)this.itemStates.get(objects[i]);
                if (state != null && state.lazy) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public boolean isEnabled(DItem item) {
        if (item != null) {
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                return true;
            }
            return state.enabled;
        }
        return false;
    }

    public synchronized DItem setEnabled(DItem item, boolean flag) {
        if (this.enable(item, flag)) {
            this.repaint();
            return item;
        }
        return null;
    }

    public synchronized DItem[] setEnabled(DItem[] items, boolean flag) {
        Vector<DItem> changed = new Vector<DItem>();
        int i = 0;
        while (i < items.length) {
            if (this.enable(items[i], flag)) {
                changed.addElement(items[i]);
            }
            ++i;
        }
        if (changed.size() > 0) {
            this.repaint();
        }
        Object[] array = new DItem[changed.size()];
        changed.copyInto(array);
        return array;
    }

    private final boolean enable(DItem item, boolean flag) {
        if (item != null) {
            if (!this.contains(item)) {
                return false;
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                state = new ItemState();
                this.itemStates.put(item, state);
            }
            if (state.enabled != flag) {
                state.enabled = flag;
                return true;
            }
            state.enabled = flag;
            return false;
        }
        return false;
    }

    public int getFontStyle(DItem item) {
        ItemState state;
        if (item != null && (state = (ItemState)this.itemStates.get(item)) != null) {
            return state.fontStyle;
        }
        return -1;
    }

    public synchronized DItem setFontStyle(DItem item, int style) {
        if (this.fontStyle(item, style)) {
            this.repaint();
            return item;
        }
        return null;
    }

    public synchronized DItem[] setFontStyle(DItem[] items, int style) {
        Vector<DItem> changed = new Vector<DItem>();
        int i = 0;
        while (i < items.length) {
            if (this.fontStyle(items[i], style)) {
                changed.addElement(items[i]);
            }
            ++i;
        }
        if (changed.size() > 0) {
            this.repaint();
        }
        Object[] array = new DItem[changed.size()];
        changed.copyInto(array);
        return array;
    }

    private final boolean fontStyle(DItem item, int style) {
        if (item != null) {
            if (!this.contains(item)) {
                return false;
            }
            ItemState state = (ItemState)this.itemStates.get(item);
            if (state == null) {
                state = new ItemState();
                this.itemStates.put(item, state);
            }
            if (state.fontStyle != style) {
                state.fontStyle = style;
                return true;
            }
            state.fontStyle = style;
            return false;
        }
        return false;
    }

    public void scrollTo(DItem item) {
        this.view.setOffset(item);
    }

    public TreeValidator getTreeValidator() {
        return this.treeValidator;
    }

    public void setTreeValidator(TreeValidator validator) {
        this.treeValidator = validator;
    }

    public int getVisibleItemCount() {
        return this.view.getVisibleItemCount();
    }

    public synchronized String[] getColumnNames() {
        Object[] names = new String[this.columns.size()];
        this.columns.copyInto(names);
        return names;
    }

    public Object getColumn(String column) {
        Column lc = (Column)this.columnMap.get(column);
        return lc != null ? lc.content : null;
    }

    public String getColumnLabel(String column) {
        Column lc = (Column)this.columnMap.get(column);
        return lc != null ? lc.label : null;
    }

    public int getColumnWidth(String column) {
        Column lc = (Column)this.columnMap.get(column);
        return lc != null ? Math.abs(lc.width) : -1;
    }

    public int getColumnAlign(String column) {
        Column lc = (Column)this.columnMap.get(column);
        return lc != null ? lc.align : -1;
    }

    public void addColumn(String name) {
        this.addColumn(name, name, -1, 4);
    }

    public void addColumn(String name, int align) {
        this.addColumn(name, name, -1, align);
    }

    public void addColumn(String name, String label) {
        this.addColumn(name, label, -1, 4);
    }

    public void addColumn(String name, String label, int align) {
        this.addColumn(name, label, -1, align);
    }

    public synchronized void addColumn(String name, Object content, int width, int align) {
        if (name == null) {
            throw new NullPointerException("column name is null");
        }
        Column lc = new Column(content, name, width, align);
        if (!this.columns.contains(name)) {
            this.columns.addElement(name);
        }
        this.columnMap.put(name, lc);
        if (this.mode == 2 || this.mode == 4) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public synchronized void removeColumn(String column) {
        if (this.columns.contains(column)) {
            this.columns.removeElement(column);
            this.columnMap.remove(column);
            this.indices.removeElement(column);
            this.descendingMap.remove(column);
            if (this.columns.size() == 0) {
                this.columns.addElement(DEFAULT_COLUMN);
                this.columnMap.put(DEFAULT_COLUMN, new Column(null, DEFAULT_COLUMN, -1, 4));
                this.indices.addElement(DEFAULT_COLUMN);
            }
            this.indicesChanged();
            if (this.mode == 2 || this.mode == 4) {
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public void setDefaultColumnLabel(String s) {
        Column c = (Column)this.columnMap.get(DEFAULT_COLUMN);
        if (c != null) {
            c.label = s;
            c.content = s;
            c.width = -1;
            c.weight = 1;
            this.setWidths();
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setDefaultColumnWidth(int width) {
        Column c = (Column)this.columnMap.get(DEFAULT_COLUMN);
        if (c != null) {
            c.width = width;
            c.weight = width;
            this.setWidths();
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public synchronized void removeAllColumns() {
        this.columns.removeAllElements();
        this.columnMap.clear();
        this.indices.removeAllElements();
        this.descendingMap.clear();
        this.columns.addElement(DEFAULT_COLUMN);
        this.columnMap.put(DEFAULT_COLUMN, new Column(null, DEFAULT_COLUMN, -1, 4));
        this.indices.addElement(DEFAULT_COLUMN);
        this.indicesChanged();
        if (this.mode == 2 || this.mode == 4) {
            if (this.sorted) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.items.sort(this.collator);
                this.setCursor(Cursor.getDefaultCursor());
                this.view.flush();
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public synchronized void moveColumn(String column, int index) {
        int cindex = this.columns.indexOf(column);
        int max = this.columns.size() - 1;
        if (index > cindex) {
            --index;
        }
        if ((index = Math.max(0, Math.min(max, index))) != cindex) {
            this.columns.removeElementAt(cindex);
            this.columns.insertElementAt(column, index);
            if (this.mode == 2 || this.mode == 4) {
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean flag) {
        if (this.sorted != flag) {
            this.sorted = flag;
            if (this.sorted) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.items.sort(this.collator);
                this.setCursor(Cursor.getDefaultCursor());
                this.view.flush();
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public synchronized String[] getIndices() {
        Object[] names = new String[this.indices.size()];
        this.indices.copyInto(names);
        return names;
    }

    public boolean isIndexDescending(String column) {
        Boolean descending = (Boolean)this.descendingMap.get(column);
        if (descending != null) {
            return descending;
        }
        return false;
    }

    public synchronized void addIndex(String column, boolean descending) {
        if (this.columns.contains(column)) {
            if (this.indices.contains(column)) {
                this.indices.removeElement(column);
            }
            this.indices.insertElementAt(column, 0);
            this.descendingMap.put(column, new Boolean(descending));
            this.indicesChanged();
            if (this.mode == 2 || this.mode == 4) {
                if (this.sorted) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.items.sort(this.collator);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.view.flush();
                }
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public synchronized void removeIndex(String column) {
        if (this.indices.contains(column)) {
            this.indices.removeElement(column);
            this.descendingMap.remove(column);
            if (this.indices.size() == 0) {
                this.indices.addElement(DEFAULT_COLUMN);
            }
            this.indicesChanged();
            if (this.mode == 2 || this.mode == 4) {
                if (this.sorted) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.items.sort(this.collator);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.view.flush();
                }
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public synchronized void removeAllIndices() {
        this.indices.removeAllElements();
        this.descendingMap.clear();
        this.indices.addElement(DEFAULT_COLUMN);
        this.indicesChanged();
        if (this.mode == 2 || this.mode == 4) {
            if (this.sorted) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.items.sort(this.collator);
                this.setCursor(Cursor.getDefaultCursor());
                this.view.flush();
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    void indicesChanged() {
        Object[] x = new String[this.indices.size()];
        this.indices.copyInto(x);
        boolean[] d = new boolean[x.length];
        int i = 0;
        while (i < x.length) {
            d[i] = this.isIndexDescending((String)x[i]);
            ++i;
        }
        this.collator.setIndices((String[])x, d);
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    String getDateString(Date date) {
        String cached = (String)this.dateStringCache.get(date);
        if (cached != null) {
            return cached;
        }
        String dateString = this.getDateFormat().format(date);
        this.dateStringCache.put(date, dateString);
        return dateString;
    }

    void flushDateStringCache() {
        this.dateStringCache.clear();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("LIST_BUTTON"));
        Dimension ps = new Dimension(0, 0);
        Dimension is = this.view.getItemSize();
        int hh = this.mode == 2 || this.mode == 4 ? this.headerRows * Math.max(16, fm.getHeight()) + 2 : 0;
        ps.height += hh + is.height * this.nofDisplayedItems;
        ps.width = ps.width + (is.width + (this.getItems().length > 10 ? this.vertical.getPreferredSize().width : 0));
        return ps;
    }

    public void doLayout() {
        int block;
        int unit;
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("LIST_BUTTON"));
        Rectangle bounds = this.getBounds();
        Dimension vs = this.view.getPreferredSize();
        Dimension vps = this.vertical.getPreferredSize();
        Dimension hps = this.horizontal.getPreferredSize();
        Dimension is = this.view.getItemSize();
        int hh = this.mode == 2 || this.mode == 4 ? this.headerRows * Math.max(16, fm.getHeight()) + 4 : 0;
        Rectangle viewport = new Rectangle(3, hh + 3, bounds.width - 6, bounds.height - 6 - hh);
        boolean sv = vs.height > viewport.height && !this.suppressVerticalScrollbar;
        boolean sh = vs.width > viewport.width && !this.suppressHorizontalScrollbar && this.mode != 4;
        viewport.height = viewport.height - (sh ? hps.height : 0);
        viewport.width = viewport.width - (sv ? vps.width : 0);
        if (sv && vs.height > viewport.height) {
            unit = is.height;
            block = viewport.height / unit * unit;
            int extra = viewport.height % unit;
            this.vertical.setParameters(0, vs.height + extra, viewport.height, unit, block);
            this.vertical.setBounds(bounds.width - vps.width - 3, hh + 3, vps.width, bounds.height - hh - 6 - (sh ? hps.height : 0));
            this.vertical.setVisible(true);
        } else {
            this.vertical.setVisible(false);
            this.vertical.setValue(0);
        }
        if (sh && vs.width > viewport.width) {
            unit = 10;
            block = viewport.width;
            this.horizontal.setParameters(0, vs.width, viewport.width, unit, block);
            this.horizontal.setBounds(3, bounds.height - hps.height - 3, bounds.width - 6 - (sv ? vps.width : 0), hps.height);
            this.horizontal.setVisible(true);
        } else {
            this.horizontal.setVisible(false);
            this.horizontal.setValue(0);
        }
        this.view.invalidate();
        this.view.setOffset(-this.horizontal.getValue(), -this.vertical.getValue());
        this.view.setBounds(viewport);
        this.setWidths();
    }

    void setWidths() {
        if (this.mode == 2) {
            FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("LIST_BUTTON"));
            FontMetrics fmField = this.getFontMetrics(this.myTheme.getFont("LIST"));
            Dimension is = this.view.getItemSize();
            int hh = this.mode == 2 || this.mode == 4 ? this.headerRows * Math.max(16, fm.getHeight()) + 2 : 0;
            int totalWidth = 0;
            String[] cols = this.getColumnNames();
            String index = null;
            if (this.sorted && this.indices.size() > 0) {
                index = (String)this.indices.elementAt(0);
            }
            int c = 0;
            while (c < cols.length) {
                Column lc = (Column)this.columnMap.get(cols[c]);
                if (lc.width < 0) {
                    int w = 1;
                    if (lc.content != null) {
                        if (lc.content instanceof String) {
                            w = Math.max(w, fm.stringWidth((String)lc.content) + 4);
                        } else if (lc.content instanceof Image) {
                            Image image = (Image)lc.content;
                            Dimension iis = new Dimension(image.getWidth(this), image.getHeight(this));
                            if (iis.height > hh - 2) {
                                double scale = ((double)hh - 2.0) / (double)iis.height;
                                iis.width = (int)((double)iis.width * scale);
                            }
                            w = Math.max(w, iis.width + 2);
                        } else {
                            w = Math.max(w, fm.stringWidth(lc.content.toString()) + 4);
                        }
                    }
                    DItem[] items = this.getItems();
                    int maxDepth = 0;
                    boolean anyIcons = false;
                    int i = 0;
                    while (i < items.length) {
                        Object field = items[i].getField(cols[c]);
                        if (DEFAULT_COLUMN.equals(cols[c])) {
                            field = items[i].getLabel();
                            maxDepth = Math.max(maxDepth, this.getDepth(items[i]));
                            if (!anyIcons && items[i].getIcon() != null) {
                                anyIcons = true;
                            }
                        }
                        if (field != null) {
                            if (field instanceof String) {
                                w = Math.max(w, fmField.stringWidth((String)field) + 2);
                            } else if (field instanceof Image) {
                                Image image = (Image)field;
                                Dimension iis = new Dimension(image.getWidth(this), image.getHeight(this));
                                if (iis.height > hh - 2) {
                                    double scale = ((double)hh - 2.0) / (double)iis.height;
                                    iis.width = (int)((double)iis.width * scale);
                                }
                                w = Math.max(w, iis.width + 1);
                            } else {
                                w = field instanceof Date ? Math.max(w, fmField.stringWidth(this.getDateString((Date)field)) + 2) : (field instanceof Component ? Math.max(w, ((Component)field).getSize().width + 1) : (field instanceof Boolean ? Math.max(w, is.height) : Math.max(w, fmField.stringWidth(field.toString()) + 2)));
                            }
                        }
                        ++i;
                    }
                    if (anyIcons && items.length > 0) {
                        w += is.height;
                    }
                    if (maxDepth > 0) {
                        if (this.indent < 0) {
                            this.indent = is.height;
                        }
                        w += this.indent * maxDepth;
                    }
                    if (cols[c].equals(index)) {
                        w += Math.max(16, fm.getHeight()) + 2;
                    }
                    lc.width = -(w + 6);
                }
                totalWidth += Math.abs(lc.width);
                ++c;
            }
            int viewWidth = this.view.getSize().width;
            this.columnsWidth = totalWidth;
            if (totalWidth < viewWidth) {
                int x = 0;
                int c2 = 0;
                while (c2 < cols.length) {
                    Column lc = (Column)this.columnMap.get(cols[c2]);
                    if (c2 < cols.length - 1) {
                        x += Math.abs(lc.width);
                    } else {
                        lc.width = lc.width >= 0 ? viewWidth - x : -(viewWidth - x);
                        x += Math.abs(lc.width);
                    }
                    ++c2;
                }
                this.columnsWidth = x;
            }
        } else if (this.mode == 4) {
            Dimension vs = this.view.getSize();
            int totalWeight = 0;
            int weightWidth = vs.width;
            String[] cols = this.getColumnNames();
            int c = 0;
            while (c < cols.length) {
                Column lc = (Column)this.columnMap.get(cols[c]);
                if (lc.weight < 0) {
                    totalWeight -= lc.weight;
                } else {
                    weightWidth -= lc.weight;
                }
                ++c;
            }
            int x = 0;
            int c3 = 0;
            while (c3 < cols.length) {
                Column lc = (Column)this.columnMap.get(cols[c3]);
                if (c3 < cols.length - 1) {
                    lc.width = lc.weight >= 0 ? lc.weight : weightWidth * Math.abs(lc.weight) / totalWeight;
                    x += lc.width;
                } else {
                    lc.width = vs.width - x;
                }
                ++c3;
            }
        }
    }

    public void paint(Graphics g) {
        DTheme theme = this.myTheme;
        Rectangle bounds = this.getBounds();
        Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
        Font font = theme.getFont("LIST_BUTTON");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        Color cBorder = theme.getColor("LIST_BORDER");
        if (!this.isEnabled()) {
            cBorder = DColor.darker(DColor.toGray(cBorder));
        }
        Rectangle clip = g.getClipBounds();
        g.setClip(clip.intersection(inside));
        if (this.mode == 2 || this.mode == 4) {
            int viewWidth;
            Color bText = theme.getColor("LIST_BUTTON_TEXT");
            Color bBorder = theme.getColor("LIST_BUTTON_BORDER");
            Color bBackground = theme.getColor("LIST_BUTTON_BACKGROUND");
            if (!this.isEnabled()) {
                bText = DColor.toGray(bText);
                bBackground = DColor.darker(DColor.toGray(bBackground));
                bBorder = DColor.darker(DColor.toGray(bBorder));
            }
            if (this.columnsWidth < (viewWidth = this.view.getSize().width)) {
                this.setWidths();
            }
            int hh = this.headerRows * Math.max(16, fm.getHeight()) + 2;
            String[] cols = this.getColumnNames();
            String index = this.indices.size() > 0 ? (String)this.indices.elementAt(0) : null;
            int coffset = 0;
            int i = 0;
            while (i < cols.length) {
                Rectangle header;
                int width = this.getColumnWidth(cols[i]) + (i == 0 ? 1 : 0);
                int align = 4;
                Object content = this.getColumn(cols[i]);
                if (this.mode == 4 && i == cols.length - 1) {
                    Rectangle rectangle = new Rectangle(this.view.offset.x + coffset, 0, bounds.width - coffset - 1, hh);
                } else {
                    header = new Rectangle(this.view.offset.x + coffset, 0, Math.abs(width - 2), hh);
                }
                coffset += width;
                g.setClip(header.intersection(clip.intersection(inside)));
                boolean toHighlight = this.columnToMove != null && (cols[i].equals(this.columnToMove) || i == this.moveTarget);
                g.setColor(toHighlight ? DColor.brighter(bBackground) : bBackground);
                g.fillRect(header.x, header.y, header.width, header.height);
                g.setColor(toHighlight ? DColor.brighter(bBorder) : bBorder);
                g.drawRect(header.x, header.y, header.width - 1, header.height - 1);
                ++header.x;
                ++header.y;
                header.width -= 2;
                header.height -= 2;
                if (this.sorted && cols[i].equals(index)) {
                    int extent = header.width < header.height ? header.width : header.height;
                    Rectangle arrow = new Rectangle(header.x + header.width - extent, header.y, extent, header.height);
                    DContainer.drawArrow(g, arrow, true, this.isIndexDescending(index) ? 1 : 3, DColor.darker(DColor.darker(bBackground)), DColor.brighter(DColor.brighter(bBackground)), bBackground);
                    header.width -= extent;
                }
                header.x += 2;
                header.width -= 2;
                if (content == null) {
                    String label = this.getColumnLabel(cols[i]);
                    if (label != null) {
                        DContainer.drawLabel(g, header, fm, label, align, bText);
                    }
                } else if (content instanceof Integer) {
                    DContainer.drawLabel(g, header, fm, ((Integer)content).toString(), align, bText);
                } else if (content instanceof String) {
                    DContainer.drawLabel(g, header, fm, (String)content, align, bText);
                } else if (content instanceof Image) {
                    DContainer.drawImage(g, header, (Image)content, this, align);
                }
                ++i;
            }
        }
        g.setClip(clip);
        super.paint(g);
        int x1 = bounds.x;
        int y1 = this.view.getBounds().y - 3;
        int x2 = bounds.width - 1;
        int y2 = bounds.height - 1;
        Color topLeft1 = cBorder;
        Color topLeft2 = DColor.brighter(topLeft1);
        Color topLeft3 = DColor.brighter(topLeft2);
        Color bottomRight1 = cBorder;
        Color bottomRight2 = DColor.darker(bottomRight1);
        Color bottomRight3 = DColor.darker(bottomRight2);
        g.setColor(topLeft1);
        g.drawLine(x1 + 2, y1 + 2, x2 - 2, y1 + 2);
        g.drawLine(x1 + 2, y1 + 2, x1 + 2, y2 - 2);
        g.setColor(topLeft2);
        g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
        g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
        g.setColor(topLeft3);
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x1, y1, x1, y2);
        g.setColor(bottomRight1);
        g.drawLine(x1 + 2, y2 - 2, x2 - 2, y2 - 2);
        g.drawLine(x2 - 2, y1 + 2, x2 - 2, y2 - 2);
        g.setColor(bottomRight2);
        g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
        g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
        g.setColor(bottomRight3);
        g.drawLine(x1, y2, x2, y2);
        g.drawLine(x2, y1, x2, y2);
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.actionListeners.addElement(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.actionListeners.removeElement(listener);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.itemListeners.addElement(listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.itemListeners.removeElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoes.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoes.removeVetoableChangeListener(listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else if (event instanceof FocusEvent) {
            this.view.requestFocus();
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        Object[] al = null;
        DList dList = this;
        synchronized (dList) {
            al = new ActionListener[this.actionListeners.size()];
            this.actionListeners.copyInto(al);
        }
        int i = 0;
        while (i < al.length) {
            al[i].actionPerformed(event);
            ++i;
        }
    }

    protected void processItemEvent(ItemEvent event) {
        Object[] il = null;
        DList dList = this;
        synchronized (dList) {
            il = new ItemListener[this.itemListeners.size()];
            this.itemListeners.copyInto(il);
        }
        int i = 0;
        while (i < il.length) {
            il[i].itemStateChanged(event);
            ++i;
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        block0 : switch (event.getID()) {
            case 500: {
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                if (!this.sorted || this.mode != 2 && this.mode != 4) break;
                int xoffset = this.view.offset.x;
                String[] cols = this.getColumnNames();
                int i = 0;
                while (i < cols.length) {
                    if (point.x < (xoffset += this.getColumnWidth(cols[i]))) {
                        boolean descending = false;
                        String[] indexNames = this.getIndices();
                        if (indexNames.length > 0 && indexNames[0].equals(cols[i])) {
                            descending = !this.isIndexDescending(cols[i]);
                        }
                        this.addIndex(cols[i], descending);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 501: {
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                if (this.mode != 2) break;
                int xoffset = this.view.offset.x;
                String[] cols = this.getColumnNames();
                int i = 0;
                while (i < cols.length) {
                    if (point.x >= (xoffset += this.getColumnWidth(cols[i])) - 3 && point.x < xoffset + 3) {
                        this.columnToResize = cols[i];
                        this.dragStartWidth = this.getColumnWidth(cols[i]);
                        this.dragStartX = xoffset;
                        this.repaint();
                        break block0;
                    }
                    if (point.x < xoffset) {
                        this.columnToMove = cols[i];
                        this.moveTarget = i;
                        this.dragStartX = xoffset;
                        this.repaint();
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 502: {
                if (!this.isEnabled()) break;
                this.columnToResize = null;
                if (this.columnToMove != null) {
                    this.moveColumn(this.columnToMove, this.moveTarget);
                }
                this.columnToMove = null;
                this.moveTarget = -1;
                this.dragStartX = -1;
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                if (this.columnToResize != null) {
                    int dw = point.x - this.dragStartX;
                    Column lc = (Column)this.columnMap.get(this.columnToResize);
                    lc.width = Math.max(4, Math.abs(this.dragStartWidth) + dw);
                    this.invalidate();
                    this.validate();
                    this.repaint();
                    break;
                }
                if (this.columnToMove == null) break;
                int xoffset = this.view.offset.x;
                this.moveTarget = -1;
                String[] cols = this.getColumnNames();
                int i = 0;
                while (i < cols.length) {
                    int w = this.getColumnWidth(cols[i]);
                    if (point.x < (xoffset += w) - w / 2) {
                        this.moveTarget = i;
                        break;
                    }
                    ++i;
                }
                if (this.moveTarget < 0) {
                    this.moveTarget = cols.length;
                }
                this.repaint();
                break;
            }
            case 503: {
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                boolean overColumnBoundary = false;
                if (this.mode == 2) {
                    int xoffset = this.view.offset.x;
                    String[] cols = this.getColumnNames();
                    int i = 0;
                    while (i < cols.length) {
                        if (point.x >= (xoffset += this.getColumnWidth(cols[i])) - 3 && point.x < xoffset + 3) {
                            overColumnBoundary = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (overColumnBoundary) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    protected void processSelection(DItem item, int modifiers, int clickCount) {
        boolean change;
        boolean doubleClick = clickCount > 1;
        boolean selected = doubleClick || !this.isSelected(item);
        boolean bl = change = this.setSelected(item, selected) != null;
        if (change) {
            this.processItemEvent(new ItemEvent(this, 701, item, selected ? 1 : 2));
        }
        if (doubleClick || this.singeClickAction) {
            this.processActionEvent(new ActionEvent(this, 1001, item.getText()));
        }
    }

    public void setPropertyChangeRepaintingEnabled(boolean enabled) {
        this.propertyChangeRepaintingEnabled = enabled;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("label".equals(name) || "icon".equals(name) || (this.mode == 2 || this.mode == 4) && "field".equals(name) && this.columns.contains(event.getNewValue())) {
            this.view.flush();
            if (this.propertyChangeRepaintingEnabled) {
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        this.view.setOffset(-this.horizontal.getValue(), -this.vertical.getValue());
        this.repaint();
    }

    public String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        buffer.append(",mode=");
        buffer.append(this.mode);
        buffer.append(",indent=");
        buffer.append(this.indent);
        buffer.append(",multipleMode=");
        buffer.append(this.multipleMode);
        buffer.append(",sorted=");
        buffer.append(this.sorted);
        return buffer.toString();
    }

    public DList() {
        this(false, 0);
    }

    public DList(boolean multipleMode) {
        this(multipleMode, 0);
    }

    public DList(int mode) {
        this(false, mode);
    }

    public DList(boolean multipleMode, int mode) {
        this.items = new Tree();
        this.collator = new ItemCollator();
        this.columns = new Vector();
        this.columns.addElement(DEFAULT_COLUMN);
        this.columnMap = new Hashtable();
        this.columnMap.put(DEFAULT_COLUMN, new Column(null, DEFAULT_COLUMN, -1, 4));
        this.indices = new Vector();
        this.indices.addElement(DEFAULT_COLUMN);
        this.descendingMap = new Hashtable();
        this.descendingMap.put(DEFAULT_COLUMN, new Boolean(false));
        this.multipleMode = multipleMode;
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid mode: " + mode);
            }
        }
        this.view = new View(this);
        this.add(this.view);
        this.vertical = new DScrollbar(1);
        this.add(this.vertical);
        this.horizontal = new DScrollbar(0);
        this.add(this.horizontal);
        this.vertical.setTheme(this.myTheme);
        this.horizontal.setTheme(this.myTheme);
        this.view.setTheme(this.myTheme);
        this.vertical.addAdjustmentListener(this);
        this.horizontal.addAdjustmentListener(this);
        this.enableEvents(48L);
    }

    public DList(boolean multipleMode, int mode, int nofDisplayedItems) {
        this(multipleMode, mode);
        this.nofDisplayedItems = nofDisplayedItems;
    }

    class Column {
        protected Object content;
        protected int width = -1;
        protected int weight = -1;
        protected int align = 4;
        String label = null;

        protected Column(Object content, String label, int width, int align) {
            switch (align) {
                case 0: 
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    align = 4;
                }
            }
            this.content = content;
            this.width = width;
            this.weight = width;
            this.align = align;
            this.label = label;
        }
    }

    class ItemState {
        protected boolean selected = false;
        protected boolean collapsed = false;
        protected boolean enabled = true;
        protected boolean lazy = false;
        protected int fontStyle = -1;

        ItemState() {
        }
    }

    class View
    extends DComponent {
        DList list;
        transient DItem down;
        transient Image offscreen;
        Point offset = new Point(0, 0);
        transient int ih = 16;
        transient int iw = 0;
        transient DItem[] items;
        transient boolean clean = false;
        transient boolean focus = false;
        transient DItem focused;
        transient Dimension ps;

        void flush() {
            this.items = null;
            this.ps = null;
            this.clean = false;
        }

        DItem[] getItems() {
            if (this.items != null) {
                return this.items;
            }
            long tm = System.currentTimeMillis();
            Vector<DItem> v = new Vector<DItem>();
            DItem[] roots = this.list.getRoots();
            int i = 0;
            while (i < roots.length) {
                v.addElement(roots[i]);
                if (!this.list.isCollapsed(roots[i])) {
                    this.addChildren(v, roots[i]);
                }
                ++i;
            }
            this.items = new DItem[v.size()];
            v.copyInto(this.items);
            return this.items;
        }

        void addChildren(Vector v, DItem parent) {
            DItem[] children = this.list.getChildren(parent);
            int i = 0;
            while (i < children.length) {
                v.addElement(children[i]);
                if (!this.list.isCollapsed(children[i])) {
                    this.addChildren(v, children[i]);
                }
                ++i;
            }
        }

        void setOffset(int x, int y) {
            this.offset.x = x;
            this.offset.y = y;
            this.repaint();
        }

        void setOffset(DItem item) {
            DItem[] items = this.getItems();
            int index = -1;
            switch (this.list.mode) {
                case 0: 
                case 2: 
                case 4: {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] == item) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index <= -1) break;
                    if (index * this.ih < -this.offset.y) {
                        int value = index * this.ih;
                        DList.this.vertical.setValue(value);
                        this.offset.y = -value;
                        break;
                    }
                    Dimension size = this.getSize();
                    if (index * this.ih < -this.offset.y + size.height) break;
                    int value = index * this.ih - size.height + this.ih;
                    DList.this.vertical.setValue(value);
                    this.offset.y = -value;
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
            }
            this.repaint();
        }

        public int getIndent() {
            int indent = this.list.getIndent();
            if (indent > -1) {
                return indent;
            }
            return this.getFontMetrics(this.myTheme.getFont("LIST")).getHeight();
        }

        protected Dimension getItemSize() {
            FontMetrics fm;
            Dimension d = new Dimension(0, 0);
            DItem[] items = this.getItems();
            Font font = this.myTheme.getFont("LIST");
            if (font != null && (fm = this.getFontMetrics(font)) != null) {
                d.height = fm.getHeight();
                int i = 0;
                while (i < items.length) {
                    String label = items[i].getLabel();
                    if (label != null) {
                        d.width = Math.max(d.width, fm.stringWidth(label) + 16);
                    }
                    ++i;
                }
            }
            if (d.width == 0) {
                d.width = 64;
            }
            if (d.height == 0) {
                d.height = 16;
            }
            this.ps = d;
            return d;
        }

        public Dimension getPreferredSize() {
            long time = System.currentTimeMillis();
            FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("LIST"));
            DItem[] items = this.getItems();
            int indent = this.getIndent();
            this.ih = Math.max(DList.MINSMALLICONSIZE.height + 1, fm.getHeight());
            Dimension ps = new Dimension(0, this.ih * items.length);
            boolean anyChildren = this.list.hasChildren();
            switch (this.list.mode) {
                case 0: 
                case 1: {
                    int i = 0;
                    while (i < items.length) {
                        int w = anyChildren ? indent * this.list.getDepth(items[i]) : 0;
                        w += this.ih + 1;
                        String label = items[i].getLabel();
                        if (label != null) {
                            int lw = fm.stringWidth(label);
                            w += lw;
                        }
                        this.iw = ps.width > w ? ps.width : w;
                        ps.width = this.iw;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    break;
                }
                case 2: 
                case 4: {
                    if (!this.clean) {
                        this.list.setWidths();
                        this.clean = true;
                    }
                    String[] cols = this.list.getColumnNames();
                    int i = 0;
                    while (i < cols.length) {
                        int w = this.list.getColumnWidth(cols[i]);
                        ps.width += w;
                        ++i;
                    }
                    break;
                }
            }
            return ps;
        }

        int getVisibleItemCount() {
            Dimension size = this.getSize();
            return size.height / this.ih;
        }

        public void paint(Graphics g) {
            DTheme theme = this.myTheme;
            Font font = theme.getFont("LIST");
            FontMetrics fm = this.getFontMetrics(font);
            Rectangle bounds = this.getBounds();
            Rectangle clip = g.getClipBounds();
            Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
            Rectangle visible = new Rectangle(-this.offset.x, -this.offset.y, inside.width, inside.height);
            boolean enabled = this.list.isEnabled();
            Color cText = theme.getColor("LIST_TEXT");
            Color cBackground = theme.getColor("LIST_BACKGROUND");
            Color cBorder = theme.getColor("LIST_BORDER");
            Color sText = theme.getColor("LIST_SELECTED_TEXT");
            Color sBackground = theme.getColor("LIST_SELECTED_BACKGROUND");
            if (!DList.this.isEnabled()) {
                cText = DColor.toGray(cText);
                cBackground = DColor.darker(DColor.toGray(cBackground));
                cBorder = DColor.darker(DColor.toGray(cBorder));
                sText = DColor.toGray(sText);
                sBackground = DColor.darker(DColor.toGray(sBackground));
            }
            Color dText = DColor.toGray(cText);
            Image ubgi = theme.getUserBackgroundImage();
            String fontName = font.getName();
            int fontSize = font.getSize();
            Font plainFont = null;
            Font boldFont = null;
            Font italicFont = null;
            Font boldItalicFont = null;
            if (this.list.isFilled()) {
                if (ubgi != null) {
                    Dimension bs = new Dimension(ubgi.getWidth(this), ubgi.getHeight(this));
                    Rectangle br = new Rectangle(0, 0, bounds.width, bounds.height);
                    DComponent.drawBackgroundImage(g, ubgi, inside, bs, br, 11, this);
                } else {
                    g.setColor(cBackground);
                    g.fillRect(0, 0, inside.width, inside.height);
                }
            }
            boolean listHasChildren = this.list.hasChildren();
            DItem[] items = this.getItems();
            int indent = this.getIndent();
            boolean anyIcons = false;
            int i = 0;
            while (i < items.length) {
                if (items[i].getIcon() != null) {
                    anyIcons = true;
                }
                ++i;
            }
            int lh = fm.getHeight();
            switch (this.list.mode) {
                case 0: {
                    int start = -this.offset.y / this.ih;
                    int dstart = -this.offset.y / this.ih;
                    int length = start + visible.height / this.ih + 2;
                    if (DList.this.showTreeLines) {
                        start = start - length < 0 ? 0 : start - length;
                        length += length;
                    }
                    g.setClip(clip.intersection(inside));
                    int i2 = start;
                    while (i2 < length) {
                        boolean itemEnabled;
                        if (i2 >= items.length) break;
                        DItem item = items[i2];
                        ItemState state = (ItemState)this.list.itemStates.get(item);
                        boolean selected = this.list.multipleMode ? (state != null ? state.selected : false) : item.equals(this.list.selected);
                        boolean collapsed = state != null ? state.collapsed : false;
                        boolean bl = itemEnabled = state != null ? state.enabled : true;
                        if (state != null && state.fontStyle > -1) {
                            switch (state.fontStyle) {
                                case 0: {
                                    if (plainFont == null) {
                                        plainFont = new Font(fontName, 0, fontSize);
                                    }
                                    g.setFont(plainFont);
                                    break;
                                }
                                case 1: {
                                    if (boldFont == null) {
                                        boldFont = new Font(fontName, 1, fontSize);
                                    }
                                    g.setFont(boldFont);
                                    break;
                                }
                                case 2: {
                                    if (italicFont == null) {
                                        italicFont = new Font(fontName, 2, fontSize);
                                    }
                                    g.setFont(italicFont);
                                    break;
                                }
                                case 3: {
                                    if (boldItalicFont == null) {
                                        boldItalicFont = new Font(fontName, 3, fontSize);
                                    }
                                    g.setFont(boldItalicFont);
                                    break;
                                }
                                default: {
                                    g.setFont(font);
                                    break;
                                }
                            }
                        } else {
                            g.setFont(font);
                        }
                        boolean itemHasChildren = this.list.hasChildren(item);
                        Rectangle r = new Rectangle(0, (i2 - dstart) * this.ih - this.offset.y, visible.width, this.ih);
                        r.y += this.offset.y % this.ih;
                        if (selected) {
                            g.setColor(sBackground);
                            g.fillRect(r.x, this.offset.y + r.y, r.width, r.height);
                        }
                        if (this.focus && this.focused == item) {
                            g.setColor(sText);
                            g.drawRect(r.x, this.offset.y + r.y, r.width - 1, r.height - 1);
                        }
                        int depth = this.list.getDepth(item);
                        int xoffset = indent * depth - indent;
                        if (listHasChildren) {
                            xoffset += indent;
                        }
                        if (anyIcons) {
                            Rectangle ir = new Rectangle(r.x + xoffset, r.y, this.ih - 1, this.ih - 1);
                            this.paintIcon(g, ir, this.offset, item.getIcon());
                            xoffset += ir.width + 1;
                        }
                        String label = item.getLabel();
                        Color nText = item.getColor();
                        if (label != null) {
                            int ascent = fm.getAscent();
                            int ly = (this.ih - lh) / 2 + ascent;
                            g.setColor(!itemEnabled ? dText : (enabled && selected && this.focus ? sText : (nText == null ? cText : nText)));
                            g.drawString(label, this.offset.x + r.x + xoffset, this.offset.y + r.y + ly);
                        }
                        ++i2;
                    }
                    g.setClip(clip);
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 2: 
                case 4: {
                    int cstart = -this.offset.y / this.ih;
                    int cdstart = -this.offset.y / this.ih;
                    int clength = cstart + visible.height / this.ih + 2;
                    if (DList.this.showTreeLines) {
                        cstart = cstart - clength < 0 ? 0 : cstart - clength;
                        clength += clength;
                    }
                    String[] cols = this.list.getColumnNames();
                    int i3 = cstart;
                    while (i3 < clength) {
                        if (i3 < items.length) {
                            boolean itemEnabled;
                            DItem item = items[i3];
                            ItemState state = (ItemState)this.list.itemStates.get(item);
                            boolean selected = this.list.multipleMode ? (state != null ? state.selected : false) : item.equals(this.list.selected);
                            boolean collapsed = state != null ? state.collapsed : false;
                            boolean bl = itemEnabled = state != null ? state.enabled : true;
                            if (state != null && state.fontStyle > -1) {
                                switch (state.fontStyle) {
                                    case 0: {
                                        if (plainFont == null) {
                                            plainFont = new Font(fontName, 0, fontSize);
                                        }
                                        g.setFont(plainFont);
                                        break;
                                    }
                                    case 1: {
                                        if (boldFont == null) {
                                            boldFont = new Font(fontName, 1, fontSize);
                                        }
                                        g.setFont(boldFont);
                                        break;
                                    }
                                    case 2: {
                                        if (italicFont == null) {
                                            italicFont = new Font(fontName, 2, fontSize);
                                        }
                                        g.setFont(italicFont);
                                        break;
                                    }
                                    case 3: {
                                        if (boldItalicFont == null) {
                                            boldItalicFont = new Font(fontName, 3, fontSize);
                                        }
                                        g.setFont(boldItalicFont);
                                        break;
                                    }
                                    default: {
                                        g.setFont(font);
                                        break;
                                    }
                                }
                            } else {
                                g.setFont(font);
                            }
                            boolean itemHasChildren = this.list.hasChildren(item);
                            Rectangle r = new Rectangle(0, (i3 - cdstart) * this.ih - this.offset.y, visible.width, this.ih);
                            r.y += this.offset.y % this.ih;
                            if (selected) {
                                g.setColor(sBackground);
                                g.fillRect(r.x, this.offset.y + r.y, r.width, r.height);
                            }
                            if (this.focus && this.focused == item) {
                                g.setColor(sText);
                                g.drawRect(r.x, this.offset.y + r.y, r.width - 1, r.height - 1);
                            }
                            int coffset = 0;
                            int j = 0;
                            while (j < cols.length) {
                                boolean def = cols[j].equals(DList.DEFAULT_COLUMN);
                                int width = this.list.getColumnWidth(cols[j]);
                                int depth = this.list.getDepth(item);
                                int xoffset = coffset + (def ? indent * depth - indent : 0);
                                String content = def ? item.getLabel() : item.getField(cols[j]);
                                Rectangle cr = new Rectangle(this.offset.x + r.x + xoffset, this.offset.y + r.y, (coffset += width) - xoffset, this.ih);
                                g.setClip(cr.intersection(clip.intersection(inside)));
                                if (def) {
                                    if (listHasChildren) {
                                        xoffset += indent;
                                    }
                                    if (anyIcons) {
                                        Rectangle ir = new Rectangle(r.x + xoffset, r.y, this.ih - 1, this.ih - 1);
                                        this.paintIcon(g, ir, this.offset, item.getIcon());
                                        xoffset += ir.width + 1;
                                    }
                                }
                                if (content != null) {
                                    int align = this.list.getColumnAlign(cols[j]);
                                    if (content instanceof Integer) {
                                        content = ((Integer)((Object)content)).toString();
                                    }
                                    if (content instanceof Date) {
                                        content = this.list.getDateString((Date)((Object)content));
                                    }
                                    if (content instanceof String) {
                                        int ascent = fm.getAscent();
                                        int ly = (this.ih - lh) / 2 + ascent;
                                        String label = content;
                                        if (align == 2 && !def) {
                                            int lw = fm.stringWidth(label);
                                            xoffset = coffset - lw - 1;
                                        } else if (align == 0 && !def) {
                                            int lw = fm.stringWidth(label);
                                            xoffset = coffset - width + (width - lw) / 2;
                                        }
                                        Color nText = item.getColor();
                                        g.setColor(!itemEnabled ? dText : (nText == null ? (enabled && selected && this.focus ? sText : cText) : nText));
                                        g.drawString(label, this.offset.x + r.x + xoffset, this.offset.y + r.y + ly);
                                    } else if (content instanceof Image) {
                                        DComponent.drawImage(g, cr, (Image)((Object)content), this, align);
                                    } else if (content instanceof Boolean && ((Boolean)((Object)content)).booleanValue()) {
                                        int max = Math.min(this.ih, lh);
                                        Rectangle box = new Rectangle(align == 2 ? cr.x + cr.width - max + 1 : (align == 0 ? cr.x + (cr.width - max) / 2 : cr.x + 1), cr.y + (cr.height - max) / 2 + 1, max - 2, max - 2);
                                        Color c1 = !itemEnabled ? dText : (enabled && selected && this.focus ? sText : cText);
                                        DComponent.drawTick(g, box, c1);
                                    }
                                }
                                ++j;
                            }
                            g.setClip(clip.intersection(inside));
                        }
                        ++i3;
                    }
                    if (this.list.showColumnLines) {
                        int coffset = 0;
                        g.setColor(cBorder);
                        int j = 0;
                        while (j < cols.length) {
                            int width = this.list.getColumnWidth(cols[j]);
                            g.drawLine(this.offset.x + coffset + width - 1, 0, this.offset.x + coffset + width - 1, visible.height);
                            coffset += width;
                            ++j;
                        }
                    }
                    g.setClip(clip);
                    break;
                }
            }
        }

        private final void paintIcon(Graphics g, Rectangle bounds, Point offset, Image icon) {
            if (icon != null) {
                double scale;
                Rectangle r = new Rectangle(0, 0, icon.getWidth(this), icon.getHeight(this));
                if (r.width > bounds.width) {
                    scale = (double)bounds.width / (double)r.width;
                    r.width = (int)((double)r.width * scale);
                    r.height = (int)((double)r.height * scale);
                }
                if (r.height > bounds.height) {
                    scale = (double)bounds.height / (double)r.height;
                    r.width = (int)((double)r.width * scale);
                    r.height = (int)((double)r.height * scale);
                }
                r.x = bounds.x + (bounds.width - r.width) / 2;
                r.y = bounds.y + (bounds.height - r.height) / 2;
                g.drawImage(icon, offset.x + r.x, offset.y + r.y, r.width, r.height, this);
            }
        }

        public boolean isFocusTraversable() {
            return this.list.isEnabled() && DList.this.selectable;
        }

        protected void processFocusEvent(FocusEvent event) {
            switch (event.getID()) {
                case 1004: {
                    if (!this.list.isEnabled()) break;
                    this.focus = true;
                    this.repaint();
                    break;
                }
                case 1005: {
                    if (!this.list.isEnabled()) break;
                    this.focus = false;
                    this.repaint();
                    break;
                }
            }
            super.processFocusEvent(event);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void processKeyEvent(KeyEvent event) {
            block0 : switch (event.getID()) {
                case 401: {
                    block3 : switch (event.getKeyCode()) {
                        case 37: {
                            switch (this.list.mode) {
                                case 0: 
                                case 2: 
                                case 4: {
                                    DItem[] items = this.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        if (items[i] == this.focused && i > 0) {
                                            this.focused = items[i - 1];
                                            this.setOffset(this.focused);
                                            this.repaint();
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.focused != null || items.length <= 0) break block3;
                                    this.focused = items[0];
                                    this.repaint();
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 39: {
                            switch (this.list.mode) {
                                case 0: 
                                case 2: 
                                case 4: {
                                    DItem[] items = this.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        if (items[i] == this.focused && i + 1 < items.length) {
                                            this.focused = items[i + 1];
                                            this.setOffset(this.focused);
                                            this.repaint();
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.focused != null || items.length <= 0) break block3;
                                    this.focused = items[0];
                                    this.repaint();
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 38: {
                            switch (this.list.mode) {
                                case 0: 
                                case 2: 
                                case 4: {
                                    DItem[] items = this.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        if (items[i] == this.focused && i > 0) {
                                            this.focused = items[i - 1];
                                            this.setOffset(this.focused);
                                            this.repaint();
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.focused != null || items.length <= 0) break block3;
                                    this.focused = items[0];
                                    this.repaint();
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 40: {
                            switch (this.list.mode) {
                                case 0: 
                                case 2: 
                                case 4: {
                                    DItem[] items = this.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        if (items[i] == this.focused && i + 1 < items.length) {
                                            this.focused = items[i + 1];
                                            this.setOffset(this.focused);
                                            this.repaint();
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.focused != null || items.length <= 0) break block3;
                                    this.focused = items[0];
                                    this.repaint();
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 36: {
                            break;
                        }
                        case 35: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 33: {
                            break;
                        }
                        case 32: {
                            if (this.focused == null) break;
                            this.list.processSelection(this.focused, event.getModifiers(), 1);
                            break;
                        }
                        case 10: {
                            if (this.focused == null) break;
                            this.list.processSelection(this.focused, event.getModifiers(), 2);
                            break;
                        }
                    }
                    break;
                }
            }
            super.processKeyEvent(event);
        }

        protected void processMouseEvent(MouseEvent event) {
            switch (event.getID()) {
                case 500: {
                    Point point;
                    DItem item;
                    if (!this.list.isEnabled() || (item = this.getItemAtPoint(point = event.getPoint())) == null) break;
                    if ((this.list.mode == 0 || this.list.mode == 2 || this.list.mode == 4) && this.list.hasChildren(item)) {
                        int xoffset = 0;
                        if (this.list.mode == 2 || this.list.mode == 4) {
                            String[] cols = this.list.getColumnNames();
                            int i = 0;
                            while (i < cols.length) {
                                if (DList.DEFAULT_COLUMN.equals(cols[i])) break;
                                xoffset += this.list.getColumnWidth(cols[i]);
                                ++i;
                            }
                        }
                        int collapseWidth = this.getIndent() * this.list.getDepth(item);
                        if (point.x >= this.offset.x + xoffset && point.x <= this.offset.x + xoffset + collapseWidth) {
                            boolean collapsed;
                            boolean bl = collapsed = !this.list.isCollapsed(item);
                            if (DList.this.isLazy(item) && DList.this.treeValidator != null) {
                                DList.this.treeValidator.validate(this.list, item);
                                this.list.setLazy(item, false);
                                if (this.list.hasChildren(item)) {
                                    this.flush();
                                }
                            }
                            if (this.list.setCollapsed(item, collapsed) != null) {
                                if (collapsed) {
                                    this.list.processItemEvent(new TreeEvent(this.list, 701, item, 3));
                                } else {
                                    this.list.processItemEvent(new TreeEvent(this.list, 701, item, 4));
                                }
                            }
                            return;
                        }
                    }
                    if (!this.list.selectable) break;
                    this.list.processSelection(item, event.getModifiers(), event.getClickCount());
                    break;
                }
                case 501: {
                    if (!this.list.isEnabled()) break;
                    this.requestFocus();
                    Point point = event.getPoint();
                    DItem item = this.getItemAtPoint(point);
                    if (item == null) break;
                    this.focused = item;
                    if (this.list.hasChildren(item) && (this.list.mode == 0 || this.list.mode == 2 || this.list.mode == 4)) {
                        int xoffset = this.offset.x;
                        if (this.list.mode == 2) {
                            String[] cols = this.list.getColumnNames();
                            int i = 0;
                            while (i < cols.length) {
                                if (DList.DEFAULT_COLUMN.equals(cols[i])) break;
                                xoffset += this.list.getColumnWidth(cols[i]);
                                ++i;
                            }
                        }
                        int collapseWidth = this.getIndent() * this.list.getDepth(item);
                        if (point.x >= xoffset && point.x <= xoffset + collapseWidth) {
                            this.down = item;
                        }
                    }
                    this.repaint();
                    break;
                }
                case 502: {
                    if (!this.list.isEnabled()) break;
                    this.down = null;
                    this.repaint();
                    break;
                }
            }
            super.processMouseEvent(event);
        }

        private final DItem getItemAtPoint(Point point) {
            int py = point.y - this.offset.y % this.ih;
            int start = -this.offset.y / this.ih;
            int off = py / this.ih;
            if (this.items == null) {
                return null;
            }
            if (start + off >= this.items.length || start + off < 0) {
                return null;
            }
            return this.items[start + off];
        }

        View(DList list) {
            if (list == null) {
                throw new NullPointerException("list is null");
            }
            this.list = list;
            this.enableEvents(28L);
        }
    }
}

