/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DColor;
import dog.gui.DComponent;
import dog.gui.DItem;
import dog.gui.DPopup;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class DMenu
extends DPopup {
    protected static final Dimension MINSMALLICONSIZE = new Dimension(16, 16);
    private Dimension preferredSize = null;
    Vector items = new Vector();
    DItem selected;
    transient DItem[] ic;
    transient int ih = 16;
    transient DItem current;
    Vector actionListeners = new Vector();
    DMenu parentMenu;
    DMenu subMenu;
    DItem parentItem;

    void flush() {
        this.ic = null;
    }

    public void add(DItem item) {
        this.items.addElement(item);
        this.flush();
    }

    public void add(DItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.items.addElement(items[i]);
            ++i;
        }
        this.flush();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public DItem[] getItems() {
        if (this.ic != null) {
            return this.ic;
        }
        Object[] i = null;
        Vector vector = this.items;
        synchronized (vector) {
            i = new DItem[this.items.size()];
            this.items.copyInto(i);
        }
        this.ic = i;
        return i;
    }

    public DItem getSelected() {
        return this.selected;
    }

    public boolean hasSubMenus() {
        DItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Object ref = items[i].getReference();
            if (ref != null && ref instanceof DMenu) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DItem getParentItem() {
        return this.parentItem;
    }

    public void dispose() {
        super.dispose();
        if (this.parentMenu != null) {
            this.parentMenu.setVisible(false);
            this.parentMenu.dispose();
        }
    }

    void showSubMenu(DItem item) {
        DMenu menu;
        this.hideSubMenu();
        this.hideOnFocusLost = false;
        this.subMenu = menu = (DMenu)item.getReference();
        this.subMenu.parentMenu = this;
        this.subMenu.parentItem = item;
        this.subMenu.nudge.y = this.getOffset(item);
        Dimension psize = this.subMenu.getPreferredSize();
        DRootPane root = this.getRootPane();
        Insets rinsets = root.getInsets();
        int rWidth = root.getSize().width - rinsets.left - rinsets.right;
        Rectangle bounds = this.getBounds();
        int dWidth = rWidth - bounds.x - bounds.width;
        if (dWidth < psize.width) {
            this.subMenu.setConstraints(this, 4, 1001);
        } else {
            this.subMenu.setConstraints(this, 2, 1001);
        }
        this.subMenu.setVisible(true);
    }

    void hideSubMenu() {
        if (this.subMenu != null) {
            this.subMenu.setVisible(false);
        }
        this.hideOnFocusLost = true;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("MENU"));
            DItem[] items = this.getItems();
            this.ih = Math.max(DMenu.MINSMALLICONSIZE.height + 1, fm.getHeight());
            Dimension ps = new Dimension(0, 0);
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof Separator) {
                    ps.height += 4;
                } else {
                    int w = this.ih * 2 + 1;
                    String label = items[i].getLabel();
                    if (label != null) {
                        w += fm.stringWidth(label);
                    }
                    ps.height += this.ih;
                    ps.width = ps.width > w ? ps.width : w;
                }
                ++i;
            }
            ps.width += 4;
            ps.height += 4;
            return ps;
        }
        return this.preferredSize;
    }

    public void fit() {
        this.setSize(this.getPreferredSize());
        super.fit();
    }

    public void paint(Graphics g) {
        DTheme theme = this.myTheme;
        Color cBackground = theme.getColor("MENU_BACKGROUND");
        Color cBorder = theme.getColor("MENU_BORDER");
        Color cText = theme.getColor("MENU_TEXT");
        Font font = this.myTheme.getFont("MENU");
        FontMetrics fm = this.getFontMetrics(font);
        Rectangle bounds = this.getBounds();
        Rectangle clip = g.getClipBounds();
        Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
        boolean enabled = this.isEnabled();
        if (!enabled) {
            cText = DColor.toGray(cText);
            cBackground = DColor.darker(DColor.toGray(cBackground));
        }
        g.setFont(font);
        g.setColor(cBackground);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.setColor(cBorder);
        g.drawRect(inside.x, inside.y, inside.width - 1, inside.height - 1);
        DItem[] items = this.getItems();
        int ascent = fm.getAscent();
        int yoffset = inside.y + 2;
        int i = 0;
        while (i < items.length) {
            DItem item = items[i];
            boolean sel = this.selected == item;
            Rectangle r = new Rectangle(inside.x + 1, yoffset, inside.width - 2, this.ih);
            if (item instanceof Separator) {
                g.setColor(cBorder);
                g.drawLine(r.x, r.y + 1, r.x + r.width - 1, r.y + 1);
                yoffset += 3;
            } else {
                Object ref;
                if (sel) {
                    g.setColor(cText);
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                int xoffset = 0;
                Rectangle ir = new Rectangle(r.x + xoffset, r.y, this.ih, this.ih);
                Image icon = item.getIcon();
                if (icon != null) {
                    Rectangle ir2 = new Rectangle(0, 0, icon.getWidth(this), icon.getHeight(this));
                    if (ir2.width > -1 && ir2.height > -1) {
                        double scale;
                        if (ir2.width > ir.width) {
                            scale = (double)ir.width / (double)ir2.width;
                            ir2.width = (int)((double)ir2.width * scale);
                            ir2.height = (int)((double)ir2.height * scale);
                        }
                        if (ir2.height > ir.height) {
                            scale = (double)ir.height / (double)ir2.height;
                            ir2.width = (int)((double)ir2.width * scale);
                            ir2.height = (int)((double)ir2.height * scale);
                        }
                        ir2.x = ir.x + (ir.width - ir2.width) / 2;
                        ir2.y = ir.y + (ir.height - ir2.height) / 2;
                        g.drawImage(icon, ir2.x, ir2.y, this);
                    }
                }
                xoffset += ir.width + 1;
                String label = item.getLabel();
                if (label != null) {
                    g.setColor(sel ? cBackground : cText);
                    g.drawString(label, r.x + xoffset, r.y + ascent);
                }
                if ((ref = item.getReference()) != null && ref instanceof DMenu) {
                    Rectangle ar = new Rectangle(r.x + r.width - this.ih - 1, r.y, this.ih, this.ih);
                    Color c = sel ? cText : cBackground;
                    DComponent.drawArrow(g, ar, true, 2, DColor.darker(DColor.darker(c)), DColor.brighter(DColor.brighter(c)), c);
                }
                yoffset += r.height;
            }
            ++i;
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.actionListeners.addElement(listener);
        }
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.actionListeners.removeElement(listener);
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processActionEvent(ActionEvent event) {
        Object[] al = null;
        DMenu dMenu = this;
        synchronized (dMenu) {
            al = new ActionListener[this.actionListeners.size()];
            this.actionListeners.copyInto(al);
        }
        int i = 0;
        while (i < al.length) {
            al[i].actionPerformed(event);
            ++i;
        }
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    protected void processKeyEvent(KeyEvent event) {
        block0 : switch (event.getID()) {
            case 401: {
                switch (event.getKeyCode()) {
                    case 37: 
                    case 38: {
                        DItem[] items = this.getItems();
                        if (items.length <= 0) break block0;
                        if (this.selected == null) {
                            this.selected = items[0];
                        } else {
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].equals(this.selected) && i > 0) {
                                    this.selected = items[i - 1];
                                    this.repaint();
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                            this.showSubMenu(this.selected);
                        } else {
                            this.hideSubMenu();
                        }
                        event.consume();
                        break;
                    }
                    case 39: 
                    case 40: {
                        DItem[] items = this.getItems();
                        if (items.length <= 0) break block0;
                        if (this.selected == null) {
                            this.selected = items[0];
                        } else {
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].equals(this.selected) && i < items.length - 1) {
                                    this.selected = items[i + 1];
                                    this.repaint();
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                            this.showSubMenu(this.selected);
                        } else {
                            this.hideSubMenu();
                        }
                        event.consume();
                        break;
                    }
                    case 36: {
                        DItem[] items = this.getItems();
                        if (items.length <= 0) break block0;
                        this.selected = items[0];
                        if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                            this.showSubMenu(this.selected);
                        } else {
                            this.hideSubMenu();
                        }
                        this.repaint();
                        event.consume();
                        break;
                    }
                    case 35: {
                        DItem[] items = this.getItems();
                        if (items.length <= 0) break block0;
                        this.selected = items[items.length - 1];
                        if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                            this.showSubMenu(this.selected);
                        } else {
                            this.hideSubMenu();
                        }
                        this.repaint();
                        event.consume();
                        break;
                    }
                    case 34: {
                        this.invalidate();
                        this.validate();
                        this.repaint();
                        event.consume();
                        break;
                    }
                    case 33: {
                        this.invalidate();
                        this.validate();
                        this.repaint();
                        event.consume();
                        break;
                    }
                    case 10: {
                        if (this.selected != null) {
                            if (this.selected.getReference() instanceof DMenu) {
                                this.showSubMenu(this.selected);
                            } else {
                                String command = this.selected.getLabel();
                                if (this.selected.getReference() instanceof String) {
                                    command = (String)this.selected.getReference();
                                }
                                this.processActionEvent(new ActionEvent(this, 1001, command));
                            }
                        }
                        event.consume();
                        break;
                    }
                    case 3: 
                    case 27: {
                        break;
                    }
                }
                break;
            }
        }
        super.processKeyEvent(event);
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 504: {
                if (!this.isEnabled()) break;
                this.selected = this.getItemAtPoint(event.getPoint());
                if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                    this.showSubMenu(this.selected);
                    break;
                }
                this.hideSubMenu();
                break;
            }
            case 505: {
                this.setVisible(false);
                if (!this.isEnabled()) break;
                this.selected = null;
                break;
            }
            case 501: {
                if (!this.isEnabled()) break;
                this.current = this.selected;
                break;
            }
            case 502: {
                DItem item;
                if (!this.isEnabled() || (item = this.getItemAtPoint(event.getPoint())) == null || item != this.current) break;
                if (item.getReference() instanceof DMenu) {
                    this.showSubMenu(item);
                    break;
                }
                String command = item.getLabel();
                if (item.getReference() instanceof String) {
                    command = (String)item.getReference();
                }
                this.processActionEvent(new ActionEvent(this, 1001, command));
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                if (!this.isEnabled()) break;
                this.selected = this.getItemAtPoint(event.getPoint());
                if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                    this.showSubMenu(this.selected);
                } else {
                    this.hideSubMenu();
                }
                this.repaint();
                break;
            }
            case 503: {
                if (!this.isEnabled()) break;
                this.selected = this.getItemAtPoint(event.getPoint());
                if (this.selected != null && this.selected.getReference() instanceof DMenu) {
                    this.showSubMenu(this.selected);
                } else {
                    this.hideSubMenu();
                }
                this.repaint();
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    int getOffset(DItem item) {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("MENU"));
        int th = fm.getHeight();
        int offset = 0;
        DItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == item) {
                return offset;
            }
            offset += th + 1;
            ++i;
        }
        return -1;
    }

    private final DItem getItemAtPoint(Point point) {
        DItem[] items = this.getItems();
        int y = 2;
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof Separator) {
                y += 4;
            } else {
                if (point.y >= y && point.y < y + this.ih) {
                    return items[i];
                }
                y += this.ih;
            }
            ++i;
        }
        return null;
    }

    public Separator createSeparator() {
        return new Separator();
    }

    public void setMenuSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
    }

    public DMenu(DRootPane root) {
        super(root);
        this.enableEvents(60L);
    }

    public class Separator
    extends DItem {
        public String getLabel() {
            return "-";
        }
    }
}

