/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DComponent;
import dog.gui.DItem;
import dog.gui.DMenu;
import dog.gui.DPopup;
import dog.gui.DTheme;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class DMenubar
extends DComponent {
    static final Dimension MINSMALLICONSIZE = new Dimension(16, 16);
    Vector items = new Vector();
    DItem selected;
    DMenu menu;
    Vector actionListeners = new Vector();
    private transient DItem[] ic;
    private transient int ih;
    transient boolean down = false;

    public void add(DItem item) {
        this.items.addElement(item);
        this.flush();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void add(DItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.items.addElement(items[i]);
            ++i;
        }
        this.flush();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void clear() {
        this.items.removeAllElements();
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.selected != null) {
            this.selected = null;
        }
        this.flush();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    void flush() {
        this.ic = null;
    }

    public DItem[] getItems() {
        if (this.ic != null) {
            return this.ic;
        }
        Object[] i = null;
        Vector vector = this.items;
        synchronized (vector) {
            i = new DItem[this.items.size()];
            this.items.copyInto(i);
        }
        this.ic = i;
        return i;
    }

    public DItem getSelected() {
        return this.selected;
    }

    protected void select(DItem item, int xoffset) {
        if (this.menu != null) {
            this.menu.setVisible(false);
            this.menu = null;
            this.selected = null;
        }
        if (item != null) {
            this.selected = item;
            Object ref = this.selected.getReference();
            if (ref instanceof DMenu) {
                this.menu = (DMenu)ref;
                Dimension size = this.getSize();
                this.menu.nudge.x = xoffset;
                this.menu.selected = null;
                this.menu.setConstraints(this, DPopup.BELOW, DPopup.RESIZE);
                this.menu.setVisible(true);
            }
            this.down = true;
        } else {
            this.down = false;
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.ih = Math.max(DMenubar.MINSMALLICONSIZE.height + 1, fm.getHeight());
        Dimension ps = new Dimension(0, 0);
        ps.height = this.ih;
        DItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            int w = this.ih * 2 + 1;
            String label = items[i].getLabel();
            if (label != null) {
                w += fm.stringWidth(label);
            }
            ps.width += w;
            ++i;
        }
        ps.width += 4;
        ps.height += 4;
        return ps;
    }

    public void paint(Graphics g) {
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        Rectangle bounds = this.getBounds();
        Rectangle clip = g.getClipBounds();
        Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
        boolean enabled = this.isEnabled();
        DTheme theme = this.myTheme;
        Color mb = theme.getColor("MENUBAR_BACKGROUND");
        Color mf = theme.getColor("MENUBAR_TEXT");
        Color msb = theme.getColor("MENUBAR_SELECTED_BACKGROUND");
        Color msf = theme.getColor("MENUBAR_SELECTED_TEXT");
        Color mdf = theme.getColor("MENUBAR_DISABLED_TEXT");
        Color sb = theme.getColor("MENUBAR_TEXT_BOTTOM_LINE");
        Color sf = theme.getColor("MENUBAR_TEXT_TOP_LINE");
        Color mbl = theme.getColor("MENUBAR_BOTTOM_LINE");
        g.setColor(mbl);
        g.drawLine(inside.x + 4, inside.y + inside.height - 2, inside.x + inside.width - 5, inside.y + inside.height - 2);
        int th = fm.getHeight();
        int ascent = fm.getAscent();
        this.ih = Math.max(DMenubar.MINSMALLICONSIZE.height + 1, th);
        DItem[] items = this.getItems();
        Rectangle r = new Rectangle(inside.x + 1, inside.y + 1, 0, this.ih);
        int i = 0;
        while (i < items.length) {
            boolean sel;
            String label = items[i].getLabel();
            r.width = this.ih * 2 + 2;
            if (label != null) {
                r.width += fm.stringWidth(label);
            }
            if (sel = items[i].equals(this.selected)) {
                g.setColor(msb);
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(sf);
                g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
                g.setColor(sb);
                g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
            }
            int xoffset = 0;
            Rectangle ir = new Rectangle(r.x + xoffset, r.y, this.ih - 1, this.ih - 1);
            Image icon = items[i].getIcon();
            if (icon != null) {
                double scale;
                Rectangle ir2 = new Rectangle(0, 0, icon.getWidth(this), icon.getHeight(this));
                if (ir2.width > ir.width) {
                    scale = (double)ir.width / (double)ir2.width;
                    ir2.width = (int)((double)ir2.width * scale);
                    ir2.height = (int)((double)ir2.height * scale);
                }
                if (ir2.height > ir.height) {
                    scale = (double)ir.height / (double)ir2.height;
                    ir2.width = (int)((double)ir2.width * scale);
                    ir2.height = (int)((double)ir2.height * scale);
                }
                ir2.x = ir.x + (ir.width - ir2.width) / 2;
                ir2.y = ir.y + (ir.height - ir2.height) / 2;
                g.drawImage(icon, ir2.x, ir2.y, ir2.width, ir2.height, this);
            }
            xoffset += ir.width + 1;
            if (label != null) {
                g.setColor(enabled ? (sel ? msf : mf) : mdf);
                g.drawString(label, r.x + xoffset, r.y + ascent);
            }
            r.x += r.width;
            ++i;
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.actionListeners.addElement(listener);
        }
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.actionListeners.removeElement(listener);
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processActionEvent(ActionEvent event) {
        Object[] al = null;
        DMenubar dMenubar = this;
        synchronized (dMenubar) {
            al = new ActionListener[this.actionListeners.size()];
            this.actionListeners.copyInto(al);
        }
        int i = 0;
        while (i < al.length) {
            al[i].actionPerformed(event);
            ++i;
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        DItem item = null;
        int xoffset = 0;
        block0 : switch (event.getID()) {
            case 501: {
                if (!this.down) {
                    Point p = event.getPoint();
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    DItem[] items = this.getItems();
                    Dimension size = this.getSize();
                    Rectangle r = new Rectangle(1, 1, 0, size.height);
                    int i = 0;
                    while (i < items.length) {
                        String label = items[i].getLabel();
                        r.width = this.ih * 2 + 2;
                        if (label != null) {
                            r.width += fm.stringWidth(label);
                        }
                        if (r.x <= p.x && r.x + r.width > p.x) {
                            item = items[i];
                            xoffset = r.x;
                            break;
                        }
                        r.x += r.width;
                        ++i;
                    }
                }
                this.select(item, xoffset);
                break;
            }
            case 502: {
                if (!this.down) break;
                Point p = event.getPoint();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                DItem[] items = this.getItems();
                Dimension size = this.getSize();
                Rectangle r = new Rectangle(1, 1, 0, size.height);
                int i = 0;
                while (i < items.length) {
                    String label = items[i].getLabel();
                    r.width = this.ih * 2 + 2;
                    if (label != null) {
                        r.width += fm.stringWidth(label);
                    }
                    if (r.x <= p.x && r.x + r.width > p.x) {
                        item = items[i];
                        xoffset = r.x;
                        if (this.menu == null || item != this.selected || p.y <= r.height) break block0;
                        MouseEvent event2 = new MouseEvent(this.menu, event.getID(), System.currentTimeMillis(), event.getModifiers(), p.x - r.x, p.y - r.height, event.getClickCount(), event.isPopupTrigger());
                        this.menu.processMouseEvent(event2);
                        this.repaint();
                        return;
                    }
                    r.x += r.width;
                    ++i;
                }
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 503: 
            case 506: {
                DItem item = null;
                int xoffset = 0;
                if (this.down) {
                    Point p = event.getPoint();
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    DItem[] items = this.getItems();
                    Dimension size = this.getSize();
                    Rectangle r = new Rectangle(1, 1, 0, size.height);
                    int i = 0;
                    while (i < items.length) {
                        String label = items[i].getLabel();
                        r.width = this.ih * 2 + 2;
                        if (label != null) {
                            r.width += fm.stringWidth(label);
                        }
                        if (r.x <= p.x && r.x + r.width > p.x) {
                            item = items[i];
                            xoffset = r.x;
                            if (this.menu == null || item != this.selected || p.y <= r.height) break;
                            MouseEvent event2 = new MouseEvent(this.menu, event.getID(), System.currentTimeMillis(), event.getModifiers(), p.x - r.x, p.y - r.height, event.getClickCount(), event.isPopupTrigger());
                            this.menu.processMouseMotionEvent(event2);
                            this.menu.current = this.menu.selected;
                            this.repaint();
                            return;
                        }
                        r.x += r.width;
                        ++i;
                    }
                }
                this.select(item, xoffset);
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    public DMenubar() {
        this.enableEvents(48L);
    }
}

