/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DContainer;
import dog.gui.DFrame;
import dog.gui.DMenubar;
import dog.gui.DRootPane;
import dog.gui.DWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class DPopup
extends DContainer
implements ComponentListener {
    public static final int NONE = -1;
    public static final int ABOVE = 1;
    public static final int BELOW = 3;
    public static final int RIGHT = 2;
    public static final int LEFT = 4;
    public static final int RESIZE = 1000;
    public static final int MOVE = 1001;
    public static final int COMPONENT = -1000;
    private static boolean useNativeWindows = false;
    protected Component component;
    protected Window componentWindow;
    protected int position = 3;
    protected int fitMode = 1000;
    protected int width = -1;
    protected int height = -1;
    protected boolean hideOnFocusLost = true;
    private DRootPane root;
    private DWindow window;
    Point nudge = new Point(0, 0);

    private final void testNativeWindowCapability() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && sm.getClass().getName().indexOf("Applet") > -1) {
                throw new SecurityException("in applet");
            }
            if (this.getToolkit().getClass().getName().equals("sun.awt.motif.MToolkit")) {
                throw new SecurityException("Sun Motif toolkit has window focus bug");
            }
        }
        catch (SecurityException e) {
            useNativeWindows = false;
        }
    }

    public void setVisible(boolean flag) {
        if (flag) {
            if (this.component != null) {
                this.component.addComponentListener(this);
            }
            if (useNativeWindows) {
                if (this.window == null) {
                    this.window = new DWindow(this.root.getFrame());
                }
                this.window.add("Center", this);
                if (this.component != null) {
                    this.componentWindow = DPopup.getWindow(this.component);
                    if (this.componentWindow != null) {
                        this.componentWindow.addComponentListener(this);
                    }
                }
                this.fit();
                super.setVisible(true);
                ((Component)this.window).setVisible(true);
                this.window.toFront();
                this.requestFocus();
            } else {
                this.root.add(this);
                this.fit();
                this.validate();
                super.setVisible(true);
                this.requestFocus();
            }
        } else {
            if (this.component != null) {
                this.component.removeComponentListener(this);
                if (this.component instanceof DMenubar) {
                    DMenubar menubar = (DMenubar)this.component;
                    menubar.selected = null;
                    menubar.down = false;
                    if (menubar.isShowing()) {
                        menubar.repaint();
                    }
                }
            }
            if (useNativeWindows) {
                if (this.componentWindow != null) {
                    this.componentWindow.removeComponentListener(this);
                }
                ((Component)this.window).setVisible(false);
                super.setVisible(false);
            } else {
                super.setVisible(false);
                this.root.remove(this);
            }
        }
    }

    public void setConstraints(Component component, int position, int fitMode) {
        this.setConstraints(component, position, fitMode, -1, -1);
    }

    public void setConstraints(Component component, int position, int fitMode, int width, int height) {
        this.component = component;
        this.position = position;
        this.fitMode = fitMode;
        this.width = width;
        this.height = height;
        Dimension ps = this.getPreferredSize();
        this.setSize(width < 0 && width != -1000 ? ps.width : width, height < 0 && height != -1000 ? ps.height : height);
        this.setLocation(this.getOffset());
    }

    private final void setComponent(Component component) {
        if (this.component != null) {
            this.component.removeComponentListener(this);
            if (this.componentWindow != null) {
                this.componentWindow.removeComponentListener(this);
            }
        }
        this.component = component;
    }

    private static final Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return DPopup.getWindow(component.getParent());
    }

    public void setSize(int width, int height) {
        Dimension csize;
        Dimension dimension = csize = this.component != null ? this.component.getSize() : null;
        if (width == -1000 && this.component != null) {
            width = csize.width;
        }
        if (height == -1000 && this.component != null) {
            height = csize.height;
        }
        super.setSize(width, height);
    }

    public void fit() {
        Dimension screen;
        Rectangle bounds = this.getBounds();
        Dimension dimension = screen = useNativeWindows ? this.getToolkit().getScreenSize() : this.root.getSize();
        if (!useNativeWindows) {
            Insets insets = this.root.getInsets();
            screen.width -= insets.left + insets.right;
            screen.height -= insets.top + insets.bottom;
        }
        int diffx = Math.max(0, bounds.x + bounds.width - screen.width);
        int diffy = Math.max(0, bounds.y + bounds.height - screen.height);
        if (diffx > 0 || diffy > 0) {
            switch (this.fitMode) {
                case 1000: {
                    this.setSize(bounds.width - diffx, bounds.height - diffy);
                    this.invalidate();
                    break;
                }
                case 1001: {
                    if (!useNativeWindows) {
                        Insets insets = this.root.getInsets();
                        diffx += insets.left;
                        diffy += insets.top;
                    }
                    this.setLocation(bounds.x - diffx, bounds.y - diffy);
                    bounds = this.getBounds();
                    diffx = Math.max(0, bounds.x + bounds.width - screen.width);
                    diffy = Math.max(0, bounds.y + bounds.height - screen.height);
                    if (diffx <= 0 && diffy <= 0) break;
                    this.setSize(bounds.width - diffx, bounds.height - diffy);
                    this.invalidate();
                    break;
                }
            }
        }
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            font = this.root.getFont();
        }
        return font;
    }

    public void dispose() {
        this.setVisible(false);
        this.removeAll();
        if (this.window != null) {
            this.window.dispose();
        }
    }

    protected void paintBackground(Graphics g) {
        Color bg = this.myTheme.getColor("POPUP_BACKGROUND");
        Dimension size = this.getSize();
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        super.paint(g);
    }

    public Point getOffset() {
        Dimension size = this.getSize();
        Point p = DPopup.getOffset(this.component);
        switch (this.position) {
            case 1: {
                p.y -= size.height - 1;
                break;
            }
            case 3: {
                p.y += this.component.getSize().height - 1;
                break;
            }
            case 2: {
                p.x += this.component.getSize().width - 1;
                break;
            }
            case 4: {
                p.x -= size.width - 1;
                break;
            }
        }
        p.x += this.nudge.x;
        p.y += this.nudge.y;
        return p;
    }

    public static Point getOffset(Component component) {
        Point p = component.getLocation();
        Container c = component.getParent();
        while (c != null) {
            if (!useNativeWindows && c instanceof DRootPane) {
                Insets insets = c.getInsets();
                p.x -= insets.left;
                p.y -= insets.top;
                if (!(c instanceof DFrame)) break;
                DFrame frame = (DFrame)c;
                if (frame.menubar == null || !frame.menubar.isVisible()) break;
                p.y -= frame.menubar.getSize().height - 1;
                break;
            }
            Point p2 = c.getLocation();
            p.x += p2.x;
            p.y += p2.y;
            if (useNativeWindows && c instanceof Window) break;
            c = c.getParent();
        }
        return p;
    }

    protected void processFocusEvent(FocusEvent event) {
        switch (event.getID()) {
            case 1005: {
                if (!this.hideOnFocusLost) break;
                this.setVisible(false);
                break;
            }
        }
        super.processFocusEvent(event);
    }

    protected void processKeyEvent(KeyEvent event) {
        block0 : switch (event.getID()) {
            case 402: {
                switch (event.getKeyCode()) {
                    case 3: 
                    case 27: {
                        this.setVisible(false);
                        if (this.component == null || !this.component.isFocusTraversable()) break block0;
                        this.component.requestFocus();
                        break;
                    }
                }
                break;
            }
        }
        super.processKeyEvent(event);
    }

    public void componentResized(ComponentEvent event) {
        if (this.component != null) {
            this.setLocation(this.getOffset());
            if (this.window != null) {
                this.window.toFront();
            }
        }
    }

    public void componentMoved(ComponentEvent event) {
        if (this.component != null) {
            this.setLocation(this.getOffset());
            if (this.window != null) {
                this.window.toFront();
            }
        }
    }

    public void componentShown(ComponentEvent event) {
        this.setVisible(true);
        if (this.window != null) {
            this.window.toFront();
        }
    }

    public void componentHidden(ComponentEvent event) {
        this.setVisible(false);
        if (this.window != null) {
            this.window.toFront();
        }
    }

    public DPopup(DRootPane root) {
        this.root = root;
        super.setVisible(false);
        if (useNativeWindows) {
            this.testNativeWindowCapability();
        }
        this.enableEvents(12L);
    }
}

