/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DColor;
import dog.gui.DComponent;
import dog.gui.DTheme;
import dog.util.Timer;
import dog.util.TimerEvent;
import dog.util.TimerListener;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class DScrollbar
extends DComponent
implements Adjustable,
TimerListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected static int PREFERREDWIDTH = 16;
    private static final int NONE = -1;
    private static final int VALUE = 0;
    private static final int UNITDECREMENT = 1;
    private static final int UNITINCREMENT = 2;
    private static final int BLOCKDECREMENT = 3;
    private static final int BLOCKINCREMENT = 4;
    protected int value = 0;
    protected int maximum = 100;
    protected int minimum = 0;
    protected int visibleAmount = 10;
    protected int orientation = 1;
    protected int unitIncrement = 10;
    protected int blockIncrement = 10;
    protected boolean dimpled = false;
    protected Object reference;
    protected transient AdjustmentListener adjustmentListener;
    private Rectangle valueRect;
    private Rectangle unitDecrementRect;
    private Rectangle unitIncrementRect;
    private Rectangle blockIncrementRect;
    private Rectangle blockDecrementRect;
    private int down = -1;
    private Timer timer;
    private Point mouseDownPoint;
    private int mouseDownValue = 0;
    private int mouseDownExtent = 0;

    public int getOrientation() {
        return this.orientation;
    }

    public synchronized void setOrientation(int orientation) {
        if (orientation != this.orientation) {
            switch (orientation) {
                case 0: 
                case 1: {
                    int old = this.orientation;
                    this.orientation = orientation;
                    this.changes.firePropertyChange("orientation", new Integer(old), new Integer(orientation));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal scrollbar orientation");
                }
            }
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
                parent.repaint();
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public synchronized void setValue(int value) {
        this.setValues(value, this.visibleAmount, this.minimum, this.maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public synchronized void setMinimum(int minimum) {
        this.setValues(this.value, this.visibleAmount, minimum, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public synchronized void setMaximum(int maximum) {
        this.setValues(this.value, this.visibleAmount, this.minimum, maximum);
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public synchronized void setVisibleAmount(int visibleAmount) {
        this.setValues(this.value, visibleAmount, this.minimum, this.maximum);
    }

    public synchronized void setUnitIncrement(int unitIncrement) {
        this.setParameters(this.minimum, this.maximum, this.visibleAmount, unitIncrement, this.blockIncrement);
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public synchronized void setBlockIncrement(int blockIncrement) {
        this.setParameters(this.minimum, this.maximum, this.visibleAmount, this.unitIncrement, blockIncrement);
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public synchronized void setParameters(int minimum, int maximum, int visibleAmount, int unitIncrement, int blockIncrement) {
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (visibleAmount > maximum - minimum) {
            visibleAmount = maximum - minimum;
        }
        if (visibleAmount < 1) {
            visibleAmount = 1;
        }
        if (this.value < minimum) {
            this.value = minimum;
        }
        if (this.value > maximum - visibleAmount) {
            this.value = maximum - visibleAmount;
        }
        if (blockIncrement > maximum - minimum) {
            blockIncrement = maximum - minimum;
        }
        if (unitIncrement > blockIncrement) {
            unitIncrement = blockIncrement;
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.visibleAmount = visibleAmount;
        this.unitIncrement = unitIncrement;
        this.blockIncrement = blockIncrement;
        this.repaint();
    }

    public synchronized void setValues(int value, int visibleAmount, int minimum, int maximum) {
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (visibleAmount > maximum - minimum) {
            visibleAmount = maximum - minimum;
        }
        if (visibleAmount < 1) {
            visibleAmount = 1;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum - visibleAmount) {
            value = maximum - visibleAmount;
        }
        this.value = value;
        this.visibleAmount = visibleAmount;
        this.minimum = minimum;
        this.maximum = maximum;
        this.repaint();
    }

    public boolean isDimpled() {
        return this.dimpled;
    }

    public void setDimpled(boolean flag) {
        if (this.dimpled != flag) {
            this.dimpled = flag;
            this.repaint();
        }
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.orientation == 1 ? PREFERREDWIDTH : PREFERREDWIDTH * 4, this.orientation == 1 ? PREFERREDWIDTH * 4 : PREFERREDWIDTH);
    }

    public boolean isDragging() {
        return this.down == 0;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        DTheme theme = this.myTheme;
        Color c = theme.getControl();
        Color h = theme.getControlHighlight();
        Color ds = theme.getControlDarkShadow();
        Color pc = theme.getPrimaryControl();
        Color button = theme.getColor("SCROLLBAR_BUTTON");
        Color background = theme.getColor("SCROLLBAR_BACKGROUND");
        if (!this.isEnabled()) {
            background = DColor.darker(DColor.toGray(background));
            button = DColor.darker(DColor.toGray(button));
        }
        boolean yep = this.maximum - this.minimum > 0;
        switch (this.orientation) {
            case 1: {
                int vh;
                int buttonHeight = Math.min(bounds.width, bounds.height / 2);
                int fieldHeight = bounds.height - buttonHeight * 2;
                this.unitDecrementRect = new Rectangle(0, 0, bounds.width, buttonHeight);
                this.unitIncrementRect = new Rectangle(0, bounds.height - buttonHeight, bounds.width, buttonHeight);
                int vy = yep ? (this.value - this.minimum) * (fieldHeight + 1) / (this.maximum - this.minimum) : 0;
                int n = vh = yep ? this.visibleAmount * (fieldHeight + 1) / (this.maximum - this.minimum) : 0;
                if (yep && vh < 5) {
                    vy -= 5 - vh;
                    vh = 5;
                }
                this.valueRect = new Rectangle(0, this.unitDecrementRect.height + vy, bounds.width, vh);
                this.blockDecrementRect = new Rectangle(0, this.unitDecrementRect.height, bounds.width, this.valueRect.y - this.unitDecrementRect.height);
                this.blockIncrementRect = new Rectangle(0, this.valueRect.y + this.valueRect.height, bounds.width, this.unitIncrementRect.y - (this.valueRect.y + this.valueRect.height));
                break;
            }
            case 0: {
                int vw;
                int buttonWidth = Math.min(bounds.height, bounds.width / 2);
                int fieldWidth = bounds.width - buttonWidth * 2;
                this.unitDecrementRect = new Rectangle(0, 0, buttonWidth, bounds.height);
                this.unitIncrementRect = new Rectangle(bounds.width - buttonWidth, 0, buttonWidth, bounds.height);
                int vx = yep ? (this.value - this.minimum) * (fieldWidth + 1) / (this.maximum - this.minimum) : 0;
                int n = vw = yep ? this.visibleAmount * (fieldWidth + 1) / (this.maximum - this.minimum) : 0;
                if (yep && vw < 5) {
                    vx -= 5 - vw;
                    vw = 5;
                }
                this.valueRect = new Rectangle(this.unitDecrementRect.width + vx, 0, vw, bounds.height);
                this.blockDecrementRect = new Rectangle(this.unitDecrementRect.width, 0, this.valueRect.x - this.unitDecrementRect.width, bounds.height);
                this.blockIncrementRect = new Rectangle(this.valueRect.x + this.valueRect.width, 0, this.unitIncrementRect.x - (this.valueRect.x + this.valueRect.width), bounds.height);
                break;
            }
        }
        g.setColor(background);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.setColor(DColor.brighter(background));
        if (this.blockDecrementRect.width > 0 && this.blockDecrementRect.height > 0 && this.down == 3) {
            g.fillRect(this.blockDecrementRect.x, this.blockDecrementRect.y, this.blockDecrementRect.width, this.blockDecrementRect.height);
        }
        if (this.blockIncrementRect.width > 0 && this.blockIncrementRect.height > 0 && this.down == 4) {
            g.fillRect(this.blockIncrementRect.x, this.blockIncrementRect.y, this.blockIncrementRect.width, this.blockIncrementRect.height);
        }
        this.drawButton(g, button, this.unitIncrementRect);
        this.drawButton(g, button, this.unitDecrementRect);
        Color ac1 = DColor.darker(DColor.darker(button));
        Color ac2 = DColor.brighter(DColor.brighter(button));
        Color acDec3 = this.down == 1 ? DColor.darker(DColor.darker(button)) : button;
        Color acInc3 = this.down == 2 ? DColor.darker(DColor.darker(button)) : button;
        DComponent.drawArrow(g, this.unitDecrementRect, true, this.orientation == 0 ? 4 : 1, ac1, ac2, acDec3);
        DComponent.drawArrow(g, this.unitIncrementRect, true, this.orientation == 0 ? 2 : 3, ac1, ac2, acInc3);
        if (this.valueRect.width > 0 && this.valueRect.height > 0) {
            this.drawButton(g, this.down == 0 ? DColor.brighter(button) : button, this.valueRect);
        }
    }

    private final void drawButton(Graphics g, Color color, Rectangle r) {
        Color topLeft = DColor.brighter(color);
        Color bottomRight = DColor.darker(color);
        int xx = r.x + r.width - 1;
        int yy = r.y + r.height - 1;
        g.setColor(color);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(topLeft);
        g.drawLine(r.x, r.y, xx, r.y);
        g.drawLine(r.x, r.y, r.x, yy);
        g.setColor(bottomRight);
        g.drawLine(r.x + 1, yy, xx, yy);
        g.drawLine(xx, r.y + 1, xx, yy);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener listener) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, listener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener listener) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processAdjustmentEvent(AdjustmentEvent event) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(event);
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
                Point point = event.getPoint();
                if (!this.isEnabled()) break;
                if (this.unitDecrementRect.contains(point)) {
                    this.down = 1;
                    this.timer = new Timer(this, 70L);
                    int oldValue = this.value;
                    this.setValue(Math.max(this.value - this.unitIncrement, this.minimum));
                    this.repaint();
                    if (this.value == oldValue) break;
                    this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 2, this.value));
                    break;
                }
                if (this.unitIncrementRect.contains(point)) {
                    this.down = 2;
                    this.timer = new Timer(this, 70L);
                    int oldValue = this.value;
                    this.setValue(Math.min(this.value + this.unitIncrement, this.maximum - this.visibleAmount));
                    this.repaint();
                    if (this.value == oldValue) break;
                    this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 1, this.value));
                    break;
                }
                if (this.blockDecrementRect.contains(point)) {
                    this.down = 3;
                    this.timer = new Timer(this, 500L);
                    int oldValue = this.value;
                    this.setValue(Math.max(this.value - this.blockIncrement, this.minimum));
                    if (this.value == oldValue) break;
                    this.repaint();
                    this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 3, this.value));
                    break;
                }
                if (this.blockIncrementRect.contains(point)) {
                    this.down = 4;
                    this.timer = new Timer(this, 500L);
                    int oldValue = this.value;
                    this.setValue(Math.min(this.value + this.blockIncrement, this.maximum - this.visibleAmount));
                    if (this.value == oldValue) break;
                    this.repaint();
                    this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 4, this.value));
                    break;
                }
                if (!this.valueRect.contains(point)) break;
                this.down = 0;
                this.mouseDownPoint = point;
                Rectangle bounds = this.getBounds();
                bounds = new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
                int buttonExtent = Math.min(bounds.width, bounds.height / 2);
                this.mouseDownExtent = (this.orientation == 1 ? bounds.height : bounds.width) - buttonExtent * 2;
                this.mouseDownValue = this.value * this.mouseDownExtent / (this.maximum - this.minimum);
                this.repaint();
                break;
            }
            case 502: {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
                this.down = -1;
                this.repaint();
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        block0 : switch (event.getID()) {
            case 506: {
                if (!this.isEnabled() || this.down != 0 || this.mouseDownPoint == null) break;
                Point point = event.getPoint();
                switch (this.orientation) {
                    case 1: {
                        int mouseDownOffset = point.y - this.mouseDownPoint.y;
                        int dValue = this.mouseDownExtent > 0 ? (this.mouseDownValue + mouseDownOffset) * (this.maximum - this.minimum) / this.mouseDownExtent : this.value;
                        int oldValue = this.value;
                        this.setValue(Math.min(this.maximum, Math.max(this.minimum, dValue)));
                        if (this.value == oldValue) break block0;
                        this.repaint();
                        this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 5, this.value));
                        break;
                    }
                    case 0: {
                        int mouseDownOffset = point.x - this.mouseDownPoint.x;
                        int dValue = this.mouseDownExtent > 0 ? (this.mouseDownValue + mouseDownOffset) * (this.maximum - this.minimum) / this.mouseDownExtent : this.value;
                        int oldValue = this.value;
                        this.setValue(Math.min(this.maximum, Math.max(this.minimum, dValue)));
                        if (this.value == oldValue) break block0;
                        this.repaint();
                        this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 5, this.value));
                        break;
                    }
                }
                break;
            }
        }
        super.processMouseEvent(event);
    }

    public void timerFired(TimerEvent event) {
        int oldValue = this.value;
        if (this.down == 1) {
            this.setValue(Math.max(this.value - this.unitIncrement, this.minimum));
            if (this.value != oldValue) {
                this.repaint();
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 2, this.value));
            }
        } else if (this.down == 2) {
            this.setValue(Math.min(this.value + this.unitIncrement, this.maximum - this.visibleAmount));
            if (this.value != oldValue) {
                this.repaint();
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 1, this.value));
            }
        } else if (this.down == 3) {
            this.timer.setInterval(150L);
            this.setValue(Math.max(this.value - this.blockIncrement, this.minimum));
            if (this.value != oldValue) {
                this.repaint();
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 3, this.value));
            }
        } else if (this.down == 4) {
            this.timer.setInterval(150L);
            this.setValue(Math.min(this.value + this.blockIncrement, this.maximum - this.visibleAmount));
            if (this.value != oldValue) {
                this.repaint();
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 4, this.value));
            }
        }
    }

    protected String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        buffer.append(",value=");
        buffer.append(this.value);
        buffer.append(",visibleAmount=");
        buffer.append(this.visibleAmount);
        buffer.append(",minimum=");
        buffer.append(this.minimum);
        buffer.append(",maximum=");
        buffer.append(this.maximum);
        buffer.append(",orientation=");
        buffer.append(this.orientation == 1 ? "VERTICAL" : "HORIZONTAL");
        return buffer.toString();
    }

    public DScrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public DScrollbar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public DScrollbar(int orientation, int value, int visibleAmount, int minimum, int maximum) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.orientation = orientation;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar orientation");
            }
        }
        this.setValues(value, visibleAmount, minimum, maximum);
        this.enableEvents(48L);
    }
}

