/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DContainer;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public abstract class DTextComponent
extends DContainer
implements ClipboardOwner {
    protected String text = "";
    protected boolean editable = true;
    protected boolean selectable = true;
    protected int position = 0;
    protected int selectionStart = 0;
    protected int selectionEnd = 0;
    protected transient TextListener textListener;

    public synchronized String getText() {
        return this.text;
    }

    String getFirstLine() {
        return this.text;
    }

    protected synchronized void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.text)) {
            this.text = text;
            int length = text.length();
            if (this.position > length) {
                this.position = length;
            }
            if (this.selectionStart > length) {
                this.selectionStart = length;
            }
            if (this.selectionEnd > length) {
                this.selectionEnd = length;
            }
        }
    }

    public synchronized String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public int getClipboardSize() {
        int size = 0;
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null) {
            try {
                size = ((String)content.getTransferData(DataFlavor.stringFlavor)).length();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return size;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean editable) {
        if (this.editable != editable) {
            this.editable = editable;
            this.repaint();
        }
    }

    public synchronized void setSelectable(boolean selectable) {
        if (this.selectable != selectable) {
            this.selectable = selectable;
            this.repaint();
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public synchronized int getSelectionStart() {
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public synchronized int getSelectionEnd() {
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public synchronized void select(int selectionStart, int selectionEnd) {
        int length = this.text.length();
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > length) {
            selectionStart = length;
        }
        if (selectionEnd > length) {
            selectionEnd = length;
        }
        if (selectionEnd < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (selectionStart > selectionEnd) {
            selectionStart = selectionEnd;
        }
        if (this.selectionStart != selectionStart || this.selectionEnd != selectionEnd) {
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.repaint();
        }
    }

    public synchronized void selectAll() {
        this.select(0, this.text.length());
    }

    public int getCaretPosition() {
        return this.position;
    }

    public void cutSelection() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        String selection = this.getSelectedText();
        if (selection.length() > 0) {
            StringSelection contents = new StringSelection(selection);
            clipboard.setContents(contents, this);
            if (this.editable) {
                this.deleteSelection();
            }
        }
    }

    public void copySelection() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        String selection = this.getSelectedText();
        if (selection.length() > 0) {
            StringSelection contents = new StringSelection(selection);
            clipboard.setContents(contents, this);
        }
    }

    public void pasteSelection() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null && this.editable) {
            String selection = this.getSelectedText();
            if (selection.length() > 0) {
                this.deleteSelection();
            }
            try {
                this.insert((String)content.getTransferData(DataFlavor.stringFlavor), false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public synchronized void moveLeft(boolean selected) {
        --this.position;
        if (selected) {
            if (this.position >= this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position < this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public synchronized void moveRight(boolean selected) {
        ++this.position;
        if (selected) {
            if (this.position < this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position <= this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public void moveWordLeft(boolean selected) {
        int wordStart = 0;
        int length = this.text.length();
        int i = this.text.indexOf(32);
        while (i > -1 && i < length) {
            if (i >= this.position - 1) break;
            wordStart = i + 1;
            i = this.text.indexOf(32, wordStart);
        }
        if (wordStart >= this.position && this.position > 0) {
            wordStart = 0;
        }
        this.position = wordStart;
        if (selected) {
            if (this.position >= this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position < this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public void moveWordRight(boolean selected) {
        int wordEnd;
        int wordStart = 0;
        int length = this.text.length();
        int i = this.text.indexOf(32);
        while (i > -1 && i < length) {
            if (i >= this.position) break;
            wordStart = i + 1;
            i = this.text.indexOf(32, wordStart);
        }
        if ((wordEnd = this.text.indexOf(32, wordStart) + 1) <= 0) {
            wordEnd = length;
        }
        if (wordEnd > length) {
            wordEnd = length;
        }
        this.position = wordEnd;
        if (selected) {
            if (this.position < this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position <= this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public void moveLineStart(boolean selected) {
        int lineStart = 0;
        int length = this.text.length();
        int i = this.text.indexOf(10);
        while (i > -1 && i < length) {
            if (i >= this.position - 1) break;
            lineStart = i + 1;
            i = this.text.indexOf(10, lineStart);
        }
        if (lineStart >= this.position && this.position > 0) {
            lineStart = 0;
        }
        this.position = lineStart;
        if (selected) {
            if (this.position >= this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position < this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public void moveLineEnd(boolean selected) {
        int lineEnd;
        int lineStart = 0;
        int length = this.text.length();
        int i = this.text.indexOf(10);
        while (i > -1 && i < length) {
            if (i >= this.position) break;
            lineStart = i + 1;
            i = this.text.indexOf(10, lineStart);
        }
        if ((lineEnd = this.text.indexOf(10, lineStart) + 1) <= 0) {
            lineEnd = length;
        }
        if (lineEnd > length) {
            lineEnd = length;
        }
        this.position = lineEnd;
        if (selected) {
            if (this.position < this.selectionStart) {
                this.selectionEnd = this.position;
            } else if (this.position <= this.selectionEnd) {
                this.selectionStart = this.position;
            } else {
                this.selectionEnd = this.position;
            }
        } else {
            this.selectionStart = this.selectionEnd = this.position;
        }
        this.repaint();
    }

    public void deleteSelection() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.text.substring(0, this.selectionStart));
        buffer.append(this.text.substring(this.selectionEnd, this.text.length()));
        this.position = this.selectionEnd = this.selectionStart;
        this.setText(buffer.toString());
    }

    public void deleteRight() {
        if (this.position < this.text.length()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.text.substring(0, this.position));
            buffer.append(this.text.substring(this.position + 1, this.text.length()));
            this.setText(buffer.toString());
        }
    }

    public void deleteLeft() {
        if (this.position > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.text.substring(0, this.position - 1));
            buffer.append(this.text.substring(this.position, this.text.length()));
            --this.position;
            this.selectionEnd = this.selectionStart = this.position;
            this.setText(buffer.toString());
        }
    }

    public void insert(char ch, boolean selected) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.text.substring(0, this.position));
        buffer.append(ch);
        buffer.append(this.text.substring(this.position, this.text.length()));
        ++this.position;
        this.selectionEnd = this.position;
        if (!selected) {
            this.selectionStart = this.selectionEnd;
        }
        this.setText(buffer.toString());
    }

    public void insert(String text, boolean selected) {
        int length = this.text.length();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.text.substring(0, this.position));
        buffer.append(text);
        buffer.append(this.text.substring(this.position, length));
        this.position += text.length();
        this.selectionEnd = this.position;
        if (!selected) {
            this.selectionStart = this.selectionEnd;
        }
        this.setText(buffer.toString());
    }

    public void addTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, listener);
    }

    public void removeTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof TextEvent) {
            this.processTextEvent((TextEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processTextEvent(TextEvent event) {
        if (this.textListener != null) {
            int id = event.getID();
            switch (id) {
                case 900: {
                    this.textListener.textValueChanged(event);
                    break;
                }
            }
        }
    }

    protected String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        buffer.append(",text=\"");
        buffer.append(this.getFirstLine());
        buffer.append("\"");
        if (this.editable) {
            buffer.append(",editable");
        }
        if (this.selectable) {
            buffer.append(",selectable");
        }
        if (this.selectionEnd > this.selectionStart) {
            buffer.append(",selection=");
            buffer.append(this.getSelectionStart());
            buffer.append("-");
            buffer.append(this.getSelectionEnd());
        }
        return buffer.toString();
    }

    DTextComponent() {
        this("");
    }

    public DTextComponent(String text) {
        this.setText(text);
        this.selectionStart = this.selectionEnd = this.text.length();
        this.position = this.selectionEnd;
    }
}

