/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DColor;
import dog.gui.DTextComponent;
import dog.gui.DTheme;
import dog.util.Timer;
import dog.util.TimerEvent;
import dog.util.TimerListener;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;

public class DTextField
extends DTextComponent
implements TimerListener {
    public static final int CENTER = 0;
    public static final int LEFT = 4;
    public static final int RIGHT = 2;
    protected int align;
    protected boolean filled = true;
    protected char echoChar = '\u0000';
    protected int columns;
    protected transient boolean focus = false;
    protected transient ActionListener actionListener;
    private transient int dragStart = 0;
    private transient String displayText = "";
    private transient Timer blinkTimer;
    private transient boolean blink = false;
    private transient int offset = 0;
    private int maxChar = 0;

    public void setMaxCharNumber(int max) {
        this.maxChar = max;
    }

    public synchronized void setText(String text) {
        if (text != null) {
            int i = text.indexOf(10);
            if (i > -1) {
                text = text.substring(0, i);
            }
            while ((i = text.indexOf(9)) > -1) {
                text = text.substring(0, i) + text.substring(i, text.length());
            }
        } else {
            text = "";
        }
        super.setText(text);
        this.repaint();
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        if (align != 4 && align != 0 && align != 2) {
            throw new IllegalArgumentException("illegal alignment value:" + align);
        }
        if (this.align != align) {
            this.align = align;
            this.repaint();
        }
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        if (this.echoChar != echoChar) {
            this.echoChar = echoChar;
            this.repaint();
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        if (this.filled != filled) {
            this.filled = filled;
            this.repaint();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int old = this.columns;
        if (columns < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (columns != old) {
            this.columns = columns;
            this.invalidate();
        }
    }

    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TEXTFIELD"));
        int ph = fm.getHeight() + 6;
        return new Dimension(ph, ph);
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TEXTFIELD"));
        int columns = this.columns < 1 ? 20 : this.columns;
        Dimension ps = new Dimension(0, 0);
        ps.width = fm.stringWidth("0") * columns + 12;
        ps.height = fm.getHeight() + 6;
        return ps;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int rxbase;
        Color topLeft2;
        Color topLeft1;
        Font font = this.myTheme.getFont("TEXTFIELD");
        FontMetrics fm = this.getFontMetrics(font);
        Rectangle bounds = this.getBounds();
        Rectangle clip = g.getClipBounds();
        Rectangle inside = new Rectangle(0, 0, bounds.width, bounds.height);
        boolean enabled = this.isEnabled();
        DTheme theme = this.myTheme;
        Color cBackground = theme.getColor("TEXTFIELD_BACKGROUND");
        Color cBorder = theme.getColor("TEXTFIELD_BORDER");
        Color cText = theme.getColor("TEXTFIELD_TEXT");
        Color cCursor = theme.getColor("TEXTFIELD_CURSOR");
        int borderType = 1;
        try {
            borderType = Integer.parseInt(theme.getParam("TEXTFIELD_BORDER_TYPE"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!enabled) {
            cText = DColor.toGray(cText);
            cBackground = DColor.darker(DColor.toGray(cBackground));
            cBorder = DColor.darker(DColor.toGray(cBorder));
            cCursor = DColor.darker(DColor.toGray(cCursor));
        }
        g.setFont(font);
        int borderSize = 0;
        if (borderType == 1) {
            borderSize = 3;
            topLeft1 = cBorder;
            topLeft2 = DColor.brighter(topLeft1);
            Color topLeft3 = DColor.brighter(topLeft2);
            Color bottomRight1 = cBorder;
            Color bottomRight2 = DColor.darker(bottomRight1);
            Color bottomRight3 = DColor.darker(bottomRight2);
            int x1 = inside.x;
            int x2 = inside.x + inside.width - 1;
            int y1 = inside.y;
            int y2 = inside.y + inside.height - 1;
            g.setColor(topLeft1);
            g.drawLine(x1 + 2, y1 + 2, x2 - 2, y1 + 2);
            g.drawLine(x1 + 2, y1 + 2, x1 + 2, y2 - 2);
            g.setColor(topLeft2);
            g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
            g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
            g.setColor(topLeft3);
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x1, y1, x1, y2);
            g.setColor(bottomRight1);
            g.drawLine(x1 + 2, y2 - 2, x2 - 2, y2 - 2);
            g.drawLine(x2 - 2, y1 + 2, x2 - 2, y2 - 2);
            g.setColor(bottomRight2);
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
            g.setColor(bottomRight3);
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(x2, y1, x2, y2);
        } else if (borderType == 2) {
            borderSize = 2;
            topLeft2 = cBorder;
            topLeft1 = DColor.darker(topLeft2);
            Color bottomRight1 = cBorder;
            Color bottomRight2 = DColor.brighter(bottomRight1);
            g.setColor(topLeft1);
            g.drawLine(inside.x + 1, inside.y + 1, inside.x + inside.width - 2, inside.y + 1);
            g.drawLine(inside.x + 1, inside.y + 1, inside.x + 1, inside.y + inside.height - 2);
            g.setColor(topLeft2);
            g.drawLine(inside.x, inside.y, inside.x + inside.width - 1, inside.y);
            g.drawLine(inside.x, inside.y, inside.x, inside.y + inside.height - 1);
            g.setColor(bottomRight1);
            g.drawLine(inside.x + 1, inside.y + inside.height - 2, inside.x + inside.width - 2, inside.y + inside.height - 2);
            g.drawLine(inside.x + inside.width - 2, inside.y + 1, inside.x + inside.width - 2, inside.y + inside.height - 2);
            g.setColor(bottomRight2);
            g.drawLine(inside.x, inside.y + inside.height - 1, inside.x + inside.width - 1, inside.y + inside.height - 1);
            g.drawLine(inside.x + inside.width - 1, inside.y, inside.x + inside.width - 1, inside.y + inside.height - 1);
        }
        inside.x += borderSize;
        inside.y += borderSize;
        inside.width -= borderSize * 2;
        inside.height -= borderSize * 2;
        g.setClip(inside.intersection(clip));
        if (this.filled) {
            g.setColor(cBackground);
            g.fillRect(inside.x, inside.y, inside.width, inside.height);
        }
        String text = this.getText();
        int length = text.length();
        if (this.echoChar != '\u0000') {
            StringBuffer buffer = new StringBuffer();
            int count = 0;
            while (count < length) {
                buffer.append(this.echoChar);
                ++count;
            }
            text = buffer.toString();
        }
        this.displayText = text;
        int ascent = fm.getAscent();
        int tw = fm.stringWidth(text);
        int texth = fm.getHeight();
        int rx = rxbase = this.align == 0 ? (inside.width - tw) / 2 : (this.align == 2 ? inside.width - tw - 2 : 2);
        if (this.focus) {
            int px = fm.stringWidth(text.substring(0, this.position));
            if ((rx += this.offset) + px > inside.width - 6) {
                this.offset = -rxbase + (inside.width - 6) - px;
                rx = rxbase + this.offset;
            }
            if (rx + px < 0) {
                this.offset = -rxbase - px;
                rx = rxbase + this.offset;
            }
        }
        int ry = (inside.height - texth) / 2;
        if (this.selectionEnd > this.selectionStart && this.focus && enabled) {
            int offset = rx;
            String part = text.substring(0, this.selectionStart);
            int partwidth = fm.stringWidth(part);
            g.setColor(cText);
            g.drawString(part, inside.x + offset, inside.y + ascent + ry);
            offset += partwidth;
            part = text.substring(this.selectionStart, this.selectionEnd);
            partwidth = fm.stringWidth(part);
            g.setColor(cText);
            g.fillRect(inside.x + offset, inside.y + ry, partwidth, texth);
            g.setColor(cBackground);
            g.drawString(part, inside.x + offset, inside.y + ascent + ry);
            offset += partwidth;
            part = text.substring(this.selectionEnd, length);
            partwidth = fm.stringWidth(part);
            g.setColor(cText);
            g.drawString(part, inside.x + offset, inside.y + ascent + ry);
        } else {
            g.setColor(cText);
            g.drawString(text, inside.x + rx, inside.y + ascent + ry);
            int cx = fm.stringWidth(text.substring(0, this.position));
            if (this.blink && this.focus) {
                g.setColor(cCursor);
                g.fillRect(inside.x + rx + cx, inside.y + ry, 1, texth);
            }
        }
        g.setClip(clip);
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    protected void processFocusEvent(FocusEvent event) {
        switch (event.getID()) {
            case 1004: {
                if (!this.isEnabled()) break;
                this.focus = true;
                this.blink = true;
                this.setCursor(Cursor.getPredefinedCursor(2));
                this.blinkTimer = new Timer(this, 500L);
                this.repaint();
                break;
            }
            case 1005: {
                if (!this.isEnabled()) break;
                this.focus = false;
                this.blinkTimer.interrupt();
                this.blink = false;
                this.repaint();
                break;
            }
        }
        super.processFocusEvent(event);
    }

    protected void processKeyEvent(KeyEvent event) {
        block0 : switch (event.getID()) {
            case 401: {
                switch (event.getKeyCode()) {
                    case 37: {
                        if (this.position > 0) {
                            if (event.isControlDown()) {
                                this.moveWordLeft(event.isShiftDown());
                            } else {
                                this.moveLeft(event.isShiftDown());
                            }
                        }
                        event.consume();
                        break block0;
                    }
                    case 39: {
                        if (this.position < this.text.length()) {
                            if (event.isControlDown()) {
                                this.moveWordRight(event.isShiftDown());
                            } else {
                                this.moveRight(event.isShiftDown());
                            }
                        }
                        event.consume();
                        break block0;
                    }
                    case 36: {
                        if (this.position > 0) {
                            this.moveLineStart(event.isShiftDown());
                        }
                        event.consume();
                        break block0;
                    }
                    case 35: {
                        if (this.position < this.text.length()) {
                            this.moveLineEnd(event.isShiftDown());
                        }
                        event.consume();
                        break block0;
                    }
                    case 12: 
                    case 127: {
                        if (this.selectionEnd > this.selectionStart) {
                            this.deleteSelection();
                        } else {
                            this.deleteRight();
                        }
                        this.processEvent(new TextEvent(this, 900));
                        event.consume();
                        break block0;
                    }
                    case 8: {
                        if (this.selectionEnd > this.selectionStart) {
                            this.deleteSelection();
                        } else {
                            this.deleteLeft();
                        }
                        this.processEvent(new TextEvent(this, 900));
                        event.consume();
                        break block0;
                    }
                    case 10: {
                        this.processDefaultAction(new ActionEvent(this, 1001, this.text));
                        event.consume();
                        break block0;
                    }
                    case 3: 
                    case 27: {
                        this.processCancelAction(new ActionEvent(this, 1001, this.text));
                        event.consume();
                        break block0;
                    }
                }
                break;
            }
            case 400: {
                char c = event.getKeyChar();
                switch (c) {
                    case '\u0018': {
                        this.cutSelection();
                        this.processEvent(new TextEvent(this, 900));
                        event.consume();
                        return;
                    }
                    case '\u0003': {
                        this.copySelection();
                        event.consume();
                        return;
                    }
                    case '\u0016': {
                        if (this.maxChar == 0 || this.getText().length() + this.getClipboardSize() <= this.maxChar) {
                            this.pasteSelection();
                            this.processEvent(new TextEvent(this, 900));
                            event.consume();
                        }
                        return;
                    }
                }
                if (event.isActionKey() || c <= '\u001f' || c == '\u007f') break;
                if (this.selectionEnd > this.selectionStart) {
                    this.deleteSelection();
                }
                if (this.maxChar != 0 && this.getText().length() > this.maxChar) break;
                this.insert(c, false);
                this.processEvent(new TextEvent(this, 900));
                event.consume();
                break;
            }
        }
        super.processKeyEvent(event);
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 500: {
                int p;
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TEXTFIELD"));
                Rectangle bounds = this.getBounds();
                this.selectionStart = this.selectionEnd = (p = this.xToPos(point.x, fm, bounds));
                this.position = this.selectionEnd;
                this.requestFocus();
                this.repaint();
                break;
            }
            case 501: {
                int p;
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TEXTFIELD"));
                Rectangle bounds = this.getBounds();
                this.dragStart = p = this.xToPos(point.x, fm, bounds);
                this.requestFocus();
                break;
            }
            case 504: {
                if (this.isEnabled()) {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                Rectangle bounds;
                if (!this.isEnabled()) break;
                Point point = event.getPoint();
                FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TEXTFIELD"));
                int p = this.xToPos(point.x, fm, bounds = this.getBounds());
                if (p > this.dragStart) {
                    this.selectionStart = this.dragStart;
                    this.selectionEnd = p;
                    this.position = p;
                } else if (p < this.dragStart) {
                    this.selectionStart = p;
                    this.selectionEnd = this.dragStart;
                    this.position = p;
                } else {
                    this.selectionEnd = this.position = p;
                    this.selectionStart = this.position;
                }
                this.repaint();
                break;
            }
        }
        super.processMouseMotionEvent(event);
    }

    public void timerFired(TimerEvent event) {
        Timer timer = event.getTimer();
        if (timer.equals(this.blinkTimer)) {
            this.blink = !this.blink;
            this.repaint();
        }
    }

    int xToPos(int x, FontMetrics fm, Rectangle bounds) {
        int pos = 0;
        String text = this.displayText;
        int length = text.length();
        int tw = fm.stringWidth(text);
        int offset = this.offset + 3;
        switch (this.align) {
            case 0: {
                offset += (bounds.width - 3 - tw) / 2 - 1;
                break;
            }
            case 2: {
                offset += bounds.width - 3 - tw - 2;
                break;
            }
        }
        int i = 0;
        while (i <= length) {
            int tx = fm.stringWidth(text.substring(0, i));
            if (x > offset + tx) {
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    protected String paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.paramString());
        buffer.append(",align=");
        switch (this.align) {
            case 4: {
                buffer.append("LEFT");
                break;
            }
            case 0: {
                buffer.append("CENTER");
                break;
            }
            case 2: {
                buffer.append("RIGHT");
                break;
            }
        }
        if (this.echoChar != '\u0000') {
            buffer.append(",echo=");
            buffer.append(this.echoChar);
        }
        return buffer.toString();
    }

    public DTextField() {
        this("", 4);
    }

    public DTextField(String text) {
        this(text, 4);
    }

    public DTextField(String text, int align) {
        super(text);
        if (align != 4 && align != 0 && align != 2) {
            throw new IllegalArgumentException("illegal alignment value:" + align);
        }
        this.align = align;
        this.enableEvents(60L);
    }
}

