/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DContainer;
import dog.gui.DPopup;
import dog.gui.DRootPane;
import dog.gui.DTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class DTooltip
extends DPopup {
    protected String label;

    public String getText() {
        return this.getLabel();
    }

    public void setText(String label) {
        this.setLabel(label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (this.label != null && label == null || label != null && !label.equals(this.label)) {
            String old = this.label;
            this.label = label;
            this.changes.firePropertyChange("label", old, label);
            this.invalidate();
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.myTheme.getFont("TOOLTIP"));
        Dimension ps = new Dimension(0, fm.getHeight());
        int rows = 1;
        if (this.label != null) {
            StringTokenizer st = new StringTokenizer(this.label, "\n", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("\n".equals(token)) {
                    ++rows;
                    continue;
                }
                ps.width = Math.max(ps.width, fm.stringWidth(token) + 2);
            }
        }
        ps.height = ps.height * rows + 2;
        return ps;
    }

    public void paint(Graphics g) {
        Color pc = this.myTheme.getColor("TOOLTIP_BACKGROUND");
        Color pcs = this.myTheme.getColor("TOOLTIP_BORDER");
        Dimension size = this.getSize();
        g.setColor(pc);
        g.fillRect(0, 0, size.width - 1, size.height - 1);
        g.setColor(pcs);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
        if (this.label != null) {
            Font font = this.myTheme.getFont("TOOLTIP");
            FontMetrics fm = this.getFontMetrics(font);
            Rectangle inside = new Rectangle(0, 0, size.width, size.height);
            Color f = this.myTheme.getColor("TOOLTIP_TEXT");
            g.setFont(font);
            DContainer.drawLabel(g, inside, fm, this.label, 0, f);
        }
    }

    public String paramString() {
        StringBuffer buffer = new StringBuffer();
        if (this.label != null) {
            buffer.append(",label=");
            buffer.append(this.label);
        }
        return buffer.toString();
    }

    public DTooltip(DRootPane root, String label) {
        super(root);
        this.label = label;
        this.fitMode = 1001;
        ((Component)this).setFont(DTheme.getTheme().getSubTextFont());
    }
}

