/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DItem;
import dog.util.ObjectCollator;
import java.util.Locale;

public class ItemCollator
extends ObjectCollator {
    private String[] indices = new String[0];
    private boolean[] indicesDescending = new boolean[0];

    public String[] getIndices() {
        return this.indices;
    }

    public boolean[] getIndicesDescending() {
        return this.indicesDescending;
    }

    public void setIndices(String[] indices, boolean[] indicesDescending) {
        if (indices == null) {
            indices = new String[]{};
        }
        if (indicesDescending == null) {
            indicesDescending = new boolean[]{};
        }
        if (indices.length != indicesDescending.length) {
            throw new IllegalArgumentException("indices and indicesDescending must be same length");
        }
        this.indices = indices;
        this.indicesDescending = indicesDescending;
    }

    public int compare(Object source, Object target) {
        if (source == null) {
            return this.applyDescending(-1);
        }
        if (target == null) {
            return this.applyDescending(1);
        }
        if (source instanceof DItem) {
            if (target instanceof DItem) {
                return this.compare((DItem)source, (DItem)target);
            }
            return this.compare((Object)((DItem)source).getLabel(), target);
        }
        if (target instanceof DItem) {
            return this.compare(source, (Object)((DItem)target).getLabel());
        }
        return super.compare(source, target);
    }

    int compare(DItem source, DItem target) {
        if (this.indices.length == 0) {
            return this.compare((Object)source.getLabel(), (Object)target.getLabel());
        }
        boolean save = this.descending;
        int i = 0;
        while (i < this.indices.length) {
            this.descending = this.indicesDescending[i];
            int c = this.indices[i] == null || "".equals(this.indices[i]) ? this.compare((Object)source.getLabel(), (Object)target.getLabel()) : this.compare(source.getField(this.indices[i]), target.getField(this.indices[i]));
            this.descending = save;
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    protected StringBuffer paramString() {
        StringBuffer buffer = super.paramString();
        buffer.append(",indices={");
        int i = 0;
        while (i < this.indices.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.indices[i]);
            ++i;
        }
        buffer.append("},indicesDescending={");
        i = 0;
        while (i < this.indicesDescending.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.indicesDescending[i]);
            ++i;
        }
        buffer.append("}");
        return buffer;
    }

    public ItemCollator() {
    }

    public ItemCollator(Locale locale) {
        super(locale);
    }
}

