/*
 * Decompiled with CFR 0.152.
 */
package dog.gui;

import dog.gui.DComponent;
import dog.gui.DContainer;
import dog.gui.DPopup;
import dog.gui.DRootPane;
import dog.gui.DTooltip;
import java.awt.Point;

public final class TooltipManager
extends Thread {
    private static TooltipManager instance;
    private static DTooltip tooltip;
    private static long delay;
    private static boolean enabled;

    private static final TooltipManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new TooltipManager();
        instance.start();
        return instance;
    }

    public static final boolean isEnabled() {
        return enabled;
    }

    public static final void setEnabled(boolean flag) {
        if (enabled && tooltip != null) {
            tooltip.dispose();
            tooltip = null;
        }
        enabled = flag;
    }

    public static final long getDelay() {
        return delay;
    }

    public static final void setDelay(long ms) {
        if (delay != ms) {
            delay = ms;
        }
    }

    public static final void setComponent(DComponent component, Point point) {
        if (!enabled) {
            return;
        }
        if (component != null) {
            DRootPane root = component.getRootPane();
            String label = component.getTooltip();
            if (root != null && label != null) {
                if (tooltip == null) {
                    tooltip = new DTooltip(root, label);
                } else {
                    tooltip.setLabel(label);
                }
                Point offset = DPopup.getOffset(component);
                offset.x += point.x;
                offset.y += point.y + 16;
                tooltip.setLocation(offset);
                tooltip.setSize(tooltip.getPreferredSize());
                TooltipManager.getInstance();
            }
        } else if (tooltip != null) {
            tooltip.dispose();
            tooltip = null;
            TooltipManager.getInstance().interrupt();
        }
    }

    public static final void setComponent(DContainer component, Point point) {
        if (!enabled) {
            return;
        }
        if (component != null) {
            DRootPane root = component.getRootPane();
            String label = component.getTooltip();
            if (root != null && label != null) {
                if (tooltip == null) {
                    tooltip = new DTooltip(root, label);
                } else {
                    tooltip.setLabel(label);
                }
                Point offset = DPopup.getOffset(component);
                offset.x += point.x;
                offset.y += point.y + 16;
                tooltip.setLocation(offset);
                tooltip.setSize(tooltip.getPreferredSize());
                TooltipManager.getInstance();
            }
        } else if (tooltip != null) {
            tooltip.dispose();
            tooltip = null;
            TooltipManager.getInstance().interrupt();
        }
    }

    public final void run() {
        try {
            while (true) {
                Thread.sleep(delay);
                if (tooltip == null) continue;
                tooltip.setVisible(true);
            }
        }
        catch (InterruptedException interruptedException) {
            instance = null;
            return;
        }
    }

    private TooltipManager() {
    }

    static {
        delay = 4000L;
        enabled = false;
    }
}

