/*
 * Decompiled with CFR 0.152.
 */
package dog.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Config {
    public static final String PARAMPREFIX = "@";
    private Properties props = null;

    public final String getString(String name, String def) {
        String val = this.props.getProperty(name, def);
        return val;
    }

    public final String getString(String name) {
        return this.getString(name, null);
    }

    public final String getString(String name, String[] params, String def) {
        return this.getString(name, params, def, PARAMPREFIX);
    }

    public final String getString(String name, String[] params, String def, String paramPrefix) {
        String s = this.getString(name, def);
        if (params == null || params.length == 0) {
            return s;
        }
        if (paramPrefix == null || paramPrefix == "") {
            paramPrefix = PARAMPREFIX;
        }
        int c = 0;
        while (c < params.length) {
            String pname = paramPrefix + (c + 1);
            while (s.indexOf(pname) > -1) {
                s = s.substring(0, s.indexOf(pname)) + params[c] + s.substring(s.indexOf(pname) + pname.length());
            }
            ++c;
        }
        return s;
    }

    public final int getInt(String name, int def) {
        int val = def;
        try {
            val = Integer.parseInt(this.getString(name, ""));
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return val;
    }

    public final boolean getBoolean(String name, boolean def) {
        String sval = this.getString(name, null);
        if (sval == null) {
            return def;
        }
        return sval.equalsIgnoreCase("true") || sval.equalsIgnoreCase("yes") || sval.equalsIgnoreCase("on") || sval.equals("1");
    }

    public final Point getPos(String name, Point def) {
        String pos = this.getString(name, null);
        try {
            int term = pos.indexOf(",");
            String x = pos.substring(0, term);
            String y = pos.substring(term + 1);
            Point p = new Point(Integer.parseInt(x), Integer.parseInt(y));
            return p;
        }
        catch (Exception hasError) {
            return def;
        }
    }

    public final Rectangle getRectangle(String name, Rectangle def) {
        String pos = this.getString(name, null);
        try {
            int term = pos.indexOf(",");
            String x = pos.substring(0, term);
            pos = pos.substring(term + 1);
            term = pos.indexOf(",");
            String y = pos.substring(0, term);
            pos = pos.substring(term + 1);
            term = pos.indexOf(",");
            String w = pos.substring(0, term);
            String h = pos.substring(term + 1);
            Rectangle r = new Rectangle(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(w), Integer.parseInt(h));
            return r;
        }
        catch (Exception hasError) {
            return def;
        }
    }

    public final Color getColor(String name, Color def) {
        String color = this.getString(name, null);
        try {
            StringTokenizer t = new StringTokenizer(color, ",");
            String r = t.nextToken();
            String g = t.nextToken();
            String b = t.nextToken();
            Color c = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            return c;
        }
        catch (Exception hasError) {
            return def;
        }
    }

    public final Font getFont(String name, Font def) {
        String font = this.getString(name, null);
        if (font != null && font.length() > 0) {
            String type = "Arial";
            int size = 14;
            int style = 0;
            int spos = font.indexOf("-");
            int epos = font.length() - 1;
            while (epos >= 0) {
                char lastChar = font.charAt(epos);
                if (lastChar == 'b' || lastChar == 'B') {
                    style |= 1;
                } else if (lastChar == 'i' || lastChar == 'I') {
                    style |= 2;
                } else {
                    if (lastChar != 'p' && lastChar != 'P') break;
                    style |= 0;
                }
                --epos;
            }
            if (style == 0) {
                style = 0;
            }
            if (epos > 0) {
                if (spos == -1) {
                    try {
                        size = Integer.parseInt(font.substring(0, epos + 1));
                    }
                    catch (NumberFormatException noC) {
                        type = font.substring(0, epos + 1);
                    }
                } else {
                    type = font.substring(0, spos);
                    try {
                        size = Integer.parseInt(font.substring(spos + 1, epos + 1));
                    }
                    catch (NumberFormatException noC) {
                        // empty catch block
                    }
                }
            }
            Font f = new Font(type, style, size);
            return f;
        }
        return def;
    }

    public final Image getImage(String name, String def) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if ((name = this.getString(name, def)) == null || name.length() == 0) {
            return null;
        }
        return tk.getImage(name);
    }

    public final Enumeration getKeys() {
        return this.props.propertyNames();
    }

    public Config(Properties props) {
        this.props = props;
    }
}

