/*
 * Decompiled with CFR 0.152.
 */
package dog.util;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Date;
import java.util.Locale;

public class ObjectCollator
extends Collator {
    protected Collator collator;
    protected boolean descending = false;

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    protected int applyDescending(int comparison) {
        return !this.descending ? comparison : -comparison;
    }

    protected int applyAscending(int comparison) {
        return this.descending ? comparison : -comparison;
    }

    public int compare(String source, String target) {
        return this.applyDescending(this.collator.compare(source, target));
    }

    public int compare(Object source, Object target) {
        if (source instanceof String) {
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare((String)source, (String)target));
            }
            if (target instanceof Number) {
                return this.applyDescending(this.collator.compare((String)source, target.toString()));
            }
        } else if (source instanceof Integer) {
            if (target instanceof Number) {
                return this.applyAscending(((Number)target).intValue() - (Integer)source);
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Double) {
            if (target instanceof Number) {
                return this.applyAscending((int)(((Number)target).doubleValue() - (Double)source));
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Long) {
            if (target instanceof Number) {
                return this.applyAscending((int)(((Number)target).longValue() - (Long)source));
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Float) {
            if (target instanceof Number) {
                return this.applyAscending((int)(((Number)target).floatValue() - ((Float)source).floatValue()));
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Byte) {
            if (target instanceof Number) {
                return this.applyAscending(((Number)target).byteValue() - (Byte)source);
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Short) {
            if (target instanceof Number) {
                return this.applyAscending(((Number)target).shortValue() - (Short)source);
            }
            if (target instanceof String) {
                return this.applyDescending(this.collator.compare(source.toString(), (String)target));
            }
        } else if (source instanceof Boolean) {
            if (target instanceof Boolean) {
                boolean s = (Boolean)source;
                boolean t = (Boolean)target;
                if (!s && t) {
                    return this.applyDescending(-1);
                }
                if (s && !t) {
                    return this.applyDescending(1);
                }
            }
        } else if (source instanceof Date && target instanceof Date) {
            Date s = (Date)source;
            Date t = (Date)target;
            if (s.before(t)) {
                return this.applyDescending(-1);
            }
            if (s.after(t)) {
                return this.applyDescending(1);
            }
        }
        return 0;
    }

    public CollationKey getCollationKey(String source) {
        return this.collator.getCollationKey(source);
    }

    public boolean equals(String source, String target) {
        return this.collator.equals(source, target);
    }

    public int getStrength() {
        return this.collator.getStrength();
    }

    public void setStrength(int newStrength) {
        this.collator.setStrength(newStrength);
    }

    public int getDecomposition() {
        return this.collator.getDecomposition();
    }

    public void setDecomposition(int decompositionMode) {
        this.collator.setDecomposition(decompositionMode);
    }

    public int hashCode() {
        return this.collator.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectCollator) {
            ObjectCollator oc = (ObjectCollator)other;
            return this.collator.equals(oc.collator);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[");
        buffer.append(this.paramString().toString());
        buffer.append("]");
        return buffer.toString();
    }

    protected StringBuffer paramString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("strength=");
        switch (this.getStrength()) {
            case 0: {
                buffer.append("PRIMARY");
                break;
            }
            case 1: {
                buffer.append("SECONDARY");
                break;
            }
            case 2: {
                buffer.append("TERTIARY");
                break;
            }
            case 3: {
                buffer.append("IDENTICAL");
                break;
            }
            default: {
                buffer.append("unknown");
            }
        }
        buffer.append(",decomposition=");
        switch (this.getDecomposition()) {
            case 0: {
                buffer.append("NO_DECOMPOSITION");
                break;
            }
            case 1: {
                buffer.append("CANONICAL_DECOMPOSITION");
                break;
            }
            case 2: {
                buffer.append("FULL_DECOMPOSITION");
                break;
            }
            default: {
                buffer.append("unknown");
            }
        }
        if (this.descending) {
            buffer.append(",descending");
        }
        return buffer;
    }

    public ObjectCollator() {
        this.collator = Collator.getInstance();
    }

    public ObjectCollator(Locale locale) {
        this.collator = Collator.getInstance(locale);
    }
}

