/*
 * Decompiled with CFR 0.152.
 */
package dog.util;

import dog.gui.DComponent;
import dog.gui.DContainer;
import dog.gui.DTheme;
import dog.util.Config;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class ThemeCenter {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private Config cf;
    private PrintStream log;
    private Hashtable themes;

    public Theme getTheme(String name) {
        Theme theme = (Theme)this.themes.get(name = name.toUpperCase());
        if (theme == null && (theme = this.loadTheme(name)) != null) {
            this.themes.put(name, theme);
        }
        return theme;
    }

    public static Theme createTheme() {
        return new Theme("");
    }

    private final Theme loadTheme(String name) {
        this.print("[" + name + "] Loading theme...");
        Theme theme = null;
        String base = this.cf.getString(name + "_BASE", null);
        if (base != null) {
            this.print("[" + name + "] base theme is: " + base);
            Theme baseTheme = this.getTheme(base);
            if (baseTheme == null) {
                this.print("[" + name + "] base theme '" + base + "' does not exist!");
                return null;
            }
            theme = new Theme(name, baseTheme);
        } else {
            theme = new Theme(name);
        }
        Enumeration e = this.cf.getKeys();
        while (e.hasMoreElements()) {
            String entry;
            String key = (String)e.nextElement();
            String keyupp = key.toUpperCase();
            if (!keyupp.startsWith(name + "_")) continue;
            String keyMain = keyupp.substring(name.length() + 1);
            if (keyMain.endsWith("_COLOR")) {
                entry = keyMain.substring(0, keyMain.length() - 6);
                Color color = this.getColor(theme, name, entry);
                if (color == null) {
                    this.print("[" + name + "] " + key + ": illegal color in the config file!");
                    continue;
                }
                theme.setColor(entry, color);
                continue;
            }
            if (keyMain.endsWith("_FONT")) {
                entry = keyMain.substring(0, keyMain.length() - 5);
                Font font = this.cf.getFont(key, null);
                if (font == null) {
                    this.print("[" + name + "] " + key + ": illegal font in the config file!");
                    continue;
                }
                theme.setFont(entry, font);
                continue;
            }
            if (keyMain.endsWith("_IMAGE")) {
                entry = keyMain.substring(0, keyMain.length() - 6);
                Image image = this.cf.getImage(key, null);
                if (image == null) {
                    this.print("[" + name + "] " + key + ": illegal image in the config file!");
                    continue;
                }
                theme.setImage(entry, image);
                continue;
            }
            if (!keyMain.endsWith("_PARAM")) continue;
            entry = keyMain.substring(0, keyMain.length() - 6);
            String param = this.cf.getString(key, null);
            theme.setParam(entry, param);
        }
        this.print("[" + name + "] " + "Theme '" + name + "' has been loaded.");
        return theme;
    }

    private final Color getColor(Theme theme, String themeName, String name) {
        String key = themeName + "_" + name + "_COLOR";
        String value = this.cf.getString(key, null);
        if (value == null) {
            return theme.getColor(name);
        }
        if ((value = value.trim()).startsWith("#")) {
            return this.getColor(theme, themeName, value.substring(1));
        }
        return this.cf.getColor(key, null);
    }

    private final void print(String msg) {
    }

    public void setTheme4all(Component comp, Theme theme) {
        if (comp instanceof DComponent) {
            ((DComponent)comp).setTheme(theme);
        } else if (comp instanceof DContainer) {
            ((DContainer)comp).setTheme(theme);
        }
        Color foreground = theme.getColor("FOREGROUND");
        Color background = theme.getColor("BACKGROUND");
        if (foreground != null) {
            comp.setForeground(theme.getColor("FOREGROUND"));
        }
        if (background != null) {
            comp.setBackground(theme.getColor("BACKGROUND"));
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            int i = 0;
            while (i < comps.length) {
                this.setTheme4all(comps[i], theme);
                ++i;
            }
        }
    }

    public ThemeCenter(Config cf, PrintStream log) {
        this.cf = cf;
        this.log = log;
        this.themes = new Hashtable();
    }

    public static class Theme
    extends DTheme {
        private String name;
        private Hashtable colors;
        private Hashtable fonts;
        private Hashtable images;
        private Hashtable params;

        public String getName() {
            return this.name;
        }

        public DTheme copy() {
            return new Theme(this.name, this);
        }

        public void setColor(String name, Color color) {
            this.colors.put(name.toUpperCase(), color);
        }

        public Color getColor(String name) {
            Color color = (Color)this.colors.get(name.toUpperCase());
            if (color == null) {
                throw new RuntimeException("Color '" + this.name + "_" + name + "' not found!");
            }
            return color;
        }

        public void setFont(String name, Font font) {
            this.fonts.put(name.toUpperCase(), font);
        }

        public Font getFont(String name) {
            Font font = (Font)this.fonts.get(name.toUpperCase());
            if (font == null) {
                throw new RuntimeException("Font '" + this.name + "_" + name + "' not found!");
            }
            return font;
        }

        public void setImage(String name, Image image) {
            this.images.put(name.toUpperCase(), image);
        }

        public Image getImage(String name) {
            Image image = (Image)this.images.get(name.toUpperCase());
            return image;
        }

        public void setParam(String name, String param) {
            this.params.put(name.toUpperCase(), param);
        }

        public String getParam(String name) {
            String param = (String)this.params.get(name.toUpperCase());
            return param;
        }

        protected Color getWhite() {
            return this.getColor("WHITE");
        }

        protected Color getBlack() {
            return this.getColor("BLACK");
        }

        protected Color getPrimary1() {
            return this.getColor("PRIMARY1");
        }

        protected Color getPrimary2() {
            return this.getColor("PRIMARY2");
        }

        protected Color getPrimary3() {
            return this.getColor("PRIMARY3");
        }

        protected Color getSecondary1() {
            return this.getColor("SECONDARY1");
        }

        protected Color getSecondary2() {
            return this.getColor("SECONDARY2");
        }

        protected Color getSecondary3() {
            return this.getColor("SECONDARY3");
        }

        protected Color getSelectedForeground() {
            return this.getColor("SELECTED_FOREGROUND");
        }

        protected Color getSelectedBackground() {
            return this.getColor("SELECTED_BACKGROUND");
        }

        public Font getControlTextFont() {
            return this.getFont("CONTROL_TEXT");
        }

        public Font getSystemTextFont() {
            return this.getFont("SYSTEM_TEXT");
        }

        public Font getUserTextFont() {
            return this.getFont("USER_TEXT");
        }

        public Font getMenuTextFont() {
            return this.getFont("MENU_TEXT");
        }

        public Font getWindowTitleFont() {
            return this.getFont("WINDOW_TITLE");
        }

        public Font getSubTextFont() {
            return this.getFont("SUB_TEXT");
        }

        public Font getMonospacedFont() {
            return this.getFont("MONOSPACED");
        }

        public Color getFocusColor() {
            return this.getColor("FOCUS");
        }

        public Color getDesktopColor() {
            return this.getColor("DESKTOP");
        }

        public Color getControl() {
            return this.getColor("CONTROL");
        }

        public Color getControlShadow() {
            return this.getColor("CONTROL_SHADOW");
        }

        public Color getControlDarkShadow() {
            return this.getColor("CONTROL_DARK_SHADOW");
        }

        public Color getControlInfo() {
            return this.getColor("CONTROL_INFO");
        }

        public Color getControlHighlight() {
            return this.getColor("CONTROL_HIGHLIGHT");
        }

        public Color getControlDisabled() {
            return this.getColor("CONTROL_DISABLED");
        }

        public Color getPrimaryControl() {
            return this.getColor("PRIMARY_CONTROL");
        }

        public Color getPrimaryControlShadow() {
            return this.getColor("PRIMARY_CONTROL_SHADOW");
        }

        public Color getPrimaryControlDarkShadow() {
            return this.getColor("PRIMARY_CONTROL_DARK_SHADOW");
        }

        public Color getPrimaryControlInfo() {
            return this.getColor("PRIMARY_CONTROL_INFO");
        }

        public Color getPrimaryControlHighlight() {
            return this.getColor("PRIMARY_CONTROL_HIGHLIGHT");
        }

        public Color getSystemTextColor() {
            return this.getColor("SYSTEM_TEXT");
        }

        public Color getControlTextColor() {
            return this.getColor("CONTROL_TEXT");
        }

        public Color getInactiveControlTextColor() {
            return this.getColor("INACTIVE_CONTROL_TEXT");
        }

        public Color getInactiveSystemTextColor() {
            return this.getColor("INACTIVE_SYSTEM_TEXT");
        }

        public Color getUserTextColor() {
            return this.getColor("USER_TEXT");
        }

        public Color getTextHighlightColor() {
            return this.getColor("TEXT_HIGHLIGHT");
        }

        public Color getHighlightedTextColor() {
            return this.getColor("HIGHLIGHTED_TEXT");
        }

        public Color getCaretColor() {
            return this.getColor("CARET");
        }

        public Color getWindowBackground() {
            return this.getColor("WINDOW_BACKGROUND");
        }

        public Color getWindowTitleBackground() {
            return this.getColor("WINDOW_TITLE_BACKGROUND");
        }

        public Color getWindowTitleForeground() {
            return this.getColor("WINDOW_TITLE_FOREGROUND");
        }

        public Color getWindowTitleInactiveBackground() {
            return this.getColor("WINDOW_TITLE_INACTIVE_BACKGROUND");
        }

        public Color getWindowTitleInactiveForeground() {
            return this.getColor("WINDOW_TITLE_INACTIVE_FOREGROUND");
        }

        public Color getMenuBackground() {
            return this.getColor("MENU_BACKGROUND");
        }

        public Color getMenuForeground() {
            return this.getColor("MENU_FOREGROUND");
        }

        public Color getMenuSelectedBackground() {
            return this.getColor("MENU_SELECTED_BACKGROUND");
        }

        public Color getMenuSelectedForeground() {
            return this.getColor("MENU_SELECTED_FOREGROUND");
        }

        public Color getMenuDisabledForeground() {
            return this.getColor("MENU_DISABLED_FOREGROUND");
        }

        public Color getSeparatorBackground() {
            return this.getColor("SEPARATOR_BACKGROUND");
        }

        public Color getSeparatorForeground() {
            return this.getColor("SEPARATOR_FOREGROUND");
        }

        public Color getAcceleratorForeground() {
            return this.getColor("ACCELERATOR_FOREGROUND");
        }

        public Color getAcceleratorSelectedForeground() {
            return this.getColor("ACCELERATOR_SELECTED_FOREGROUND");
        }

        public Image getControlBackgroundImage() {
            return this.getImage("CONTROL_BACKGROUND");
        }

        public Image getUserBackgroundImage() {
            return this.getImage("USER_BACKGROUND");
        }

        public Theme(String name) {
            this.name = name;
            this.colors = new Hashtable();
            this.fonts = new Hashtable();
            this.images = new Hashtable();
            this.params = new Hashtable();
            this.setColor("WHITE", Color.white);
            this.setColor("LIGHT_GRAY", Color.lightGray);
            this.setColor("GRAY", Color.gray);
            this.setColor("DARK_GRAY", Color.darkGray);
            this.setColor("BLACK", Color.black);
            this.setColor("RED", Color.red);
            this.setColor("PINK", Color.pink);
            this.setColor("ORANGE", Color.orange);
            this.setColor("YELLOW", Color.yellow);
            this.setColor("GREEN", Color.green);
            this.setColor("MAGENTA", Color.magenta);
            this.setColor("CYAN", Color.cyan);
            this.setColor("BLUE", Color.blue);
        }

        public Theme(String name, Theme base) {
            this.name = name;
            this.colors = (Hashtable)base.colors.clone();
            this.fonts = (Hashtable)base.fonts.clone();
            this.images = (Hashtable)base.images.clone();
            this.params = (Hashtable)base.params.clone();
        }
    }
}

