/*
 * Decompiled with CFR 0.152.
 */
package dog.util;

import dog.util.TimerEvent;
import dog.util.TimerListener;

public final class Timer
extends Thread {
    long time;
    long interval = 0L;
    TimerListener listener;

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long interval) {
        this.interval = interval;
    }

    public final void run() {
        boolean interrupt = false;
        while (!interrupt) {
            Timer timer = this;
            synchronized (timer) {
                try {
                    this.wait(this.interval);
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
                this.listener.timerFired(new TimerEvent(this, this.interval));
            }
        }
    }

    public Timer(TimerListener listener) {
        this(listener, 0L, false);
    }

    public Timer(TimerListener listener, long interval) {
        this(listener, interval, true);
    }

    public Timer(TimerListener listener, long interval, boolean start) {
        this.listener = listener;
        this.interval = interval;
        this.time = System.currentTimeMillis();
        this.setDaemon(true);
        this.setPriority(1);
        if (start) {
            this.start();
        }
    }
}

