/*
 * Decompiled with CFR 0.152.
 */
package dog.util;

import dog.util.ObjectCollator;
import java.util.Vector;

public final class Tree {
    int nparents = 0;
    Object[] parents;
    int[] nchildren;
    Object[][] children;
    int nelements = 0;
    Object[] elements;
    int[] depths;
    int increment;
    Object LOCK = new Object();

    private final int elementIndex(Object object) {
        int i = 0;
        while (i < this.nelements) {
            if (this.elements[i] == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final int parentIndex(Object object) {
        int i = 0;
        while (i < this.nparents) {
            if (this.parents[i] == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final Object getParent(Object child) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.parentOf(child);
        }
    }

    private final Object parentOf(Object child) {
        int p = 0;
        while (p < this.nparents) {
            int c = 0;
            while (c < this.nchildren[p]) {
                if (this.children[p][c] == child) {
                    return this.parents[p];
                }
                ++c;
            }
            ++p;
        }
        return null;
    }

    public final Object[] getChildren(Object parent) {
        Object object = this.LOCK;
        synchronized (object) {
            int p = this.parentIndex(parent);
            if (p > -1) {
                Object[] c = new Object[this.nchildren[p]];
                System.arraycopy(this.children[p], 0, c, 0, this.nchildren[p]);
                return c;
            }
        }
        return new Object[0];
    }

    public final int getChildCount(Object parent) {
        Object object = this.LOCK;
        synchronized (object) {
            int p = this.parentIndex(parent);
            if (p > -1) {
                return this.nchildren[p];
            }
        }
        return 0;
    }

    public final boolean contains(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            return this.elementIndex(object) > -1;
        }
    }

    private final void ensureRootCapacity(int amount) {
        int block = (int)Math.max(Math.ceil((double)amount / (double)this.increment), 1.0) * this.increment;
        if (this.elements.length < this.nelements + amount) {
            int len = this.elements.length;
            Object[] newelements = new Object[len + block];
            System.arraycopy(this.elements, 0, newelements, 0, this.nelements);
            this.elements = newelements;
            int[] newdepths = new int[len + block];
            System.arraycopy(this.depths, 0, newdepths, 0, this.nelements);
            this.depths = newdepths;
        }
    }

    private final void ensureParentCapacity(int amount) {
        int block = (int)Math.max(Math.ceil((double)amount / (double)this.increment), 1.0) * this.increment;
        if (this.parents.length < this.nparents + 1) {
            Object[] newparents = new Object[this.parents.length + this.increment];
            System.arraycopy(this.parents, 0, newparents, 0, this.nparents);
            this.parents = newparents;
            Object[][] newchildren = new Object[this.parents.length + this.increment][];
            System.arraycopy(this.children, 0, newchildren, 0, this.nparents);
            this.children = newchildren;
            int[] newnchildren = new int[this.parents.length + this.increment];
            System.arraycopy(this.nchildren, 0, newnchildren, 0, this.nparents);
            this.nchildren = newnchildren;
        }
        if (this.elements.length < this.nelements + amount) {
            int len = this.elements.length;
            Object[] newelements = new Object[len + block];
            System.arraycopy(this.elements, 0, newelements, 0, this.nelements);
            this.elements = newelements;
            int[] newdepths = new int[len + block];
            System.arraycopy(this.depths, 0, newdepths, 0, this.nelements);
            this.depths = newdepths;
        }
    }

    private final void ensureChildCapacity(int amount, int parent) {
        int block = (int)Math.max(Math.ceil((double)amount / (double)this.increment), 1.0) * this.increment;
        if (this.children[parent].length < this.nchildren[parent] + amount) {
            Object[] newchildren = new Object[this.children[parent].length + block];
            System.arraycopy(this.children[parent], 0, newchildren, 0, this.nchildren[parent]);
            this.children[parent] = newchildren;
        }
        if (this.elements.length < this.nelements + amount) {
            int len = this.elements.length;
            Object[] newelements = new Object[len + block];
            System.arraycopy(this.elements, 0, newelements, 0, this.nelements);
            this.elements = newelements;
            int[] newdepths = new int[len + block];
            System.arraycopy(this.depths, 0, newdepths, 0, this.nelements);
            this.depths = newdepths;
        }
    }

    public final void add(Object object) {
        if (object == null) {
            throw new NullPointerException("cannot add null to a tree");
        }
        Object object2 = this.LOCK;
        synchronized (object2) {
            int e = this.elementIndex(object);
            if (e > -1) {
                this.removeElement(e);
            }
            this.ensureRootCapacity(1);
            this.elements[this.nelements] = object;
            this.depths[this.nelements] = 1;
            ++this.nelements;
        }
    }

    public final void add(Object[] objects) {
        Object object = this.LOCK;
        synchronized (object) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    throw new NullPointerException("cannot add null to a tree");
                }
                int e = this.elementIndex(objects[i]);
                if (e > -1) {
                    this.removeElement(e);
                }
                ++i;
            }
            this.ensureRootCapacity(objects.length);
            System.arraycopy(objects, 0, this.elements, this.nelements, objects.length);
            i = this.nelements;
            while (i < this.nelements + objects.length) {
                this.depths[i] = 1;
                ++i;
            }
            this.nelements += objects.length;
        }
    }

    public final void add(Object parent, Object child) {
        if (parent == null) {
            throw new NullPointerException("null parent specified");
        }
        if (child == null) {
            throw new NullPointerException("cannot add null to a tree");
        }
        if (child == parent) {
            throw new IllegalArgumentException("cannot add child to itself");
        }
        Object object = this.LOCK;
        synchronized (object) {
            int p = this.parentIndex(parent);
            int pe = -1;
            if (p < 0 && (pe = this.elementIndex(parent)) < 0) {
                throw new IllegalArgumentException("parent does not exist");
            }
            int e = this.elementIndex(child);
            if (e > -1) {
                this.removeElement(e);
            }
            if (p < 0) {
                p = this.nparents++;
                this.ensureParentCapacity(1);
                this.parents[p] = parent;
                this.children[p] = new Object[this.increment];
                this.nchildren[p] = 0;
            }
            this.ensureChildCapacity(1, p);
            this.children[p][this.nchildren[p]] = child;
            int depth = this.depth(parent);
            int off = pe + this.nchildren[p] + 1;
            int len = this.nelements - off;
            Object[] buffer = new Object[len];
            System.arraycopy(this.elements, off, buffer, 0, len);
            this.elements[off] = child;
            System.arraycopy(buffer, 0, this.elements, off + 1, len);
            int[] dbuffer = new int[len];
            System.arraycopy(this.depths, off, dbuffer, 0, len);
            this.depths[off] = depth + 1;
            System.arraycopy(dbuffer, 0, this.depths, off + 1, len);
            ++this.nelements;
            int n = p;
            this.nchildren[n] = this.nchildren[n] + 1;
        }
    }

    public final void add(Object parent, Object[] children) {
        if (parent == null) {
            throw new NullPointerException("null parent specified");
        }
        Object object = this.LOCK;
        synchronized (object) {
            int p = this.parentIndex(parent);
            int pe = -1;
            if (p < 0 && (pe = this.elementIndex(parent)) < 0) {
                throw new IllegalArgumentException("parent does not exist");
            }
            int i = 0;
            while (i < children.length) {
                if (children[i] == null) {
                    throw new NullPointerException("cannot add null to a tree");
                }
                if (children[i] == parent) {
                    throw new IllegalArgumentException("cannot add child to itself");
                }
                int e = this.elementIndex(children[i]);
                if (e > -1) {
                    this.removeElement(e);
                }
                ++i;
            }
            if (p < 0) {
                p = this.nparents++;
                this.ensureParentCapacity(1);
                this.parents[p] = parent;
                this.children[p] = new Object[Math.max(this.increment, children.length / this.increment * this.increment)];
                this.nchildren[p] = 0;
            }
            this.ensureChildCapacity(children.length, p);
            System.arraycopy(children, 0, this.children[p], this.nchildren[p], children.length);
            int depth = this.depth(parent);
            int off = pe + this.nchildren[p] + 1;
            int len = this.nelements - off;
            Object[] buffer = new Object[len];
            System.arraycopy(this.elements, off, buffer, 0, len);
            System.arraycopy(children, 0, this.elements, off, children.length);
            System.arraycopy(buffer, 0, this.elements, off + children.length, len);
            int[] dbuffer = new int[len];
            System.arraycopy(this.depths, off, dbuffer, 0, len);
            int i2 = off;
            while (i2 < off + children.length) {
                this.depths[i2] = depth + 1;
                ++i2;
            }
            System.arraycopy(dbuffer, 0, this.depths, off + children.length, len);
            this.nelements += children.length;
            int n = p;
            this.nchildren[n] = this.nchildren[n] + children.length;
        }
    }

    private final int depth(Object object) {
        Object parent = this.parentOf(object);
        if (parent == null) {
            return 1;
        }
        return this.depth(parent) + 1;
    }

    public final void remove(Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.LOCK;
        synchronized (object2) {
            int e = this.elementIndex(object);
            if (e > -1) {
                this.removeElement(e);
            }
        }
    }

    final void removeElement(int e) {
        int len = 0;
        int p = 0;
        while (p < this.nparents) {
            if (this.parents[p] == this.elements[e]) {
                int nc = this.nchildren[p];
                Object[] pchildren = new Object[nc];
                System.arraycopy(this.children[p], 0, pchildren, 0, nc);
                int c = 0;
                while (c < nc) {
                    int ce = this.elementIndex(pchildren[c]);
                    if (ce > -1) {
                        this.removeElement(ce);
                    }
                    ++c;
                }
                len = this.nparents - p - 1;
                if (len > 0) {
                    System.arraycopy(this.parents, p + 1, this.parents, p, len);
                    System.arraycopy(this.children, p + 1, this.children, p, len);
                    System.arraycopy(this.nchildren, p + 1, this.nchildren, p, len);
                }
                --this.nparents;
                --p;
            } else {
                int c = 0;
                while (c < this.nchildren[p]) {
                    if (this.children[p][c] == this.elements[e]) {
                        len = this.nchildren[p] - c - 1;
                        if (len > 0) {
                            System.arraycopy(this.children[p], c + 1, this.children[p], c, len);
                        }
                        int n = p;
                        this.nchildren[n] = this.nchildren[n] - 1;
                        --c;
                    }
                    ++c;
                }
            }
            ++p;
        }
        len = this.nelements - e - 1;
        if (len > 0) {
            System.arraycopy(this.elements, e + 1, this.elements, e, len);
            System.arraycopy(this.depths, e + 1, this.depths, e, len);
        }
        --this.nelements;
    }

    public final void remove(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            this.remove(objects[i]);
            ++i;
        }
    }

    public final void removeChildren(Object parent) {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeChildrenImpl(parent);
        }
    }

    final void removeChildrenImpl(Object parent) {
        int p = this.parentIndex(parent);
        if (p > -1) {
            int c = 0;
            while (c < this.nchildren[p]) {
                this.removeChildrenImpl(this.children[p][c]);
                ++c;
            }
            this.children[p] = new Object[this.increment];
            this.nchildren[p] = 0;
        }
    }

    public final void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.parents = new Object[this.increment];
            this.nparents = 0;
            this.nchildren = new int[this.increment];
            int i = 0;
            while (i < this.increment) {
                this.nchildren[i] = 0;
                ++i;
            }
            this.children = new Object[this.increment][this.increment];
            this.elements = new Object[this.increment];
            this.depths = new int[this.increment];
            this.nelements = 0;
        }
    }

    public final int getDepth(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            int e = this.elementIndex(object);
            if (e == -1) {
                return -1;
            }
            return this.depths[e];
        }
    }

    public final Object[] getRoots() {
        Object object = this.LOCK;
        synchronized (object) {
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < this.nelements) {
                if (this.depths[i] == 1) {
                    v.addElement(this.elements[i]);
                }
                ++i;
            }
            Object[] roots = new Object[v.size()];
            v.copyInto(roots);
            return roots;
        }
    }

    public final int getRootCount() {
        Object object = this.LOCK;
        synchronized (object) {
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < this.nelements) {
                if (this.depths[i] == 1) {
                    v.addElement(this.elements[i]);
                }
                ++i;
            }
            return v.size();
        }
    }

    public final Object[] getTree() {
        Object object = this.LOCK;
        synchronized (object) {
            Object[] objects = new Object[this.nelements];
            System.arraycopy(this.elements, 0, objects, 0, this.nelements);
            return objects;
        }
    }

    public final int getTreeCount() {
        return this.nelements;
    }

    public final boolean hasChildren() {
        Object object = this.LOCK;
        synchronized (object) {
            int p = 0;
            while (p < this.nparents) {
                if (this.nchildren[p] > 0) {
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    public final void sort(ObjectCollator collator) {
        if (collator == null) {
            throw new NullPointerException("null collator");
        }
        Object object = this.LOCK;
        synchronized (object) {
            Sorter sorter = new Sorter(collator);
            this.elements = sorter.newelements;
            this.depths = sorter.newdepths;
        }
    }

    /*
     * Unable to fully structure code
     */
    static final void sort(Object[] objects, int first, int last, ObjectCollator collator) {
        block5: {
            lo = first;
            hi = last;
            if (last <= first) break block5;
            mid = objects[(first + last) / 2];
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < last && collator.compare(objects[lo], mid) < 0) continue block0;
                    while (hi > first && collator.compare(objects[hi], mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    tmp = objects[lo];
                    objects[lo] = objects[hi];
                    objects[hi] = tmp;
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (first < hi) {
                Tree.sort(objects, first, hi, collator);
            }
            if (lo < last) {
                Tree.sort(objects, lo, last, collator);
            }
        }
    }

    public static final void printArray(String name, Object[] array, int count) {
        System.out.println(name + ": length=" + array.length + ", count=" + count);
        int i = 0;
        while (i < count) {
            System.out.println("\t" + array[i]);
            ++i;
        }
    }

    public final void printElements() {
        System.out.println("elements=");
        int i = 0;
        while (i < this.nelements) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(Integer.toString(this.depths[i]));
            int j = 0;
            while (j < this.depths[i]) {
                buffer.append("  ");
                ++j;
            }
            buffer.append(this.elements[i]);
            System.out.println(buffer.toString());
            ++i;
        }
        System.out.println("tree=");
        int p = 0;
        while (p < this.nparents) {
            System.out.println(this.parents[p]);
            int c = 0;
            while (c < this.nchildren[p]) {
                System.out.println("  " + this.children[p][c]);
                ++c;
            }
            ++p;
        }
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[");
        buffer.append("nelements=" + this.nelements);
        buffer.append(",elements.length=" + this.elements.length);
        buffer.append(",depths.length=" + this.depths.length);
        buffer.append(",nparents=" + this.nparents);
        buffer.append(",parents.length=" + this.parents.length);
        buffer.append("]");
        return buffer.toString();
    }

    public Tree() {
        this(10);
    }

    public Tree(int increment) {
        this.increment = increment > 0 ? increment : 1;
        this.clear();
    }

    class Sorter {
        Object[] newelements;
        int[] newdepths;
        int count = 0;

        void appendChildren(Object parent) {
            int p = 0;
            while (p < Tree.this.nparents) {
                if (parent == Tree.this.parents[p]) {
                    int c = 0;
                    while (c < Tree.this.nchildren[p]) {
                        this.newelements[this.count] = Tree.this.children[p][c];
                        this.newdepths[this.count] = Tree.this.getDepth(Tree.this.children[p][c]);
                        ++this.count;
                        this.appendChildren(Tree.this.children[p][c]);
                        ++c;
                    }
                    break;
                }
                ++p;
            }
        }

        Sorter(ObjectCollator collator) {
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < Tree.this.nelements) {
                if (Tree.this.depths[i] == 1) {
                    v.addElement(Tree.this.elements[i]);
                }
                ++i;
            }
            Object[] roots = new Object[v.size()];
            v.copyInto(roots);
            Tree.sort(roots, 0, roots.length - 1, collator);
            int p = 0;
            while (p < Tree.this.nparents) {
                Tree.sort(Tree.this.children[p], 0, Tree.this.nchildren[p] - 1, collator);
                ++p;
            }
            this.newelements = new Object[Tree.this.elements.length];
            this.newdepths = new int[Tree.this.elements.length];
            int r = 0;
            while (r < roots.length) {
                this.newelements[this.count] = roots[r];
                this.newdepths[this.count] = Tree.this.depths[Tree.this.elementIndex(roots[r])];
                ++this.count;
                this.appendChildren(roots[r]);
                ++r;
            }
        }
    }
}

