/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.BASEPACKET;
import common.GET_INFO;
import common.INFO;
import common.MESSAGE;
import connection.Connection;
import connection.ConnectionHandler;
import connection.ObjectPacket;
import connection.Packet;
import connection.TCPConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import server.ClientListener;

class Client
implements Runnable,
ConnectionHandler {
    private ClientListener listener;
    private InetAddress bindAddr;
    private int bindPort;
    private int id;
    private String name;
    private boolean isEnabled;
    private long start;
    private long stop;
    private long length;
    private TCPConnection tcpc;
    private boolean packetCame;
    private Thread thread;
    private boolean toRun;

    private final void print(String msg) {
        System.out.println("[#" + this.id + " " + this.name + "] " + msg);
    }

    void start() {
        this.print("Sz\u00e1l ind\u00edt\u00e1sa");
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Client #" + this.id + " " + this.name);
            this.toRun = true;
            this.thread.start();
        }
        this.print("Sz\u00e1l ind\u00edt\u00e1sa rendben");
    }

    void stop() {
        this.print("Sz\u00e1l le\u00e1ll\u00edt\u00e1sa");
        if (this.thread != null) {
            this.toRun = false;
            try {
                Socket s = new Socket(this.bindAddr, this.bindPort);
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.print("Sz\u00e1l le\u00e1ll\u00edt\u00e1sa rendben");
    }

    public void run() {
        this.print("A sz\u00e1l elindult");
        try {
            ServerSocket ss = new ServerSocket(this.bindPort, 50, this.bindAddr);
            while (this.toRun) {
                Socket sock = ss.accept();
                if (this.toRun) {
                    this.print("Klienskapcsol\u00f3d\u00e1s: " + sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
                    if (this.tcpc != null) {
                        this.print("M\u00e1r van egy kapcsolat!");
                        sock.close();
                        continue;
                    }
                    this.tcpc = new TCPConnection(sock, (Packet)new ObjectPacket(), (ConnectionHandler)this);
                    this.packetCame = false;
                    this.tcpc.start();
                    this.print("Klienskapcsolat fel\u00e9p\u00edtve");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.print(e.getMessage());
            e.printStackTrace();
        }
        this.print("A sz\u00e1l le\u00e1llt");
    }

    private final boolean send(BASEPACKET packet) {
        if (this.tcpc != null) {
            this.print("<- " + packet);
            return this.tcpc.send(new ObjectPacket(packet));
        }
        return false;
    }

    public void onConnectionData(Connection conn, Packet packet) {
        if (packet instanceof ObjectPacket) {
            BASEPACKET p = (BASEPACKET)((ObjectPacket)packet).getObject();
            this.print("-> " + p);
            if (p instanceof GET_INFO) {
                if (this.start == 0L && this.isEnabled()) {
                    this.start = System.currentTimeMillis();
                    this.sendINFO();
                } else {
                    this.sendINFO();
                }
                if (!this.packetCame) {
                    this.packetCame = true;
                    this.listener.clientConnected(this);
                }
            }
        }
    }

    public void onConnectionBroken(Connection conn, IOException ioe) {
        this.print("A kapcsolat megszakadt: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        this.tcpc = null;
        this.listener.clientLost(this);
    }

    public void onConnectionClosed(Connection conn) {
        this.print("A kapcsolat lez\u00e1rva");
        this.tcpc = null;
        this.listener.clientLost(this);
    }

    boolean isAlive() {
        if (this.tcpc == null) {
            return false;
        }
        return !this.tcpc.isClosed();
    }

    String getName() {
        return this.name;
    }

    void enable(long length) {
        this.print("Kliens enged\u00e9lyez\u00e9se " + length / 60000L + " percre");
        this.isEnabled = true;
        this.start = 0L;
        this.stop = 0L;
        this.length = length;
    }

    void modifyLength(long length) {
        this.print("Kliens m\u00f3dos\u00edt\u00e1sa " + length / 60000L + " percre");
        this.length = length;
        this.check();
        if (this.check()) {
            this.sendINFO();
        }
    }

    boolean check() {
        if (this.isEnabled() && this.getTimeLeft() == 0L) {
            this.disable();
            return false;
        }
        return true;
    }

    long getStart() {
        return this.start;
    }

    long getLength() {
        return this.length;
    }

    long getTimeLeft() {
        if (this.start == 0L) {
            return this.length;
        }
        if (this.stop != 0L) {
            return Math.max(0L, this.start + this.length - this.stop);
        }
        return Math.max(0L, this.start + this.length - System.currentTimeMillis());
    }

    long getUsedTime() {
        if (this.start == 0L) {
            return 0L;
        }
        if (this.stop == 0L) {
            return System.currentTimeMillis() - this.start;
        }
        return this.stop - this.start;
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    void disable() {
        this.print("Kliens tilt\u00e1sa");
        this.isEnabled = false;
        this.stop = System.currentTimeMillis();
        this.sendINFO();
    }

    void sendINFO() {
        INFO p = new INFO();
        p.isEnabled = this.isEnabled();
        p.timeLeft = this.getTimeLeft();
        this.send(p);
    }

    void sendMESSAGE(String message) {
        MESSAGE p = new MESSAGE();
        p.message = message;
        this.send(p);
    }

    void save(Properties prop) {
        String base = "client." + this.id + ".";
        ((Hashtable)prop).put(base + "isEnabled", this.isEnabled ? "yes" : "no");
        ((Hashtable)prop).put(base + "start", Long.toString(this.start));
        ((Hashtable)prop).put(base + "stop", Long.toString(this.stop));
        ((Hashtable)prop).put(base + "length", Long.toString(this.length));
    }

    void load(Properties prop) {
        String base = "client." + this.id + ".";
        try {
            boolean isEnabled = prop.getProperty(base + "isEnabled").equals("yes");
            long start = Long.parseLong(prop.getProperty(base + "start"));
            long stop = Long.parseLong(prop.getProperty(base + "stop"));
            long length = Long.parseLong(prop.getProperty(base + "length"));
            this.isEnabled = isEnabled;
            this.start = start;
            this.stop = stop;
            this.length = length;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String toString() {
        return "Client[id=" + this.id + ", name=" + this.name + ", bindAddr=" + this.bindAddr.getHostAddress() + ", bindPort=" + this.bindPort + "]";
    }

    Client(int id, String name, InetAddress bindAddr, int bindPort, ClientListener listener) {
        this.id = id;
        this.name = name;
        this.bindAddr = bindAddr;
        this.bindPort = bindPort;
        this.listener = listener;
        this.isEnabled = false;
        this.start = 0L;
        this.length = 0L;
    }
}

