/*
 * Decompiled with CFR 0.152.
 */
package server;

import dog.gui.DButton;
import dog.gui.DButtonLight;
import dog.gui.DContainer;
import dog.gui.DFrame;
import dog.gui.DItem;
import dog.gui.DLabel;
import dog.gui.DList;
import dog.gui.DTextField;
import dog.gui.DTheme;
import dog.util.Config;
import dog.util.ThemeCenter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import server.ChoiceDialog;
import server.Client;
import server.ClientListener;
import server.MessageDialog;

class Main
implements Runnable,
ActionListener,
ItemListener,
WindowListener,
ClientListener {
    private Client[] clients;
    private Hashtable ditems;
    private ThemeCenter.Theme theme;
    private DFrame frame;
    private DList list;
    private DTextField tfLength;
    private DButton bStart;
    private DButton bStop;
    private DButton bMessage;
    private String lastMessage = "";
    private Color cError;
    private Color cOK;
    private String saveFile;
    private Client selectedClient;
    private Thread thread;
    private boolean toRun = false;

    public static void main(String[] args) throws Exception {
        new Main(args);
    }

    private final void print(String msg) {
        System.out.println("[MAIN] " + msg);
    }

    private final void updateList() {
        this.list.setPropertyChangeRepaintingEnabled(false);
        int i = 0;
        while (i < this.clients.length) {
            Client client = this.clients[i];
            DItem item = (DItem)this.ditems.get(client);
            this.fillInDItem(item, client);
            ++i;
        }
        this.list.setPropertyChangeRepaintingEnabled(true);
        this.list.invalidate();
        this.list.validate();
        this.list.repaint();
    }

    private final void fillInDItem(DItem item, Client client) {
        String sClient;
        Color color = null;
        String sStatus = client.isEnabled() ? "Akt\u00edv" : "Tiltva";
        item.addField("status", sStatus);
        if (client.isAlive()) {
            sClient = "OK";
            if (client.isEnabled()) {
                color = this.cOK;
            }
        } else {
            sClient = "???";
            if (client.isEnabled()) {
                color = this.cError;
            }
        }
        item.addField("client", sClient);
        long start = client.getStart();
        long length = client.getLength();
        String sStart = start == 0L ? "--:--" : this.dateToTime(start);
        String sEnd = start == 0L ? "--:--" : this.dateToTime(start + length);
        item.addField("start", sStart);
        item.addField("end", sEnd);
        String sLeft = this.diffToTime(client.getTimeLeft());
        item.addField("left", sLeft);
        long used = client.getUsedTime();
        item.addField("used", used == 0L ? "--:--:--" : this.diffToTime(used));
        item.setColor(color);
    }

    private final String dateToTime(long time) {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm");
        return f.format(new Date(time));
    }

    private final String diffToTime(long diff) {
        boolean minus = diff < 0L;
        diff = Math.abs(diff + 500L) / 1000L;
        int hours = (int)(diff / 3600L);
        int mins = (int)(diff % 3600L / 60L);
        int secs = (int)(diff % 60L);
        return (minus ? "-" : "") + hours + ":" + (mins < 10 ? "0" : "") + mins + ":" + (secs < 10 ? "0" : "") + secs;
    }

    public void actionPerformed(ActionEvent e) {
        MessageDialog m;
        Client client = this.selectedClient;
        if (e.getSource() == this.bStart) {
            long newLength;
            String text = this.tfLength.getText();
            boolean rel = false;
            if (text.startsWith("+")) {
                rel = true;
                text = text.substring(1);
            } else if (text.startsWith("-")) {
                rel = true;
            }
            int val = 0;
            try {
                val = Integer.parseInt(text);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (rel) {
                long nfe = client.getLength() + (long)(val * 60000);
            } else {
                newLength = val * 60000;
            }
            if (newLength < 0L) {
                newLength = 0L;
            }
            if (client.isEnabled() && client.getStart() != 0L) {
                long currLength = System.currentTimeMillis() - client.getStart();
                if (client.getTimeLeft() > 60000L) {
                    currLength += 60000L;
                }
                newLength = Math.max(currLength, newLength);
            }
            if (!client.isEnabled() && newLength > 0L) {
                client.enable(newLength);
            } else {
                client.modifyLength(newLength);
            }
            this.updateComponents(client);
            this.save();
        } else if (e.getSource() == this.bStop) {
            if (new ChoiceDialog(this.frame, "Figyelmeztet\u00e9s", "Biztos, hogy le\u00e1ll\u00edtsam?", "Igen", "M\u00e9gsem").getChoice() == 1) {
                client.disable();
                this.updateComponents(client);
                this.save();
            }
        } else if (e.getSource() == this.bMessage && (m = new MessageDialog(this.frame, 40, "\u00dczenet k\u00fcld\u00e9se", new String[]{"T\u00f6rl\u00e9s", "K\u00fcld\u00e9s", "M\u00e9gsem"}, this.lastMessage)).getChoice() == 1) {
            String msg = m.getMessage();
            client.sendMESSAGE(msg);
            this.lastMessage = msg;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Client client;
            this.selectedClient = client = (Client)((DItem)e.getItem()).getReference();
            this.updateComponents(client);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (new ChoiceDialog(this.frame, "Figyelmeztet\u00e9s", "Biztos, hogy lez\u00e1rja a programot?", "Igen", "M\u00e9gsem").getChoice() == 1) {
            this.save();
            System.exit(0);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private final void updateComponents(Client client) {
        if (client != null) {
            this.tfLength.setEnabled(true);
            this.tfLength.setText(Long.toString(client.getLength() / 60000L));
            this.tfLength.selectAll();
            this.bStart.setEnabled(true);
            this.bStop.setEnabled(client.isEnabled());
            this.bMessage.setEnabled(client.isAlive());
        }
    }

    private final void checkClients() {
        boolean toSave = false;
        int i = 0;
        while (i < this.clients.length) {
            Client client = this.clients[i];
            if (!client.check() && this.selectedClient == client) {
                this.updateComponents(client);
                toSave = true;
            }
            ++i;
        }
        if (toSave) {
            this.save();
        }
    }

    public void clientConnected(Client client) {
        this.updateComponents(this.selectedClient);
        this.save();
    }

    public void clientLost(Client client) {
        this.updateComponents(this.selectedClient);
        this.save();
    }

    private final void save() {
        this.print("\u00c1llapot kiment\u00e9se");
        try {
            Properties prop = new Properties();
            Rectangle r = this.frame.getBounds();
            ((Hashtable)prop).put("window.x", Integer.toString(r.x));
            ((Hashtable)prop).put("window.y", Integer.toString(r.y));
            ((Hashtable)prop).put("window.width", Integer.toString(r.width));
            ((Hashtable)prop).put("window.height", Integer.toString(r.height));
            int i = 0;
            while (i < this.clients.length) {
                Client client = this.clients[i];
                client.save(prop);
                ++i;
            }
            FileOutputStream out = new FileOutputStream(this.saveFile);
            prop.save(out, null);
            out.close();
            this.print("\u00c1llapotok kiment\u00e9se rendben");
        }
        catch (Exception e) {
            this.print("Hiba:");
            e.printStackTrace();
        }
    }

    private final void load() {
        this.print("\u00c1llapotok bet\u00f6lt\u00e9se");
        try {
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(this.saveFile);
            prop.load(in);
            in.close();
            try {
                int x = Integer.parseInt(prop.getProperty("window.x"));
                int y = Integer.parseInt(prop.getProperty("window.y"));
                int width = Integer.parseInt(prop.getProperty("window.width"));
                int height = Integer.parseInt(prop.getProperty("window.height"));
                ((Component)this.frame).setBounds(x, y, width, height);
            }
            catch (Exception e) {
                // empty catch block
            }
            int i = 0;
            while (i < this.clients.length) {
                Client client = this.clients[i];
                client.load(prop);
                ++i;
            }
            this.print("\u00c1llapotok bet\u00f6lt\u00e9se rendben");
        }
        catch (Exception e) {
            this.print("Hiba:");
            e.printStackTrace();
        }
    }

    public void run() {
        this.print("A sz\u00e1l elindult");
        try {
            while (this.toRun) {
                this.checkClients();
                this.updateList();
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.print(e.getMessage());
            e.printStackTrace();
        }
        this.print("A sz\u00e1l le\u00e1llt");
    }

    Main(String[] args) throws Exception {
        String name;
        Properties propCfg = new Properties();
        FileInputStream in = new FileInputStream("server.cfg");
        propCfg.load(in);
        in.close();
        Config config = new Config(propCfg);
        ThemeCenter tc = new ThemeCenter(config, System.out);
        this.theme = tc.getTheme("MAIN");
        DTheme.setTheme(this.theme);
        this.cError = this.theme.getColor("LIST_ERROR");
        this.cOK = this.theme.getColor("LIST_OK");
        InetAddress bindAddr = InetAddress.getByName(config.getString("bind_addr", "0.0.0.0"));
        int bindBasePort = config.getInt("bind_base_port", 7000);
        this.saveFile = config.getString("save_file", "save.dat");
        Vector<Client> clients = new Vector<Client>();
        int i = 1;
        while ((name = config.getString("client." + i + ".name", null)) != null) {
            Client client = new Client(i, name, bindAddr, bindBasePort + i, this);
            clients.addElement(client);
            this.print("Kliens #" + i + " " + name + " " + bindAddr.getHostAddress() + ":" + bindBasePort + i);
            ++i;
        }
        this.clients = new Client[clients.size()];
        clients.copyInto(this.clients);
        this.frame = new DFrame();
        this.frame.setLayout(new BorderLayout());
        this.frame.addWindowListener(this);
        this.list = new DList(false, 2, this.clients.length);
        this.list.setDefaultColumnLabel("G\u00e9p");
        this.list.addItemListener(this);
        this.list.addColumn("status", "\u00c1llapot", -1, 0);
        this.list.addColumn("client", "Kliens", -1, 0);
        this.list.addColumn("start", "Kezdet", -1, 0);
        this.list.addColumn("end", "V\u00e9ge", -1, 0);
        this.list.addColumn("used", "Haszn\u00e1lt", -1, 0);
        this.list.addColumn("left", "Marad\u00e9k", -1, 0);
        this.ditems = new Hashtable();
        i = 0;
        while (i < this.clients.length) {
            Client client = this.clients[i];
            DItem item = new DItem(Integer.toString(i + 1) + ". " + client.getName(), null, (Object)client);
            this.list.add(item);
            this.ditems.put(client, item);
            ++i;
        }
        this.frame.add((Component)this.list, "Center");
        DContainer cLower = new DContainer();
        cLower.setLayout(new FlowLayout());
        cLower.add(new DLabel("Hossz:"));
        this.tfLength = new DTextField();
        this.tfLength.addActionListener(this);
        this.tfLength.setColumns(5);
        this.tfLength.setMaxCharNumber(4);
        this.tfLength.setEnabled(false);
        cLower.add(this.tfLength);
        this.bStart = new DButtonLight("    Start    ");
        this.bStart.addActionListener(this);
        cLower.add(this.bStart);
        this.bStart.setEnabled(false);
        this.tfLength.setDefaultButton(this.bStart);
        this.bStop = new DButtonLight("    Stop    ");
        this.bStop.addActionListener(this);
        this.bStop.setEnabled(false);
        cLower.add(this.bStop);
        this.bMessage = new DButtonLight("    \u00dczenet    ");
        this.bMessage.addActionListener(this);
        this.bMessage.setEnabled(false);
        cLower.add(this.bMessage);
        this.frame.add((Component)cLower, "South");
        ((Component)this.frame).setSize(500, 200);
        this.frame.show();
        this.load();
        int i2 = 0;
        while (i2 < this.clients.length) {
            this.clients[i2].start();
            ++i2;
        }
        this.toRun = true;
        this.thread = new Thread((Runnable)this, "Main");
        this.thread.start();
    }
}

