/*
 * Decompiled with CFR 0.152.
 */
package server;

import dog.gui.DButton;
import dog.gui.DButtonLight;
import dog.gui.DDialog;
import dog.gui.DTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MessageDialog
extends DDialog
implements ActionListener {
    private DButton[] buttons;
    private DTextField text;
    private int choice;

    private final GridBagConstraints newGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = gridx;
        g.gridy = gridy;
        g.gridwidth = gridwidth;
        g.gridheight = gridheight;
        g.fill = fill;
        g.ipadx = ipadx;
        g.ipady = ipady;
        g.insets = insets;
        g.anchor = anchor;
        g.weightx = weightx;
        g.weighty = weighty;
        return g;
    }

    private final void center() {
        Dimension size = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1001) {
            if (e.getSource() == this.buttons[0]) {
                this.text.setText("");
                this.text.requestFocus();
            } else {
                int i = 1;
                while (i < this.buttons.length) {
                    if (e.getSource() == this.buttons[i]) {
                        MessageDialog messageDialog = this;
                        synchronized (messageDialog) {
                            this.choice = i;
                            this.dispose();
                            this.notify();
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void stop() {
        MessageDialog messageDialog = this;
        synchronized (messageDialog) {
            this.dispose();
            this.notify();
        }
    }

    public int getChoice() {
        this.choice = -1;
        this.text.requestFocus();
        this.show();
        return this.choice;
    }

    public String getMessage() {
        return this.text.getText();
    }

    public MessageDialog(Frame parent, int columns, String title, String[] buttons, String msg) {
        super(parent, title, true);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.text = new DTextField(msg);
        this.text.setColumns(columns);
        gridbag.setConstraints(this.text, this.newGridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 3, new Insets(10, 20, 10, 20), 10, 10));
        this.add(this.text);
        this.buttons = new DButton[buttons.length];
        int i = 0;
        while (i < buttons.length) {
            DButtonLight button = new DButtonLight("    " + buttons[i] + "    ");
            button.addActionListener(this);
            gridbag.setConstraints(button, this.newGridBagConstraints(i, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 10, 0));
            this.add(button);
            this.buttons[i] = button;
            ++i;
        }
        this.text.setDefaultButton(this.buttons[1]);
        this.pack();
        this.center();
    }
}

